/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RetryException;
import org.truffleruby.language.exceptions.RescueNode;
import org.truffleruby.language.exceptions.TryNodeGen;
import org.truffleruby.language.methods.TranslateExceptionNode;
import org.truffleruby.language.threadlocal.ThreadLocalGlobals;

public abstract class TryNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode tryPart;
    @Node.Children
    private final RescueNode[] rescueParts;
    @Node.Child
    private RubyNode elsePart;
    @Node.Child
    private TranslateExceptionNode translateExceptionNode;
    private final boolean canOmitBacktrace;

    public TryNode(RubyNode tryPart, RescueNode[] rescueParts, RubyNode elsePart, boolean canOmitBacktrace) {
        this.tryPart = tryPart;
        this.rescueParts = rescueParts;
        this.elsePart = elsePart;
        this.canOmitBacktrace = canOmitBacktrace;
    }

    @Specialization
    Object doTry(VirtualFrame frame, @Cached InlinedBranchProfile noExceptionProfile, @Cached InlinedBranchProfile killExceptionProfile, @Cached InlinedBranchProfile guestExceptionProfile, @Cached InlinedBranchProfile retryProfile, @Cached BooleanCastNode booleanCastNode, @Cached InlinedConditionProfile raiseExceptionProfile) {
        Object result;
        while (true) {
            try {
                result = this.tryPart.execute(frame);
                noExceptionProfile.enter((Node)this);
            }
            catch (KillException e) {
                killExceptionProfile.enter((Node)this);
                throw e;
            }
            catch (AbstractTruffleException exception) {
                guestExceptionProfile.enter((Node)this);
                try {
                    return this.handleException(frame, exception, raiseExceptionProfile, booleanCastNode);
                }
                catch (RetryException e) {
                    retryProfile.enter((Node)this);
                    TruffleSafepoint.poll((Node)this);
                    continue;
                }
            }
            catch (Throwable t) {
                if (this.translateExceptionNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.translateExceptionNode = (TranslateExceptionNode)this.insert(TranslateExceptionNode.create());
                }
                throw this.translateExceptionNode.executeTranslation(t);
            }
            break;
        }
        if (this.elsePart != null) {
            result = this.elsePart.execute(frame);
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    private Object handleException(VirtualFrame frame, AbstractTruffleException exception, InlinedConditionProfile raiseExceptionProfile, BooleanCastNode booleanCastNode) {
        Object exceptionObject = ExceptionOperations.getExceptionObject(this, exception, raiseExceptionProfile);
        for (RescueNode rescue : this.rescueParts) {
            if (!rescue.canHandle(frame, exceptionObject, booleanCastNode)) continue;
            if (this.getContext().getOptions().BACKTRACE_ON_RESCUE) {
                this.printBacktraceOnRescue(rescue, exception);
            }
            if (this.canOmitBacktrace) {
                return rescue.execute(frame);
            }
            TruffleStackTrace.fillIn((Throwable)exception);
            return this.setLastExceptionAndRunRescue(frame, exceptionObject, rescue);
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setLastExceptionAndRunRescue(VirtualFrame frame, Object exceptionObject, RescueNode rescue) {
        ThreadLocalGlobals threadLocalGlobals = this.getLanguage().getCurrentThread().threadLocalGlobals;
        Object previousException = threadLocalGlobals.getLastException();
        threadLocalGlobals.setLastException(exceptionObject);
        try {
            CompilerAsserts.partialEvaluationConstant((Object)((Object)rescue));
            Object object = rescue.execute(frame);
            return object;
        }
        finally {
            threadLocalGlobals.setLastException(previousException);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void printBacktraceOnRescue(RescueNode rescue, AbstractTruffleException exception) {
        String info = "rescued at " + this.getContext().fileLine(this.getContext().getCallStack().getTopMostUserSourceSection(rescue.getEncapsulatingSourceSection())) + ":\n";
        this.getContext().getDefaultBacktraceFormatter().printRubyExceptionOnEnvStderr(info, exception);
    }

    @Override
    public RubyNode cloneUninitialized() {
        TryNode copy = TryNodeGen.create(this.tryPart.cloneUninitialized(), TryNode.cloneUninitialized(this.rescueParts), TryNode.cloneUninitialized(this.elsePart), this.canOmitBacktrace);
        return copy.copyFlags(this);
    }

    protected static RescueNode[] cloneUninitialized(RescueNode[] nodes) {
        RescueNode[] copies = new RescueNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            copies[i] = (RescueNode)nodes[i].cloneUninitialized();
        }
        return copies;
    }
}

