/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import org.graalvm.collections.Pair;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.control.RaiseException;

public final class FileLoader {
    private final RubyContext context;
    private final RubyLanguage language;

    public FileLoader(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
    }

    public static void ensureReadable(RubyContext context, TruffleFile file, Node currentNode) {
        if (!file.exists(new LinkOption[0])) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("No such file or directory -- " + file, file.getPath(), currentNode));
        }
        if (!file.isReadable()) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("Permission denied -- " + file, file.getPath(), currentNode));
        }
    }

    public Pair<Source, TStringWithEncoding> loadFile(String path) throws IOException {
        if (this.context.getOptions().LOG_LOAD) {
            RubyLanguage.LOGGER.info("loading " + path);
        }
        TruffleFile file = FileLoader.getSafeTruffleFile(this.language, this.context, path);
        FileLoader.ensureReadable(this.context, file, null);
        byte[] sourceBytes = file.readAllBytes();
        TStringWithEncoding tstringWithEnc = new TStringWithEncoding(TStringUtils.fromByteArray(sourceBytes, Encodings.UTF_8), Encodings.UTF_8);
        Source source = this.buildSource(file, path, tstringWithEnc, this.isInternal(path), false);
        return Pair.create((Object)source, (Object)tstringWithEnc);
    }

    public static TruffleFile getSafeTruffleFile(RubyLanguage language, RubyContext context, String path) {
        TruffleFile file;
        TruffleLanguage.Env env = context.getEnv();
        if (env.isFileIOAllowed()) {
            return env.getPublicTruffleFile(path);
        }
        try {
            file = env.getInternalTruffleFile(path).getCanonicalFile(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("Failed to canonicalize -- " + path, path, null));
        }
        String homeLibDir = language.getRubyHome() + "/lib/";
        if (file.getPath().startsWith(homeLibDir)) {
            String homeRelativePath = file.getPath().substring(language.getRubyHome().length() + 1);
            TruffleFile internalResourceFile = language.getRubyHomeTruffleFile().resolve(homeRelativePath);
            if (FileLoader.isStdLibRubyOrCExtFile(internalResourceFile.getPath())) {
                return internalResourceFile;
            }
        }
        try {
            return env.getPublicTruffleFile(path);
        }
        catch (SecurityException e) {
            throw new RaiseException(context, context.getCoreExceptions().loadError("Permission denied (" + e.getMessage() + ") -- " + path, path, null));
        }
    }

    private static boolean isStdLibRubyOrCExtFile(String path) {
        return path.endsWith(".rb") || path.endsWith(RubyLanguage.CEXT_EXTENSION);
    }

    Source buildSource(TruffleFile file, String path, TStringWithEncoding sourceTStringWithEncoding, boolean internal, boolean mainSource) {
        assert (file.getPath().equals(path));
        boolean coverageEnabled = this.language.coverageManager.isEnabled();
        String mimeType = mainSource ? "application/x-ruby;main-script=true" : RubyLanguage.getMimeType(coverageEnabled);
        Source source = Source.newBuilder((String)"ruby", (TruffleFile)file).canonicalizePath(false).mimeType(mimeType).content((CharSequence)sourceTStringWithEncoding.tstring.toString()).internal(internal).cached(!coverageEnabled).build();
        assert (source.getPath().equals(path)) : "Source#getPath() = " + source.getPath() + " is not the same as " + path;
        return source;
    }

    private boolean isInternal(String path) {
        String canonicalPath;
        try {
            canonicalPath = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        if (canonicalPath.startsWith(this.language.coreLoadPath)) {
            return this.language.options.CORE_AS_INTERNAL;
        }
        if (canonicalPath.startsWith(this.language.getRubyHome() + "/lib/") && !canonicalPath.startsWith(this.language.getRubyHome() + "/lib/gems/")) {
            return this.language.options.STDLIB_AS_INTERNAL;
        }
        return false;
    }
}

