/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.LinkOption;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.loader.EmbeddedScript;
import org.truffleruby.language.loader.FileLoader;
import org.truffleruby.parser.RubySource;

public final class MainLoader {
    private final RubyContext context;
    private final RubyLanguage language;

    public MainLoader(RubyContext context, RubyLanguage language) {
        this.context = context;
        this.language = language;
    }

    public RubySource loadFromCommandLineArgument(String code) {
        Source source = Source.newBuilder((String)"ruby", (CharSequence)code, (String)"-e").mimeType("application/x-ruby;main-script=true").build();
        return new RubySource(source, "-e");
    }

    public RubySource loadFromStandardIn(Node currentNode, String path) throws IOException {
        byte[] sourceBytes = this.readAllOfStandardIn();
        TStringWithEncoding sourceTString = this.transformScript(currentNode, path, sourceBytes);
        Source source = Source.newBuilder((String)"ruby", (CharSequence)sourceTString.toString(), (String)path).mimeType("application/x-ruby;main-script=true").build();
        return new RubySource(source, path, sourceTString);
    }

    private TStringWithEncoding transformScript(Node currentNode, String path, byte[] sourceBytes) {
        EmbeddedScript embeddedScript = new EmbeddedScript(this.context);
        if (embeddedScript.shouldTransform(sourceBytes)) {
            sourceBytes = embeddedScript.transformForExecution(currentNode, sourceBytes, path);
        }
        return new TStringWithEncoding(TStringUtils.fromByteArray(sourceBytes, Encodings.UTF_8), Encodings.UTF_8);
    }

    private byte[] readAllOfStandardIn() throws IOException {
        int read;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((read = System.in.read(buffer)) != -1) {
            byteStream.write(buffer, 0, read);
        }
        return byteStream.toByteArray();
    }

    public RubySource loadFromFile(TruffleLanguage.Env env, Node currentNode, String mainPath) throws IOException {
        FileLoader fileLoader = new FileLoader(this.context, this.language);
        TruffleFile file = env.getPublicTruffleFile(mainPath);
        FileLoader.ensureReadable(this.context, file, currentNode);
        byte[] sourceBytes = file.readAllBytes();
        TStringWithEncoding sourceTString = this.transformScript(currentNode, mainPath, sourceBytes);
        Source mainSource = fileLoader.buildSource(file, mainPath, sourceTString, false, true);
        this.context.getFeatureLoader().setMainScript(mainSource, file.getCanonicalFile(new LinkOption[0]).getPath());
        return new RubySource(mainSource, mainPath, sourceTString);
    }
}

