/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.locals.ReadFrameSlotNodeGen;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.WriteDeclarationVariableNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.parser.BlockDescriptorInfo;

public final class ReadDeclarationVariableNode
extends ReadLocalNode {
    private final int frameDepth;

    public ReadDeclarationVariableNode(LocalVariableType type, int frameDepth, int frameSlot) {
        super(frameSlot, type);
        this.frameDepth = frameDepth;
    }

    public int getFrameDepth() {
        return this.frameDepth;
    }

    public int getFrameSlot() {
        return this.frameSlot;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readFrameSlot(frame);
    }

    @Override
    protected Object readFrameSlot(VirtualFrame frame) {
        if (this.readFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readFrameSlotNode = (ReadFrameSlotNode)this.insert(ReadFrameSlotNodeGen.create(this.frameSlot));
        }
        Frame declarationFrame = RubyArguments.getDeclarationFrame((Frame)frame, this.frameDepth);
        return this.readFrameSlotNode.executeRead(declarationFrame);
    }

    @Override
    public WriteLocalNode makeWriteNode(RubyNode rhs) {
        return new WriteDeclarationVariableNode(this.frameSlot, this.frameDepth, rhs);
    }

    @Override
    protected String getVariableName() {
        FrameDescriptor descriptor = BlockDescriptorInfo.getDeclarationFrameDescriptor(this.getRootNode().getFrameDescriptor(), this.frameDepth);
        return descriptor.getSlotName(this.frameSlot).toString();
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadDeclarationVariableNode copy = new ReadDeclarationVariableNode(this.type, this.frameDepth, this.frameSlot);
        return copy.copyFlags(this);
    }
}

