/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.debug.SingleMemberDescriptor;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.utils.Utils;

public abstract class ReadLocalNode
extends RubyContextSourceNode {
    protected final int frameSlot;
    protected final LocalVariableType type;
    @Node.Child
    protected ReadFrameSlotNode readFrameSlotNode;

    public ReadLocalNode(int frameSlot, LocalVariableType type) {
        this.frameSlot = frameSlot;
        this.type = type;
    }

    protected abstract Object readFrameSlot(VirtualFrame var1);

    public abstract WriteLocalNode makeWriteNode(RubyNode var1);

    protected abstract String getVariableName();

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        switch (this.type) {
            case FRAME_LOCAL: {
                return FrozenStrings.LOCAL_VARIABLE;
            }
            case FRAME_LOCAL_GLOBAL: {
                if (this.readFrameSlot(frame) != nil) {
                    return FrozenStrings.GLOBAL_VARIABLE;
                }
                return nil;
            }
        }
        throw Utils.unsupportedOperation(new Object[]{"didn't expect local type ", this.type});
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.ReadVariableTag.class || super.hasTag(tag);
    }

    public Object getNodeObject() {
        return new SingleMemberDescriptor("readVariableName", this.getVariableName());
    }
}

