/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.locals.WriteFrameSlotNode;
import org.truffleruby.language.locals.WriteFrameSlotNodeGen;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.parser.BlockDescriptorInfo;

public final class WriteDeclarationVariableNode
extends WriteLocalNode {
    private final int frameDepth;
    @Node.Child
    private WriteFrameSlotNode writeFrameSlotNode;

    public WriteDeclarationVariableNode(int frameSlot, int frameDepth, RubyNode valueNode) {
        super(frameSlot, valueNode);
        this.frameDepth = frameDepth;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.valueNode.execute(frame);
        this.assign(frame, value);
        return value;
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        if (this.writeFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.writeFrameSlotNode = (WriteFrameSlotNode)this.insert(WriteFrameSlotNodeGen.create(this.frameSlot));
        }
        Frame declarationFrame = RubyArguments.getDeclarationFrame((Frame)frame, this.frameDepth);
        this.writeFrameSlotNode.executeWrite(declarationFrame, value);
    }

    @Override
    public AssignableNode toAssignableNode() {
        this.valueNode = null;
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    protected String getVariableName() {
        FrameDescriptor descriptor = BlockDescriptorInfo.getDeclarationFrameDescriptor(this.getRootNode().getFrameDescriptor(), this.frameDepth);
        return descriptor.getSlotName(this.frameSlot).toString();
    }

    @Override
    public RubyNode cloneUninitialized() {
        WriteDeclarationVariableNode copy = new WriteDeclarationVariableNode(this.frameSlot, this.frameDepth, WriteDeclarationVariableNode.cloneUninitialized(this.valueNode));
        return copy.copyFlags(this);
    }
}

