/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.locals.WriteFrameSlotNodeGen;

@ImportStatic(value={FrameSlotKind.class, RubyGuards.class})
public abstract class WriteFrameSlotNode
extends RubyBaseNode
implements AssignableNode {
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor cachedDescriptor;
    private final int frameSlot;

    public WriteFrameSlotNode(int frameSlot) {
        assert (frameSlot >= 0);
        this.frameSlot = frameSlot;
    }

    public abstract void executeWrite(Frame var1, Object var2);

    @Override
    public void assign(VirtualFrame frame, Object value) {
        this.executeWrite((Frame)frame, value);
    }

    @Specialization(guards={"isExpectedOrIllegal(frame, Boolean)"})
    void writeBoolean(Frame frame, boolean value) {
        frame.setBoolean(this.frameSlot, value);
    }

    @Specialization(guards={"isExpectedOrIllegal(frame, Int)"})
    void writeInt(Frame frame, int value) {
        frame.setInt(this.frameSlot, value);
    }

    @Specialization(guards={"isExpectedOrIllegal(frame, Long)"})
    void writeLong(Frame frame, long value) {
        frame.setLong(this.frameSlot, value);
    }

    @Specialization(guards={"isExpectedOrIllegal(frame, Double)"})
    void writeDouble(Frame frame, double value) {
        frame.setDouble(this.frameSlot, value);
    }

    @Specialization(replaces={"writeBoolean", "writeInt", "writeLong", "writeDouble"})
    void writeObject(Frame frame, Object value) {
        FrameDescriptor descriptor = this.getFrameDescriptor(frame);
        descriptor.setSlotKind(this.frameSlot, FrameSlotKind.Object);
        frame.setObject(this.frameSlot, value);
    }

    protected boolean isExpectedOrIllegal(Frame frame, FrameSlotKind expectedKind) {
        FrameDescriptor descriptor = this.getFrameDescriptor(frame);
        FrameSlotKind kind = descriptor.getSlotKind(this.frameSlot);
        if (kind == expectedKind) {
            return true;
        }
        if (kind == FrameSlotKind.Illegal) {
            descriptor.setSlotKind(this.frameSlot, expectedKind);
            return true;
        }
        return false;
    }

    private FrameDescriptor getFrameDescriptor(Frame frame) {
        if (this.cachedDescriptor == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedDescriptor = frame.getFrameDescriptor();
        }
        assert (frame.getFrameDescriptor() == this.cachedDescriptor);
        return this.cachedDescriptor;
    }

    @Override
    public AssignableNode toAssignableNode() {
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return WriteFrameSlotNodeGen.create(this.frameSlot);
    }
}

