/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.FrameOnStackMarker;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.WithoutVisibilityNode;
import org.truffleruby.language.methods.WithoutVisibilityNodeGen;

public final class BlockDefinitionNode
extends RubyContextSourceNode {
    private final ProcType type;
    private final SharedMethodInfo sharedMethodInfo;
    private final ProcCallTargets callTargets;
    private final BreakID breakID;
    private final int frameOnStackMarkerSlot;
    @Node.Child
    private TruffleKernelNodes.GetSpecialVariableStorage readSpecialVariableStorageNode;
    @Node.Child
    private WithoutVisibilityNode withoutVisibilityNode;

    public BlockDefinitionNode(ProcType type, SharedMethodInfo sharedMethodInfo, ProcCallTargets callTargets, BreakID breakID, int frameOnStackMarkerSlot) {
        assert (type == ProcType.PROC == (frameOnStackMarkerSlot != -1));
        this.type = type;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargets = callTargets;
        this.breakID = breakID;
        this.frameOnStackMarkerSlot = frameOnStackMarkerSlot;
        this.readSpecialVariableStorageNode = TruffleKernelNodes.GetSpecialVariableStorage.create();
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    @Override
    public RubyProc execute(VirtualFrame frame) {
        FrameOnStackMarker frameOnStackMarker;
        if (this.frameOnStackMarkerSlot != -1) {
            frameOnStackMarker = (FrameOnStackMarker)frame.getObject(this.frameOnStackMarkerSlot);
            assert (frameOnStackMarker != null);
        } else {
            frameOnStackMarker = null;
        }
        return ProcOperations.createRubyProc(this.coreLibrary().procClass, this.getLanguage().procShape, this.type, this.sharedMethodInfo, this.callTargets, frame.materialize(), this.readSpecialVariableStorageNode.executeCached((Frame)frame), RubyArguments.getMethod((Frame)frame), frameOnStackMarker, this.executeWithoutVisibility(RubyArguments.getDeclarationContext((Frame)frame)));
    }

    private DeclarationContext executeWithoutVisibility(DeclarationContext ctxIn) {
        if (this.withoutVisibilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.withoutVisibilityNode = (WithoutVisibilityNode)this.insert(WithoutVisibilityNodeGen.create());
        }
        return this.withoutVisibilityNode.executeWithoutVisibility(ctxIn);
    }

    @Override
    public RubyNode cloneUninitialized() {
        BlockDefinitionNode copy = new BlockDefinitionNode(this.type, this.sharedMethodInfo, this.callTargets, this.breakID, this.frameOnStackMarkerSlot);
        return copy.copyFlags(this);
    }
}

