/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import java.util.Set;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;

public final class LiteralMethodDefinitionNode
extends RubyContextSourceNode {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final boolean isDefSingleton;
    private final CachedLazyCallTargetSupplier callTargetSupplier;
    @Node.Child
    private RubyNode moduleNode;

    public LiteralMethodDefinitionNode(RubyNode moduleNode, String name, SharedMethodInfo sharedMethodInfo, boolean isDefSingleton, CachedLazyCallTargetSupplier callTargetSupplier) {
        this.name = name;
        this.sharedMethodInfo = sharedMethodInfo;
        this.isDefSingleton = isDefSingleton;
        this.callTargetSupplier = callTargetSupplier;
        this.moduleNode = moduleNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyModule module = this.moduleNode == null ? RubyArguments.getDeclarationContext((Frame)frame).getModuleToDefineMethods() : (RubyModule)this.moduleNode.execute(frame);
        Visibility visibility = this.isDefSingleton ? Visibility.PUBLIC : DeclarationContext.findVisibility((Frame)frame);
        InternalMethod currentMethod = RubyArguments.getMethod((Frame)frame);
        DeclarationContext declarationContext = RubyArguments.getDeclarationContext((Frame)frame);
        return this.addMethod(module, visibility, currentMethod, declarationContext);
    }

    @CompilerDirectives.TruffleBoundary
    private Object addMethod(RubyModule module, Visibility visibility, InternalMethod currentMethod, DeclarationContext declarationContext) {
        InternalMethod method = new InternalMethod(this.getContext(), this.sharedMethodInfo, currentMethod.getLexicalScope(), declarationContext.withVisibility(Visibility.PUBLIC), this.name, module, visibility, false, null, null, null, this.callTargetSupplier);
        if (this.isDefSingleton) {
            module.addMethodIgnoreNameVisibility(this.getContext(), method, visibility, this);
        } else {
            module.addMethodConsiderNameVisibility(this.getContext(), method, visibility, this);
        }
        return this.getSymbol(this.name);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(StandardTags.StatementTag.class)) {
            this.callTargetSupplier.get();
        }
        return this;
    }

    @Override
    public RubyNode cloneUninitialized() {
        LiteralMethodDefinitionNode copy = new LiteralMethodDefinitionNode(LiteralMethodDefinitionNode.cloneUninitialized(this.moduleNode), this.name, this.sharedMethodInfo, this.isDefSingleton, this.callTargetSupplier);
        return copy.copyFlags(this);
    }
}

