/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.IsANodeGen;
import org.truffleruby.language.objects.MetaClassNode;

@GenerateUncached
public abstract class IsANode
extends RubyBaseNode {
    @NeverDefault
    public static IsANode create() {
        return IsANodeGen.create();
    }

    public static IsANode getUncached() {
        return IsANodeGen.getUncached();
    }

    public abstract boolean executeIsA(Object var1, RubyModule var2);

    @Specialization(guards={"isSingleContext()", "metaClassNode.execute(this, self) == cachedMetaClass", "module == cachedModule"}, assumptions={"getHierarchyUnmodifiedAssumption(cachedModule)"}, limit="getCacheLimit()")
    boolean isAMetaClassCached(Object self, RubyModule module, @Cached @Cached.Shared MetaClassNode metaClassNode, @Cached(value="metaClassNode.execute(this, self)") RubyClass cachedMetaClass, @Cached(value="module") RubyModule cachedModule, @Cached(value="isA(cachedMetaClass, cachedModule)") boolean result) {
        return result;
    }

    public Assumption getHierarchyUnmodifiedAssumption(RubyModule module) {
        if (module instanceof RubyClass) {
            return Assumption.ALWAYS_VALID;
        }
        return module.fields.getHierarchyUnmodifiedAssumption();
    }

    @Specialization(guards={"isSingleContext()", "klass == cachedClass"}, replaces={"isAMetaClassCached"}, limit="getCacheLimit()")
    boolean isAClassCached(Object self, RubyClass klass, @Cached @Cached.Shared MetaClassNode metaClassNode, @Cached @Cached.Shared InlinedConditionProfile isMetaClass, @Cached(value="klass") RubyClass cachedClass) {
        return this.isAClassUncached(self, klass, metaClassNode, isMetaClass);
    }

    @Specialization(replaces={"isAClassCached"})
    boolean isAClassUncached(Object self, RubyClass klass, @Cached @Cached.Shared MetaClassNode metaClassNode, @Cached @Cached.Shared InlinedConditionProfile isMetaClass) {
        RubyClass metaclass = metaClassNode.execute(this, self);
        if (isMetaClass.profile((Node)this, metaclass == klass)) {
            return true;
        }
        assert (metaclass.ancestorClasses != null);
        int depth = klass.depth;
        if (depth < metaclass.depth) {
            return metaclass.ancestorClasses[depth] == klass;
        }
        return false;
    }

    @Specialization(guards={"!isRubyClass(module)"}, replaces={"isAMetaClassCached"})
    boolean isAUncached(Object self, RubyModule module, @Cached @Cached.Shared MetaClassNode metaClassNode) {
        return this.isA(metaClassNode.execute(this, self), module);
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean isA(RubyClass metaClass, RubyModule module) {
        return ModuleOperations.assignableTo(metaClass, module);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.IS_A_CACHE;
    }
}

