/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.ModuleBodyDefinition;

public final class RunModuleDefinitionNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode definingModule;
    private final ModuleBodyDefinition moduleBodyDefinition;
    @Node.Child
    private IndirectCallNode callModuleDefinitionNode = Truffle.getRuntime().createIndirectCallNode();

    public RunModuleDefinitionNode(ModuleBodyDefinition definition, RubyNode definingModule) {
        this.definingModule = definingModule;
        this.moduleBodyDefinition = definition;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyModule module = (RubyModule)this.definingModule.execute(frame);
        InternalMethod definition = this.moduleBodyDefinition.createMethod(frame, module, this);
        return this.callModuleDefinitionNode.call((CallTarget)definition.getCallTarget(), RubyArguments.pack(null, null, definition, null, module, nil, EmptyArgumentsDescriptor.INSTANCE, EMPTY_ARGUMENTS));
    }

    @Override
    public RubyNode cloneUninitialized() {
        RunModuleDefinitionNode copy = new RunModuleDefinitionNode(this.moduleBodyDefinition, this.definingModule.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

