/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.RubyContext;
import org.truffleruby.core.klass.ClassNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.FreezeNode;
import org.truffleruby.language.objects.IsFrozenNodeGen;
import org.truffleruby.language.objects.SingletonClassNodeGen;
import org.truffleruby.language.objects.shared.SharedObjects;

@GenerateUncached
public abstract class SingletonClassNode
extends RubyBaseNode {
    public static SingletonClassNode getUncached() {
        return SingletonClassNodeGen.getUncached();
    }

    public abstract RubyClass execute(Object var1);

    @Specialization(guards={"isSingleContext()", "rubyClass == cachedClass", "cachedSingletonClass != null"}, limit="1")
    RubyClass singletonClassClassCached(RubyClass rubyClass, @Cached(value="rubyClass") RubyClass cachedClass, @Cached(value="getSingletonClassOfClassOrNull(getContext(), cachedClass)") RubyClass cachedSingletonClass) {
        return cachedSingletonClass;
    }

    @Specialization(replaces={"singletonClassClassCached"})
    RubyClass singletonClassClassUncached(RubyClass rubyClass) {
        return ClassNodes.getSingletonClassOfClass(this.getContext(), rubyClass);
    }

    @Specialization(guards={"isSingleContext()", "object == cachedObject", "!isRubyClass(cachedObject)", "!isRubyIO(cachedObject)"}, limit="1")
    RubyClass singletonClassInstanceCached(RubyDynamicObject object, @Cached(value="object") RubyDynamicObject cachedObject, @Cached(value="getSingletonClassForInstance(getContext(), object)") RubyClass cachedSingletonClass) {
        return cachedSingletonClass;
    }

    @Specialization(guards={"!isRubyClass(object)"}, replaces={"singletonClassInstanceCached"})
    RubyClass singletonClassInstanceUncached(RubyDynamicObject object) {
        return this.getSingletonClassForInstance(this.getContext(), object);
    }

    @Specialization(guards={"value"})
    RubyClass singletonClassTrue(boolean value) {
        return this.coreLibrary().trueClass;
    }

    @Specialization(guards={"!value"})
    RubyClass singletonClassFalse(boolean value) {
        return this.coreLibrary().falseClass;
    }

    @Specialization
    RubyClass singletonClassNil(Nil value) {
        return this.coreLibrary().nilClass;
    }

    @Specialization
    RubyClass singletonClass(int value) {
        return this.noSingletonClass();
    }

    @Specialization
    RubyClass singletonClass(long value) {
        return this.noSingletonClass();
    }

    @Specialization
    RubyClass singletonClass(double value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"!isNil(value)"})
    RubyClass singletonClassImmutableObject(ImmutableRubyObject value) {
        return this.noSingletonClass();
    }

    private RubyClass noSingletonClass() {
        throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorCantDefineSingleton(this));
    }

    protected RubyClass getSingletonClassOfClassOrNull(RubyContext context, RubyClass rubyClass) {
        return ClassNodes.getSingletonClassOfClassOrNull(context, rubyClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected RubyClass getSingletonClassForInstance(RubyContext context, RubyDynamicObject object) {
        RubyDynamicObject rubyDynamicObject = object;
        synchronized (rubyDynamicObject) {
            RubyClass metaClass = object.getMetaClass();
            if (metaClass.isSingleton) {
                return metaClass;
            }
            RubyClass logicalClass = object.getLogicalClass();
            RubyClass singletonClass = ClassNodes.createSingletonClassOfObject(context, this.getEncapsulatingSourceSection(), logicalClass, object);
            if (IsFrozenNodeGen.getUncached().execute((Object)object)) {
                FreezeNode.executeUncached(singletonClass);
            }
            SharedObjects.propagate(context.getLanguageSlow(), object, singletonClass);
            object.setMetaClass(singletonClass);
            return singletonClass;
        }
    }

    @NodeChild(value="valueNode", type=RubyNode.class)
    public static abstract class SingletonClassASTNode
    extends RubyContextSourceNode {
        @Specialization
        Object singletonClass(Object value, @Cached SingletonClassNode singletonClassNode) {
            return singletonClassNode.execute(value);
        }

        abstract RubyNode getValueNode();

        @Override
        public RubyNode cloneUninitialized() {
            return SingletonClassNodeGen.SingletonClassASTNodeGen.create(this.getValueNode().cloneUninitialized()).copyFlags(this);
        }
    }
}

