/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.lang.invoke.VarHandle;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

@ReportPolymorphism
@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class WriteObjectFieldNode
extends RubyBaseNode {
    public abstract void execute(Node var1, RubyDynamicObject var2, Object var3, Object var4);

    @Specialization(guards={"!objectLibrary.isShared(object)"}, limit="getDynamicObjectCacheLimit()")
    static void writeLocal(RubyDynamicObject object, Object name, Object value, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
        objectLibrary.put((DynamicObject)object, name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"objectLibrary.isShared(object)"})
    static void writeShared(Node node, RubyDynamicObject object, Object name, Object value, @CachedLibrary(limit="getDynamicObjectCacheLimit()") DynamicObjectLibrary objectLibrary, @Cached WriteBarrierNode writeBarrierNode) {
        writeBarrierNode.execute(node, value);
        VarHandle.storeStoreFence();
        RubyDynamicObject rubyDynamicObject = object;
        synchronized (rubyDynamicObject) {
            objectLibrary.put((DynamicObject)object, name, value);
        }
    }
}

