/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;
import org.truffleruby.language.objects.classvariables.SetClassVariableNodeGen;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

public abstract class SetClassVariableNode
extends RubyBaseNode {
    @NeverDefault
    public static SetClassVariableNode create() {
        return SetClassVariableNodeGen.create();
    }

    public abstract Object execute(RubyModule var1, String var2, Object var3);

    @Specialization(guards={"!objectLibrary.isShared(classVariableStorage)"})
    Object setClassVariableLocal(RubyModule module, String name, Object value, @Bind(value="module.fields.getClassVariables()") ClassVariableStorage classVariableStorage, @CachedLibrary(limit="getDynamicObjectCacheLimit()") @Cached.Shared DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared InlinedBranchProfile slowPath) {
        if (!objectLibrary.putIfPresent((DynamicObject)classVariableStorage, (Object)name, value)) {
            slowPath.enter((Node)this);
            ModuleOperations.setClassVariable(this.getLanguage(), this.getContext(), module, name, value, this);
        }
        return value;
    }

    @Specialization(guards={"objectLibrary.isShared(classVariableStorage)"})
    Object setClassVariableShared(RubyModule module, String name, Object value, @Bind(value="module.fields.getClassVariables()") ClassVariableStorage classVariableStorage, @CachedLibrary(limit="getDynamicObjectCacheLimit()") @Cached.Shared DynamicObjectLibrary objectLibrary, @Cached WriteBarrierNode writeBarrierNode, @Cached @Cached.Shared InlinedBranchProfile slowPath) {
        writeBarrierNode.execute(this, value);
        boolean set = classVariableStorage.putIfPresent(name, value, objectLibrary);
        if (!set) {
            slowPath.enter((Node)this);
            ModuleOperations.setClassVariable(this.getLanguage(), this.getContext(), module, name, value, this);
        }
        return value;
    }
}

