/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.objects.classvariables;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.classvariables.ResolveTargetModuleForClassVariablesNode;
import org.truffleruby.language.objects.classvariables.SetClassVariableNode;

public final class WriteClassVariableNode
extends RubyContextSourceNode
implements AssignableNode {
    private final String name;
    private final BranchProfile topLevelProfile = BranchProfile.create();
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private RubyNode lexicalScopeNode;
    @Node.Child
    private ResolveTargetModuleForClassVariablesNode resolveTargetModuleNode = ResolveTargetModuleForClassVariablesNode.create();
    @Node.Child
    private SetClassVariableNode setClassVariableNode = SetClassVariableNode.create();

    public WriteClassVariableNode(RubyNode lexicalScopeNode, String name, RubyNode rhs) {
        this.lexicalScopeNode = lexicalScopeNode;
        this.name = name;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.rhs.execute(frame);
        this.assign(frame, value);
        return value;
    }

    @Override
    public void assign(VirtualFrame frame, Object value) {
        LexicalScope lexicalScope = (LexicalScope)this.lexicalScopeNode.execute(frame);
        if (lexicalScope.getParent() == null) {
            this.topLevelProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().runtimeErrorClassVariableTopLevel(this));
        }
        RubyModule module = this.resolveTargetModuleNode.execute(lexicalScope);
        this.setClassVariableNode.execute(module, this.name, value);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.ASSIGNMENT;
    }

    @Override
    public AssignableNode toAssignableNode() {
        this.rhs = null;
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    public RubyNode cloneUninitialized() {
        WriteClassVariableNode copy = new WriteClassVariableNode(this.lexicalScopeNode.cloneUninitialized(), this.name, this.rhs.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

