/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.ArrayToObjectArrayNodeGen;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class ReadZSuperArgumentsNode
extends RubyContextSourceNode {
    @Node.Children
    private final RubyNode[] reloadNodes;
    @Node.Child
    private ArrayToObjectArrayNode unsplatNode;
    private final int restArgIndex;
    private final ConditionProfile isArrayProfile = ConditionProfile.create();

    public ReadZSuperArgumentsNode(int restArgIndex, RubyNode[] reloadNodes) {
        this.restArgIndex = restArgIndex;
        this.reloadNodes = reloadNodes;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object[] superArguments = new Object[this.reloadNodes.length];
        for (int n = 0; n < superArguments.length; ++n) {
            superArguments[n] = this.reloadNodes[n].execute(frame);
        }
        if (this.restArgIndex != -1) {
            Object restArg = superArguments[this.restArgIndex];
            Object[] restArgs = this.isArrayProfile.profile(restArg instanceof RubyArray) ? this.unsplat((RubyArray)restArg) : new Object[]{restArg};
            int after = superArguments.length - (this.restArgIndex + 1);
            Object[] splattedArguments = ArrayUtils.copyOf(superArguments, superArguments.length + restArgs.length - 1);
            ArrayUtils.arraycopy(superArguments, this.restArgIndex + 1, splattedArguments, this.restArgIndex + restArgs.length, after);
            ArrayUtils.arraycopy(restArgs, 0, splattedArguments, this.restArgIndex, restArgs.length);
            superArguments = splattedArguments;
        }
        return superArguments;
    }

    private Object[] unsplat(RubyArray array) {
        if (this.unsplatNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unsplatNode = (ArrayToObjectArrayNode)this.insert(ArrayToObjectArrayNodeGen.create());
        }
        return this.unsplatNode.executeToObjectArray(array);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadZSuperArgumentsNode copy = new ReadZSuperArgumentsNode(this.restArgIndex, ReadZSuperArgumentsNode.cloneUninitialized(this.reloadNodes));
        return copy.copyFlags(this);
    }
}

