/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.yield;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.yield.CallBlockNodeGen;

@ReportPolymorphism
@GenerateUncached
public abstract class CallBlockNode
extends RubyBaseNode {
    @NeverDefault
    public static CallBlockNode create() {
        return CallBlockNodeGen.create();
    }

    public static CallBlockNode getUncached() {
        return CallBlockNodeGen.getUncached();
    }

    public final Object yield(RubyProc block, ArgumentsDescriptor descriptor, Object[] args, LiteralCallNode literalCallNode) {
        return this.executeCallBlock(block.declarationContext, block, ProcOperations.getSelf(block), nil, descriptor, args, literalCallNode);
    }

    public final Object yield(RubyProc block, Object ... args) {
        return this.executeCallBlock(block.declarationContext, block, ProcOperations.getSelf(block), nil, EmptyArgumentsDescriptor.INSTANCE, args, null);
    }

    public abstract Object executeCallBlock(DeclarationContext var1, RubyProc var2, Object var3, Object var4, ArgumentsDescriptor var5, Object[] var6, LiteralCallNode var7);

    @Specialization(guards={"block.callTarget == cachedCallTarget"}, limit="getCacheLimit()")
    Object callBlockCached(DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments, LiteralCallNode literalCallNode, @Cached(value="block.callTarget") RootCallTarget cachedCallTarget, @Cached(value="createBlockCallNode(cachedCallTarget)") DirectCallNode callNode) {
        if (literalCallNode != null) {
            literalCallNode.copyRuby2KeywordsHash(arguments, RubyRootNode.of(cachedCallTarget).getSharedMethodInfo());
        }
        Object[] frameArguments = this.packArguments(declarationContext, block, self, blockArgument, descriptor, arguments);
        return callNode.call(frameArguments);
    }

    @Specialization(replaces={"callBlockCached"})
    Object callBlockUncached(DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments, LiteralCallNode literalCallNode, @Cached IndirectCallNode callNode) {
        if (literalCallNode != null) {
            literalCallNode.copyRuby2KeywordsHash(arguments, block.getSharedMethodInfo());
        }
        Object[] frameArguments = this.packArguments(declarationContext, block, self, blockArgument, descriptor, arguments);
        return callNode.call((CallTarget)block.callTarget, frameArguments);
    }

    private Object[] packArguments(DeclarationContext declarationContext, RubyProc block, Object self, Object blockArgument, ArgumentsDescriptor descriptor, Object[] arguments) {
        return RubyArguments.pack(block.declarationFrame, null, block.declaringMethod, declarationContext, block.frameOnStackMarker, self, blockArgument, descriptor, arguments);
    }

    protected DirectCallNode createBlockCallNode(RootCallTarget callTarget) {
        DirectCallNode callNode = Truffle.getRuntime().createDirectCallNode((CallTarget)callTarget);
        if (callNode.isCallTargetCloningAllowed() && RubyRootNode.of(callTarget).shouldAlwaysClone()) {
            callNode.cloneCallTarget();
        }
        if (this.getContext().getOptions().YIELD_ALWAYS_INLINE && callNode.isInlinable()) {
            callNode.forceInlining();
        }
        return callNode;
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.YIELD_CACHE;
    }
}

