/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.options;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionValues;
import org.truffleruby.shared.options.OptionsCatalog;

public final class LanguageOptions {
    public final boolean NO_HOME_PROVIDED;
    public final String CORE_LOAD_PATH;
    public final boolean FROZEN_STRING_LITERALS;
    public final boolean DEFAULT_LAZY;
    public final boolean LAZY_CALLTARGETS;
    public final boolean COVERAGE_GLOBAL;
    public final boolean CORE_AS_INTERNAL;
    public final boolean STDLIB_AS_INTERNAL;
    public final boolean LAZY_TRANSLATION_USER;
    public final boolean BACKTRACES_OMIT_UNUSED;
    public final boolean LAZY_TRANSLATION_LOG;
    public final boolean LOG_DYNAMIC_CONSTANT_LOOKUP;
    public final boolean LAZY_BUILTINS;
    public final boolean LAZY_TRANSLATION_CORE;
    public final boolean CHAOS_DATA;
    public final boolean BASICOPS_INLINE;
    public final boolean PROFILE_ARGUMENTS;
    public final int DEFAULT_CACHE;
    public final int METHOD_LOOKUP_CACHE;
    public final int DISPATCH_CACHE;
    public final int YIELD_CACHE;
    public final int METHOD_TO_PROC_CACHE;
    public final int IS_A_CACHE;
    public final int BIND_CACHE;
    public final int CONSTANT_CACHE;
    public final int INSTANCE_VARIABLE_CACHE;
    public final int BINDING_LOCAL_VARIABLE_CACHE;
    public final int SYMBOL_TO_PROC_CACHE;
    public final int PACK_CACHE;
    public final int UNPACK_CACHE;
    public final int EVAL_CACHE;
    public final int ENCODING_COMPATIBLE_QUERY_CACHE;
    public final int ENCODING_LOADED_CLASSES_CACHE;
    public final int INTEROP_CONVERT_CACHE;
    public final int TIME_FORMAT_CACHE;
    public final int POW_CACHE;
    public final int IDENTITY_CACHE;
    public final int CONTEXT_SPECIFIC_IDENTITY_CACHE;
    public final int CLASS_CACHE;
    public final int ARRAY_DUP_CACHE;
    public final int ARRAY_STRATEGY_CACHE;
    public final int ARRAY_UNINITIALIZED_SIZE;
    public final int PACK_UNROLL_LIMIT;
    public final int PACK_RECOVER_LOOP_MIN;
    public final boolean ALWAYS_CLONE_ALL;
    public final boolean CHECK_CLONE_UNINITIALIZED_CORRECTNESS;
    public final boolean REGEXP_INSTRUMENT_CREATION;
    public final boolean SHARED_OBJECTS_ENABLED;
    public final boolean SHARED_OBJECTS_DEBUG;
    public final boolean SHARED_OBJECTS_FORCE;
    public final boolean RUN_TWICE;
    public final boolean EXPERIMENTAL_ENGINE_CACHING;

    public LanguageOptions(TruffleLanguage.Env env, OptionValues options, boolean singleContext) {
        this.NO_HOME_PROVIDED = (Boolean)options.get(OptionsCatalog.NO_HOME_PROVIDED_KEY);
        this.CORE_LOAD_PATH = (String)options.get(OptionsCatalog.CORE_LOAD_PATH_KEY);
        this.FROZEN_STRING_LITERALS = (Boolean)options.get(OptionsCatalog.FROZEN_STRING_LITERALS_KEY);
        this.DEFAULT_LAZY = (Boolean)options.get(OptionsCatalog.DEFAULT_LAZY_KEY);
        this.LAZY_CALLTARGETS = singleContext && (options.hasBeenSet(OptionsCatalog.LAZY_CALLTARGETS_KEY) ? (Boolean)options.get(OptionsCatalog.LAZY_CALLTARGETS_KEY) != false : this.DEFAULT_LAZY);
        this.COVERAGE_GLOBAL = (Boolean)options.get(OptionsCatalog.COVERAGE_GLOBAL_KEY);
        this.CORE_AS_INTERNAL = (Boolean)options.get(OptionsCatalog.CORE_AS_INTERNAL_KEY);
        this.STDLIB_AS_INTERNAL = (Boolean)options.get(OptionsCatalog.STDLIB_AS_INTERNAL_KEY);
        this.LAZY_TRANSLATION_USER = options.hasBeenSet(OptionsCatalog.LAZY_TRANSLATION_USER_KEY) ? (Boolean)options.get(OptionsCatalog.LAZY_TRANSLATION_USER_KEY) : this.LAZY_CALLTARGETS;
        this.BACKTRACES_OMIT_UNUSED = (Boolean)options.get(OptionsCatalog.BACKTRACES_OMIT_UNUSED_KEY);
        this.LAZY_TRANSLATION_LOG = (Boolean)options.get(OptionsCatalog.LAZY_TRANSLATION_LOG_KEY);
        this.LOG_DYNAMIC_CONSTANT_LOOKUP = (Boolean)options.get(OptionsCatalog.LOG_DYNAMIC_CONSTANT_LOOKUP_KEY);
        this.LAZY_BUILTINS = options.hasBeenSet(OptionsCatalog.LAZY_BUILTINS_KEY) ? (Boolean)options.get(OptionsCatalog.LAZY_BUILTINS_KEY) : this.LAZY_CALLTARGETS;
        this.LAZY_TRANSLATION_CORE = options.hasBeenSet(OptionsCatalog.LAZY_TRANSLATION_CORE_KEY) ? (Boolean)options.get(OptionsCatalog.LAZY_TRANSLATION_CORE_KEY) : this.LAZY_CALLTARGETS;
        this.CHAOS_DATA = (Boolean)options.get(OptionsCatalog.CHAOS_DATA_KEY);
        this.BASICOPS_INLINE = (Boolean)options.get(OptionsCatalog.BASICOPS_INLINE_KEY);
        this.PROFILE_ARGUMENTS = (Boolean)options.get(OptionsCatalog.PROFILE_ARGUMENTS_KEY);
        this.DEFAULT_CACHE = (Integer)options.get(OptionsCatalog.DEFAULT_CACHE_KEY);
        this.METHOD_LOOKUP_CACHE = options.hasBeenSet(OptionsCatalog.METHOD_LOOKUP_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.METHOD_LOOKUP_CACHE_KEY) : this.DEFAULT_CACHE;
        this.DISPATCH_CACHE = options.hasBeenSet(OptionsCatalog.DISPATCH_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.DISPATCH_CACHE_KEY) : this.DEFAULT_CACHE;
        this.YIELD_CACHE = options.hasBeenSet(OptionsCatalog.YIELD_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.YIELD_CACHE_KEY) : this.DEFAULT_CACHE;
        this.METHOD_TO_PROC_CACHE = options.hasBeenSet(OptionsCatalog.METHOD_TO_PROC_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.METHOD_TO_PROC_CACHE_KEY) : this.DEFAULT_CACHE;
        this.IS_A_CACHE = options.hasBeenSet(OptionsCatalog.IS_A_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.IS_A_CACHE_KEY) : this.DEFAULT_CACHE;
        this.BIND_CACHE = options.hasBeenSet(OptionsCatalog.BIND_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.BIND_CACHE_KEY) : this.DEFAULT_CACHE;
        this.CONSTANT_CACHE = options.hasBeenSet(OptionsCatalog.CONSTANT_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.CONSTANT_CACHE_KEY) : this.DEFAULT_CACHE;
        this.INSTANCE_VARIABLE_CACHE = options.hasBeenSet(OptionsCatalog.INSTANCE_VARIABLE_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.INSTANCE_VARIABLE_CACHE_KEY) : this.DEFAULT_CACHE;
        this.BINDING_LOCAL_VARIABLE_CACHE = options.hasBeenSet(OptionsCatalog.BINDING_LOCAL_VARIABLE_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.BINDING_LOCAL_VARIABLE_CACHE_KEY) : this.DEFAULT_CACHE;
        this.SYMBOL_TO_PROC_CACHE = options.hasBeenSet(OptionsCatalog.SYMBOL_TO_PROC_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.SYMBOL_TO_PROC_CACHE_KEY) : this.DEFAULT_CACHE;
        this.PACK_CACHE = options.hasBeenSet(OptionsCatalog.PACK_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.PACK_CACHE_KEY) : this.DEFAULT_CACHE;
        this.UNPACK_CACHE = options.hasBeenSet(OptionsCatalog.UNPACK_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.UNPACK_CACHE_KEY) : this.DEFAULT_CACHE;
        this.EVAL_CACHE = options.hasBeenSet(OptionsCatalog.EVAL_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.EVAL_CACHE_KEY) : this.DEFAULT_CACHE;
        this.ENCODING_COMPATIBLE_QUERY_CACHE = options.hasBeenSet(OptionsCatalog.ENCODING_COMPATIBLE_QUERY_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.ENCODING_COMPATIBLE_QUERY_CACHE_KEY) : this.DEFAULT_CACHE;
        this.ENCODING_LOADED_CLASSES_CACHE = options.hasBeenSet(OptionsCatalog.ENCODING_LOADED_CLASSES_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.ENCODING_LOADED_CLASSES_CACHE_KEY) : this.DEFAULT_CACHE;
        this.INTEROP_CONVERT_CACHE = options.hasBeenSet(OptionsCatalog.INTEROP_CONVERT_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.INTEROP_CONVERT_CACHE_KEY) : this.DEFAULT_CACHE;
        this.TIME_FORMAT_CACHE = options.hasBeenSet(OptionsCatalog.TIME_FORMAT_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.TIME_FORMAT_CACHE_KEY) : this.DEFAULT_CACHE;
        this.POW_CACHE = options.hasBeenSet(OptionsCatalog.POW_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.POW_CACHE_KEY) : this.DEFAULT_CACHE;
        this.IDENTITY_CACHE = (Integer)options.get(OptionsCatalog.IDENTITY_CACHE_KEY);
        this.CONTEXT_SPECIFIC_IDENTITY_CACHE = !singleContext ? 0 : (options.hasBeenSet(OptionsCatalog.CONTEXT_SPECIFIC_IDENTITY_CACHE_KEY) ? (Integer)options.get(OptionsCatalog.CONTEXT_SPECIFIC_IDENTITY_CACHE_KEY) : this.IDENTITY_CACHE);
        this.CLASS_CACHE = (Integer)options.get(OptionsCatalog.CLASS_CACHE_KEY);
        this.ARRAY_DUP_CACHE = (Integer)options.get(OptionsCatalog.ARRAY_DUP_CACHE_KEY);
        this.ARRAY_STRATEGY_CACHE = (Integer)options.get(OptionsCatalog.ARRAY_STRATEGY_CACHE_KEY);
        this.ARRAY_UNINITIALIZED_SIZE = (Integer)options.get(OptionsCatalog.ARRAY_UNINITIALIZED_SIZE_KEY);
        this.PACK_UNROLL_LIMIT = (Integer)options.get(OptionsCatalog.PACK_UNROLL_LIMIT_KEY);
        this.PACK_RECOVER_LOOP_MIN = (Integer)options.get(OptionsCatalog.PACK_RECOVER_LOOP_MIN_KEY);
        this.ALWAYS_CLONE_ALL = (Boolean)options.get(OptionsCatalog.ALWAYS_CLONE_ALL_KEY);
        this.CHECK_CLONE_UNINITIALIZED_CORRECTNESS = (Boolean)options.get(OptionsCatalog.CHECK_CLONE_UNINITIALIZED_CORRECTNESS_KEY);
        this.REGEXP_INSTRUMENT_CREATION = (Boolean)options.get(OptionsCatalog.REGEXP_INSTRUMENT_CREATION_KEY);
        this.SHARED_OBJECTS_ENABLED = (Boolean)options.get(OptionsCatalog.SHARED_OBJECTS_ENABLED_KEY);
        this.SHARED_OBJECTS_DEBUG = (Boolean)options.get(OptionsCatalog.SHARED_OBJECTS_DEBUG_KEY);
        this.SHARED_OBJECTS_FORCE = (Boolean)options.get(OptionsCatalog.SHARED_OBJECTS_FORCE_KEY);
        this.RUN_TWICE = (Boolean)options.get(OptionsCatalog.RUN_TWICE_KEY);
        this.EXPERIMENTAL_ENGINE_CACHING = options.hasBeenSet(OptionsCatalog.EXPERIMENTAL_ENGINE_CACHING_KEY) ? (Boolean)options.get(OptionsCatalog.EXPERIMENTAL_ENGINE_CACHING_KEY) : this.RUN_TWICE;
    }

    public Object fromDescriptor(OptionDescriptor descriptor) {
        switch (descriptor.getName()) {
            case "ruby.no-home-provided": {
                return this.NO_HOME_PROVIDED;
            }
            case "ruby.core-load-path": {
                return this.CORE_LOAD_PATH;
            }
            case "ruby.frozen-string-literals": {
                return this.FROZEN_STRING_LITERALS;
            }
            case "ruby.lazy-default": {
                return this.DEFAULT_LAZY;
            }
            case "ruby.lazy-calltargets": {
                return this.LAZY_CALLTARGETS;
            }
            case "ruby.coverage-global": {
                return this.COVERAGE_GLOBAL;
            }
            case "ruby.core-as-internal": {
                return this.CORE_AS_INTERNAL;
            }
            case "ruby.stdlib-as-internal": {
                return this.STDLIB_AS_INTERNAL;
            }
            case "ruby.lazy-translation-user": {
                return this.LAZY_TRANSLATION_USER;
            }
            case "ruby.backtraces-omit-unused": {
                return this.BACKTRACES_OMIT_UNUSED;
            }
            case "ruby.lazy-translation-log": {
                return this.LAZY_TRANSLATION_LOG;
            }
            case "ruby.constant-dynamic-lookup-log": {
                return this.LOG_DYNAMIC_CONSTANT_LOOKUP;
            }
            case "ruby.lazy-builtins": {
                return this.LAZY_BUILTINS;
            }
            case "ruby.lazy-translation-core": {
                return this.LAZY_TRANSLATION_CORE;
            }
            case "ruby.chaos-data": {
                return this.CHAOS_DATA;
            }
            case "ruby.basic-ops-inline": {
                return this.BASICOPS_INLINE;
            }
            case "ruby.profile-arguments": {
                return this.PROFILE_ARGUMENTS;
            }
            case "ruby.default-cache": {
                return this.DEFAULT_CACHE;
            }
            case "ruby.method-lookup-cache": {
                return this.METHOD_LOOKUP_CACHE;
            }
            case "ruby.dispatch-cache": {
                return this.DISPATCH_CACHE;
            }
            case "ruby.yield-cache": {
                return this.YIELD_CACHE;
            }
            case "ruby.to-proc-cache": {
                return this.METHOD_TO_PROC_CACHE;
            }
            case "ruby.is-a-cache": {
                return this.IS_A_CACHE;
            }
            case "ruby.bind-cache": {
                return this.BIND_CACHE;
            }
            case "ruby.constant-cache": {
                return this.CONSTANT_CACHE;
            }
            case "ruby.instance-variable-cache": {
                return this.INSTANCE_VARIABLE_CACHE;
            }
            case "ruby.binding-local-variable-cache": {
                return this.BINDING_LOCAL_VARIABLE_CACHE;
            }
            case "ruby.symbol-to-proc-cache": {
                return this.SYMBOL_TO_PROC_CACHE;
            }
            case "ruby.pack-cache": {
                return this.PACK_CACHE;
            }
            case "ruby.unpack-cache": {
                return this.UNPACK_CACHE;
            }
            case "ruby.eval-cache": {
                return this.EVAL_CACHE;
            }
            case "ruby.encoding-compatible-query-cache": {
                return this.ENCODING_COMPATIBLE_QUERY_CACHE;
            }
            case "ruby.encoding-loaded-classes-cache": {
                return this.ENCODING_LOADED_CLASSES_CACHE;
            }
            case "ruby.interop-convert-cache": {
                return this.INTEROP_CONVERT_CACHE;
            }
            case "ruby.time-format-cache": {
                return this.TIME_FORMAT_CACHE;
            }
            case "ruby.integer-pow-cache": {
                return this.POW_CACHE;
            }
            case "ruby.identity-cache": {
                return this.IDENTITY_CACHE;
            }
            case "ruby.context-identity-cache": {
                return this.CONTEXT_SPECIFIC_IDENTITY_CACHE;
            }
            case "ruby.class-cache": {
                return this.CLASS_CACHE;
            }
            case "ruby.array-dup-cache": {
                return this.ARRAY_DUP_CACHE;
            }
            case "ruby.array-strategy-cache": {
                return this.ARRAY_STRATEGY_CACHE;
            }
            case "ruby.array-uninitialized-size": {
                return this.ARRAY_UNINITIALIZED_SIZE;
            }
            case "ruby.pack-unroll": {
                return this.PACK_UNROLL_LIMIT;
            }
            case "ruby.pack-recover": {
                return this.PACK_RECOVER_LOOP_MIN;
            }
            case "ruby.always-clone-all": {
                return this.ALWAYS_CLONE_ALL;
            }
            case "ruby.check-clone-uninitialized-correctness": {
                return this.CHECK_CLONE_UNINITIALIZED_CORRECTNESS;
            }
            case "ruby.regexp-instrument-creation": {
                return this.REGEXP_INSTRUMENT_CREATION;
            }
            case "ruby.shared-objects": {
                return this.SHARED_OBJECTS_ENABLED;
            }
            case "ruby.shared-objects-debug": {
                return this.SHARED_OBJECTS_DEBUG;
            }
            case "ruby.shared-objects-force": {
                return this.SHARED_OBJECTS_FORCE;
            }
            case "ruby.run-twice": {
                return this.RUN_TWICE;
            }
            case "ruby.experimental-engine-caching": {
                return this.EXPERIMENTAL_ENGINE_CACHING;
            }
        }
        return null;
    }

    public static boolean areOptionsCompatible(OptionValues one, OptionValues two) {
        return ((Boolean)one.get(OptionsCatalog.NO_HOME_PROVIDED_KEY)).equals(two.get(OptionsCatalog.NO_HOME_PROVIDED_KEY)) && ((String)one.get(OptionsCatalog.CORE_LOAD_PATH_KEY)).equals(two.get(OptionsCatalog.CORE_LOAD_PATH_KEY)) && ((Boolean)one.get(OptionsCatalog.FROZEN_STRING_LITERALS_KEY)).equals(two.get(OptionsCatalog.FROZEN_STRING_LITERALS_KEY)) && ((Boolean)one.get(OptionsCatalog.DEFAULT_LAZY_KEY)).equals(two.get(OptionsCatalog.DEFAULT_LAZY_KEY)) && ((Boolean)one.get(OptionsCatalog.LAZY_CALLTARGETS_KEY)).equals(two.get(OptionsCatalog.LAZY_CALLTARGETS_KEY)) && ((Boolean)one.get(OptionsCatalog.COVERAGE_GLOBAL_KEY)).equals(two.get(OptionsCatalog.COVERAGE_GLOBAL_KEY)) && ((Boolean)one.get(OptionsCatalog.CORE_AS_INTERNAL_KEY)).equals(two.get(OptionsCatalog.CORE_AS_INTERNAL_KEY)) && ((Boolean)one.get(OptionsCatalog.STDLIB_AS_INTERNAL_KEY)).equals(two.get(OptionsCatalog.STDLIB_AS_INTERNAL_KEY)) && ((Boolean)one.get(OptionsCatalog.LAZY_TRANSLATION_USER_KEY)).equals(two.get(OptionsCatalog.LAZY_TRANSLATION_USER_KEY)) && ((Boolean)one.get(OptionsCatalog.BACKTRACES_OMIT_UNUSED_KEY)).equals(two.get(OptionsCatalog.BACKTRACES_OMIT_UNUSED_KEY)) && ((Boolean)one.get(OptionsCatalog.LAZY_TRANSLATION_LOG_KEY)).equals(two.get(OptionsCatalog.LAZY_TRANSLATION_LOG_KEY)) && ((Boolean)one.get(OptionsCatalog.LOG_DYNAMIC_CONSTANT_LOOKUP_KEY)).equals(two.get(OptionsCatalog.LOG_DYNAMIC_CONSTANT_LOOKUP_KEY)) && ((Boolean)one.get(OptionsCatalog.LAZY_BUILTINS_KEY)).equals(two.get(OptionsCatalog.LAZY_BUILTINS_KEY)) && ((Boolean)one.get(OptionsCatalog.LAZY_TRANSLATION_CORE_KEY)).equals(two.get(OptionsCatalog.LAZY_TRANSLATION_CORE_KEY)) && ((Boolean)one.get(OptionsCatalog.CHAOS_DATA_KEY)).equals(two.get(OptionsCatalog.CHAOS_DATA_KEY)) && ((Boolean)one.get(OptionsCatalog.BASICOPS_INLINE_KEY)).equals(two.get(OptionsCatalog.BASICOPS_INLINE_KEY)) && ((Boolean)one.get(OptionsCatalog.PROFILE_ARGUMENTS_KEY)).equals(two.get(OptionsCatalog.PROFILE_ARGUMENTS_KEY)) && ((Integer)one.get(OptionsCatalog.DEFAULT_CACHE_KEY)).equals(two.get(OptionsCatalog.DEFAULT_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.METHOD_LOOKUP_CACHE_KEY)).equals(two.get(OptionsCatalog.METHOD_LOOKUP_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.DISPATCH_CACHE_KEY)).equals(two.get(OptionsCatalog.DISPATCH_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.YIELD_CACHE_KEY)).equals(two.get(OptionsCatalog.YIELD_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.METHOD_TO_PROC_CACHE_KEY)).equals(two.get(OptionsCatalog.METHOD_TO_PROC_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.IS_A_CACHE_KEY)).equals(two.get(OptionsCatalog.IS_A_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.BIND_CACHE_KEY)).equals(two.get(OptionsCatalog.BIND_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.CONSTANT_CACHE_KEY)).equals(two.get(OptionsCatalog.CONSTANT_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.INSTANCE_VARIABLE_CACHE_KEY)).equals(two.get(OptionsCatalog.INSTANCE_VARIABLE_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.BINDING_LOCAL_VARIABLE_CACHE_KEY)).equals(two.get(OptionsCatalog.BINDING_LOCAL_VARIABLE_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.SYMBOL_TO_PROC_CACHE_KEY)).equals(two.get(OptionsCatalog.SYMBOL_TO_PROC_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.PACK_CACHE_KEY)).equals(two.get(OptionsCatalog.PACK_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.UNPACK_CACHE_KEY)).equals(two.get(OptionsCatalog.UNPACK_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.EVAL_CACHE_KEY)).equals(two.get(OptionsCatalog.EVAL_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.ENCODING_COMPATIBLE_QUERY_CACHE_KEY)).equals(two.get(OptionsCatalog.ENCODING_COMPATIBLE_QUERY_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.ENCODING_LOADED_CLASSES_CACHE_KEY)).equals(two.get(OptionsCatalog.ENCODING_LOADED_CLASSES_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.INTEROP_CONVERT_CACHE_KEY)).equals(two.get(OptionsCatalog.INTEROP_CONVERT_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.TIME_FORMAT_CACHE_KEY)).equals(two.get(OptionsCatalog.TIME_FORMAT_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.POW_CACHE_KEY)).equals(two.get(OptionsCatalog.POW_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.IDENTITY_CACHE_KEY)).equals(two.get(OptionsCatalog.IDENTITY_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.CONTEXT_SPECIFIC_IDENTITY_CACHE_KEY)).equals(two.get(OptionsCatalog.CONTEXT_SPECIFIC_IDENTITY_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.CLASS_CACHE_KEY)).equals(two.get(OptionsCatalog.CLASS_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.ARRAY_DUP_CACHE_KEY)).equals(two.get(OptionsCatalog.ARRAY_DUP_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.ARRAY_STRATEGY_CACHE_KEY)).equals(two.get(OptionsCatalog.ARRAY_STRATEGY_CACHE_KEY)) && ((Integer)one.get(OptionsCatalog.ARRAY_UNINITIALIZED_SIZE_KEY)).equals(two.get(OptionsCatalog.ARRAY_UNINITIALIZED_SIZE_KEY)) && ((Integer)one.get(OptionsCatalog.PACK_UNROLL_LIMIT_KEY)).equals(two.get(OptionsCatalog.PACK_UNROLL_LIMIT_KEY)) && ((Integer)one.get(OptionsCatalog.PACK_RECOVER_LOOP_MIN_KEY)).equals(two.get(OptionsCatalog.PACK_RECOVER_LOOP_MIN_KEY)) && ((Boolean)one.get(OptionsCatalog.ALWAYS_CLONE_ALL_KEY)).equals(two.get(OptionsCatalog.ALWAYS_CLONE_ALL_KEY)) && ((Boolean)one.get(OptionsCatalog.CHECK_CLONE_UNINITIALIZED_CORRECTNESS_KEY)).equals(two.get(OptionsCatalog.CHECK_CLONE_UNINITIALIZED_CORRECTNESS_KEY)) && ((Boolean)one.get(OptionsCatalog.REGEXP_INSTRUMENT_CREATION_KEY)).equals(two.get(OptionsCatalog.REGEXP_INSTRUMENT_CREATION_KEY)) && ((Boolean)one.get(OptionsCatalog.SHARED_OBJECTS_ENABLED_KEY)).equals(two.get(OptionsCatalog.SHARED_OBJECTS_ENABLED_KEY)) && ((Boolean)one.get(OptionsCatalog.SHARED_OBJECTS_DEBUG_KEY)).equals(two.get(OptionsCatalog.SHARED_OBJECTS_DEBUG_KEY)) && ((Boolean)one.get(OptionsCatalog.SHARED_OBJECTS_FORCE_KEY)).equals(two.get(OptionsCatalog.SHARED_OBJECTS_FORCE_KEY)) && ((Boolean)one.get(OptionsCatalog.RUN_TWICE_KEY)).equals(two.get(OptionsCatalog.RUN_TWICE_KEY)) && ((Boolean)one.get(OptionsCatalog.EXPERIMENTAL_ENGINE_CACHING_KEY)).equals(two.get(OptionsCatalog.EXPERIMENTAL_ENGINE_CACHING_KEY));
    }

    public static boolean areOptionsCompatibleOrLog(TruffleLogger logger, LanguageOptions oldOptions, LanguageOptions newOptions) {
        Object oldValue = oldOptions.NO_HOME_PROVIDED;
        Object newValue = newOptions.NO_HOME_PROVIDED;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --no-home-provided differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        newValue = newOptions.CORE_LOAD_PATH;
        oldValue = oldOptions.CORE_LOAD_PATH;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --core-load-path differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.FROZEN_STRING_LITERALS;
        newValue = newOptions.FROZEN_STRING_LITERALS;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --frozen-string-literals differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.DEFAULT_LAZY;
        newValue = newOptions.DEFAULT_LAZY;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --lazy-default differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.LAZY_CALLTARGETS;
        newValue = newOptions.LAZY_CALLTARGETS;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --lazy-calltargets differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.COVERAGE_GLOBAL;
        newValue = newOptions.COVERAGE_GLOBAL;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --coverage-global differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.CORE_AS_INTERNAL;
        newValue = newOptions.CORE_AS_INTERNAL;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --core-as-internal differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.STDLIB_AS_INTERNAL;
        newValue = newOptions.STDLIB_AS_INTERNAL;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --stdlib-as-internal differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.LAZY_TRANSLATION_USER;
        newValue = newOptions.LAZY_TRANSLATION_USER;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --lazy-translation-user differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.BACKTRACES_OMIT_UNUSED;
        newValue = newOptions.BACKTRACES_OMIT_UNUSED;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --backtraces-omit-unused differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.LAZY_TRANSLATION_LOG;
        newValue = newOptions.LAZY_TRANSLATION_LOG;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --lazy-translation-log differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.LOG_DYNAMIC_CONSTANT_LOOKUP;
        newValue = newOptions.LOG_DYNAMIC_CONSTANT_LOOKUP;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --constant-dynamic-lookup-log differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.LAZY_BUILTINS;
        newValue = newOptions.LAZY_BUILTINS;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --lazy-builtins differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.LAZY_TRANSLATION_CORE;
        newValue = newOptions.LAZY_TRANSLATION_CORE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --lazy-translation-core differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.CHAOS_DATA;
        newValue = newOptions.CHAOS_DATA;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --chaos-data differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.BASICOPS_INLINE;
        newValue = newOptions.BASICOPS_INLINE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --basic-ops-inline differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.PROFILE_ARGUMENTS;
        newValue = newOptions.PROFILE_ARGUMENTS;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --profile-arguments differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.DEFAULT_CACHE;
        newValue = newOptions.DEFAULT_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --default-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.METHOD_LOOKUP_CACHE;
        newValue = newOptions.METHOD_LOOKUP_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --method-lookup-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.DISPATCH_CACHE;
        newValue = newOptions.DISPATCH_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --dispatch-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.YIELD_CACHE;
        newValue = newOptions.YIELD_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --yield-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.METHOD_TO_PROC_CACHE;
        newValue = newOptions.METHOD_TO_PROC_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --to-proc-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.IS_A_CACHE;
        newValue = newOptions.IS_A_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --is-a-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.BIND_CACHE;
        newValue = newOptions.BIND_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --bind-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.CONSTANT_CACHE;
        newValue = newOptions.CONSTANT_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --constant-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.INSTANCE_VARIABLE_CACHE;
        newValue = newOptions.INSTANCE_VARIABLE_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --instance-variable-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.BINDING_LOCAL_VARIABLE_CACHE;
        newValue = newOptions.BINDING_LOCAL_VARIABLE_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --binding-local-variable-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.SYMBOL_TO_PROC_CACHE;
        newValue = newOptions.SYMBOL_TO_PROC_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --symbol-to-proc-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.PACK_CACHE;
        newValue = newOptions.PACK_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --pack-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.UNPACK_CACHE;
        newValue = newOptions.UNPACK_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --unpack-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.EVAL_CACHE;
        newValue = newOptions.EVAL_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --eval-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.ENCODING_COMPATIBLE_QUERY_CACHE;
        newValue = newOptions.ENCODING_COMPATIBLE_QUERY_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --encoding-compatible-query-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.ENCODING_LOADED_CLASSES_CACHE;
        newValue = newOptions.ENCODING_LOADED_CLASSES_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --encoding-loaded-classes-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.INTEROP_CONVERT_CACHE;
        newValue = newOptions.INTEROP_CONVERT_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --interop-convert-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.TIME_FORMAT_CACHE;
        newValue = newOptions.TIME_FORMAT_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --time-format-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.POW_CACHE;
        newValue = newOptions.POW_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --integer-pow-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.IDENTITY_CACHE;
        newValue = newOptions.IDENTITY_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --identity-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.CONTEXT_SPECIFIC_IDENTITY_CACHE;
        newValue = newOptions.CONTEXT_SPECIFIC_IDENTITY_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --context-identity-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.CLASS_CACHE;
        newValue = newOptions.CLASS_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --class-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.ARRAY_DUP_CACHE;
        newValue = newOptions.ARRAY_DUP_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --array-dup-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.ARRAY_STRATEGY_CACHE;
        newValue = newOptions.ARRAY_STRATEGY_CACHE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --array-strategy-cache differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.ARRAY_UNINITIALIZED_SIZE;
        newValue = newOptions.ARRAY_UNINITIALIZED_SIZE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --array-uninitialized-size differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.PACK_UNROLL_LIMIT;
        newValue = newOptions.PACK_UNROLL_LIMIT;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --pack-unroll differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.PACK_RECOVER_LOOP_MIN;
        newValue = newOptions.PACK_RECOVER_LOOP_MIN;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --pack-recover differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.ALWAYS_CLONE_ALL;
        newValue = newOptions.ALWAYS_CLONE_ALL;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --always-clone-all differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.CHECK_CLONE_UNINITIALIZED_CORRECTNESS;
        newValue = newOptions.CHECK_CLONE_UNINITIALIZED_CORRECTNESS;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --check-clone-uninitialized-correctness differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.REGEXP_INSTRUMENT_CREATION;
        newValue = newOptions.REGEXP_INSTRUMENT_CREATION;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --regexp-instrument-creation differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.SHARED_OBJECTS_ENABLED;
        newValue = newOptions.SHARED_OBJECTS_ENABLED;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --shared-objects differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.SHARED_OBJECTS_DEBUG;
        newValue = newOptions.SHARED_OBJECTS_DEBUG;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --shared-objects-debug differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.SHARED_OBJECTS_FORCE;
        newValue = newOptions.SHARED_OBJECTS_FORCE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --shared-objects-force differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.RUN_TWICE;
        newValue = newOptions.RUN_TWICE;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --run-twice differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        oldValue = oldOptions.EXPERIMENTAL_ENGINE_CACHING;
        newValue = newOptions.EXPERIMENTAL_ENGINE_CACHING;
        if (!newValue.equals(oldValue)) {
            logger.fine("not reusing pre-initialized context: --experimental-engine-caching differs, was: " + oldValue + " and is now: " + newValue);
            return false;
        }
        return true;
    }
}

