/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import org.truffleruby.parser.IdentifierType;

public final class Identifiers {
    @CompilerDirectives.TruffleBoundary
    public static boolean isValidConstantName(String id) {
        if (id.isEmpty()) {
            return false;
        }
        int first = id.codePointAt(0);
        return Identifiers.isConstantFirstCodePoint(first) && Identifiers.isNameString(id, Character.charCount(first));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidLocalVariableName(String id) {
        return Identifiers.isValidIdentifier(id, 0);
    }

    @CompilerDirectives.TruffleBoundary
    @Idempotent
    public static boolean isValidClassVariableName(String id) {
        return id.startsWith("@@") && Identifiers.isValidIdentifier(id, 2);
    }

    @CompilerDirectives.TruffleBoundary
    @Idempotent
    public static boolean isValidInstanceVariableName(String id) {
        return id.startsWith("@") && Identifiers.isValidIdentifier(id, 1);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isValidGlobalVariableName(String id) {
        return id.startsWith("$") && Identifiers.isValidIdentifier(id, 1);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isValidIdentifier(String id, int start) {
        if (start >= id.length()) {
            return false;
        }
        int codePoint = id.codePointAt(start);
        return Identifiers.isInitialCharacter(codePoint) && Identifiers.isNameString(id, start + Character.charCount(codePoint));
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isNameString(String id, int start) {
        int codePoint;
        int length = id.length();
        for (int i = start; i < length; i += Character.charCount(codePoint)) {
            codePoint = id.codePointAt(i);
            if (Character.isLetterOrDigit(codePoint) || codePoint == 95) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isInitialCharacter(int c) {
        return Character.isAlphabetic(c) || c == 95 || c >= 128;
    }

    private static boolean isConstantFirstCodePoint(int first) {
        return Character.isUpperCase(first) || !Character.isLowerCase(first) && Character.isTitleCase(first);
    }

    public static IdentifierType stringToType(String id) {
        if (id.isEmpty()) {
            return IdentifierType.JUNK;
        }
        int first = id.codePointAt(0);
        switch (first) {
            case 0: {
                return IdentifierType.JUNK;
            }
            case 36: {
                return Identifiers.isValidIdentifier(id, 1) ? IdentifierType.GLOBAL : IdentifierType.JUNK;
            }
            case 64: {
                if (Identifiers.isValidClassVariableName(id)) {
                    return IdentifierType.CLASS;
                }
                if (Identifiers.isValidIdentifier(id, 1)) {
                    return IdentifierType.INSTANCE;
                }
                return IdentifierType.JUNK;
            }
        }
        if (Identifiers.isValidConstantName(id)) {
            return IdentifierType.CONST;
        }
        if (Identifiers.isValidLocalVariableName(id)) {
            return IdentifierType.LOCAL;
        }
        return IdentifierType.JUNK;
    }
}

