/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.source.Source;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.parser.RubySource;

public final class ParseEnvironment {
    public final Source source;
    private final boolean inCore;
    private final boolean coverageEnabled;
    public Boolean allowTruffleRubyPrimitives = null;

    public ParseEnvironment(RubyLanguage language, RubySource rubySource) {
        this.source = rubySource.getSource();
        this.inCore = RubyLanguage.getPath(this.source).startsWith(language.corePath);
        this.coverageEnabled = "application/x-ruby;coverage=true".equals(rubySource.getSource().getMimeType());
    }

    public boolean inCore() {
        return this.inCore;
    }

    public boolean canUsePrimitives() {
        assert (this.allowTruffleRubyPrimitives != null);
        return this.inCore() || this.allowTruffleRubyPrimitives != false;
    }

    public boolean isCoverageEnabled() {
        return this.coverageEnabled;
    }

    @SuppressFBWarnings(value={"ISC_INSTANTIATE_STATIC_CLASS"})
    public ReturnID allocateReturnID() {
        return new ReturnID();
    }

    @SuppressFBWarnings(value={"ISC_INSTANTIATE_STATIC_CLASS"})
    public BreakID allocateBreakID() {
        return new BreakID();
    }
}

