/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import java.util.Arrays;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.ArrayLiteralNode;
import org.truffleruby.core.array.ArrayPatternLengthCheckNode;
import org.truffleruby.core.array.ArraySliceNode;
import org.truffleruby.core.array.ArraySliceNodeGen;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.control.AndNodeGen;
import org.truffleruby.language.control.ExecuteAndReturnTrueNode;
import org.truffleruby.language.control.NotNodeGen;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.literal.NilLiteralNode;
import org.truffleruby.language.literal.TruffleInternalModuleLiteralNode;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.ReadLocalVariableNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.parser.BaseTranslator;
import org.truffleruby.parser.BodyTranslator;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.TranslatorEnvironment;
import org.truffleruby.parser.ast.ArrayParseNode;
import org.truffleruby.parser.ast.ArrayPatternParseNode;
import org.truffleruby.parser.ast.CallParseNode;
import org.truffleruby.parser.ast.ConstParseNode;
import org.truffleruby.parser.ast.DAsgnParseNode;
import org.truffleruby.parser.ast.DStrParseNode;
import org.truffleruby.parser.ast.DotParseNode;
import org.truffleruby.parser.ast.FalseParseNode;
import org.truffleruby.parser.ast.FindPatternParseNode;
import org.truffleruby.parser.ast.FixnumParseNode;
import org.truffleruby.parser.ast.HashPatternParseNode;
import org.truffleruby.parser.ast.IfParseNode;
import org.truffleruby.parser.ast.LambdaParseNode;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.LocalAsgnParseNode;
import org.truffleruby.parser.ast.NilParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.RegexpParseNode;
import org.truffleruby.parser.ast.StarParseNode;
import org.truffleruby.parser.ast.StrParseNode;
import org.truffleruby.parser.ast.TrueParseNode;

public final class PatternMatchingTranslator
extends BaseTranslator {
    final TranslatorEnvironment environment;
    final BodyTranslator bodyTranslator;
    RubyNode currentValueToMatch;

    public PatternMatchingTranslator(RubyLanguage language, Source source, ParserContext parserContext, Node currentNode, TranslatorEnvironment environment, BodyTranslator bodyTranslator) {
        super(language, source, parserContext, currentNode, environment);
        this.environment = environment;
        this.bodyTranslator = bodyTranslator;
    }

    public RubyNode translatePatternNode(ParseNode patternNode, RubyNode expressionValue) {
        this.currentValueToMatch = expressionValue;
        switch (patternNode.getNodeType()) {
            case ARRAYPATTERNNODE: {
                return this.visitArrayPatternNode((ArrayPatternParseNode)patternNode);
            }
            case HASHPATTERNNODE: 
            case FINDPATTERNNODE: {
                RubyContext context = RubyLanguage.getCurrentContext();
                throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("not yet handled in pattern matching: " + patternNode + " " + patternNode.getPosition(), this.currentNode, patternNode.getPosition().toSourceSection(this.source)));
            }
            case IFNODE: {
                RubyNode pattern;
                IfParseNode ifNode = (IfParseNode)patternNode;
                RubyNode condition = ifNode.getCondition().accept(this.bodyTranslator);
                if (ifNode.getThenBody() != null) {
                    pattern = this.translatePatternNode(ifNode.getThenBody(), expressionValue);
                } else {
                    pattern = this.translatePatternNode(ifNode.getElseBody(), expressionValue);
                    condition = NotNodeGen.create(condition);
                }
                return AndNodeGen.create(pattern, condition);
            }
        }
        return this.createCallNode(patternNode.accept(this), "===", (RubyNode)NodeUtil.cloneNode((Node)expressionValue));
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        RubyContext context = RubyLanguage.getCurrentContext();
        throw new RaiseException(context, (RubyException)context.getCoreExceptions().syntaxError("not yet handled in pattern matching: " + node.toString() + " " + node.getPosition(), this.currentNode, node.getPosition().toSourceSection(this.source)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitArrayPatternNode(ArrayPatternParseNode arrayPatternParseNode) {
        RubyContextSourceNode callNode;
        RubyNode translatedPatternElement;
        ArrayIndexNodes.ReadConstantIndexNode exprElement;
        RubyNode prev;
        SourceIndexLength sourceSection = arrayPatternParseNode.getPosition();
        ListParseNode preNodes = arrayPatternParseNode.getPreArgs();
        ListParseNode postNodes = arrayPatternParseNode.getPostArgs();
        ParseNode restNode = arrayPatternParseNode.getRestArg();
        RubyContextSourceNode deconstructed = this.createCallNode(new TruffleInternalModuleLiteralNode(), "deconstruct_checked", this.currentValueToMatch);
        int deconstructedSlot = this.environment.declareLocalTemp("p_decon_array");
        ReadLocalVariableNode readTemp = this.environment.readNode(deconstructedSlot, sourceSection);
        WriteLocalNode assignTemp = ((ReadLocalNode)readTemp).makeWriteNode(deconstructed);
        this.currentValueToMatch = readTemp;
        int preSize = arrayPatternParseNode.preArgsNum();
        RubyContextSourceNode condition = new ArrayPatternLengthCheckNode(arrayPatternParseNode.minimumArgsNum(), this.currentValueToMatch, arrayPatternParseNode.hasRestArg());
        if (arrayPatternParseNode.hasConstant()) {
            ConstParseNode constant = (ConstParseNode)arrayPatternParseNode.getConstant();
            RubyNode constVal = constant.accept(this);
            RubyContextSourceNode isInstance = this.createCallNode(constVal, "===", this.currentValueToMatch);
            condition = AndNodeGen.create(isInstance, condition);
        }
        for (int i = 0; i < preSize; ++i) {
            ParseNode preNode = preNodes.get(i);
            prev = this.currentValueToMatch;
            exprElement = ArrayIndexNodes.ReadConstantIndexNode.create(this.currentValueToMatch, i);
            this.currentValueToMatch = exprElement;
            try {
                translatedPatternElement = preNode.accept(this);
            }
            finally {
                this.currentValueToMatch = prev;
            }
            callNode = this.createCallNode(translatedPatternElement, "===", (RubyNode)NodeUtil.cloneNode((Node)exprElement));
            condition = AndNodeGen.create(condition, callNode);
        }
        if (restNode != null && !(restNode instanceof StarParseNode)) {
            RubyNode restAccept;
            RubyNode prev2 = this.currentValueToMatch;
            int postSize = postNodes == null ? 0 : postNodes.size();
            ArraySliceNode exprSlice = ArraySliceNodeGen.create(preSize, -postSize, this.currentValueToMatch);
            this.currentValueToMatch = exprSlice;
            try {
                restAccept = restNode.accept(this);
            }
            finally {
                this.currentValueToMatch = prev2;
            }
            ExecuteAndReturnTrueNode seq = new ExecuteAndReturnTrueNode(restAccept);
            condition = AndNodeGen.create(condition, seq);
        }
        if (postNodes != null) {
            for (int i = 0; i < postNodes.size(); ++i) {
                ParseNode loopPostNode = postNodes.get(i);
                prev = this.currentValueToMatch;
                exprElement = ArrayIndexNodes.ReadConstantIndexNode.create(this.currentValueToMatch, -postNodes.size() + i);
                this.currentValueToMatch = exprElement;
                try {
                    translatedPatternElement = loopPostNode.accept(this);
                }
                finally {
                    this.currentValueToMatch = prev;
                }
                callNode = this.createCallNode(translatedPatternElement, "===", (RubyNode)NodeUtil.cloneNode((Node)exprElement));
                condition = AndNodeGen.create(condition, callNode);
            }
        }
        return PatternMatchingTranslator.sequence(sourceSection, Arrays.asList(new RubyNode[]{assignTemp, condition}));
    }

    @Override
    public RubyNode visitFindPatternNode(FindPatternParseNode findPatternParseNode) {
        return findPatternParseNode.accept(this);
    }

    @Override
    public RubyNode visitHashPatternNode(HashPatternParseNode node) {
        RubyContextSourceNode deconstructed = this.createCallNode(this.currentValueToMatch, "deconstruct_keys", new NilLiteralNode(true));
        return this.createCallNode(new TruffleInternalModuleLiteralNode(), "hash_pattern_matches?", node.accept(this), (RubyNode)NodeUtil.cloneNode((Node)deconstructed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitArrayNode(ArrayParseNode node) {
        ParseNode[] values = node.children();
        RubyNode[] translatedValues = PatternMatchingTranslator.createArray(values.length);
        for (int n = 0; n < values.length; ++n) {
            RubyNode prev = this.currentValueToMatch;
            this.currentValueToMatch = ArrayIndexNodes.ReadConstantIndexNode.create(this.currentValueToMatch, n);
            try {
                translatedValues[n] = values[n].accept(this);
                continue;
            }
            finally {
                this.currentValueToMatch = prev;
            }
        }
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.language, translatedValues);
        ret.unsafeSetSourceSection(node.getPosition());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitLocalAsgnNode(LocalAsgnParseNode node) {
        WriteLocalNode writeLocalNode = this.bodyTranslator.visitLocalAsgnNode(node);
        writeLocalNode.setValueNode(this.currentValueToMatch);
        return writeLocalNode;
    }

    @Override
    public RubyNode visitDAsgnNode(DAsgnParseNode node) {
        WriteLocalNode writeLocalNode = this.bodyTranslator.visitDAsgnNode(node);
        writeLocalNode.setValueNode(this.currentValueToMatch);
        return writeLocalNode;
    }

    @Override
    public RubyNode visitFixnumNode(FixnumParseNode node) {
        return this.bodyTranslator.visitFixnumNode(node);
    }

    @Override
    public RubyNode visitTrueNode(TrueParseNode node) {
        return this.bodyTranslator.visitTrueNode(node);
    }

    @Override
    public RubyNode visitFalseNode(FalseParseNode node) {
        return this.bodyTranslator.visitFalseNode(node);
    }

    @Override
    public RubyNode visitStrNode(StrParseNode node) {
        return this.bodyTranslator.visitStrNode(node);
    }

    @Override
    public RubyNode visitDotNode(DotParseNode node) {
        return this.bodyTranslator.visitDotNode(node);
    }

    @Override
    public RubyNode visitNilNode(NilParseNode node) {
        return this.bodyTranslator.visitNilNode(node);
    }

    @Override
    public RubyNode visitConstNode(ConstParseNode node) {
        return this.bodyTranslator.visitConstNode(node);
    }

    @Override
    public RubyNode visitRegexpNode(RegexpParseNode node) {
        return this.bodyTranslator.visitRegexpNode(node);
    }

    @Override
    public RubyNode visitLambdaNode(LambdaParseNode node) {
        return this.bodyTranslator.visitLambdaNode(node);
    }

    @Override
    public RubyNode visitDStrNode(DStrParseNode node) {
        return this.bodyTranslator.visitDStrNode(node);
    }

    @Override
    public RubyNode visitCallNode(CallParseNode node) {
        return this.bodyTranslator.visitCallNode(node);
    }
}

