/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.util.ArrayList;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.hash.ConcatHashLiteralNode;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.literal.ObjectLiteralNode;
import org.truffleruby.parser.BodyTranslator;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.ArgumentParseNode;
import org.truffleruby.parser.ast.AssignableParseNode;
import org.truffleruby.parser.ast.KeywordArgParseNode;
import org.truffleruby.parser.ast.KeywordRestArgParseNode;
import org.truffleruby.parser.ast.MultipleAsgnParseNode;
import org.truffleruby.parser.ast.NoKeywordsArgParseNode;
import org.truffleruby.parser.ast.OptArgParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.RestArgParseNode;
import org.truffleruby.parser.ast.types.INameNode;

public final class ReloadArgumentsTranslator
extends Translator {
    private final BodyTranslator methodBodyTranslator;
    private final boolean hasKeywordArguments;
    private int index = 0;
    private int restParameterIndex = -1;

    public ReloadArgumentsTranslator(RubyLanguage language, Source source, ParserContext parserContext, Node currentNode, BodyTranslator methodBodyTranslator, ArgsParseNode argsNode) {
        super(language, source, parserContext, currentNode);
        this.methodBodyTranslator = methodBodyTranslator;
        this.hasKeywordArguments = argsNode.hasKwargs();
    }

    public int getRestParameterIndex() {
        return this.restParameterIndex;
    }

    public RubyNode[] reload(ArgsParseNode node) {
        int postCount;
        int optArgsCount;
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        ParseNode[] args = node.getArgs();
        int preCount = node.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                sequence.add(args[i].accept(this));
                ++this.index;
            }
        }
        if ((optArgsCount = node.getOptionalArgsCount()) > 0) {
            int optArgsIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgsCount; ++i) {
                sequence.add(args[optArgsIndex + i].accept(this));
                ++this.index;
            }
        }
        if (node.hasRestArg()) {
            this.restParameterIndex = node.getPostIndex();
            sequence.add(node.getRestArgNode().accept(this));
        }
        if ((postCount = node.getPostCount()) > 0) {
            this.index = -postCount;
            int postIndex = node.getPostIndex();
            for (int i = 0; i < postCount; ++i) {
                sequence.add(args[postIndex + i].accept(this));
                ++this.index;
            }
        }
        RubyNode kwArgsNode = null;
        if (node.hasKwargs()) {
            int keywordIndex = node.getKeywordsIndex();
            int keywordCount = node.getKeywordCount();
            RubyNode[] keyValues = new RubyNode[keywordCount * 2];
            for (int i = 0; i < keywordCount; ++i) {
                KeywordArgParseNode kwArg = (KeywordArgParseNode)args[keywordIndex + i];
                RubyNode value = kwArg.accept(this);
                String name = ((INameNode)((Object)kwArg.getAssignable())).getName();
                ObjectLiteralNode key = new ObjectLiteralNode(this.language.getSymbol(name));
                keyValues[2 * i] = key;
                keyValues[2 * i + 1] = value;
            }
            kwArgsNode = HashLiteralNode.create(keyValues);
        }
        if (node.hasKeyRest()) {
            RubyNode keyRest = node.getKeyRest().accept(this);
            kwArgsNode = kwArgsNode == null ? keyRest : new ConcatHashLiteralNode(new RubyNode[]{kwArgsNode, keyRest});
        }
        if (kwArgsNode != null) {
            sequence.add(kwArgsNode);
        }
        return sequence.toArray(RubyNode.EMPTY_ARRAY);
    }

    @Override
    public RubyNode visitArgumentNode(ArgumentParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    @Override
    public RubyNode visitOptArgNode(OptArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        return ReloadArgumentsTranslator.profileArgument(this.language, new ReadPreArgumentNode(this.index, this.hasKeywordArguments, MissingArgumentBehavior.NIL));
    }

    @Override
    public RubyNode visitRestArgNode(RestArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    @Override
    public RubyNode visitKeywordArgNode(KeywordArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        AssignableParseNode asgnNode = node.getAssignable();
        String name = ((INameNode)((Object)asgnNode)).getName();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(name, sourceSection);
    }

    @Override
    public RubyNode visitKeywordRestArgNode(KeywordRestArgParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    @Override
    public RubyNode visitNoKeywordsArgNode(NoKeywordsArgParseNode node) {
        return this.defaultVisit(node);
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        return this.nilNode(sourceSection);
    }
}

