/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser;

import java.util.Arrays;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.locals.WriteLocalVariableNode;
import org.truffleruby.parser.BodyTranslator;
import org.truffleruby.parser.Translator;
import org.truffleruby.parser.ast.LocalVarParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.SelfParseNode;
import org.truffleruby.parser.ast.SplatParseNode;

public interface ValueFromNode {
    public RubyNode prepareAndThen(SourceIndexLength var1, RubyNode var2);

    public ParseNode get(SourceIndexLength var1);

    public static ValueFromNode valueFromNode(BodyTranslator translator, ParseNode node) {
        if (node instanceof SelfParseNode) {
            return new ValueFromSelfNode();
        }
        if (node instanceof SplatParseNode) {
            return new ValueFromSplatNode(translator, (SplatParseNode)node);
        }
        return new ValueFromEffectNode(translator, node);
    }

    public static final class ValueFromSelfNode
    implements ValueFromNode {
        @Override
        public RubyNode prepareAndThen(SourceIndexLength sourceSection, RubyNode subsequent) {
            return subsequent;
        }

        @Override
        public ParseNode get(SourceIndexLength sourceSection) {
            return new SelfParseNode(sourceSection);
        }
    }

    public static final class ValueFromSplatNode
    implements ValueFromNode {
        private final ValueFromNode value;

        public ValueFromSplatNode(BodyTranslator translator, SplatParseNode node) {
            this.value = ValueFromNode.valueFromNode(translator, node.getValue());
        }

        @Override
        public RubyNode prepareAndThen(SourceIndexLength sourceSection, RubyNode subsequent) {
            return this.value.prepareAndThen(sourceSection, subsequent);
        }

        @Override
        public ParseNode get(SourceIndexLength sourceSection) {
            return new SplatParseNode(sourceSection, this.value.get(sourceSection));
        }
    }

    public static final class ValueFromEffectNode
    implements ValueFromNode {
        private final BodyTranslator translator;
        private final ParseNode node;
        private final String temp;
        private final int slot;
        private boolean sequenced = false;

        public ValueFromEffectNode(BodyTranslator translator, ParseNode node) {
            this.translator = translator;
            this.node = node;
            this.temp = translator.getEnvironment().allocateLocalTemp("value");
            this.slot = translator.getEnvironment().declareVar(this.temp);
        }

        @Override
        public RubyNode prepareAndThen(SourceIndexLength sourceSection, RubyNode subsequent) {
            if (this.sequenced) {
                throw new UnsupportedOperationException("don't use a value more than once");
            }
            this.sequenced = true;
            return Translator.sequence(sourceSection, Arrays.asList(new WriteLocalVariableNode(this.slot, this.node.accept(this.translator)), subsequent));
        }

        @Override
        public ParseNode get(SourceIndexLength sourceSection) {
            return new LocalVarParseNode(sourceSection, 0, this.temp);
        }
    }
}

