/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public class ArgumentParseNode
extends ParseNode
implements INameNode {
    private String identifier;
    private int location;

    public ArgumentParseNode(SourceIndexLength position, String identifier) {
        super(position);
        this.identifier = identifier;
    }

    public ArgumentParseNode(SourceIndexLength position, String identifier, int location) {
        this(position, identifier);
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGUMENTNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArgumentNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    public void setName(String name) {
        this.identifier = name;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }
}

