/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.StarParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class ArrayPatternParseNode
extends ParseNode {
    private ListParseNode preArgs;
    private final ParseNode restArg;
    private final ListParseNode postArgs;
    private ParseNode constant;

    public ArrayPatternParseNode(SourceIndexLength position, ListParseNode preArgs, ParseNode restArg, ListParseNode postArgs) {
        super(position);
        this.preArgs = preArgs;
        this.restArg = restArg;
        this.postArgs = postArgs;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArrayPatternNode(this);
    }

    @Override
    public List<ParseNode> childNodes() {
        return ArrayPatternParseNode.createList(this.preArgs, this.restArg, this.postArgs, this.constant);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARRAYPATTERNNODE;
    }

    public void setConstant(ParseNode constant) {
        this.constant = constant;
    }

    public boolean hasConstant() {
        return this.constant != null;
    }

    public ParseNode getConstant() {
        return this.constant;
    }

    public ListParseNode getPreArgs() {
        return this.preArgs;
    }

    public ListParseNode getPostArgs() {
        return this.postArgs;
    }

    public void setPreArgs(ListParseNode preArgs) {
        this.preArgs = preArgs;
    }

    public ParseNode getRestArg() {
        return this.restArg;
    }

    public boolean hasRestArg() {
        return this.restArg != null;
    }

    public boolean isNamedRestArg() {
        return !(this.restArg instanceof StarParseNode);
    }

    public boolean usesRestNum() {
        if (this.restArg == null) {
            return false;
        }
        boolean named = !(this.restArg instanceof StarParseNode);
        return named || this.postArgsNum() > 0;
    }

    public int preArgsNum() {
        return this.preArgs == null ? 0 : this.preArgs.size();
    }

    public int postArgsNum() {
        return this.postArgs == null ? 0 : this.postArgs.size();
    }

    public int minimumArgsNum() {
        return this.preArgsNum() + this.postArgsNum();
    }
}

