/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.IArgumentNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.SelfParseNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class AttrAssignParseNode
extends ParseNode
implements INameNode,
IArgumentNode {
    private final ParseNode receiverNode;
    private String name;
    private ParseNode argsNode;
    private final boolean isLazy;
    private final boolean isSelf;

    public AttrAssignParseNode(SourceIndexLength position, ParseNode receiverNode, String name, ParseNode argsNode, boolean isLazy) {
        this(position, receiverNode, name, argsNode, isLazy, receiverNode instanceof SelfParseNode);
    }

    public AttrAssignParseNode(SourceIndexLength position, ParseNode receiverNode, String name, ParseNode argsNode, boolean isLazy, boolean isSelf) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.name = name;
        this.argsNode = argsNode;
        this.isLazy = isLazy;
        this.isSelf = isSelf;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ATTRASSIGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public ParseNode getArgsNode() {
        return this.argsNode;
    }

    @Override
    public ParseNode setArgsNode(ParseNode argsNode) {
        this.argsNode = argsNode;
        return this;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.argsNode);
    }

    public boolean isSelf() {
        return this.isSelf;
    }
}

