/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class CaseInParseNode
extends ParseNode {
    private final ParseNode caseNode;
    private final ListParseNode cases;
    private ParseNode elseNode = null;

    public CaseInParseNode(SourceIndexLength position, ParseNode caseNode, ListParseNode cases) {
        super(position);
        assert (cases != null) : "caseBody is not null";
        this.caseNode = caseNode;
        this.cases = cases;
    }

    public void setElseNode(ParseNode elseNode) {
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CASENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitCaseInNode(this);
    }

    public ParseNode getCaseNode() {
        return this.caseNode;
    }

    public ListParseNode getCases() {
        return this.cases;
    }

    public ParseNode getElseNode() {
        return this.elseNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.caseNode, (ParseNode)this.cases);
    }
}

