/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.AssignableParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class ConstDeclParseNode
extends AssignableParseNode
implements INameNode {
    private final String name;
    private final INameNode constNode;

    public ConstDeclParseNode(SourceIndexLength position, TruffleString name, INameNode constNode, ParseNode valueNode) {
        super(position, valueNode);
        assert (constNode != null || name != null && !name.isEmpty());
        this.name = name == null ? null : name.toJavaStringUncached();
        this.constNode = constNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONSTDECLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitConstDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public ParseNode getConstNode() {
        return (ParseNode)((Object)this.constNode);
    }

    @Override
    public List<ParseNode> childNodes() {
        return ConstDeclParseNode.createList(this.getConstNode(), this.getValueNode());
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

