/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.HashParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.StarParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;
import org.truffleruby.parser.parser.ParseNodeTuple;

public final class HashPatternParseNode
extends ParseNode {
    private final ParseNode restArg;
    private final HashParseNode keywordArgs;
    private ParseNode constant;

    public HashPatternParseNode(SourceIndexLength position, ParseNode restArg, HashParseNode keywordArgs) {
        super(position);
        this.restArg = restArg;
        this.keywordArgs = keywordArgs;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitHashPatternNode(this);
    }

    @Override
    public List<ParseNode> childNodes() {
        return HashPatternParseNode.createList(this.restArg, (ParseNode)this.keywordArgs, this.constant);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHPATTERNNODE;
    }

    public ParseNode getConstant() {
        return this.constant;
    }

    public void setConstant(ParseNode constant) {
        this.constant = constant;
    }

    public int getArgumentSize() {
        return this.keywordArgs == null ? 0 : this.keywordArgs.getPairs().size();
    }

    public ParseNode getRestArg() {
        return this.restArg;
    }

    public boolean hasRestArg() {
        return this.restArg != null;
    }

    public boolean isNamedRestArg() {
        return !(this.restArg instanceof StarParseNode);
    }

    public boolean hasKeywordArgs() {
        return this.keywordArgs != null;
    }

    public HashParseNode getKeywordArgs() {
        return this.keywordArgs;
    }

    public List<ParseNode> getKeys() {
        List<ParseNodeTuple> pairs = this.keywordArgs.getPairs();
        ArrayList<ParseNode> keys = new ArrayList<ParseNode>(pairs.size());
        for (ParseNodeTuple pair : pairs) {
            keys.add(pair.getKey());
        }
        return keys;
    }

    public boolean hashNamedKeywordRestArg() {
        return this.hasRestArg() && !(this.restArg instanceof StarParseNode);
    }
}

