/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.DefNode;
import org.truffleruby.parser.ast.NilImplicitParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;
import org.truffleruby.parser.scope.StaticScope;

public class IterParseNode
extends ParseNode
implements DefNode {
    private final ParseNode varNode;
    private final ParseNode bodyNode;
    private StaticScope scope;

    public IterParseNode(SourceIndexLength position, ParseNode args, StaticScope scope, ParseNode body) {
        super(position);
        this.varNode = args;
        this.scope = scope;
        this.bodyNode = body;
    }

    public IterParseNode(SourceIndexLength position, ArgsParseNode args, ParseNode body, StaticScope scope) {
        super(position);
        this.varNode = args;
        this.bodyNode = body == null ? NilImplicitParseNode.NIL : body;
        this.scope = scope;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    @Override
    public ArgsParseNode getArgsNode() {
        return (ArgsParseNode)this.varNode;
    }

    @Override
    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getVarNode() {
        return this.varNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.varNode, this.bodyNode);
    }
}

