/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.InvisibleNode;
import org.truffleruby.parser.ast.NilImplicitParseNode;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.RequiredKeywordArgumentValueParseNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public abstract class ParseNode {
    public static final ParseNode[] EMPTY_ARRAY = new ParseNode[0];
    static final List<ParseNode> EMPTY_LIST = new ArrayList<ParseNode>();
    private int sourceCharIndex;
    private int sourceLength;
    protected boolean newline;

    public ParseNode(SourceIndexLength position) {
        Objects.requireNonNull(position);
        this.sourceCharIndex = position.getCharIndex();
        this.sourceLength = position.getLength();
        assert (this.hasPosition() || this instanceof NilImplicitParseNode || this instanceof RequiredKeywordArgumentValueParseNode) : this.getClass();
    }

    public final void setNewline() {
        this.newline = true;
    }

    public final boolean isNewline() {
        return this.newline;
    }

    public final boolean hasPosition() {
        return this.sourceLength != -1;
    }

    public final SourceIndexLength getPosition() {
        return new SourceIndexLength(this.sourceCharIndex, this.sourceLength);
    }

    public final void extendPosition(ParseNode node) {
        if (this.hasPosition() && node.hasPosition()) {
            int begin = Math.min(this.sourceCharIndex, node.sourceCharIndex);
            int end = Math.max(this.sourceCharIndex + this.sourceLength, node.sourceCharIndex + node.sourceLength);
            this.sourceCharIndex = begin;
            this.sourceLength = end - begin;
        }
    }

    public final void extendPosition(SourceIndexLength pos) {
        if (this.hasPosition() && pos.isAvailable()) {
            int begin = Math.min(this.sourceCharIndex, pos.getCharIndex());
            int end = Math.max(this.sourceCharIndex + this.sourceLength, pos.getCharEnd());
            this.sourceCharIndex = begin;
            this.sourceLength = end - begin;
        }
    }

    public abstract <T> T accept(NodeVisitor<T> var1);

    public abstract List<ParseNode> childNodes();

    protected static List<ParseNode> createList(ParseNode node) {
        return Collections.singletonList(node);
    }

    protected static List<ParseNode> createList(ParseNode node1, ParseNode node2) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(2);
        list.add(node1);
        list.add(node2);
        return list;
    }

    protected static List<ParseNode> createList(ParseNode node1, ParseNode node2, ParseNode node3) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(3);
        list.add(node1);
        list.add(node2);
        list.add(node3);
        return list;
    }

    protected static List<ParseNode> createList(ParseNode ... nodes) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(nodes.length);
        for (ParseNode node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean indent, int indentation) {
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        if (indent) {
            ParseNode.indent(indentation, builder);
        }
        builder.append("(").append(this.getNodeName());
        String moreState = this.toStringInternal();
        if (moreState != null) {
            builder.append("[").append(moreState).append("]");
        }
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        if (!this.childNodes().isEmpty() && indent) {
            builder.append("\n");
        }
        for (ParseNode child : this.childNodes()) {
            if (!indent) {
                builder.append(", ");
            }
            if (child == null) {
                if (indent) {
                    ParseNode.indent(indentation + 1, builder);
                }
                builder.append("null");
            } else if (indent && child instanceof NilImplicitParseNode) {
                ParseNode.indent(indentation + 1, builder);
                builder.append(child.getClass().getSimpleName());
            } else {
                builder.append(child.toString(indent, indentation + 1));
            }
            if (!indent) continue;
            builder.append("\n");
        }
        if (!this.childNodes().isEmpty() && indent) {
            ParseNode.indent(indentation, builder);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String toStringInternal() {
        return null;
    }

    private static void indent(int indentation, StringBuilder builder) {
        for (int n = 0; n < indentation; ++n) {
            builder.append("  ");
        }
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public abstract NodeType getNodeType();

    public boolean isNil() {
        return false;
    }

    public boolean needsDefinitionCheck() {
        return true;
    }
}

