/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.source.Source;
import java.util.List;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class RootParseNode
extends ParseNode {
    private final ParseNode beginNode;
    private final Source source;
    private final ParseNode bodyNode;
    private final int endPosition;

    public RootParseNode(Source source, SourceIndexLength position, ParseNode beginNode, ParseNode bodyNode, int endPosition) {
        super(position);
        this.source = source;
        this.beginNode = beginNode;
        this.bodyNode = bodyNode;
        this.endPosition = endPosition;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    public Source getSource() {
        return this.source;
    }

    public ParseNode getBeginNode() {
        return this.beginNode;
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<ParseNode> childNodes() {
        return RootParseNode.createList(this.bodyNode);
    }

    public boolean hasEndPosition() {
        return this.endPosition != -1;
    }

    public int getEndPosition() {
        return this.endPosition;
    }
}

