/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.ast;

import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.parser.ast.NodeType;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.StrParseNode;
import org.truffleruby.parser.ast.types.ILiteralNode;
import org.truffleruby.parser.ast.visitor.NodeVisitor;

public final class XStrParseNode
extends ParseNode
implements ILiteralNode {
    private final TruffleString value;
    public final RubyEncoding encoding;

    public XStrParseNode(SourceIndexLength position, StrParseNode strParseNode) {
        super(position);
        this.value = strParseNode == null ? TStringConstants.EMPTY_US_ASCII : strParseNode.getValue();
        this.encoding = strParseNode == null ? Encodings.US_ASCII : strParseNode.encoding;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.XSTRNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitXStrNode(this);
    }

    public TruffleString getValue() {
        return this.value;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }
}

