/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.lexer;

import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.jcodings.Encoding;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.parser.lexer.RubyLexer;
import org.truffleruby.parser.lexer.StrTerm;
import org.truffleruby.parser.lexer.StringTerm;

public final class HeredocTerm
extends StrTerm {
    private final TruffleString nd_lit;
    private final int flags;
    final int nth;
    final int line;
    final TruffleString lastLine;

    public HeredocTerm(TruffleString marker, int func, int nth, int line, TruffleString lastLine) {
        this.nd_lit = marker;
        this.flags = func;
        this.nth = nth;
        this.line = line;
        this.lastLine = lastLine;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected int error(RubyLexer lexer, TruffleString eos) {
        lexer.compile_error("can't find string \"" + eos.toJavaStringUncached() + "\" anywhere before EOF");
        return -1;
    }

    private int restore(RubyLexer lexer) {
        lexer.heredoc_restore(this);
        lexer.setStrTerm(new StringTerm(this.flags | 0x8000, 0, 0, this.line));
        return -1;
    }

    @Override
    public int parseString(RubyLexer lexer) {
        ByteArrayBuilder str = null;
        boolean indent = (this.flags & 0x20) != 0;
        int c = lexer.nextc();
        if (c == -1) {
            return this.error(lexer, this.nd_lit);
        }
        if (lexer.was_bol() && lexer.whole_match_p(this.nd_lit, lexer.tencoding, indent)) {
            lexer.heredoc_restore(this);
            lexer.setStrTerm(null);
            lexer.setState(2);
            return 374;
        }
        if ((this.flags & 2) == 0) {
            do {
                TruffleString lbuf = lexer.lexb;
                int pend = lexer.lex_pend;
                if (pend > 0) {
                    switch (lexer.p(pend - 1)) {
                        case 10: {
                            if (--pend <= 0 || lexer.p(pend - 1) != 13) break;
                            --pend;
                            break;
                        }
                        case 13: {
                            --pend;
                        }
                    }
                }
                if (lexer.getHeredocIndent() > 0) {
                    for (int i = 0; i < pend && lexer.update_heredoc_indent(lexer.p(i)); ++i) {
                    }
                    lexer.setHeredocLineIndent(0);
                }
                InternalByteArray bytes = lbuf.getInternalByteArrayUncached(lexer.getTEncoding());
                if (str != null) {
                    str.append(bytes.getArray(), bytes.getOffset(), pend);
                } else {
                    TStringBuilder builder = TStringBuilder.create(bytes.getArray(), bytes.getOffset(), pend);
                    builder.setEncoding(lexer.encoding);
                    str = builder;
                }
                str.append(10);
                lexer.lex_goto_eol();
                if (lexer.getHeredocIndent() > 0) {
                    lexer.setValue(lexer.createStr((TStringBuilder)str, 0));
                    return 379;
                }
                if (lexer.nextc() != -1) continue;
                return this.error(lexer, this.nd_lit);
            } while (!lexer.whole_match_p(this.nd_lit, lexer.tencoding, indent));
        } else {
            TStringBuilder tok = new TStringBuilder();
            tok.setEncoding(lexer.encoding);
            if (c == 35) {
                int token = lexer.peekVariableName(373, 372);
                if (token != 0) {
                    return token;
                }
                tok.append(35);
            }
            do {
                lexer.pushback(c);
                Encoding[] enc = new Encoding[]{lexer.getEncoding()};
                c = new StringTerm(this.flags, 0, 10, lexer.ruby_sourceline).parseStringIntoBuffer(lexer, tok, enc);
                if (c == -1) {
                    if (lexer.eofp) {
                        return this.error(lexer, this.nd_lit);
                    }
                    return this.restore(lexer);
                }
                if (c != 10) {
                    lexer.setValue(lexer.createStr(tok, 0));
                    return 379;
                }
                tok.append(lexer.nextc());
                if (lexer.getHeredocIndent() > 0) {
                    lexer.lex_goto_eol();
                    lexer.setValue(lexer.createStr(tok, 0));
                    return 379;
                }
                c = lexer.nextc();
                if (c != -1) continue;
                return this.error(lexer, this.nd_lit);
            } while (!lexer.whole_match_p(this.nd_lit, lexer.tencoding, indent));
            str = tok;
        }
        lexer.pushback(c);
        lexer.setValue(lexer.createStr((TStringBuilder)str, 0));
        return 379;
    }
}

