/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.parser;

import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.truffleruby.RubyContext;
import org.truffleruby.parser.scope.StaticScope;

public final class ParserConfiguration {
    private StaticScope existingScope = null;
    private boolean asBlock = false;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean isDebug = false;
    private boolean saveData = false;
    private boolean frozenStringLiteral = false;
    public boolean allowTruffleRubyPrimitives = false;
    private Encoding defaultEncoding;
    private RubyContext context;

    public ParserConfiguration(RubyContext context, boolean inlineSource, boolean isFileParse, boolean saveData) {
        this.context = context;
        this.inlineSource = inlineSource;
        this.isEvalParse = !isFileParse;
        this.saveData = saveData;
    }

    public void setFrozenStringLiteral(boolean frozenStringLiteral) {
        this.frozenStringLiteral = frozenStringLiteral;
    }

    public boolean isFrozenStringLiteral() {
        return this.frozenStringLiteral;
    }

    public void setDefaultEncoding(Encoding encoding) {
        this.defaultEncoding = encoding;
    }

    public Encoding getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = UTF8Encoding.INSTANCE;
        }
        return this.defaultEncoding;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public void parseAsBlock(StaticScope existingScope) {
        this.asBlock = true;
        this.existingScope = existingScope;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public StaticScope getScope(String file) {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new StaticScope(StaticScope.Type.LOCAL, (StaticScope)null, file);
    }

    public boolean isCoverageEnabled() {
        return !this.isEvalParse();
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }
}

