/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.parser.parser;

import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.SJISEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.SourceIndexLength;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.ast.AliasParseNode;
import org.truffleruby.parser.ast.AndParseNode;
import org.truffleruby.parser.ast.ArgsCatParseNode;
import org.truffleruby.parser.ast.ArgsParseNode;
import org.truffleruby.parser.ast.ArgsPushParseNode;
import org.truffleruby.parser.ast.ArgumentParseNode;
import org.truffleruby.parser.ast.ArrayParseNode;
import org.truffleruby.parser.ast.ArrayPatternParseNode;
import org.truffleruby.parser.ast.AssignableParseNode;
import org.truffleruby.parser.ast.AttrAssignParseNode;
import org.truffleruby.parser.ast.BackRefParseNode;
import org.truffleruby.parser.ast.BeginParseNode;
import org.truffleruby.parser.ast.BigRationalParseNode;
import org.truffleruby.parser.ast.BignumParseNode;
import org.truffleruby.parser.ast.BinaryOperatorParseNode;
import org.truffleruby.parser.ast.BlockArgParseNode;
import org.truffleruby.parser.ast.BlockParseNode;
import org.truffleruby.parser.ast.BlockPassParseNode;
import org.truffleruby.parser.ast.CallParseNode;
import org.truffleruby.parser.ast.CaseInParseNode;
import org.truffleruby.parser.ast.CaseParseNode;
import org.truffleruby.parser.ast.ClassVarParseNode;
import org.truffleruby.parser.ast.Colon2ConstParseNode;
import org.truffleruby.parser.ast.Colon2ImplicitParseNode;
import org.truffleruby.parser.ast.Colon2ParseNode;
import org.truffleruby.parser.ast.Colon3ParseNode;
import org.truffleruby.parser.ast.ComplexParseNode;
import org.truffleruby.parser.ast.ConstParseNode;
import org.truffleruby.parser.ast.DAsgnParseNode;
import org.truffleruby.parser.ast.DParseNode;
import org.truffleruby.parser.ast.DRegexpParseNode;
import org.truffleruby.parser.ast.DStrParseNode;
import org.truffleruby.parser.ast.DSymbolParseNode;
import org.truffleruby.parser.ast.DVarParseNode;
import org.truffleruby.parser.ast.DefinedParseNode;
import org.truffleruby.parser.ast.DotParseNode;
import org.truffleruby.parser.ast.EncodingParseNode;
import org.truffleruby.parser.ast.EvStrParseNode;
import org.truffleruby.parser.ast.FCallParseNode;
import org.truffleruby.parser.ast.FalseParseNode;
import org.truffleruby.parser.ast.FileParseNode;
import org.truffleruby.parser.ast.FindPatternParseNode;
import org.truffleruby.parser.ast.FixnumParseNode;
import org.truffleruby.parser.ast.FlipParseNode;
import org.truffleruby.parser.ast.FloatParseNode;
import org.truffleruby.parser.ast.GlobalAsgnParseNode;
import org.truffleruby.parser.ast.GlobalVarParseNode;
import org.truffleruby.parser.ast.HashParseNode;
import org.truffleruby.parser.ast.HashPatternParseNode;
import org.truffleruby.parser.ast.IArgumentNode;
import org.truffleruby.parser.ast.IfParseNode;
import org.truffleruby.parser.ast.InParseNode;
import org.truffleruby.parser.ast.InstAsgnParseNode;
import org.truffleruby.parser.ast.InstVarParseNode;
import org.truffleruby.parser.ast.KeywordArgParseNode;
import org.truffleruby.parser.ast.KeywordRestArgParseNode;
import org.truffleruby.parser.ast.ListParseNode;
import org.truffleruby.parser.ast.LocalAsgnParseNode;
import org.truffleruby.parser.ast.LocalVarParseNode;
import org.truffleruby.parser.ast.Match2ParseNode;
import org.truffleruby.parser.ast.Match3ParseNode;
import org.truffleruby.parser.ast.MatchParseNode;
import org.truffleruby.parser.ast.MultipleAsgnParseNode;
import org.truffleruby.parser.ast.NilImplicitParseNode;
import org.truffleruby.parser.ast.NilParseNode;
import org.truffleruby.parser.ast.NilRestArgParseNode;
import org.truffleruby.parser.ast.NoKeywordsArgParseNode;
import org.truffleruby.parser.ast.NthRefParseNode;
import org.truffleruby.parser.ast.NumericParseNode;
import org.truffleruby.parser.ast.OpAsgnConstDeclParseNode;
import org.truffleruby.parser.ast.OpAsgnParseNode;
import org.truffleruby.parser.ast.OpElementAsgnParseNode;
import org.truffleruby.parser.ast.OrParseNode;
import org.truffleruby.parser.ast.ParseNode;
import org.truffleruby.parser.ast.RationalParseNode;
import org.truffleruby.parser.ast.RegexpParseNode;
import org.truffleruby.parser.ast.RescueBodyParseNode;
import org.truffleruby.parser.ast.RescueModParseNode;
import org.truffleruby.parser.ast.RestArgParseNode;
import org.truffleruby.parser.ast.RootParseNode;
import org.truffleruby.parser.ast.SValueParseNode;
import org.truffleruby.parser.ast.SelfParseNode;
import org.truffleruby.parser.ast.SplatParseNode;
import org.truffleruby.parser.ast.StarParseNode;
import org.truffleruby.parser.ast.StrParseNode;
import org.truffleruby.parser.ast.SuperParseNode;
import org.truffleruby.parser.ast.SymbolParseNode;
import org.truffleruby.parser.ast.TrueParseNode;
import org.truffleruby.parser.ast.UndefParseNode;
import org.truffleruby.parser.ast.VCallParseNode;
import org.truffleruby.parser.ast.WhenOneArgParseNode;
import org.truffleruby.parser.ast.WhenParseNode;
import org.truffleruby.parser.ast.YieldParseNode;
import org.truffleruby.parser.ast.types.ILiteralNode;
import org.truffleruby.parser.ast.types.INameNode;
import org.truffleruby.parser.lexer.LexerSource;
import org.truffleruby.parser.lexer.RubyLexer;
import org.truffleruby.parser.lexer.SyntaxException;
import org.truffleruby.parser.parser.ArgsTailHolder;
import org.truffleruby.parser.parser.ParseNodeTuple;
import org.truffleruby.parser.parser.ParserConfiguration;
import org.truffleruby.parser.parser.RubyParserResult;
import org.truffleruby.parser.scope.StaticScope;

public final class ParserSupport {
    public static final String FORWARD_ARGS_REST_VAR = "%forward_rest";
    public static final String FORWARD_ARGS_KWREST_VAR = "%forward_kwrest";
    public static final TruffleString FORWARD_ARGS_KWREST_VAR_TSTRING = TStringUtils.usAsciiString("%forward_kwrest");
    public static final String FORWARD_ARGS_BLOCK_VAR = "%forward_block";
    public static final TruffleString FORWARD_ARGS_BLOCK_VAR_TSTRING = TStringUtils.usAsciiString("%forward_block");
    public static final String UNDERSCORE_PREFIX = "_$";
    private StaticScope currentScope;
    private RubyLexer lexer;
    private int inSingleton;
    private boolean inDefinition;
    private boolean inClass;
    private ParserConfiguration configuration;
    private RubyParserResult result;
    private final String file;
    private final RubyDeferredWarnings warnings;
    private int maxNumParam = 0;
    private ParseNode numParamCurrent = null;
    private Set<TruffleString> keyTable;
    private Set<TruffleString> variableTable;
    public static final TruffleString KWNOREST = TStringConstants.EMPTY_US_ASCII;
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final TruffleString INTERNAL_ID = TStringConstants.EMPTY_US_ASCII;

    public ParserSupport(LexerSource source, RubyDeferredWarnings warnings) {
        this.file = source.getSourcePath();
        this.warnings = warnings;
    }

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public String toString() {
        return super.toString() + " @ " + this.lexer.getLocation();
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        if (!this.currentScope.isBlockScope()) {
            this.lexer.getCmdArgumentState().reset(this.currentScope.getCommandArgumentStack());
        }
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new StaticScope(StaticScope.Type.BLOCK, this.currentScope, this.lexer.getFile());
    }

    public void pushLocalScope() {
        this.currentScope = new StaticScope(StaticScope.Type.LOCAL, this.currentScope, this.lexer.getFile());
        this.currentScope.setCommandArgumentStack(this.lexer.getCmdArgumentState().getStack());
        this.lexer.getCmdArgumentState().reset(0L);
    }

    public ParseNode arg_concat(SourceIndexLength position, ParseNode node1, ParseNode node2) {
        return node2 == null ? node1 : new ArgsCatParseNode(position, node1, node2);
    }

    public ParseNode arg_blk_pass(ParseNode firstNode, BlockPassParseNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public ParseNode gettable2(ParseNode node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                String name = ((INameNode)((Object)node)).getName();
                TruffleString currentArg = this.lexer.getCurrentArg();
                if (currentArg != null && name.equals(currentArg.toJavaStringUncached())) {
                    this.warn(node.getPosition(), "circular argument reference - " + name);
                }
                this.checkDeclarationForNumberedParameterMisuse(name, node);
                return this.currentScope.declare(node.getPosition(), name);
            }
            case CONSTDECLNODE: {
                return new ConstParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarParseNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(node.getPosition(), ((INameNode)((Object)node)).getName());
        return null;
    }

    private void checkDeclarationForNumberedParameterMisuse(String name, ParseNode node) {
        if (ParserSupport.isNumberedParameter(name)) {
            int depth = this.currentScope.isDefined(name) >> 16;
            if (depth < 0) {
                throw this.compile_error(name + " is reserved for numbered parameter");
            }
            if (depth == 0 && this.currentScope.isBlockScope() && this.currentScope.isNumberedBlockScope()) {
                throw this.compile_error("Can't assign to numbered parameter " + name);
            }
        }
    }

    private void warnNumberedParameterLikeDeclaration(SourceIndexLength position, String name) {
        this.warn(position, "`" + name + "' is reserved for numbered parameter; consider another name");
    }

    public static boolean isNumberedParameter(String name) {
        return name.length() == 2 && name.charAt(0) == '_' && '1' <= name.charAt(1) && name.charAt(1) <= '9';
    }

    public void checkMethodName(TruffleString tstring) {
        String name = tstring.toJavaStringUncached();
        if (ParserSupport.isNumberedParameter(name)) {
            this.warnNumberedParameterLikeDeclaration(this.lexer.getPosition(), name);
        }
    }

    public ParseNode declareIdentifier(TruffleString tstring) {
        return this.declareIdentifier(tstring.toJavaStringUncached());
    }

    public ParseNode declareIdentifier(String string) {
        String name = string.intern();
        TruffleString currentArg = this.lexer.getCurrentArg();
        if (currentArg != null && name.equals(currentArg.toJavaStringUncached())) {
            this.warn(this.lexer.getPosition(), "circular argument reference - " + name);
        }
        if (this.currentScope.isBlockScope() && ParserSupport.isNumberedParameter(name)) {
            int definitionDepth = this.currentScope.isDefined(name) >> 16;
            if (definitionDepth < 0) {
                if (!this.currentScope.hasBlockParameters()) {
                    this.currentScope.addNumberedParameter(name, this.lexer.getPosition());
                } else {
                    throw this.compile_error("ordinary parameter is defined");
                }
            }
            if (this.currentScope.hasNumberedSubScope()) {
                throw this.compile_error("numbered parameter is already used in inner block");
            }
            if (this.currentScope.hasNumberedSuperScope()) {
                throw this.compile_error("numbered parameter is already used in outer block");
            }
        }
        return this.currentScope.declare(this.lexer.tokline, name);
    }

    public AssignableParseNode assignableLabelOrIdentifier(TruffleString name, ParseNode value) {
        return this.assignableLabelOrIdentifier(name.toJavaStringUncached().intern(), value);
    }

    public AssignableParseNode assignableLabelOrIdentifier(String name, ParseNode value) {
        this.checkDeclarationForNumberedParameterMisuse(name, value);
        return this.currentScope.assign(this.lexer.getPosition(), name, this.makeNullNil(value));
    }

    public AssignableParseNode assignableKeyword(TruffleString name, ParseNode value) {
        return this.assignableLabelOrIdentifier(name, value);
    }

    protected void getterIdentifierError(SourceIndexLength position, String identifier) {
        this.lexer.compile_error(SyntaxException.PID.BAD_IDENTIFIER, "identifier " + identifier + " is not valid to get");
    }

    public ParseNode newline_node(ParseNode node, SourceIndexLength position) {
        if (node == null) {
            return null;
        }
        node.setNewline();
        return node;
    }

    public ParseNode addRootNode(ParseNode topOfAST) {
        SourceIndexLength position;
        int endPosition = this.lexer.getEndPosition();
        ParseNode body = topOfAST;
        if (topOfAST == null) {
            body = NilImplicitParseNode.NIL;
            position = this.lexer.getPosition();
        } else {
            position = topOfAST.getPosition();
        }
        BlockParseNode beginAST = null;
        if (!this.result.getBeginNodes().isEmpty()) {
            SourceIndexLength beginPosition = this.result.getBeginNodes().get(0).getPosition();
            beginAST = new BlockParseNode(beginPosition);
            for (ParseNode beginNode : this.result.getBeginNodes()) {
                this.appendToBlock(beginAST, beginNode);
            }
        }
        return new RootParseNode(this.lexer.getSource(), position, beginAST, body, endPosition);
    }

    public ParseNode appendToBlock(ParseNode head, ParseNode tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!(head instanceof BlockParseNode)) {
            head = new BlockParseNode(head.getPosition()).add(head);
        }
        if (this.isBreakStatement(((BlockParseNode)head).getLast())) {
            this.warnings.warning(this.file, tail.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "statement not reached");
        }
        ((BlockParseNode)head).add(tail);
        return head;
    }

    public AssignableParseNode assignableInCurr(TruffleString name, ParseNode value) {
        String nameString = name.toJavaStringUncached().intern();
        this.checkDeclarationForNumberedParameterMisuse(nameString, value);
        this.currentScope.addVariableThisScope(nameString);
        return this.currentScope.assign(this.lexer.getPosition(), nameString, this.makeNullNil(value));
    }

    public ParseNode getOperatorCallNode(ParseNode firstNode, TruffleString operator) {
        ParserSupport.value_expr(this.lexer, firstNode);
        return new CallParseNode(this.getPosition(firstNode), firstNode, operator.toJavaStringUncached(), null, null);
    }

    public ParseNode getOperatorCallNode(ParseNode firstNode, TruffleString operator, ParseNode secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public ParseNode getOperatorCallNode(ParseNode firstNode, TruffleString operator, ParseNode secondNode, SourceIndexLength defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        ParserSupport.value_expr(this.lexer, firstNode);
        ParserSupport.value_expr(this.lexer, secondNode);
        return new CallParseNode(firstNode.getPosition(), firstNode, operator.toJavaStringUncached(), new ArrayParseNode(secondNode.getPosition(), secondNode), null);
    }

    public ParseNode getMatchNode(ParseNode firstNode, ParseNode secondNode) {
        if (firstNode instanceof DRegexpParseNode) {
            return new Match2ParseNode(firstNode.getPosition(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpParseNode) {
            this.allocateNamedLocals((RegexpParseNode)firstNode);
            return new Match2ParseNode(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpParseNode || secondNode instanceof RegexpParseNode) {
            return new Match3ParseNode(firstNode.getPosition(), firstNode, secondNode);
        }
        return this.getOperatorCallNode(firstNode, TStringConstants.EQ_TILDE, secondNode);
    }

    public ParseNode aryset(ParseNode receiver, ParseNode index) {
        ParserSupport.value_expr(this.lexer, receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, "[]=", index, false);
    }

    public ParseNode attrset(ParseNode receiver, TruffleString name) {
        return this.attrset(receiver, TStringConstants.DOT, name);
    }

    public ParseNode attrset(ParseNode receiver, TruffleString callType, TruffleString name) {
        ParserSupport.value_expr(this.lexer, receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, name.toJavaStringUncached() + "=", null, this.isLazy(callType));
    }

    public void backrefAssignError(ParseNode node) {
        if (node instanceof NthRefParseNode) {
            String varName = "$" + ((NthRefParseNode)node).getMatchNumber();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + ".");
        } else if (node instanceof BackRefParseNode) {
            String varName = "$" + ((BackRefParseNode)node).getType();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + ".");
        }
    }

    public static ParseNode arg_add(SourceIndexLength position, ParseNode node1, ParseNode node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayParseNode(position, NilImplicitParseNode.NIL);
            }
            return new ArrayParseNode(position, node2);
        }
        if (node1 instanceof ArrayParseNode) {
            return ((ArrayParseNode)node1).add(node2);
        }
        return new ArgsPushParseNode(position, node1, node2);
    }

    public ParseNode node_assign(ParseNode lhs, ParseNode rhs) {
        if (lhs == null) {
            return null;
        }
        ParseNode newNode = lhs;
        ParserSupport.value_expr(this.lexer, rhs);
        if (lhs instanceof AssignableParseNode) {
            ((AssignableParseNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(ParserSupport.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public ParseNode ret_args(ParseNode node, SourceIndexLength position) {
        if (node != null) {
            if (node instanceof BlockPassParseNode) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "block argument should not be given");
            } else if (node instanceof ArrayParseNode && ((ArrayParseNode)node).size() == 1) {
                node = ((ArrayParseNode)node).get(0);
            } else if (node instanceof SplatParseNode) {
                node = this.newSValueNode(position, node);
            }
        }
        if (node == null) {
            node = NilImplicitParseNode.NIL;
        }
        return node;
    }

    public boolean isBreakStatement(ParseNode node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case BREAKNODE: 
            case NEXTNODE: 
            case REDONODE: 
            case RETRYNODE: 
            case RETURNNODE: {
                return true;
            }
        }
        return false;
    }

    public void warnUnlessEOption(ParseNode node, String message) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), message);
        }
    }

    public void checkExpression(ParseNode node) {
        ParserSupport.value_expr(this.lexer, node);
    }

    public static void value_expr(RubyLexer lexer, ParseNode node) {
        ParserSupport.value_expr(lexer, node, false);
    }

    private static boolean value_expr(RubyLexer lexer, ParseNode node, boolean conditional) {
        block7: while (node != null) {
            switch (node.getNodeType()) {
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    if (!conditional) {
                        lexer.compile_error(SyntaxException.PID.VOID_VALUE_EXPRESSION, "void value expression");
                    }
                    return false;
                }
                case BLOCKNODE: {
                    node = ((BlockParseNode)node).getLast();
                    continue block7;
                }
                case BEGINNODE: {
                    node = ((BeginParseNode)node).getBodyNode();
                    continue block7;
                }
                case IFNODE: {
                    if (ParserSupport.value_expr(lexer, ((IfParseNode)node).getThenBody(), true)) {
                        return true;
                    }
                    node = ((IfParseNode)node).getElseBody();
                    continue block7;
                }
                case ANDNODE: 
                case ORNODE: {
                    node = ((BinaryOperatorParseNode)((Object)node)).getFirstNode();
                    continue block7;
                }
            }
            return true;
        }
        return true;
    }

    private void handleUselessWarn(ParseNode node, String useless) {
        this.warnings.warning(this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "Useless use of " + useless + " in void context.");
    }

    public void checkUselessStatement(ParseNode node) {
        if (!this.configuration.isInlineSource() && this.configuration.isEvalParse()) {
            return;
        }
        if (node == null) {
            return;
        }
        block0 : switch (node.getNodeType()) {
            case CALLNODE: {
                String name;
                switch (name = ((CallParseNode)node).getName()) {
                    case "+": 
                    case "-": 
                    case "*": 
                    case "/": 
                    case "%": 
                    case "**": 
                    case "+@": 
                    case "-@": 
                    case "|": 
                    case "^": 
                    case "&": 
                    case "<=>": 
                    case ">": 
                    case ">=": 
                    case "<": 
                    case "<=": 
                    case "==": 
                    case "!=": {
                        this.handleUselessWarn(node, name);
                        break block0;
                    }
                }
                break;
            }
            case BACKREFNODE: 
            case DVARNODE: 
            case GLOBALVARNODE: 
            case LOCALVARNODE: 
            case NTHREFNODE: 
            case CLASSVARNODE: 
            case INSTVARNODE: {
                this.handleUselessWarn(node, "a variable");
                break;
            }
            case BIGNUMNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case FIXNUMNODE: 
            case FLOATNODE: 
            case REGEXPNODE: 
            case STRNODE: 
            case SYMBOLNODE: {
                this.handleUselessWarn(node, "a literal");
                break;
            }
            case DOTNODE: {
                this.handleUselessWarn(node, ((DotParseNode)node).isExclusive() ? "..." : "..");
                break;
            }
            case DEFINEDNODE: {
                this.handleUselessWarn(node, "defined?");
                break;
            }
            case FALSENODE: {
                this.handleUselessWarn(node, "false");
                break;
            }
            case NILNODE: {
                this.handleUselessWarn(node, "nil");
                break;
            }
            case TRUENODE: {
                this.handleUselessWarn(node, "true");
                break;
            }
        }
    }

    public void checkUselessStatements(BlockParseNode blockNode) {
        ParseNode lastNode = blockNode.getLast();
        for (int i = 0; i < blockNode.size(); ++i) {
            ParseNode currentNode = blockNode.get(i);
            if (lastNode == currentNode) continue;
            this.checkUselessStatement(currentNode);
        }
    }

    private boolean checkAssignmentInCondition(ParseNode node) {
        if (node instanceof MultipleAsgnParseNode || node instanceof LocalAsgnParseNode || node instanceof DAsgnParseNode || node instanceof GlobalAsgnParseNode || node instanceof InstAsgnParseNode) {
            ParseNode valueNode = ((AssignableParseNode)node).getValueNode();
            if (this.isStaticContent(valueNode)) {
                this.warnings.warn(this.file, node.getPosition().toSourceSection(this.lexer.getSource()).getStartLine(), "found = in conditional, should be ==");
            }
            return true;
        }
        return false;
    }

    private boolean isStaticContent(ParseNode node) {
        if (node instanceof HashParseNode) {
            HashParseNode hash = (HashParseNode)node;
            for (ParseNodeTuple pair : hash.getPairs()) {
                if (this.isStaticContent(pair.getKey()) && this.isStaticContent(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (node instanceof ArrayParseNode) {
            ArrayParseNode array = (ArrayParseNode)node;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                if (this.isStaticContent(array.get(i))) continue;
                return false;
            }
            return true;
        }
        if (node instanceof FalseParseNode || node instanceof NilParseNode || node instanceof TrueParseNode) {
            return true;
        }
        if (node instanceof ILiteralNode) {
            return !(node instanceof DParseNode);
        }
        return false;
    }

    protected ParseNode makeNullNil(ParseNode node) {
        return node == null ? NilImplicitParseNode.NIL : node;
    }

    private ParseNode cond0(ParseNode node) {
        this.checkAssignmentInCondition(node);
        if (node == null) {
            return new NilParseNode(this.lexer.getPosition());
        }
        switch (node.getNodeType()) {
            case DREGEXPNODE: {
                SourceIndexLength position = node.getPosition();
                return new Match2ParseNode(position, node, new GlobalVarParseNode(position, "$_"));
            }
            case ANDNODE: {
                ParseNode leftNode = this.cond0(((AndParseNode)node).getFirstNode());
                ParseNode rightNode = this.cond0(((AndParseNode)node).getSecondNode());
                return new AndParseNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                ParseNode leftNode = this.cond0(((OrParseNode)node).getFirstNode());
                ParseNode rightNode = this.cond0(((OrParseNode)node).getSecondNode());
                return new OrParseNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotParseNode dotNode = (DotParseNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label);
                int slot = this.currentScope.isDefined(label);
                return new FlipParseNode(node.getPosition(), this.getFlipConditionNode(((DotParseNode)node).getBeginNode()), this.getFlipConditionNode(((DotParseNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                this.warnUnlessEOption(node, "regex literal in condition");
                return new MatchParseNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public ParseNode getConditionNode(ParseNode node) {
        ParseNode cond = this.cond0(node);
        cond.setNewline();
        return cond;
    }

    private ParseNode getFlipConditionNode(ParseNode node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof FixnumParseNode) {
            this.warnUnlessEOption(node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, TStringConstants.EQ_EQ, new GlobalVarParseNode(node.getPosition(), "$."));
        }
        return node;
    }

    public SValueParseNode newSValueNode(SourceIndexLength position, ParseNode node) {
        return new SValueParseNode(position, node);
    }

    public SplatParseNode newSplatNode(SourceIndexLength position, ParseNode node) {
        return new SplatParseNode(position, this.makeNullNil(node));
    }

    public ArrayParseNode newArrayNode(SourceIndexLength position, ParseNode firstNode) {
        return new ArrayParseNode(position, this.makeNullNil(firstNode));
    }

    public SourceIndexLength position(ParseNode one, ParseNode two) {
        return one == null ? two.getPosition() : one.getPosition();
    }

    public AndParseNode newAndNode(SourceIndexLength position, ParseNode left, ParseNode right) {
        ParserSupport.value_expr(this.lexer, left);
        if (left == null && right == null) {
            return new AndParseNode(position, NilImplicitParseNode.NIL, NilImplicitParseNode.NIL);
        }
        return new AndParseNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public OrParseNode newOrNode(SourceIndexLength position, ParseNode left, ParseNode right) {
        ParserSupport.value_expr(this.lexer, left);
        if (left == null && right == null) {
            return new OrParseNode(position, NilImplicitParseNode.NIL, NilImplicitParseNode.NIL);
        }
        return new OrParseNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public CaseParseNode newCaseNode(SourceIndexLength position, ParseNode expression, ParseNode firstWhenNode) {
        ArrayParseNode cases = new ArrayParseNode(firstWhenNode != null ? firstWhenNode.getPosition() : position);
        CaseParseNode caseNode = new CaseParseNode(position, expression, cases);
        ParseNode current = firstWhenNode;
        while (current != null) {
            if (current instanceof WhenOneArgParseNode) {
                cases.add(current);
            } else if (current instanceof WhenParseNode) {
                this.simplifyMultipleArgumentWhenNodes((WhenParseNode)current, cases);
            } else {
                caseNode.setElseNode(current);
                break;
            }
            current = ((WhenParseNode)current).getNextCase();
        }
        return caseNode;
    }

    public ArrayPatternParseNode new_array_pattern(SourceIndexLength position, ParseNode constant, ParseNode preArg, ArrayPatternParseNode arrayPattern) {
        arrayPattern.setConstant(constant);
        if (preArg != null) {
            ArrayParseNode preArgs = new ArrayParseNode(position, preArg);
            ListParseNode arrayPatternPreArgs = arrayPattern.getPreArgs();
            arrayPattern.setPreArgs(arrayPatternPreArgs != null ? this.list_concat(preArgs, arrayPatternPreArgs) : preArgs);
        }
        return arrayPattern;
    }

    public ArrayPatternParseNode new_array_pattern_tail(SourceIndexLength line, ListParseNode preArgs, boolean hasRest, TruffleString restArg, ListParseNode postArgs) {
        return new ArrayPatternParseNode(line, preArgs, hasRest ? (restArg != null ? this.assignableLabelOrIdentifier(restArg, null) : new StarParseNode(this.lexer.getPosition())) : null, postArgs);
    }

    public void error_duplicate_pattern_key(TruffleString key) {
        if (this.keyTable == null) {
            this.keyTable = new HashSet<TruffleString>();
        }
        if (this.keyTable.contains(key)) {
            this.yyerror("duplicated key name");
        }
        this.keyTable.add(key);
    }

    public void error_duplicate_pattern_variable(TruffleString variable) {
        if (this.is_private_local_id(variable)) {
            return;
        }
        if (this.variableTable.contains(variable)) {
            this.yyerror("duplicated variable name");
        }
        this.variableTable.add(variable);
    }

    public boolean is_private_local_id(TruffleString name) {
        if (name.byteLength(this.lexer.tencoding) == 1 && (char)name.readByteUncached(0, this.lexer.tencoding) == '_') {
            return true;
        }
        if (!this.is_local_id(name)) {
            return false;
        }
        return name.readByteUncached(0, this.lexer.tencoding) == 95;
    }

    public ParseNode new_find_pattern(ParseNode constant, FindPatternParseNode findPattern) {
        findPattern.setConstant(constant);
        return findPattern;
    }

    public ParseNode new_find_pattern_tail(SourceIndexLength line, TruffleString preRestArg, ListParseNode postArgs, TruffleString postRestArg) {
        return new FindPatternParseNode(line, preRestArg != null ? this.assignableLabelOrIdentifier(preRestArg, null) : new StarParseNode(this.lexer.getPosition()), postArgs, postRestArg != null ? this.assignableLabelOrIdentifier(postRestArg, null) : new StarParseNode(this.lexer.getPosition()));
    }

    public HashPatternParseNode new_hash_pattern(ParseNode constant, HashPatternParseNode hashPatternNode) {
        hashPatternNode.setConstant(constant);
        return hashPatternNode;
    }

    public HashPatternParseNode new_hash_pattern_tail(SourceIndexLength line, HashParseNode keywordArgs, TruffleString keywordRestArg) {
        ParseNode restArg = keywordRestArg == KWNOREST ? new NilRestArgParseNode(line) : (keywordRestArg != null ? this.assignableLabelOrIdentifier(keywordRestArg, null) : new StarParseNode(this.lexer.getPosition()));
        return new HashPatternParseNode(line, restArg, keywordArgs == null ? new HashParseNode(line) : keywordArgs);
    }

    private void simplifyMultipleArgumentWhenNodes(WhenParseNode sourceWhen, ArrayParseNode cases) {
        ParseNode expressionNodes = sourceWhen.getExpressionNodes();
        if (expressionNodes instanceof SplatParseNode || expressionNodes instanceof ArgsCatParseNode) {
            cases.add(sourceWhen);
            return;
        }
        if (expressionNodes instanceof ListParseNode) {
            ListParseNode list = (ListParseNode)expressionNodes;
            SourceIndexLength position = sourceWhen.getPosition();
            ParseNode bodyNode = sourceWhen.getBodyNode();
            for (int i = 0; i < list.size(); ++i) {
                ParseNode expression = list.get(i);
                if (expression instanceof SplatParseNode || expression instanceof ArgsCatParseNode) {
                    cases.add(new WhenParseNode(position, expression, bodyNode, null));
                    continue;
                }
                cases.add(new WhenOneArgParseNode(position, expression, bodyNode, null));
            }
        } else {
            cases.add(sourceWhen);
        }
    }

    public WhenParseNode newWhenNode(SourceIndexLength position, ParseNode expressionNodes, ParseNode bodyNode, ParseNode nextCase) {
        ParseNode element;
        if (bodyNode == null) {
            bodyNode = NilImplicitParseNode.NIL;
        }
        if (expressionNodes instanceof SplatParseNode || expressionNodes instanceof ArgsCatParseNode || expressionNodes instanceof ArgsPushParseNode) {
            return new WhenParseNode(position, expressionNodes, bodyNode, nextCase);
        }
        ListParseNode list = (ListParseNode)expressionNodes;
        if (list.size() == 1 && !((element = list.get(0)) instanceof SplatParseNode)) {
            return new WhenOneArgParseNode(position, element, bodyNode, nextCase);
        }
        return new WhenParseNode(position, expressionNodes, bodyNode, nextCase);
    }

    public CaseInParseNode newCaseInNode(SourceIndexLength position, ParseNode expression, ParseNode firstInNode) {
        ArrayParseNode cases = new ArrayParseNode(firstInNode != null ? firstInNode.getPosition() : position);
        CaseInParseNode caseNode = new CaseInParseNode(position, expression, cases);
        ParseNode current = firstInNode;
        while (current != null) {
            if (!(current instanceof InParseNode)) {
                caseNode.setElseNode(current);
                break;
            }
            cases.add(current);
            current = ((InParseNode)current).getNextCase();
        }
        return caseNode;
    }

    public InParseNode newInNode(SourceIndexLength position, ParseNode expressionNodes, ParseNode bodyNode, ParseNode nextCase) {
        if (bodyNode == null) {
            bodyNode = NilImplicitParseNode.NIL;
        }
        return new InParseNode(position, expressionNodes, bodyNode, nextCase);
    }

    public ParseNode new_opElementAsgnNode(ParseNode receiverNode, TruffleString operatorName, ParseNode argsNode, ParseNode valueNode) {
        OpElementAsgnParseNode newNode = new OpElementAsgnParseNode(receiverNode.getPosition(), receiverNode, operatorName.toJavaStringUncached(), argsNode, valueNode);
        return newNode;
    }

    public TruffleString symbolID(TruffleString identifier) {
        return identifier;
    }

    public ParseNode newOpAsgn(SourceIndexLength position, ParseNode receiverNode, TruffleString callType, ParseNode valueNode, TruffleString variableName, TruffleString operatorName) {
        return new OpAsgnParseNode(position, receiverNode, valueNode, variableName.toJavaStringUncached(), operatorName.toJavaStringUncached(), this.isLazy(callType));
    }

    public ParseNode newOpConstAsgn(SourceIndexLength position, ParseNode lhs, TruffleString operatorName, ParseNode rhs) {
        if (lhs != null) {
            return new OpAsgnConstDeclParseNode(position, lhs, operatorName, rhs);
        }
        return new BeginParseNode(position, NilImplicitParseNode.NIL);
    }

    public boolean isLazy(TruffleString callType) {
        return callType == TStringConstants.AMPERSAND_DOT;
    }

    public ParseNode new_attrassign(SourceIndexLength position, ParseNode receiver, String name, ParseNode args, boolean isLazy) {
        return new AttrAssignParseNode(position, receiver, name, args, isLazy);
    }

    public ParseNode new_call(ParseNode receiver, TruffleString callType, TruffleString name, ParseNode argsNode, ParseNode iter) {
        if (argsNode instanceof BlockPassParseNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassParseNode blockPass = (BlockPassParseNode)argsNode;
            return new CallParseNode(this.position(receiver, argsNode), receiver, name.toJavaStringUncached(), blockPass.getArgsNode(), blockPass, this.isLazy(callType));
        }
        return new CallParseNode(this.position(receiver, argsNode), receiver, name.toJavaStringUncached(), argsNode, iter, this.isLazy(callType));
    }

    public ParseNode new_call(ParseNode receiver, TruffleString name, ParseNode argsNode, ParseNode iter) {
        return this.new_call(receiver, TStringConstants.DOT, name, argsNode, iter);
    }

    public Colon2ParseNode new_colon2(SourceIndexLength position, ParseNode leftNode, TruffleString name) {
        if (leftNode == null) {
            return new Colon2ImplicitParseNode(position, name);
        }
        return new Colon2ConstParseNode(position, leftNode, name);
    }

    public Colon3ParseNode new_colon3(SourceIndexLength position, TruffleString name) {
        return new Colon3ParseNode(position, name);
    }

    public void frobnicate_fcall_args(FCallParseNode fcall, ParseNode args, ParseNode iter) {
        if (args instanceof BlockPassParseNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassParseNode blockPass = (BlockPassParseNode)args;
            args = blockPass.getArgsNode();
            iter = blockPass;
        }
        fcall.setArgsNode(args);
        fcall.setIterNode(iter);
    }

    public ParseNode new_fcall(TruffleString operation) {
        return new FCallParseNode(this.lexer.tokline, operation.toJavaStringUncached());
    }

    public ParseNode new_super(SourceIndexLength position, ParseNode args) {
        if (args != null && args instanceof BlockPassParseNode) {
            return new SuperParseNode(position, ((BlockPassParseNode)args).getArgsNode(), args);
        }
        return new SuperParseNode(position, args);
    }

    public void initTopLocalVariables() {
        this.currentScope = this.configuration.getScope(this.lexer.getFile());
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public boolean isInClass() {
        return this.inClass;
    }

    public void setIsInClass(boolean inClass) {
        this.inClass = inClass;
    }

    public void enterBlockParameters() {
        this.currentScope.setHasBlockParameters();
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setLexer(RubyLexer lexer) {
        this.lexer = lexer;
    }

    public DStrParseNode createDStrNode(SourceIndexLength position) {
        return new DStrParseNode(position, this.lexer.getEncoding());
    }

    public ParseNodeTuple createKeyValue(ParseNode key, ParseNode value) {
        if (key != null && key instanceof StrParseNode) {
            ((StrParseNode)key).setFrozen(true);
        }
        return new ParseNodeTuple(key, value);
    }

    public ParseNode asSymbol(SourceIndexLength position, TruffleString value) {
        TruffleString tstringWithCorrectEncoding = value.switchEncodingUncached(this.lexer.encoding.tencoding);
        SymbolParseNode symbolParseNode = new SymbolParseNode(position, tstringWithCorrectEncoding, this.lexer.encoding);
        this.checkSymbolCodeRange(symbolParseNode);
        return symbolParseNode;
    }

    public ParseNode asSymbol(SourceIndexLength position, ParseNode value) {
        ParseNode parseNode;
        if (value instanceof StrParseNode) {
            StrParseNode strParseNode = (StrParseNode)value;
            SymbolParseNode symbolParseNode = new SymbolParseNode(position, strParseNode.getValue(), strParseNode.encoding);
            this.checkSymbolCodeRange(symbolParseNode);
            parseNode = symbolParseNode;
        } else {
            parseNode = new DSymbolParseNode(position, (DStrParseNode)value);
        }
        return parseNode;
    }

    private void checkSymbolCodeRange(SymbolParseNode symbolParseNode) {
        if (!symbolParseNode.getTString().isValidUncached(symbolParseNode.getRubyEncoding().tencoding)) {
            throw new RaiseException(RubyLanguage.getCurrentContext(), this.getConfiguration().getContext().getCoreExceptions().encodingError(symbolParseNode.getTString(), symbolParseNode.getRubyEncoding(), null));
        }
    }

    public ParseNode literal_concat(ParseNode head, ParseNode tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrParseNode) {
            head = this.createDStrNode(head.getPosition()).add(head);
        }
        if (this.lexer.getHeredocIndent() > 0) {
            if (head instanceof StrParseNode) {
                head = this.createDStrNode(head.getPosition()).add(head);
                return this.list_append(head, tail);
            }
            if (head instanceof DStrParseNode) {
                return this.list_append(head, tail);
            }
        }
        if (tail instanceof StrParseNode) {
            if (head instanceof StrParseNode) {
                StrParseNode front = (StrParseNode)head;
                if (!front.getValue().isEmpty()) {
                    return new StrParseNode(head.getPosition(), front, (StrParseNode)tail);
                }
                return tail;
            }
            return ((ListParseNode)head).add(tail);
        }
        if (tail instanceof DStrParseNode) {
            if (head instanceof StrParseNode) {
                DStrParseNode newDStr = new DStrParseNode(head.getPosition(), ((DStrParseNode)tail).getEncoding());
                newDStr.add(head);
                newDStr.add(tail);
                return newDStr;
            }
            return ((ListParseNode)head).add(tail);
        }
        if (head instanceof StrParseNode) {
            head = ((StrParseNode)head).getValue().isEmpty() ? this.createDStrNode(head.getPosition()) : this.createDStrNode(head.getPosition()).add(head);
        }
        return ((DStrParseNode)head).add(tail);
    }

    public ParseNode newRescueModNode(ParseNode body, ParseNode rescueBody) {
        if (rescueBody == null) {
            rescueBody = NilImplicitParseNode.NIL;
        }
        SourceIndexLength pos = this.getPosition(body);
        return new RescueModParseNode(pos, body, new RescueBodyParseNode(pos, null, rescueBody, null));
    }

    public ParseNode newEvStrNode(SourceIndexLength position, ParseNode node) {
        if (node instanceof StrParseNode || node instanceof DStrParseNode || node instanceof EvStrParseNode) {
            return node;
        }
        return new EvStrParseNode(position, node);
    }

    public ParseNode new_yield(SourceIndexLength position, ParseNode node) {
        if (node != null && node instanceof BlockPassParseNode) {
            this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "Block argument should not be given.");
        }
        return new YieldParseNode(position, node);
    }

    public NumericParseNode negateInteger(NumericParseNode integerNode) {
        if (integerNode instanceof FixnumParseNode) {
            FixnumParseNode fixnumNode = (FixnumParseNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumParseNode) {
            BignumParseNode bignumNode = (BignumParseNode)integerNode;
            BigInteger value = bignumNode.getValue().negate();
            if (value.compareTo(LONG_MIN) >= 0) {
                return new FixnumParseNode(bignumNode.getPosition(), value.longValue());
            }
            bignumNode.setValue(value);
        }
        return integerNode;
    }

    public FloatParseNode negateFloat(FloatParseNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ComplexParseNode negateComplexNode(ComplexParseNode complexNode) {
        complexNode.setNumber(this.negateNumeric(complexNode.getNumber()));
        return complexNode;
    }

    public RationalParseNode negateRational(RationalParseNode rationalNode) {
        return new RationalParseNode(rationalNode.getPosition(), -rationalNode.getNumerator(), rationalNode.getDenominator());
    }

    public BigRationalParseNode negateBigRational(BigRationalParseNode rationalNode) {
        return new BigRationalParseNode(rationalNode.getPosition(), rationalNode.getNumerator().negate(), rationalNode.getDenominator());
    }

    private ParseNode checkForNilNode(ParseNode node, SourceIndexLength defaultPosition) {
        return node == null ? new NilParseNode(defaultPosition) : node;
    }

    public ParseNode new_args(SourceIndexLength position, ListParseNode pre, ListParseNode optional, RestArgParseNode rest, ListParseNode post, ArgsTailHolder tail) {
        ArgsParseNode argsNode = tail == null ? new ArgsParseNode(position, pre, optional, rest, post, null) : new ArgsParseNode(position, pre, optional, rest, post, tail.getKeywordArgs(), tail.getKeywordRestArgNode(), tail.getBlockArg());
        this.currentScope.setArgsParseNode(argsNode);
        return argsNode;
    }

    public ArgsTailHolder new_args_tail(SourceIndexLength position, ListParseNode keywordArg, TruffleString keywordRestArgName, BlockArgParseNode blockArg) {
        if (keywordRestArgName == null) {
            return new ArgsTailHolder(position, keywordArg, null, blockArg);
        }
        if (keywordRestArgName == RubyLexer.Keyword.NIL.bytes) {
            return new ArgsTailHolder(position, keywordArg, new NoKeywordsArgParseNode(position, "%nil_kwrest"), blockArg);
        }
        String restKwargsName = keywordRestArgName.isEmpty() ? "%kwrest" : keywordRestArgName.toJavaStringUncached().intern();
        int slot = this.currentScope.exists(restKwargsName);
        if (slot == -1) {
            slot = this.currentScope.addVariable(restKwargsName);
        }
        KeywordRestArgParseNode keywordRestArg = new KeywordRestArgParseNode(position, restKwargsName, slot);
        return new ArgsTailHolder(position, keywordArg, keywordRestArg, blockArg);
    }

    public ParseNode remove_duplicate_keys(HashParseNode hash) {
        ArrayList<ParseNode> encounteredKeys = new ArrayList<ParseNode>();
        this.visitPairsRecursive(hash, encounteredKeys);
        return hash;
    }

    private void visitPairsRecursive(HashParseNode hash, List<ParseNode> encounteredKeys) {
        for (ParseNodeTuple pair : hash.getPairs()) {
            ParseNode key = pair.getKey();
            if (key == null) {
                if (!(pair.getValue() instanceof HashParseNode)) continue;
                this.visitPairsRecursive((HashParseNode)pair.getValue(), encounteredKeys);
                continue;
            }
            int index = this.matchesExistingIndex(key, encounteredKeys);
            if (index >= 0) {
                encounteredKeys.set(index, key);
                this.warn(hash.getPosition(), "key " + this.keyToString(key) + " is duplicated and overwritten on line " + encounteredKeys.get(index).getPosition().toSourceSection(this.lexer.getSource()).getStartLine());
                continue;
            }
            encounteredKeys.add(key);
        }
    }

    private String keyToString(ParseNode node) {
        if (node instanceof SymbolParseNode) {
            return ":" + ((SymbolParseNode)node).getName();
        }
        return node.toString();
    }

    private int matchesExistingIndex(ParseNode currentNode, List<ParseNode> encounteredKeys) {
        for (int i = 0; i < encounteredKeys.size(); ++i) {
            ParseNode parseNode = encounteredKeys.get(i);
            if (!(parseNode instanceof SymbolParseNode) || !(currentNode instanceof SymbolParseNode) || !((SymbolParseNode)parseNode).valueEquals((SymbolParseNode)currentNode)) continue;
            return i;
        }
        return -1;
    }

    public ParseNode newAlias(SourceIndexLength position, ParseNode newNode, ParseNode oldNode) {
        return new AliasParseNode(position, newNode, oldNode);
    }

    public ParseNode newUndef(SourceIndexLength position, ParseNode nameNode) {
        return new UndefParseNode(position, nameNode);
    }

    public void yyerror(String message) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message);
    }

    public void yyerror(String message, String[] expected, String found) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message + ", unexpected " + found);
    }

    public SourceIndexLength getPosition(ParseNode start) {
        if (start != null && start.hasPosition()) {
            return start.getPosition();
        }
        return this.lexer.getPosition();
    }

    public SourceIndexLength getPosition(Object start) {
        if (start instanceof ParseNode) {
            return ((ParseNode)start).getPosition();
        }
        return this.lexer.getPosition();
    }

    public void warn(SourceIndexLength position, String message) {
        this.warnings.warn(this.file, position.toSourceSection(this.lexer.getSource()).getStartLine(), message);
    }

    public void warning(SourceIndexLength position, String message) {
        this.warnings.warning(this.file, position.toSourceSection(this.lexer.getSource()).getStartLine(), message);
    }

    public boolean local_id(String value) {
        return this.currentScope.isDefined(value) >= 0;
    }

    public boolean is_local_id(TruffleString name) {
        return this.lexer.isIdentifierChar(name.readByteUncached(0, this.lexer.tencoding));
    }

    public ListParseNode list_append(ParseNode list, ParseNode item) {
        if (list == null) {
            return new ArrayParseNode(item.getPosition(), item);
        }
        if (!(list instanceof ListParseNode)) {
            return new ArrayParseNode(list.getPosition(), list).add(item);
        }
        return ((ListParseNode)list).add(item);
    }

    public ParseNode new_bv(TruffleString identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(this.lexer.getPosition(), identifier.toJavaStringUncached());
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    @SuppressFBWarnings(value={"ES"})
    public ArgumentParseNode arg_var(TruffleString tstring) {
        return this.arg_var(tstring.toJavaStringUncached());
    }

    @SuppressFBWarnings(value={"ES"})
    public ArgumentParseNode arg_var(String string) {
        String name = string.intern();
        StaticScope current = this.getCurrentScope();
        if (name == "_") {
            int count = 0;
            while (current.exists(name) >= 0) {
                name = (UNDERSCORE_PREFIX + count++).intern();
            }
        }
        if (ParserSupport.isNumberedParameter(name)) {
            this.warnNumberedParameterLikeDeclaration(this.lexer.getPosition(), name);
        }
        return new ArgumentParseNode(this.lexer.getPosition(), name, current.addVariableThisScope(name));
    }

    public TruffleString formal_argument(TruffleString identifier) {
        this.lexer.validateFormalIdentifier(identifier);
        return this.shadowing_lvar(identifier);
    }

    @SuppressFBWarnings(value={"ES"})
    public TruffleString shadowing_lvar(TruffleString tstring) {
        String name = tstring.toJavaStringUncached().intern();
        if (name == "_") {
            return tstring;
        }
        StaticScope current = this.getCurrentScope();
        if (current.exists(name) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return tstring;
    }

    public ListParseNode list_concat(ParseNode first, ParseNode second) {
        if (first instanceof ListParseNode) {
            if (second instanceof ListParseNode) {
                return ((ListParseNode)first).addAll((ListParseNode)second);
            }
            return ((ListParseNode)first).add(second);
        }
        return new ArrayParseNode(first.getPosition(), first).add(second);
    }

    public ParseNode splat_array(ParseNode node) {
        if (node instanceof SplatParseNode) {
            node = ((SplatParseNode)node).getValue();
        }
        if (node instanceof ArrayParseNode) {
            return node;
        }
        return null;
    }

    public ParseNode arg_append(ParseNode node1, ParseNode node2) {
        if (node1 == null) {
            return new ArrayParseNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListParseNode) {
            return ((ListParseNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassParseNode) {
            return this.arg_append(((BlockPassParseNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushParseNode) {
            ArgsPushParseNode pushNode = (ArgsPushParseNode)node1;
            ParseNode body = pushNode.getSecondNode();
            return new ArgsCatParseNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayParseNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushParseNode(this.position(node1, node2), node1, node2);
    }

    public TStringWithEncoding regexpFragmentCheck(RegexpParseNode end, TStringWithEncoding value) {
        TStringWithEncoding strEnc = this.setRegexpEncoding(end, value);
        try {
            ClassicRegexp.preprocessCheck(strEnc);
        }
        catch (DeferredRaiseException dre) {
            throw this.compile_error(dre.getException(this.getConfiguration().getContext()).getMessage());
        }
        catch (RaiseException re) {
            throw this.compile_error(re.getMessage());
        }
        return strEnc;
    }

    private void allocateNamedLocals(RegexpParseNode regexpNode) {
        ClassicRegexp pattern;
        try {
            pattern = new ClassicRegexp(this.configuration.getContext(), regexpNode.getValue(), regexpNode.getOptions());
        }
        catch (DeferredRaiseException dre) {
            throw dre.getException(RubyLanguage.getCurrentContext());
        }
        pattern.setLiteral();
        String[] names = pattern.getNames();
        int length = names.length;
        StaticScope scope = this.getCurrentScope();
        for (int i = 0; i < length; ++i) {
            if (RubyLexer.getKeyword(names[i]) != null || Character.isUpperCase(names[i].charAt(0))) continue;
            int slot = scope.isDefined(names[i]);
            if (slot >= 0) {
                if (scope.isNamedCapture(slot)) continue;
                this.warn(this.getPosition(regexpNode), "named capture conflicts a local variable - " + names[i]);
                continue;
            }
            this.getCurrentScope().addNamedCaptureVariable(names[i]);
        }
    }

    private char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == USASCIIEncoding.INSTANCE) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == UTF8Encoding.INSTANCE) {
            return 'u';
        }
        return ' ';
    }

    public RuntimeException compile_error(String message) {
        String line = this.lexer.getCurrentLine();
        SourceIndexLength position = this.lexer.getPosition();
        if (line.length() > 5) {
            boolean addNewline = message != null && !((String)message).endsWith("\n");
            message = (String)message + (addNewline ? "\n" : "") + line;
        }
        throw new RaiseException(RubyLanguage.getCurrentContext(), (RubyException)this.getConfiguration().getContext().getCoreExceptions().syntaxError((String)message, null, position.toSourceSection(this.lexer.getSource())));
    }

    protected void compileError(RubyEncoding optionEncoding, RubyEncoding encoding) {
        this.lexer.compile_error(SyntaxException.PID.REGEXP_ENCODING_MISMATCH, "regexp encoding option '" + this.optionsEncodingChar(optionEncoding == null ? null : optionEncoding.jcoding) + "' differs from source encoding '" + encoding + "'");
    }

    public TStringWithEncoding setRegexpEncoding(RegexpParseNode end, TStringWithEncoding value) {
        RegexpOptions options = end.getOptions();
        RubyEncoding optionsEncoding = (options = options.setup()).getEncoding() == null ? null : Encodings.getBuiltInEncoding(options.getEncoding());
        RubyEncoding encoding = value.encoding;
        if (optionsEncoding != null) {
            if (optionsEncoding != encoding && !value.isAsciiOnly()) {
                this.compileError(optionsEncoding, encoding);
            }
            value = value.forceEncoding(optionsEncoding);
        } else if (options.isEncodingNone()) {
            if (encoding == Encodings.BINARY && !value.isAsciiOnly()) {
                this.compileError(null, encoding);
            }
            value = value.forceEncoding(Encodings.BINARY);
        } else if (this.lexer.getEncoding() == USASCIIEncoding.INSTANCE) {
            value = !value.isAsciiOnly() ? value.forceEncoding(Encodings.US_ASCII) : value.forceEncoding(Encodings.BINARY);
        }
        return value;
    }

    protected ClassicRegexp checkRegexpSyntax(TStringWithEncoding value, RegexpOptions options) {
        try {
            return new ClassicRegexp(this.getConfiguration().getContext(), value, options);
        }
        catch (DeferredRaiseException dre) {
            throw this.compile_error(dre.getException(this.getConfiguration().getContext()).getMessage());
        }
        catch (RaiseException re) {
            throw this.compile_error(re.getMessage());
        }
    }

    public ParseNode newRegexpNode(SourceIndexLength position, ParseNode contents, RegexpParseNode end) {
        RegexpOptions options = end.getOptions().setup();
        Encoding encoding = this.lexer.getEncoding();
        if (contents == null) {
            TStringWithEncoding newValue = new TStringWithEncoding(TStringConstants.EMPTY_US_ASCII, Encodings.US_ASCII);
            if (encoding != null) {
                newValue = newValue.forceEncoding(Encodings.getBuiltInEncoding(encoding));
            }
            newValue = this.regexpFragmentCheck(end, newValue);
            return new RegexpParseNode(position, newValue, options.withoutOnce());
        }
        if (contents instanceof StrParseNode) {
            TStringWithEncoding meat = ((StrParseNode)contents).getTStringWithEncoding();
            meat = this.regexpFragmentCheck(end, meat);
            this.checkRegexpSyntax(meat, options.withoutOnce());
            return new RegexpParseNode(contents.getPosition(), meat, options.withoutOnce());
        }
        if (contents instanceof DStrParseNode) {
            DStrParseNode dStrNode = (DStrParseNode)contents;
            for (int i = 0; i < dStrNode.size(); ++i) {
                ParseNode fragment = dStrNode.get(i);
                if (!(fragment instanceof StrParseNode)) continue;
                this.regexpFragmentCheck(end, ((StrParseNode)fragment).getTStringWithEncoding());
            }
            DRegexpParseNode dRegexpNode = new DRegexpParseNode(position, options, encoding);
            dRegexpNode.add(new StrParseNode(contents.getPosition(), this.createMaster(options)));
            dRegexpNode.addAll(dStrNode);
            return dRegexpNode;
        }
        TStringWithEncoding master = this.createMaster(options);
        master = this.regexpFragmentCheck(end, master);
        DRegexpParseNode node = new DRegexpParseNode(position, options, master.encoding.jcoding);
        node.add(new StrParseNode(contents.getPosition(), master));
        node.add(contents);
        return node;
    }

    private TStringWithEncoding createMaster(RegexpOptions options) {
        Encoding encoding = options.getEncoding();
        RubyEncoding enc = encoding == null ? Encodings.BINARY : Encodings.getBuiltInEncoding(encoding);
        return new TStringWithEncoding(enc.tencoding.getEmpty(), enc);
    }

    public KeywordArgParseNode keyword_arg(SourceIndexLength position, AssignableParseNode assignable) {
        return new KeywordArgParseNode(position, assignable);
    }

    public NumericParseNode negateNumeric(NumericParseNode node) {
        switch (node.getNodeType()) {
            case BIGNUMNODE: 
            case FIXNUMNODE: {
                return this.negateInteger(node);
            }
            case COMPLEXNODE: {
                return this.negateComplexNode((ComplexParseNode)node);
            }
            case FLOATNODE: {
                return this.negateFloat((FloatParseNode)node);
            }
            case RATIONALNODE: {
                return this.negateRational((RationalParseNode)node);
            }
            case BIGRATIONALNODE: {
                return this.negateBigRational((BigRationalParseNode)node);
            }
        }
        this.yyerror("Invalid or unimplemented numeric to negate: " + node.toString());
        return null;
    }

    public Set<TruffleString> push_pvtbl() {
        Set<TruffleString> currentTable = this.variableTable;
        this.variableTable = new HashSet<TruffleString>();
        return currentTable;
    }

    public void pop_pvtbl(Set<TruffleString> table) {
        this.variableTable = table;
    }

    public Set<TruffleString> push_pktbl() {
        Set<TruffleString> currentTable = this.keyTable;
        this.keyTable = new HashSet<TruffleString>();
        return currentTable;
    }

    public void pop_pktbl(Set<TruffleString> table) {
        this.keyTable = table;
    }

    public ParseNode new_defined(SourceIndexLength position, ParseNode something) {
        return new DefinedParseNode(position, this.makeNullNil(something));
    }

    public SourceIndexLength extendedUntil(SourceIndexLength start, SourceIndexLength end) {
        return new SourceIndexLength(start.getCharIndex(), end.getCharEnd() - start.getCharIndex());
    }

    public ParseNode gettable(TruffleString id) {
        SourceIndexLength loc = this.lexer.getPosition();
        if (id.equals((Object)TStringConstants.SELF)) {
            return new SelfParseNode(loc);
        }
        if (id.equals((Object)TStringConstants.NIL)) {
            return new NilParseNode(loc);
        }
        if (id.equals((Object)TStringConstants.TRUE)) {
            return new TrueParseNode(loc);
        }
        if (id.equals((Object)TStringConstants.FALSE)) {
            return new FalseParseNode(loc);
        }
        if (id.equals((Object)TStringConstants.__FILE__)) {
            return new FileParseNode(loc, TruffleString.fromJavaStringUncached((String)this.lexer.getFile(), (TruffleString.Encoding)this.lexer.tencoding), this.lexer.encoding);
        }
        if (id.equals((Object)TStringConstants.__LINE__)) {
            return new FixnumParseNode(loc, this.lexer.getRubySourceLine());
        }
        if (id.equals((Object)TStringConstants.__ENCODING__)) {
            return new EncodingParseNode(loc, this.lexer.getEncoding());
        }
        TruffleString name = this.symbolID(id);
        switch (this.id_type(id)) {
            case Local: {
                String id2 = name.toString();
                int slot = this.currentScope.isDefined(id2);
                if (this.currentScope.isBlockScope() && slot != -1) {
                    if (this.isNumParamId(id2) && this.isNumParamNested()) {
                        return null;
                    }
                    if (name.equals((Object)this.lexer.getCurrentArg())) {
                        this.warn(this.lexer.getPosition(), "circular argument reference - " + name);
                    }
                    DVarParseNode newNode = new DVarParseNode(loc, slot, TruffleString.ToJavaStringNode.create().execute((AbstractTruffleString)name));
                    return newNode;
                }
                StaticScope.Type type = this.currentScope.getType();
                if (type == StaticScope.Type.LOCAL && slot != -1) {
                    if (name.equals((Object)this.lexer.getCurrentArg())) {
                        this.warn(this.lexer.getPosition(), "circular argument reference - " + name);
                    }
                    LocalVarParseNode newNode = new LocalVarParseNode(loc, slot, id2);
                    return newNode;
                }
                if (type == StaticScope.Type.BLOCK && this.isNumParamId(id2) && this.numberedParam(id2)) {
                    if (this.isNumParamNested()) {
                        return null;
                    }
                    DVarParseNode newNode = new DVarParseNode(loc, slot, TruffleString.ToJavaStringNode.create().execute((AbstractTruffleString)name));
                    if (this.numParamCurrent == null) {
                        this.numParamCurrent = newNode;
                    }
                    return newNode;
                }
                return new VCallParseNode(loc, id2);
            }
            case Global: {
                return new GlobalVarParseNode(loc, name);
            }
            case Instance: {
                return new InstVarParseNode(loc, name);
            }
            case Constant: {
                return new ConstParseNode(loc, name);
            }
            case Class: {
                return new ClassVarParseNode(loc, name);
            }
        }
        this.compile_error("identifier " + id + " is not valid to get");
        return null;
    }

    public IDType id_type(TruffleString identifier) {
        byte first = (byte)identifier.readByteUncached(0, this.lexer.tencoding);
        if (Character.isUpperCase(first)) {
            return IDType.Constant;
        }
        switch (first) {
            case 64: {
                return (char)identifier.readByteUncached(1, this.lexer.tencoding) == '@' ? IDType.Class : IDType.Instance;
            }
            case 36: {
                return IDType.Global;
            }
        }
        return IDType.Local;
    }

    private boolean isNumParamId(String id) {
        if (id.length() != 2 || id.charAt(0) != '_') {
            return false;
        }
        char one = id.charAt(1);
        return one != '0' && Character.isDigit(one);
    }

    private boolean isNumParamNested() {
        return false;
    }

    private boolean numberedParam(String id) {
        int n = Integer.parseInt(id.substring(1));
        if (this.currentScope.getEnclosingScope() == null) {
            return false;
        }
        if (this.maxNumParam == -1) {
            this.compile_error("ordinary parameter is defined");
            return false;
        }
        if (this.maxNumParam < n) {
            this.maxNumParam = n;
        }
        return true;
    }

    public void nd_set_first_loc(ParseNode node, SourceIndexLength line) {
    }

    static enum IDType {
        Local,
        Global,
        Instance,
        AttrSet,
        Constant,
        Class;

    }
}

