/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.digest;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.stdlib.digest.DigestAlgorithm;
import org.truffleruby.stdlib.digest.RubyDigest;

@CoreModule(value="Truffle::Digest", isClass=true)
public abstract class DigestNodes {
    @CompilerDirectives.TruffleBoundary
    private static MessageDigest getMessageDigestInstance(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static RubyDigest createDigest(RubyBaseNode node, DigestAlgorithm algorithm) {
        RubyDigest instance = new RubyDigest(node.getContext().getCoreLibrary().digestClass, node.getLanguage().digestShape, algorithm, DigestNodes.getMessageDigestInstance(algorithm.getName()));
        AllocationTracing.trace(instance, node);
        return instance;
    }

    @CoreMethod(names={"bubblebabble"}, onSingleton=true, required=1)
    public static abstract class BubbleBabbleNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(message)"}, limit="1")
        RubyString bubblebabble(Object message, @Cached RubyStringLibrary strings) {
            AbstractTruffleString tstring = strings.getTString(message);
            InternalByteArray byteArray = tstring.getInternalByteArrayUncached(strings.getTEncoding(message));
            byte[] bubblebabbleBytes = BubbleBabbleNode.bubblebabble(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength()).getBytes();
            return this.createString(this.fromByteArrayNode, bubblebabbleBytes, Encodings.UTF_8);
        }

        public static ByteArrayBuilder bubblebabble(byte[] message, int begin, int length) {
            char[] vowels = new char[]{'a', 'e', 'i', 'o', 'u', 'y'};
            char[] consonants = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'k', 'l', 'm', 'n', 'p', 'r', 's', 't', 'v', 'z', 'x'};
            long seed = 1L;
            ByteArrayBuilder retval = new ByteArrayBuilder();
            int rounds = length / 2 + 1;
            retval.append(120);
            for (int i = 0; i < rounds; ++i) {
                int idx2;
                int idx1;
                int idx0;
                if (i + 1 < rounds || length % 2 != 0) {
                    long b = message[begin + 2 * i] & 0xFF;
                    idx0 = (int)(((b >> 6 & 3L) + seed) % 6L);
                    idx1 = (int)(b >> 2 & 0xFL);
                    idx2 = (int)(((b & 3L) + seed / 6L) % 6L);
                    retval.append(vowels[idx0]);
                    retval.append(consonants[idx1]);
                    retval.append(vowels[idx2]);
                    if (i + 1 >= rounds) continue;
                    long b2 = message[begin + 2 * i + 1] & 0xFF;
                    int idx3 = (int)(b2 >> 4 & 0xFL);
                    int idx4 = (int)(b2 & 0xFL);
                    retval.append(consonants[idx3]);
                    retval.append(45);
                    retval.append(consonants[idx4]);
                    seed = (seed * 5L + (b * 7L + b2)) % 36L;
                    continue;
                }
                idx0 = (int)(seed % 6L);
                idx1 = 16;
                idx2 = (int)(seed / 6L);
                retval.append(vowels[idx0]);
                retval.append(consonants[idx1]);
                retval.append(vowels[idx2]);
            }
            retval.append(120);
            return retval;
        }
    }

    @CoreMethod(names={"digest_length"}, onSingleton=true, required=1)
    public static abstract class DigestLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int digestLength(RubyDigest digestObject) {
            return digestObject.algorithm.getLength();
        }
    }

    @CoreMethod(names={"digest_block_length"}, onSingleton=true, required=1)
    public static abstract class DigestBlockLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int digestBlockLength(RubyDigest digestObject) {
            return digestObject.algorithm.getBlockLength();
        }
    }

    @CoreMethod(names={"digest"}, onSingleton=true, required=1)
    public static abstract class DigestNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @Specialization
        RubyString digest(RubyDigest digestObject) {
            MessageDigest digest = digestObject.digest;
            return this.createString(this.fromByteArrayNode, DigestNode.cloneAndDigest(digest), Encodings.BINARY);
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] cloneAndDigest(MessageDigest digest) {
            MessageDigest clonedDigest;
            try {
                clonedDigest = (MessageDigest)digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            return clonedDigest.digest();
        }
    }

    @CoreMethod(names={"reset"}, onSingleton=true, required=1)
    public static abstract class ResetNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyDigest reset(RubyDigest digestObject) {
            digestObject.digest.reset();
            return digestObject;
        }
    }

    @CoreMethod(names={"update"}, onSingleton=true, required=2)
    public static abstract class UpdateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(message)"}, limit="1")
        RubyDigest update(RubyDigest digestObject, Object message, @Cached RubyStringLibrary strings, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            MessageDigest digest = digestObject.digest;
            AbstractTruffleString tstring = strings.getTString(message);
            InternalByteArray byteArray = getInternalByteArrayNode.execute(tstring, strings.getTEncoding(message));
            this.update(digest, byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
            return digestObject;
        }

        @CompilerDirectives.TruffleBoundary
        private void update(MessageDigest digest, byte[] input, int offset, int len) {
            digest.update(input, offset, len);
        }
    }

    @CoreMethod(names={"sha512"}, onSingleton=true)
    public static abstract class SHA512Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyDigest sha512() {
            return DigestNodes.createDigest(this, DigestAlgorithm.SHA512);
        }
    }

    @CoreMethod(names={"sha384"}, onSingleton=true)
    public static abstract class SHA384Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyDigest sha384() {
            return DigestNodes.createDigest(this, DigestAlgorithm.SHA384);
        }
    }

    @CoreMethod(names={"sha256"}, onSingleton=true)
    public static abstract class SHA256Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyDigest sha256() {
            return DigestNodes.createDigest(this, DigestAlgorithm.SHA256);
        }
    }

    @CoreMethod(names={"sha1"}, onSingleton=true)
    public static abstract class SHA1Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyDigest sha1() {
            return DigestNodes.createDigest(this, DigestAlgorithm.SHA1);
        }
    }

    @CoreMethod(names={"md5"}, onSingleton=true)
    public static abstract class MD5Node
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyDigest md5() {
            return DigestNodes.createDigest(this, DigestAlgorithm.MD5);
        }
    }
}

