/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import java.io.OutputStream;
import org.graalvm.shadowed.org.jline.utils.NonBlockingInputStream;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.adapters.InputStreamAdapter;
import org.truffleruby.core.adapters.OutputStreamAdapter;
import org.truffleruby.core.support.RubyIO;

public final class IoStream {
    private final RubyContext context;
    private final RubyLanguage language;
    private final int fd;
    private final RubyIO io;
    private NonBlockingInputStream in;
    private OutputStream out;

    public IoStream(RubyContext context, RubyLanguage language, int fd, RubyIO io) {
        this.context = context;
        this.language = language;
        this.fd = fd;
        this.io = io;
    }

    public int getFd() {
        return this.fd;
    }

    public RubyIO getIo() {
        return this.io;
    }

    public NonBlockingInputStream getIn() {
        if (this.in == null) {
            this.in = new InputStreamAdapter(this.io);
        }
        return this.in;
    }

    public OutputStream getOut() {
        if (this.out == null) {
            switch (this.fd) {
                case 1: {
                    this.out = this.context.getEnv().out();
                    break;
                }
                case 2: {
                    this.out = this.context.getEnv().err();
                    break;
                }
                default: {
                    this.out = new OutputStreamAdapter(this.context, this.language, this.io, this.context.getEncodingManager().getDefaultExternalEncoding());
                }
            }
        }
        return this.out;
    }
}

