/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import org.graalvm.shadowed.org.jline.reader.History;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.collections.BoundaryIterable;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.stdlib.readline.ConsoleHolder;

@CoreModule(value="Truffle::ReadlineHistory")
public abstract class ReadlineHistoryNodes {

    @CoreMethod(names={"delete_at"}, needsSelf=false, required=1, lowerFixnum={1})
    public static abstract class DeleteAtNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object deleteAt(int index) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            int normalizedIndex = index < 0 ? index + consoleHolder.getHistory().size() : index;
            try {
                String line = consoleHolder.getHistory().remove(normalizedIndex).line();
                return this.createString(this.fromJavaStringNode, line, this.getLocaleEncoding());
            }
            catch (IndexOutOfBoundsException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().indexErrorInvalidIndex(this));
            }
        }
    }

    @CoreMethod(names={"[]="}, needsSelf=false, lowerFixnum={1}, required=2)
    public static abstract class SetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object setIndex(Object indexObject, Object line, @Cached ToIntNode toIntNode, @Cached ToJavaStringNode toJavaStringNode) {
            int index = toIntNode.execute(indexObject);
            String lineAsString = toJavaStringNode.execute(this, line);
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            int normalizedIndex = index < 0 ? index + consoleHolder.getHistory().size() : index;
            try {
                consoleHolder.getHistory().set(normalizedIndex, lineAsString);
                return nil;
            }
            catch (IndexOutOfBoundsException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().indexErrorInvalidIndex(this));
            }
        }
    }

    @CoreMethod(names={"[]"}, needsSelf=false, required=1, lowerFixnum={1})
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object getIndex(int index) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            int normalizedIndex = index < 0 ? index + consoleHolder.getHistory().size() : index;
            try {
                String line = consoleHolder.getHistory().get(normalizedIndex);
                return this.createString(this.fromJavaStringNode, line, this.getLocaleEncoding());
            }
            catch (IndexOutOfBoundsException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().indexErrorInvalidIndex(this));
            }
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true)
    public static abstract class EachNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyBasicObject each(RubyBasicObject history, RubyProc block, @Cached CallBlockNode yieldNode) {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            for (History.Entry e : BoundaryIterable.wrap(consoleHolder.getHistory())) {
                RubyString line = this.createString(this.fromJavaStringNode, this.historyEntryToString(e), this.getLocaleEncoding());
                yieldNode.yield(block, new Object[]{line});
            }
            return history;
        }

        @CompilerDirectives.TruffleBoundary
        private String historyEntryToString(History.Entry entry) {
            return entry.line();
        }
    }

    @CoreMethod(names={"clear"}, needsSelf=false)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object clear() {
            try {
                this.getContext().getConsoleHolder().getHistory().purge();
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
            }
            return nil;
        }
    }

    @CoreMethod(names={"length", "size"}, needsSelf=false)
    public static abstract class LengthNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int length() {
            return this.getContext().getConsoleHolder().getHistory().size();
        }
    }

    @CoreMethod(names={"shift"}, needsSelf=false)
    public static abstract class ShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object shift() {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            if (consoleHolder.getHistory().isEmpty()) {
                return nil;
            }
            String lastLine = consoleHolder.getHistory().removeFirst().line();
            return this.createString(this.fromJavaStringNode, lastLine, this.getLocaleEncoding());
        }
    }

    @CoreMethod(names={"pop"}, needsSelf=false)
    public static abstract class PopNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object pop() {
            ConsoleHolder consoleHolder = this.getContext().getConsoleHolder();
            if (consoleHolder.getHistory().isEmpty()) {
                return nil;
            }
            String lastLine = consoleHolder.getHistory().removeLast().line();
            return this.createString(this.fromJavaStringNode, lastLine, this.getLocaleEncoding());
        }
    }

    @CoreMethod(names={"push", "<<"}, rest=true)
    public static abstract class PushNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyBasicObject push(RubyBasicObject history, Object[] lines, @Cached ToJavaStringNode toJavaStringNode) {
            for (Object line : lines) {
                String asString = toJavaStringNode.execute(this, line);
                this.addToHistory(asString);
            }
            return history;
        }

        @CompilerDirectives.TruffleBoundary
        private void addToHistory(String item) {
            this.getContext().getConsoleHolder().getHistory().add(item);
        }
    }
}

