/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import org.graalvm.shadowed.org.jline.reader.Buffer;
import org.graalvm.shadowed.org.jline.reader.Candidate;
import org.graalvm.shadowed.org.jline.reader.Completer;
import org.graalvm.shadowed.org.jline.reader.EndOfFileException;
import org.graalvm.shadowed.org.jline.reader.LineReader;
import org.graalvm.shadowed.org.jline.reader.ParsedLine;
import org.graalvm.shadowed.org.jline.reader.UserInterruptException;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayOperations;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.cast.BooleanCastWithDefaultNode;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.support.RubyIO;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.ToJavaStringWithDefaultNode;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.stdlib.readline.ConsoleHolder;

@CoreModule(value="Truffle::Readline")
public abstract class ReadlineNodes {

    private static final class ProcCompleter
    implements Completer {
        private final RubyContext context;
        private final RubyLanguage language;
        private final RubyProc proc;

        public ProcCompleter(RubyContext context, RubyLanguage language, RubyProc proc) {
            this.context = context;
            this.language = language;
            this.proc = proc;
        }

        public void complete(LineReader lineReader, ParsedLine commandLine, List<Candidate> candidates) {
            String buffer = commandLine.word().substring(0, commandLine.wordCursor());
            String after = commandLine.word().substring(commandLine.wordCursor());
            boolean complete = lineReader.getBuffer().cursor() == lineReader.getBuffer().length();
            RubyString string = StringOperations.createUTF8String(this.context, this.language, buffer);
            RubyArray completions = (RubyArray)DispatchNode.getUncached().call((Object)this.proc, "call", (Object)string);
            for (Object element : ArrayOperations.toIterable(completions)) {
                String completion = RubyGuards.getJavaString(element);
                candidates.add(new Candidate(completion + after, completion, null, null, null, null, complete));
            }
        }
    }

    @Primitive(name="readline_set_output", lowerFixnum={0})
    public static abstract class SetOutputNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int setOutput(int fd, RubyIO io) {
            ConsoleHolder oldConsoleHolder = this.getContext().getConsoleHolder();
            ConsoleHolder newConsoleHolder = oldConsoleHolder.updateOut(fd, io);
            if (newConsoleHolder != oldConsoleHolder) {
                this.getContext().setConsoleHolder(newConsoleHolder);
            }
            return fd;
        }
    }

    @Primitive(name="readline_set_input", lowerFixnum={0})
    public static abstract class SetInputNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int setInput(int fd, RubyIO io) {
            ConsoleHolder oldConsoleHolder = this.getContext().getConsoleHolder();
            ConsoleHolder newConsoleHolder = oldConsoleHolder.updateIn(fd, io);
            if (newConsoleHolder != oldConsoleHolder) {
                this.getContext().setConsoleHolder(newConsoleHolder);
            }
            return fd;
        }
    }

    @CoreMethod(names={"line_buffer"}, onSingleton=true)
    public static abstract class LineBufferNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object lineBuffer() {
            Buffer buffer = this.getContext().getConsoleHolder().getReadline().getBuffer();
            return this.createString(this.fromJavaStringNode, buffer.toString(), this.getLocaleEncoding());
        }
    }

    @CoreMethod(names={"delete_text"}, constructor=true)
    public static abstract class DeleteTextNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyBasicObject deleteText(RubyBasicObject readline) {
            this.getContext().getConsoleHolder().getReadline().getBuffer().clear();
            return readline;
        }
    }

    @CoreMethod(names={"insert_text"}, constructor=true, required=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="text", type=RubyNode.class)})
    public static abstract class InsertTextNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyBasicObject insertText(RubyBasicObject readline, Object text, @Cached ToJavaStringNode toJavaStringNode) {
            String textAsString = toJavaStringNode.execute(this, text);
            this.getContext().getConsoleHolder().getReadline().getBuffer().write((CharSequence)textAsString);
            return readline;
        }
    }

    @CoreMethod(names={"point"}, onSingleton=true)
    public static abstract class PointNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int point() {
            return this.getContext().getConsoleHolder().getReadline().getBuffer().cursor();
        }
    }

    @CoreMethod(names={"readline"}, isModuleFunction=true, optional=2)
    public static abstract class ReadlineNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object readline(Object maybePromptObject, Object maybeAddToHistory, @Cached ToJavaStringWithDefaultNode toJavaStringWithDefaultNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached BooleanCastWithDefaultNode booleanCastWithDefaultNode) {
            String prompt = toJavaStringWithDefaultNode.execute(this, maybePromptObject, "");
            boolean addToHistory = booleanCastWithDefaultNode.execute(this, maybeAddToHistory, false);
            LineReader readline = this.getContext().getConsoleHolder().getReadline();
            Memo<Object> result = new Memo<Object>(null);
            this.getContext().getThreadManager().runUntilResult(this, () -> {
                String line;
                try {
                    line = readline.readLine(prompt);
                }
                catch (EndOfFileException e) {
                    line = null;
                }
                catch (UserInterruptException e) {
                    throw new InterruptedException();
                }
                result.set(line);
                return true;
            });
            String value = result.get();
            if (value == null) {
                return nil;
            }
            if (addToHistory) {
                readline.getHistory().add(value);
            }
            return this.createString(fromJavaStringNode, value, this.getContext().getEncodingManager().getDefaultExternalEncoding());
        }
    }

    @CoreMethod(names={"get_screen_size"}, onSingleton=true)
    public static abstract class GetScreenSizeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray getScreenSize() {
            LineReader readline = this.getContext().getConsoleHolder().getReadline();
            int[] store = new int[]{readline.getTerminal().getHeight(), readline.getTerminal().getWidth()};
            return ArrayHelpers.createArray(this.getContext(), this.getLanguage(), store);
        }
    }

    @Primitive(name="readline_set_completion_proc")
    public static abstract class CompletionProcSetNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyProc setCompletionProc(RubyProc proc) {
            ProcCompleter completer = new ProcCompleter(this.getContext(), this.getLanguage(), proc);
            this.getContext().getConsoleHolder().setCompleter(completer);
            return proc;
        }
    }

    @CoreMethod(names={"basic_word_break_characters="}, onSingleton=true, required=1)
    @NodeChild(value="characters", type=RubyBaseNodeWithExecute.class)
    public static abstract class SetBasicWordBreakCharactersNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(charactersAsString)"}, limit="1")
        static Object setBasicWordBreakCharacters(Object characters, @Cached ToStrNode toStrNode, @Cached RubyStringLibrary strings, @Bind(value="this") Node node, @Bind(value="toStrNode.execute(node, characters)") Object charactersAsString) {
            String delimiters = RubyGuards.getJavaString(charactersAsString);
            SetBasicWordBreakCharactersNode.getContext(node).getConsoleHolder().getParser().setDelimiters(delimiters);
            return charactersAsString;
        }
    }

    @CoreMethod(names={"basic_word_break_characters"}, onSingleton=true)
    public static abstract class BasicWordBreakCharactersNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString basicWordBreakCharacters() {
            String delimiters = this.getContext().getConsoleHolder().getParser().getDelimiters();
            return this.createString(this.fromJavaStringNode, delimiters, Encodings.UTF_8);
        }
    }
}

