/*
 * Decompiled with CFR 0.152.
 */
package org.yarp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.yarp.MarkNewlinesVisitor;
import org.yarp.Nodes;
import org.yarp.ParseResult;

public class Loader {
    private final ByteBuffer buffer;
    private ConstantPool constantPool;
    private final Nodes.Source source;
    private byte MAJOR_VERSION = 0;
    private byte MINOR_VERSION = (byte)8;
    private byte PATCH_VERSION = 0;

    public static ParseResult load(byte[] serialized, Nodes.Source source) {
        return new Loader(serialized, source).load();
    }

    private Loader(byte[] serialized, Nodes.Source source) {
        this.buffer = ByteBuffer.wrap(serialized).order(ByteOrder.nativeOrder());
        this.source = source;
    }

    private ParseResult load() {
        this.expect((byte)89);
        this.expect((byte)65);
        this.expect((byte)82);
        this.expect((byte)80);
        this.expect(this.MAJOR_VERSION);
        this.expect(this.MINOR_VERSION);
        this.expect(this.PATCH_VERSION);
        int encodingLength = this.loadVarInt();
        byte[] encodingName = new byte[encodingLength];
        this.buffer.get(encodingName);
        ParseResult.Comment[] comments = this.loadComments();
        ParseResult.Error[] errors = this.loadSyntaxErrors();
        ParseResult.Warning[] warnings = this.loadWarnings();
        int constantPoolBufferOffset = this.buffer.getInt();
        int constantPoolLength = this.loadVarInt();
        this.constantPool = new ConstantPool(this.source.bytes, constantPoolBufferOffset, constantPoolLength);
        Nodes.Node node = this.loadNode();
        int left = constantPoolBufferOffset - this.buffer.position();
        if (left != 0) {
            throw new Error("Expected to consume all bytes while deserializing but there were " + left + " bytes left");
        }
        boolean[] newlineMarked = new boolean[1 + this.source.getLineCount()];
        MarkNewlinesVisitor visitor = new MarkNewlinesVisitor(this.source, newlineMarked);
        node.accept(visitor);
        return new ParseResult(node, comments, errors, warnings);
    }

    private byte[] loadString() {
        int length = this.loadVarInt();
        byte[] string = new byte[length];
        this.buffer.get(string);
        return string;
    }

    private ParseResult.Comment[] loadComments() {
        int count = this.loadVarInt();
        ParseResult.Comment[] comments = new ParseResult.Comment[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Comment comment;
            ParseResult.CommentType type = ParseResult.CommentType.VALUES[this.buffer.get()];
            Nodes.Location location = this.loadLocation();
            comments[i] = comment = new ParseResult.Comment(type, location);
        }
        return comments;
    }

    private ParseResult.Error[] loadSyntaxErrors() {
        int count = this.loadVarInt();
        ParseResult.Error[] errors = new ParseResult.Error[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Error error;
            byte[] bytes = this.loadString();
            String message = new String(bytes, StandardCharsets.US_ASCII);
            Nodes.Location location = this.loadLocation();
            errors[i] = error = new ParseResult.Error(message, location);
        }
        return errors;
    }

    private ParseResult.Warning[] loadWarnings() {
        int count = this.loadVarInt();
        ParseResult.Warning[] warnings = new ParseResult.Warning[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Warning warning;
            byte[] bytes = this.loadString();
            String message = new String(bytes, StandardCharsets.US_ASCII);
            Nodes.Location location = this.loadLocation();
            warnings[i] = warning = new ParseResult.Warning(message, location);
        }
        return warnings;
    }

    private Nodes.Node loadOptionalNode() {
        if (this.buffer.get(this.buffer.position()) != 0) {
            return this.loadNode();
        }
        this.buffer.position(this.buffer.position() + 1);
        return null;
    }

    private Nodes.Location[] loadLocations() {
        int length = this.loadVarInt();
        if (length == 0) {
            return Nodes.Location.EMPTY_ARRAY;
        }
        Nodes.Location[] locations = new Nodes.Location[length];
        for (int i = 0; i < length; ++i) {
            locations[i] = this.loadLocation();
        }
        return locations;
    }

    private byte[] loadConstant() {
        return this.constantPool.get(this.buffer, this.loadVarInt());
    }

    private byte[][] loadConstants() {
        int length = this.loadVarInt();
        if (length == 0) {
            return Nodes.EMPTY_BYTE_ARRAY_ARRAY;
        }
        byte[][] constants = new byte[length][];
        for (int i = 0; i < length; ++i) {
            constants[i] = this.constantPool.get(this.buffer, this.loadVarInt());
        }
        return constants;
    }

    private Nodes.Node[] loadNodes() {
        int length = this.loadVarInt();
        if (length == 0) {
            return Nodes.Node.EMPTY_ARRAY;
        }
        Nodes.Node[] nodes = new Nodes.Node[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = this.loadNode();
        }
        return nodes;
    }

    private Nodes.Location loadLocation() {
        return new Nodes.Location(this.loadVarInt(), this.loadVarInt());
    }

    private Nodes.Location loadOptionalLocation() {
        if (this.buffer.get() != 0) {
            return this.loadLocation();
        }
        return null;
    }

    private int loadVarInt() {
        int x = this.buffer.get();
        if (x >= 0) {
            return x;
        }
        if ((x ^= this.buffer.get() << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= this.buffer.get() << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= this.buffer.get() << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            x ^= this.buffer.get() << 28;
            x ^= 0xFE03F80;
        }
        return x;
    }

    private short loadFlags() {
        int flags = this.loadVarInt();
        assert (flags >= 0 && flags <= Short.MAX_VALUE);
        return (short)flags;
    }

    private Nodes.Node loadNode() {
        int type = this.buffer.get() & 0xFF;
        int startOffset = this.loadVarInt();
        int length = this.loadVarInt();
        switch (type) {
            case 1: {
                return new Nodes.AliasNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 2: {
                return new Nodes.AlternationPatternNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 3: {
                return new Nodes.AndNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 4: {
                return new Nodes.AndWriteNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 5: {
                return new Nodes.ArgumentsNode(this.loadNodes(), startOffset, length);
            }
            case 6: {
                return new Nodes.ArrayNode(this.loadNodes(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 7: {
                return new Nodes.ArrayPatternNode(this.loadOptionalNode(), this.loadNodes(), this.loadOptionalNode(), this.loadNodes(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 8: {
                return new Nodes.AssocNode(this.loadNode(), this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 9: {
                return new Nodes.AssocSplatNode(this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 10: {
                return new Nodes.BackReferenceReadNode(startOffset, length);
            }
            case 11: {
                return new Nodes.BeginNode(this.loadOptionalLocation(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.RescueNode)this.loadOptionalNode(), (Nodes.ElseNode)this.loadOptionalNode(), (Nodes.EnsureNode)this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 12: {
                return new Nodes.BlockArgumentNode(this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 13: {
                return new Nodes.BlockNode(this.loadConstants(), (Nodes.BlockParametersNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 14: {
                return new Nodes.BlockParameterNode(this.loadOptionalLocation(), this.loadLocation(), startOffset, length);
            }
            case 15: {
                return new Nodes.BlockParametersNode((Nodes.ParametersNode)this.loadOptionalNode(), this.loadLocations(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 16: {
                return new Nodes.BreakNode((Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 17: {
                return new Nodes.CallNode(this.loadOptionalNode(), this.loadOptionalLocation(), this.loadOptionalLocation(), this.loadOptionalLocation(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalLocation(), (Nodes.BlockNode)this.loadOptionalNode(), this.loadFlags(), this.loadString(), startOffset, length);
            }
            case 18: {
                return new Nodes.CallOperatorAndWriteNode((Nodes.CallNode)this.loadNode(), this.loadLocation(), this.loadNode(), startOffset, length);
            }
            case 19: {
                return new Nodes.CallOperatorOrWriteNode((Nodes.CallNode)this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 20: {
                return new Nodes.CallOperatorWriteNode((Nodes.CallNode)this.loadNode(), this.loadLocation(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 21: {
                return new Nodes.CapturePatternNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 22: {
                return new Nodes.CaseNode(this.loadOptionalNode(), this.loadNodes(), (Nodes.ElseNode)this.loadOptionalNode(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 23: {
                return new Nodes.ClassNode(this.loadConstants(), this.loadLocation(), this.loadNode(), this.loadOptionalLocation(), this.loadOptionalNode(), this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 24: {
                return new Nodes.ClassVariableReadNode(startOffset, length);
            }
            case 25: {
                return new Nodes.ClassVariableWriteNode(this.loadLocation(), this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 26: {
                return new Nodes.ConstantPathNode(this.loadOptionalNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 27: {
                return new Nodes.ConstantPathWriteNode((Nodes.ConstantPathNode)this.loadNode(), this.loadOptionalLocation(), this.loadOptionalNode(), startOffset, length);
            }
            case 28: {
                return new Nodes.ConstantReadNode(startOffset, length);
            }
            case 29: {
                return new Nodes.ConstantWriteNode(this.loadLocation(), this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 30: {
                return new Nodes.DefNode(this.buffer.getInt(), this.loadLocation(), this.loadOptionalNode(), (Nodes.ParametersNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadConstants(), this.loadLocation(), this.loadOptionalLocation(), this.loadOptionalLocation(), this.loadOptionalLocation(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 31: {
                return new Nodes.DefinedNode(this.loadOptionalLocation(), this.loadNode(), this.loadOptionalLocation(), this.loadLocation(), startOffset, length);
            }
            case 32: {
                return new Nodes.ElseNode(this.loadLocation(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 33: {
                return new Nodes.EmbeddedStatementsNode(this.loadLocation(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 34: {
                return new Nodes.EmbeddedVariableNode(this.loadLocation(), this.loadNode(), startOffset, length);
            }
            case 35: {
                return new Nodes.EnsureNode(this.loadLocation(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 36: {
                return new Nodes.FalseNode(startOffset, length);
            }
            case 37: {
                return new Nodes.FindPatternNode(this.loadOptionalNode(), this.loadNode(), this.loadNodes(), this.loadNode(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 38: {
                return new Nodes.FlipFlopNode(this.loadOptionalNode(), this.loadOptionalNode(), this.loadLocation(), this.loadFlags(), startOffset, length);
            }
            case 39: {
                return new Nodes.FloatNode(startOffset, length);
            }
            case 40: {
                return new Nodes.ForNode(this.loadNode(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadLocation(), this.loadLocation(), this.loadOptionalLocation(), this.loadLocation(), startOffset, length);
            }
            case 41: {
                return new Nodes.ForwardingArgumentsNode(startOffset, length);
            }
            case 42: {
                return new Nodes.ForwardingParameterNode(startOffset, length);
            }
            case 43: {
                return new Nodes.ForwardingSuperNode((Nodes.BlockNode)this.loadOptionalNode(), startOffset, length);
            }
            case 44: {
                return new Nodes.GlobalVariableReadNode(startOffset, length);
            }
            case 45: {
                return new Nodes.GlobalVariableWriteNode(this.loadLocation(), this.loadOptionalLocation(), this.loadOptionalNode(), startOffset, length);
            }
            case 46: {
                return new Nodes.HashNode(this.loadLocation(), this.loadNodes(), this.loadLocation(), startOffset, length);
            }
            case 47: {
                return new Nodes.HashPatternNode(this.loadOptionalNode(), this.loadNodes(), this.loadOptionalNode(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 48: {
                return new Nodes.IfNode(this.loadOptionalLocation(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 49: {
                return new Nodes.ImaginaryNode(this.loadNode(), startOffset, length);
            }
            case 50: {
                return new Nodes.InNode(this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 51: {
                return new Nodes.InstanceVariableReadNode(startOffset, length);
            }
            case 52: {
                return new Nodes.InstanceVariableWriteNode(this.loadLocation(), this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 53: {
                return new Nodes.IntegerNode(startOffset, length);
            }
            case 54: {
                return new Nodes.InterpolatedRegularExpressionNode(this.loadLocation(), this.loadNodes(), this.loadLocation(), this.loadFlags(), startOffset, length);
            }
            case 55: {
                return new Nodes.InterpolatedStringNode(this.loadOptionalLocation(), this.loadNodes(), this.loadOptionalLocation(), startOffset, length);
            }
            case 56: {
                return new Nodes.InterpolatedSymbolNode(this.loadOptionalLocation(), this.loadNodes(), this.loadOptionalLocation(), startOffset, length);
            }
            case 57: {
                return new Nodes.InterpolatedXStringNode(this.loadLocation(), this.loadNodes(), this.loadLocation(), startOffset, length);
            }
            case 58: {
                return new Nodes.KeywordHashNode(this.loadNodes(), startOffset, length);
            }
            case 59: {
                return new Nodes.KeywordParameterNode(this.loadLocation(), this.loadOptionalNode(), startOffset, length);
            }
            case 60: {
                return new Nodes.KeywordRestParameterNode(this.loadLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 61: {
                return new Nodes.LambdaNode(this.loadConstants(), this.loadLocation(), (Nodes.BlockParametersNode)this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 62: {
                return new Nodes.LocalVariableReadNode(this.loadConstant(), this.loadVarInt(), startOffset, length);
            }
            case 63: {
                return new Nodes.LocalVariableWriteNode(this.loadConstant(), this.loadVarInt(), this.loadOptionalNode(), this.loadLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 64: {
                return new Nodes.MatchPredicateNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 65: {
                return new Nodes.MatchRequiredNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 66: {
                return new Nodes.MissingNode(startOffset, length);
            }
            case 67: {
                return new Nodes.ModuleNode(this.loadConstants(), this.loadLocation(), this.loadNode(), this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 68: {
                return new Nodes.MultiWriteNode(this.loadNodes(), this.loadOptionalLocation(), this.loadOptionalNode(), this.loadOptionalLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 69: {
                return new Nodes.NextNode((Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 70: {
                return new Nodes.NilNode(startOffset, length);
            }
            case 71: {
                return new Nodes.NoKeywordsParameterNode(this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 72: {
                return new Nodes.NumberedReferenceReadNode(startOffset, length);
            }
            case 73: {
                return new Nodes.OperatorWriteNode(this.loadNode(), this.loadLocation(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 74: {
                return new Nodes.OptionalParameterNode(this.loadConstant(), this.loadLocation(), this.loadLocation(), this.loadNode(), startOffset, length);
            }
            case 75: {
                return new Nodes.OrNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 76: {
                return new Nodes.OrWriteNode(this.loadNode(), this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 77: {
                return new Nodes.ParametersNode(this.loadNodes(), this.loadNodes(), this.loadNodes(), (Nodes.RestParameterNode)this.loadOptionalNode(), this.loadNodes(), this.loadOptionalNode(), (Nodes.BlockParameterNode)this.loadOptionalNode(), startOffset, length);
            }
            case 78: {
                return new Nodes.ParenthesesNode(this.loadOptionalNode(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 79: {
                return new Nodes.PinnedExpressionNode(this.loadNode(), this.loadLocation(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 80: {
                return new Nodes.PinnedVariableNode(this.loadNode(), this.loadLocation(), startOffset, length);
            }
            case 81: {
                return new Nodes.PostExecutionNode((Nodes.StatementsNode)this.loadOptionalNode(), this.loadLocation(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 82: {
                return new Nodes.PreExecutionNode((Nodes.StatementsNode)this.loadOptionalNode(), this.loadLocation(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 83: {
                return new Nodes.ProgramNode(this.loadConstants(), (Nodes.StatementsNode)this.loadNode(), startOffset, length);
            }
            case 84: {
                return new Nodes.RangeNode(this.loadOptionalNode(), this.loadOptionalNode(), this.loadLocation(), this.loadFlags(), startOffset, length);
            }
            case 85: {
                return new Nodes.RationalNode(this.loadNode(), startOffset, length);
            }
            case 86: {
                return new Nodes.RedoNode(startOffset, length);
            }
            case 87: {
                return new Nodes.RegularExpressionNode(this.loadLocation(), this.loadLocation(), this.loadLocation(), this.loadString(), this.loadFlags(), startOffset, length);
            }
            case 88: {
                return new Nodes.RequiredDestructuredParameterNode(this.loadNodes(), this.loadLocation(), this.loadLocation(), startOffset, length);
            }
            case 89: {
                return new Nodes.RequiredParameterNode(this.loadConstant(), startOffset, length);
            }
            case 90: {
                return new Nodes.RescueModifierNode(this.loadNode(), this.loadLocation(), this.loadNode(), startOffset, length);
            }
            case 91: {
                return new Nodes.RescueNode(this.loadLocation(), this.loadNodes(), this.loadOptionalLocation(), this.loadOptionalNode(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.RescueNode)this.loadOptionalNode(), startOffset, length);
            }
            case 92: {
                return new Nodes.RestParameterNode(this.loadLocation(), this.loadOptionalLocation(), startOffset, length);
            }
            case 93: {
                return new Nodes.RetryNode(startOffset, length);
            }
            case 94: {
                return new Nodes.ReturnNode(this.loadLocation(), (Nodes.ArgumentsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 95: {
                return new Nodes.SelfNode(startOffset, length);
            }
            case 96: {
                return new Nodes.SingletonClassNode(this.loadConstants(), this.loadLocation(), this.loadLocation(), this.loadNode(), this.loadOptionalNode(), this.loadLocation(), startOffset, length);
            }
            case 97: {
                return new Nodes.SourceEncodingNode(startOffset, length);
            }
            case 98: {
                return new Nodes.SourceFileNode(this.loadString(), startOffset, length);
            }
            case 99: {
                return new Nodes.SourceLineNode(startOffset, length);
            }
            case 100: {
                return new Nodes.SplatNode(this.loadLocation(), this.loadOptionalNode(), startOffset, length);
            }
            case 101: {
                return new Nodes.StatementsNode(this.loadNodes(), startOffset, length);
            }
            case 102: {
                return new Nodes.StringConcatNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 103: {
                return new Nodes.StringNode(this.loadOptionalLocation(), this.loadLocation(), this.loadOptionalLocation(), this.loadString(), startOffset, length);
            }
            case 104: {
                return new Nodes.SuperNode(this.loadLocation(), this.loadOptionalLocation(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalLocation(), (Nodes.BlockNode)this.loadOptionalNode(), startOffset, length);
            }
            case 105: {
                return new Nodes.SymbolNode(this.loadOptionalLocation(), this.loadLocation(), this.loadOptionalLocation(), this.loadString(), startOffset, length);
            }
            case 106: {
                return new Nodes.TrueNode(startOffset, length);
            }
            case 107: {
                return new Nodes.UndefNode(this.loadNodes(), this.loadLocation(), startOffset, length);
            }
            case 108: {
                return new Nodes.UnlessNode(this.loadLocation(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.ElseNode)this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
            case 109: {
                return new Nodes.UntilNode(this.loadLocation(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadFlags(), startOffset, length);
            }
            case 110: {
                return new Nodes.WhenNode(this.loadLocation(), this.loadNodes(), (Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 111: {
                return new Nodes.WhileNode(this.loadLocation(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadFlags(), startOffset, length);
            }
            case 112: {
                return new Nodes.XStringNode(this.loadLocation(), this.loadLocation(), this.loadLocation(), this.loadString(), startOffset, length);
            }
            case 113: {
                return new Nodes.YieldNode(this.loadLocation(), this.loadOptionalLocation(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalLocation(), startOffset, length);
            }
        }
        throw new Error("Unknown node type: " + type);
    }

    private void expect(byte value) {
        byte b = this.buffer.get();
        if (b != value) {
            throw new Error("Expected " + value + " but was " + b + " at position " + this.buffer.position());
        }
    }

    private static final class ConstantPool {
        private final byte[] source;
        private final int bufferOffset;
        private final byte[][] cache;

        ConstantPool(byte[] source, int bufferOffset, int length) {
            this.source = source;
            this.bufferOffset = bufferOffset;
            this.cache = new byte[length][];
        }

        byte[] get(ByteBuffer buffer, int oneBasedIndex) {
            int index = oneBasedIndex - 1;
            byte[] constant = this.cache[index];
            if (constant == null) {
                int offset = this.bufferOffset + index * 8;
                int start = buffer.getInt(offset);
                int length = buffer.getInt(offset + 4);
                constant = new byte[length];
                System.arraycopy(this.source, start, constant, 0, length);
                this.cache[index] = constant;
            }
            return constant;
        }
    }
}

