/*
 * Decompiled with CFR 0.152.
 */
package org.yarp;

import java.util.ArrayList;
import java.util.Arrays;
import org.yarp.AbstractNodeVisitor;

public abstract class Nodes {
    public static final byte[][] EMPTY_BYTE_ARRAY_ARRAY = new byte[0][];

    public static final class YieldNode
    extends Node {
        public final Location keyword_loc;
        public final Location lparen_loc;
        public final ArgumentsNode arguments;
        public final Location rparen_loc;

        public YieldNode(Location keyword_loc, Location lparen_loc, ArgumentsNode arguments, Location rparen_loc, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.lparen_loc = lparen_loc;
            this.arguments = arguments;
            this.rparen_loc = rparen_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitYieldNode(this);
        }
    }

    public static final class XStringNode
    extends Node {
        public final Location opening_loc;
        public final Location content_loc;
        public final Location closing_loc;
        public final byte[] unescaped;

        public XStringNode(Location opening_loc, Location content_loc, Location closing_loc, byte[] unescaped, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.content_loc = content_loc;
            this.closing_loc = closing_loc;
            this.unescaped = unescaped;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitXStringNode(this);
        }
    }

    public static final class WhileNode
    extends Node {
        public final Location keyword_loc;
        public final Node predicate;
        public final StatementsNode statements;
        public final short flags;

        public WhileNode(Location keyword_loc, Node predicate, StatementsNode statements, short flags, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.predicate = predicate;
            this.statements = statements;
            this.flags = flags;
        }

        public boolean isBeginModifier() {
            return LoopFlags.isBeginModifier(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitWhileNode(this);
        }
    }

    public static final class WhenNode
    extends Node {
        public final Location keyword_loc;
        public final Node[] conditions;
        public final StatementsNode statements;

        public WhenNode(Location keyword_loc, Node[] conditions, StatementsNode statements, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.conditions = conditions;
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.conditions) {
                child.accept(visitor);
            }
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.conditions));
            childNodes.add(this.statements);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitWhenNode(this);
        }
    }

    public static final class UntilNode
    extends Node {
        public final Location keyword_loc;
        public final Node predicate;
        public final StatementsNode statements;
        public final short flags;

        public UntilNode(Location keyword_loc, Node predicate, StatementsNode statements, short flags, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.predicate = predicate;
            this.statements = statements;
            this.flags = flags;
        }

        public boolean isBeginModifier() {
            return LoopFlags.isBeginModifier(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitUntilNode(this);
        }
    }

    public static final class UnlessNode
    extends Node {
        public final Location keyword_loc;
        public final Node predicate;
        public final StatementsNode statements;
        public final ElseNode consequent;
        public final Location end_keyword_loc;

        public UnlessNode(Location keyword_loc, Node predicate, StatementsNode statements, ElseNode consequent, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.predicate = predicate;
            this.statements = statements;
            this.consequent = consequent;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.consequent != null) {
                this.consequent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements, this.consequent};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitUnlessNode(this);
        }
    }

    public static final class UndefNode
    extends Node {
        public final Node[] names;
        public final Location keyword_loc;

        public UndefNode(Node[] names, Location keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.names = names;
            this.keyword_loc = keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.names) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.names;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitUndefNode(this);
        }
    }

    public static final class TrueNode
    extends Node {
        public TrueNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitTrueNode(this);
        }
    }

    public static final class SymbolNode
    extends Node {
        public final Location opening_loc;
        public final Location value_loc;
        public final Location closing_loc;
        public final byte[] unescaped;

        public SymbolNode(Location opening_loc, Location value_loc, Location closing_loc, byte[] unescaped, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.value_loc = value_loc;
            this.closing_loc = closing_loc;
            this.unescaped = unescaped;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSymbolNode(this);
        }
    }

    public static final class SuperNode
    extends Node {
        public final Location keyword_loc;
        public final Location lparen_loc;
        public final ArgumentsNode arguments;
        public final Location rparen_loc;
        public final BlockNode block;

        public SuperNode(Location keyword_loc, Location lparen_loc, ArgumentsNode arguments, Location rparen_loc, BlockNode block, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.lparen_loc = lparen_loc;
            this.arguments = arguments;
            this.rparen_loc = rparen_loc;
            this.block = block;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments, this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSuperNode(this);
        }
    }

    public static final class StringNode
    extends Node {
        public final Location opening_loc;
        public final Location content_loc;
        public final Location closing_loc;
        public final byte[] unescaped;

        public StringNode(Location opening_loc, Location content_loc, Location closing_loc, byte[] unescaped, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.content_loc = content_loc;
            this.closing_loc = closing_loc;
            this.unescaped = unescaped;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitStringNode(this);
        }
    }

    public static final class StringConcatNode
    extends Node {
        public final Node left;
        public final Node right;

        public StringConcatNode(Node left, Node right, int startOffset, int length) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitStringConcatNode(this);
        }
    }

    public static final class StatementsNode
    extends Node {
        public final Node[] body;

        public StatementsNode(Node[] body, int startOffset, int length) {
            super(startOffset, length);
            this.body = body;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.body) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.body;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitStatementsNode(this);
        }
    }

    public static final class SplatNode
    extends Node {
        public final Location operator_loc;
        public final Node expression;

        public SplatNode(Location operator_loc, Node expression, int startOffset, int length) {
            super(startOffset, length);
            this.operator_loc = operator_loc;
            this.expression = expression;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.expression != null) {
                this.expression.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSplatNode(this);
        }
    }

    public static final class SourceLineNode
    extends Node {
        public SourceLineNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSourceLineNode(this);
        }
    }

    public static final class SourceFileNode
    extends Node {
        public final byte[] filepath;

        public SourceFileNode(byte[] filepath, int startOffset, int length) {
            super(startOffset, length);
            this.filepath = filepath;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSourceFileNode(this);
        }
    }

    public static final class SourceEncodingNode
    extends Node {
        public SourceEncodingNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSourceEncodingNode(this);
        }
    }

    public static final class SingletonClassNode
    extends Node {
        public final byte[][] locals;
        public final Location class_keyword_loc;
        public final Location operator_loc;
        public final Node expression;
        public final Node body;
        public final Location end_keyword_loc;

        public SingletonClassNode(byte[][] locals, Location class_keyword_loc, Location operator_loc, Node expression, Node body, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.locals = locals;
            this.class_keyword_loc = class_keyword_loc;
            this.operator_loc = operator_loc;
            this.expression = expression;
            this.body = body;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.expression.accept(visitor);
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSingletonClassNode(this);
        }
    }

    public static final class SelfNode
    extends Node {
        public SelfNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitSelfNode(this);
        }
    }

    public static final class ReturnNode
    extends Node {
        public final Location keyword_loc;
        public final ArgumentsNode arguments;

        public ReturnNode(Location keyword_loc, ArgumentsNode arguments, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.arguments = arguments;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitReturnNode(this);
        }
    }

    public static final class RetryNode
    extends Node {
        public RetryNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRetryNode(this);
        }
    }

    public static final class RestParameterNode
    extends Node {
        public final Location operator_loc;
        public final Location name_loc;

        public RestParameterNode(Location operator_loc, Location name_loc, int startOffset, int length) {
            super(startOffset, length);
            this.operator_loc = operator_loc;
            this.name_loc = name_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRestParameterNode(this);
        }
    }

    public static final class RescueNode
    extends Node {
        public final Location keyword_loc;
        public final Node[] exceptions;
        public final Location operator_loc;
        public final Node reference;
        public final StatementsNode statements;
        public final RescueNode consequent;

        public RescueNode(Location keyword_loc, Node[] exceptions, Location operator_loc, Node reference, StatementsNode statements, RescueNode consequent, int startOffset, int length) {
            super(startOffset, length);
            this.keyword_loc = keyword_loc;
            this.exceptions = exceptions;
            this.operator_loc = operator_loc;
            this.reference = reference;
            this.statements = statements;
            this.consequent = consequent;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.exceptions) {
                child.accept(visitor);
            }
            if (this.reference != null) {
                this.reference.accept(visitor);
            }
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.consequent != null) {
                this.consequent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.exceptions));
            childNodes.add(this.reference);
            childNodes.add(this.statements);
            childNodes.add(this.consequent);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRescueNode(this);
        }
    }

    public static final class RescueModifierNode
    extends Node {
        public final Node expression;
        public final Location keyword_loc;
        public final Node rescue_expression;

        public RescueModifierNode(Node expression, Location keyword_loc, Node rescue_expression, int startOffset, int length) {
            super(startOffset, length);
            this.expression = expression;
            this.keyword_loc = keyword_loc;
            this.rescue_expression = rescue_expression;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.expression.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.expression.accept(visitor);
            this.rescue_expression.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression, this.rescue_expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRescueModifierNode(this);
        }
    }

    public static final class RequiredParameterNode
    extends Node {
        public final byte[] constant_id;

        public RequiredParameterNode(byte[] constant_id, int startOffset, int length) {
            super(startOffset, length);
            this.constant_id = constant_id;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRequiredParameterNode(this);
        }
    }

    public static final class RequiredDestructuredParameterNode
    extends Node {
        public final Node[] parameters;
        public final Location opening_loc;
        public final Location closing_loc;

        public RequiredDestructuredParameterNode(Node[] parameters, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.parameters = parameters;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parameters) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.parameters;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRequiredDestructuredParameterNode(this);
        }
    }

    public static final class RegularExpressionNode
    extends Node {
        public final Location opening_loc;
        public final Location content_loc;
        public final Location closing_loc;
        public final byte[] unescaped;
        public final short flags;

        public RegularExpressionNode(Location opening_loc, Location content_loc, Location closing_loc, byte[] unescaped, short flags, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.content_loc = content_loc;
            this.closing_loc = closing_loc;
            this.unescaped = unescaped;
            this.flags = flags;
        }

        public boolean isIgnoreCase() {
            return RegularExpressionFlags.isIgnoreCase(this.flags);
        }

        public boolean isMultiLine() {
            return RegularExpressionFlags.isMultiLine(this.flags);
        }

        public boolean isExtended() {
            return RegularExpressionFlags.isExtended(this.flags);
        }

        public boolean isEucJp() {
            return RegularExpressionFlags.isEucJp(this.flags);
        }

        public boolean isAscii8bit() {
            return RegularExpressionFlags.isAscii8bit(this.flags);
        }

        public boolean isWindows31j() {
            return RegularExpressionFlags.isWindows31j(this.flags);
        }

        public boolean isUtf8() {
            return RegularExpressionFlags.isUtf8(this.flags);
        }

        public boolean isOnce() {
            return RegularExpressionFlags.isOnce(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRegularExpressionNode(this);
        }
    }

    public static final class RedoNode
    extends Node {
        public RedoNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRedoNode(this);
        }
    }

    public static final class RationalNode
    extends Node {
        public final Node numeric;

        public RationalNode(Node numeric, int startOffset, int length) {
            super(startOffset, length);
            this.numeric = numeric;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.numeric.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.numeric};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRationalNode(this);
        }
    }

    public static final class RangeNode
    extends Node {
        public final Node left;
        public final Node right;
        public final Location operator_loc;
        public final short flags;

        public RangeNode(Node left, Node right, Location operator_loc, short flags, int startOffset, int length) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
            this.operator_loc = operator_loc;
            this.flags = flags;
        }

        public boolean isExcludeEnd() {
            return RangeFlags.isExcludeEnd(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.left != null) {
                this.left.accept(visitor);
            }
            if (this.right != null) {
                this.right.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitRangeNode(this);
        }
    }

    public static final class ProgramNode
    extends Node {
        public final byte[][] locals;
        public final StatementsNode statements;

        public ProgramNode(byte[][] locals, StatementsNode statements, int startOffset, int length) {
            super(startOffset, length);
            this.locals = locals;
            this.statements = statements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.statements.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitProgramNode(this);
        }
    }

    public static final class PreExecutionNode
    extends Node {
        public final StatementsNode statements;
        public final Location keyword_loc;
        public final Location opening_loc;
        public final Location closing_loc;

        public PreExecutionNode(StatementsNode statements, Location keyword_loc, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.statements = statements;
            this.keyword_loc = keyword_loc;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPreExecutionNode(this);
        }
    }

    public static final class PostExecutionNode
    extends Node {
        public final StatementsNode statements;
        public final Location keyword_loc;
        public final Location opening_loc;
        public final Location closing_loc;

        public PostExecutionNode(StatementsNode statements, Location keyword_loc, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.statements = statements;
            this.keyword_loc = keyword_loc;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPostExecutionNode(this);
        }
    }

    public static final class PinnedVariableNode
    extends Node {
        public final Node variable;
        public final Location operator_loc;

        public PinnedVariableNode(Node variable, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.variable = variable;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.variable.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.variable};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPinnedVariableNode(this);
        }
    }

    public static final class PinnedExpressionNode
    extends Node {
        public final Node expression;
        public final Location operator_loc;
        public final Location lparen_loc;
        public final Location rparen_loc;

        public PinnedExpressionNode(Node expression, Location operator_loc, Location lparen_loc, Location rparen_loc, int startOffset, int length) {
            super(startOffset, length);
            this.expression = expression;
            this.operator_loc = operator_loc;
            this.lparen_loc = lparen_loc;
            this.rparen_loc = rparen_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.expression.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitPinnedExpressionNode(this);
        }
    }

    public static final class ParenthesesNode
    extends Node {
        public final Node body;
        public final Location opening_loc;
        public final Location closing_loc;

        public ParenthesesNode(Node body, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.body = body;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitParenthesesNode(this);
        }
    }

    public static final class ParametersNode
    extends Node {
        public final Node[] requireds;
        public final Node[] optionals;
        public final Node[] posts;
        public final RestParameterNode rest;
        public final Node[] keywords;
        public final Node keyword_rest;
        public final BlockParameterNode block;

        public ParametersNode(Node[] requireds, Node[] optionals, Node[] posts, RestParameterNode rest, Node[] keywords, Node keyword_rest, BlockParameterNode block, int startOffset, int length) {
            super(startOffset, length);
            this.requireds = requireds;
            this.optionals = optionals;
            this.posts = posts;
            this.rest = rest;
            this.keywords = keywords;
            this.keyword_rest = keyword_rest;
            this.block = block;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.requireds) {
                child.accept(visitor);
            }
            for (Node child : this.optionals) {
                child.accept(visitor);
            }
            for (Node child : this.posts) {
                child.accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
            for (Node child : this.keywords) {
                child.accept(visitor);
            }
            if (this.keyword_rest != null) {
                this.keyword_rest.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.requireds));
            childNodes.addAll(Arrays.asList(this.optionals));
            childNodes.addAll(Arrays.asList(this.posts));
            childNodes.add(this.rest);
            childNodes.addAll(Arrays.asList(this.keywords));
            childNodes.add(this.keyword_rest);
            childNodes.add(this.block);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitParametersNode(this);
        }
    }

    public static final class OrWriteNode
    extends Node {
        public final Node target;
        public final Node value;
        public final Location operator_loc;

        public OrWriteNode(Node target, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOrWriteNode(this);
        }
    }

    public static final class OrNode
    extends Node {
        public final Node left;
        public final Node right;
        public final Location operator_loc;

        public OrNode(Node left, Node right, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOrNode(this);
        }
    }

    public static final class OptionalParameterNode
    extends Node {
        public final byte[] constant_id;
        public final Location name_loc;
        public final Location operator_loc;
        public final Node value;

        public OptionalParameterNode(byte[] constant_id, Location name_loc, Location operator_loc, Node value, int startOffset, int length) {
            super(startOffset, length);
            this.constant_id = constant_id;
            this.name_loc = name_loc;
            this.operator_loc = operator_loc;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOptionalParameterNode(this);
        }
    }

    public static final class OperatorWriteNode
    extends Node {
        public final Node target;
        public final Location operator_loc;
        public final byte[] operator;
        public final Node value;

        public OperatorWriteNode(Node target, Location operator_loc, byte[] operator, Node value, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.operator_loc = operator_loc;
            this.operator = operator;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitOperatorWriteNode(this);
        }
    }

    public static final class NumberedReferenceReadNode
    extends Node {
        public NumberedReferenceReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNumberedReferenceReadNode(this);
        }
    }

    public static final class NoKeywordsParameterNode
    extends Node {
        public final Location operator_loc;
        public final Location keyword_loc;

        public NoKeywordsParameterNode(Location operator_loc, Location keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.operator_loc = operator_loc;
            this.keyword_loc = keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNoKeywordsParameterNode(this);
        }
    }

    public static final class NilNode
    extends Node {
        public NilNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNilNode(this);
        }
    }

    public static final class NextNode
    extends Node {
        public final ArgumentsNode arguments;
        public final Location keyword_loc;

        public NextNode(ArgumentsNode arguments, Location keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.arguments = arguments;
            this.keyword_loc = keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitNextNode(this);
        }
    }

    public static final class MultiWriteNode
    extends Node {
        public final Node[] targets;
        public final Location operator_loc;
        public final Node value;
        public final Location lparen_loc;
        public final Location rparen_loc;

        public MultiWriteNode(Node[] targets, Location operator_loc, Node value, Location lparen_loc, Location rparen_loc, int startOffset, int length) {
            super(startOffset, length);
            this.targets = targets;
            this.operator_loc = operator_loc;
            this.value = value;
            this.lparen_loc = lparen_loc;
            this.rparen_loc = rparen_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.targets) {
                child.accept(visitor);
            }
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.addAll(Arrays.asList(this.targets));
            childNodes.add(this.value);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMultiWriteNode(this);
        }
    }

    public static final class ModuleNode
    extends Node {
        public final byte[][] locals;
        public final Location module_keyword_loc;
        public final Node constant_path;
        public final Node body;
        public final Location end_keyword_loc;

        public ModuleNode(byte[][] locals, Location module_keyword_loc, Node constant_path, Node body, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.locals = locals;
            this.module_keyword_loc = module_keyword_loc;
            this.constant_path = constant_path;
            this.body = body;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.constant_path.accept(visitor);
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.constant_path, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitModuleNode(this);
        }
    }

    public static final class MissingNode
    extends Node {
        public MissingNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMissingNode(this);
        }
    }

    public static final class MatchRequiredNode
    extends Node {
        public final Node value;
        public final Node pattern;
        public final Location operator_loc;

        public MatchRequiredNode(Node value, Node pattern, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.value = value;
            this.pattern = pattern;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
            this.pattern.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value, this.pattern};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMatchRequiredNode(this);
        }
    }

    public static final class MatchPredicateNode
    extends Node {
        public final Node value;
        public final Node pattern;
        public final Location operator_loc;

        public MatchPredicateNode(Node value, Node pattern, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.value = value;
            this.pattern = pattern;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
            this.pattern.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value, this.pattern};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitMatchPredicateNode(this);
        }
    }

    public static final class LocalVariableWriteNode
    extends Node {
        public final byte[] constant_id;
        public final int depth;
        public final Node value;
        public final Location name_loc;
        public final Location operator_loc;

        public LocalVariableWriteNode(byte[] constant_id, int depth, Node value, Location name_loc, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.constant_id = constant_id;
            this.depth = depth;
            this.value = value;
            this.name_loc = name_loc;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableWriteNode(this);
        }
    }

    public static final class LocalVariableReadNode
    extends Node {
        public final byte[] constant_id;
        public final int depth;

        public LocalVariableReadNode(byte[] constant_id, int depth, int startOffset, int length) {
            super(startOffset, length);
            this.constant_id = constant_id;
            this.depth = depth;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLocalVariableReadNode(this);
        }
    }

    public static final class LambdaNode
    extends Node {
        public final byte[][] locals;
        public final Location opening_loc;
        public final BlockParametersNode parameters;
        public final Node body;

        public LambdaNode(byte[][] locals, Location opening_loc, BlockParametersNode parameters, Node body, int startOffset, int length) {
            super(startOffset, length);
            this.locals = locals;
            this.opening_loc = opening_loc;
            this.parameters = parameters;
            this.body = body;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parameters, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitLambdaNode(this);
        }
    }

    public static final class KeywordRestParameterNode
    extends Node {
        public final Location operator_loc;
        public final Location name_loc;

        public KeywordRestParameterNode(Location operator_loc, Location name_loc, int startOffset, int length) {
            super(startOffset, length);
            this.operator_loc = operator_loc;
            this.name_loc = name_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitKeywordRestParameterNode(this);
        }
    }

    public static final class KeywordParameterNode
    extends Node {
        public final Location name_loc;
        public final Node value;

        public KeywordParameterNode(Location name_loc, Node value, int startOffset, int length) {
            super(startOffset, length);
            this.name_loc = name_loc;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitKeywordParameterNode(this);
        }
    }

    public static final class KeywordHashNode
    extends Node {
        public final Node[] elements;

        public KeywordHashNode(Node[] elements, int startOffset, int length) {
            super(startOffset, length);
            this.elements = elements;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.elements) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.elements;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitKeywordHashNode(this);
        }
    }

    public static final class InterpolatedXStringNode
    extends Node {
        public final Location opening_loc;
        public final Node[] parts;
        public final Location closing_loc;

        public InterpolatedXStringNode(Location opening_loc, Node[] parts, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.parts = parts;
            this.closing_loc = closing_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.parts;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedXStringNode(this);
        }
    }

    public static final class InterpolatedSymbolNode
    extends Node {
        public final Location opening_loc;
        public final Node[] parts;
        public final Location closing_loc;

        public InterpolatedSymbolNode(Location opening_loc, Node[] parts, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.parts = parts;
            this.closing_loc = closing_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.parts;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedSymbolNode(this);
        }
    }

    public static final class InterpolatedStringNode
    extends Node {
        public final Location opening_loc;
        public final Node[] parts;
        public final Location closing_loc;

        public InterpolatedStringNode(Location opening_loc, Node[] parts, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.parts = parts;
            this.closing_loc = closing_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.parts;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedStringNode(this);
        }
    }

    public static final class InterpolatedRegularExpressionNode
    extends Node {
        public final Location opening_loc;
        public final Node[] parts;
        public final Location closing_loc;
        public final short flags;

        public InterpolatedRegularExpressionNode(Location opening_loc, Node[] parts, Location closing_loc, short flags, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.parts = parts;
            this.closing_loc = closing_loc;
            this.flags = flags;
        }

        public boolean isIgnoreCase() {
            return RegularExpressionFlags.isIgnoreCase(this.flags);
        }

        public boolean isMultiLine() {
            return RegularExpressionFlags.isMultiLine(this.flags);
        }

        public boolean isExtended() {
            return RegularExpressionFlags.isExtended(this.flags);
        }

        public boolean isEucJp() {
            return RegularExpressionFlags.isEucJp(this.flags);
        }

        public boolean isAscii8bit() {
            return RegularExpressionFlags.isAscii8bit(this.flags);
        }

        public boolean isWindows31j() {
            return RegularExpressionFlags.isWindows31j(this.flags);
        }

        public boolean isUtf8() {
            return RegularExpressionFlags.isUtf8(this.flags);
        }

        public boolean isOnce() {
            return RegularExpressionFlags.isOnce(this.flags);
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            Node first;
            Node node = first = this.parts.length > 0 ? this.parts[0] : null;
            if (first != null) {
                first.setNewLineFlag(source, newlineMarked);
            }
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.parts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.parts;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInterpolatedRegularExpressionNode(this);
        }
    }

    public static final class IntegerNode
    extends Node {
        public IntegerNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIntegerNode(this);
        }
    }

    public static final class InstanceVariableWriteNode
    extends Node {
        public final Location name_loc;
        public final Node value;
        public final Location operator_loc;

        public InstanceVariableWriteNode(Location name_loc, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.name_loc = name_loc;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableWriteNode(this);
        }
    }

    public static final class InstanceVariableReadNode
    extends Node {
        public InstanceVariableReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInstanceVariableReadNode(this);
        }
    }

    public static final class InNode
    extends Node {
        public final Node pattern;
        public final StatementsNode statements;
        public final Location in_loc;
        public final Location then_loc;

        public InNode(Node pattern, StatementsNode statements, Location in_loc, Location then_loc, int startOffset, int length) {
            super(startOffset, length);
            this.pattern = pattern;
            this.statements = statements;
            this.in_loc = in_loc;
            this.then_loc = then_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.pattern.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.pattern, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitInNode(this);
        }
    }

    public static final class ImaginaryNode
    extends Node {
        public final Node numeric;

        public ImaginaryNode(Node numeric, int startOffset, int length) {
            super(startOffset, length);
            this.numeric = numeric;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.numeric.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.numeric};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitImaginaryNode(this);
        }
    }

    public static final class IfNode
    extends Node {
        public final Location if_keyword_loc;
        public final Node predicate;
        public final StatementsNode statements;
        public final Node consequent;
        public final Location end_keyword_loc;

        public IfNode(Location if_keyword_loc, Node predicate, StatementsNode statements, Node consequent, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.if_keyword_loc = if_keyword_loc;
            this.predicate = predicate;
            this.statements = statements;
            this.consequent = consequent;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            this.predicate.setNewLineFlag(source, newlineMarked);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.predicate.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.consequent != null) {
                this.consequent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.predicate, this.statements, this.consequent};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitIfNode(this);
        }
    }

    public static final class HashPatternNode
    extends Node {
        public final Node constant;
        public final Node[] assocs;
        public final Node kwrest;
        public final Location opening_loc;
        public final Location closing_loc;

        public HashPatternNode(Node constant, Node[] assocs, Node kwrest, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.constant = constant;
            this.assocs = assocs;
            this.kwrest = kwrest;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.constant != null) {
                this.constant.accept(visitor);
            }
            for (Node child : this.assocs) {
                child.accept(visitor);
            }
            if (this.kwrest != null) {
                this.kwrest.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.constant);
            childNodes.addAll(Arrays.asList(this.assocs));
            childNodes.add(this.kwrest);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitHashPatternNode(this);
        }
    }

    public static final class HashNode
    extends Node {
        public final Location opening_loc;
        public final Node[] elements;
        public final Location closing_loc;

        public HashNode(Location opening_loc, Node[] elements, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.elements = elements;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.elements) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.elements;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitHashNode(this);
        }
    }

    public static final class GlobalVariableWriteNode
    extends Node {
        public final Location name_loc;
        public final Location operator_loc;
        public final Node value;

        public GlobalVariableWriteNode(Location name_loc, Location operator_loc, Node value, int startOffset, int length) {
            super(startOffset, length);
            this.name_loc = name_loc;
            this.operator_loc = operator_loc;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableWriteNode(this);
        }
    }

    public static final class GlobalVariableReadNode
    extends Node {
        public GlobalVariableReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitGlobalVariableReadNode(this);
        }
    }

    public static final class ForwardingSuperNode
    extends Node {
        public final BlockNode block;

        public ForwardingSuperNode(BlockNode block, int startOffset, int length) {
            super(startOffset, length);
            this.block = block;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForwardingSuperNode(this);
        }
    }

    public static final class ForwardingParameterNode
    extends Node {
        public ForwardingParameterNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForwardingParameterNode(this);
        }
    }

    public static final class ForwardingArgumentsNode
    extends Node {
        public ForwardingArgumentsNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForwardingArgumentsNode(this);
        }
    }

    public static final class ForNode
    extends Node {
        public final Node index;
        public final Node collection;
        public final StatementsNode statements;
        public final Location for_keyword_loc;
        public final Location in_keyword_loc;
        public final Location do_keyword_loc;
        public final Location end_keyword_loc;

        public ForNode(Node index, Node collection, StatementsNode statements, Location for_keyword_loc, Location in_keyword_loc, Location do_keyword_loc, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.index = index;
            this.collection = collection;
            this.statements = statements;
            this.for_keyword_loc = for_keyword_loc;
            this.in_keyword_loc = in_keyword_loc;
            this.do_keyword_loc = do_keyword_loc;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.index.accept(visitor);
            this.collection.accept(visitor);
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.index, this.collection, this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitForNode(this);
        }
    }

    public static final class FloatNode
    extends Node {
        public FloatNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFloatNode(this);
        }
    }

    public static final class FlipFlopNode
    extends Node {
        public final Node left;
        public final Node right;
        public final Location operator_loc;
        public final short flags;

        public FlipFlopNode(Node left, Node right, Location operator_loc, short flags, int startOffset, int length) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
            this.operator_loc = operator_loc;
            this.flags = flags;
        }

        public boolean isExcludeEnd() {
            return RangeFlags.isExcludeEnd(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.left != null) {
                this.left.accept(visitor);
            }
            if (this.right != null) {
                this.right.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFlipFlopNode(this);
        }
    }

    public static final class FindPatternNode
    extends Node {
        public final Node constant;
        public final Node left;
        public final Node[] requireds;
        public final Node right;
        public final Location opening_loc;
        public final Location closing_loc;

        public FindPatternNode(Node constant, Node left, Node[] requireds, Node right, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.constant = constant;
            this.left = left;
            this.requireds = requireds;
            this.right = right;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.constant != null) {
                this.constant.accept(visitor);
            }
            this.left.accept(visitor);
            for (Node child : this.requireds) {
                child.accept(visitor);
            }
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.constant);
            childNodes.add(this.left);
            childNodes.addAll(Arrays.asList(this.requireds));
            childNodes.add(this.right);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFindPatternNode(this);
        }
    }

    public static final class FalseNode
    extends Node {
        public FalseNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitFalseNode(this);
        }
    }

    public static final class EnsureNode
    extends Node {
        public final Location ensure_keyword_loc;
        public final StatementsNode statements;
        public final Location end_keyword_loc;

        public EnsureNode(Location ensure_keyword_loc, StatementsNode statements, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.ensure_keyword_loc = ensure_keyword_loc;
            this.statements = statements;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitEnsureNode(this);
        }
    }

    public static final class EmbeddedVariableNode
    extends Node {
        public final Location operator_loc;
        public final Node variable;

        public EmbeddedVariableNode(Location operator_loc, Node variable, int startOffset, int length) {
            super(startOffset, length);
            this.operator_loc = operator_loc;
            this.variable = variable;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.variable.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.variable};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitEmbeddedVariableNode(this);
        }
    }

    public static final class EmbeddedStatementsNode
    extends Node {
        public final Location opening_loc;
        public final StatementsNode statements;
        public final Location closing_loc;

        public EmbeddedStatementsNode(Location opening_loc, StatementsNode statements, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.opening_loc = opening_loc;
            this.statements = statements;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitEmbeddedStatementsNode(this);
        }
    }

    public static final class ElseNode
    extends Node {
        public final Location else_keyword_loc;
        public final StatementsNode statements;
        public final Location end_keyword_loc;

        public ElseNode(Location else_keyword_loc, StatementsNode statements, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.else_keyword_loc = else_keyword_loc;
            this.statements = statements;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitElseNode(this);
        }
    }

    public static final class DefinedNode
    extends Node {
        public final Location lparen_loc;
        public final Node value;
        public final Location rparen_loc;
        public final Location keyword_loc;

        public DefinedNode(Location lparen_loc, Node value, Location rparen_loc, Location keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.lparen_loc = lparen_loc;
            this.value = value;
            this.rparen_loc = rparen_loc;
            this.keyword_loc = keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitDefinedNode(this);
        }
    }

    public static final class DefNode
    extends Node {
        public final int serializedLength;
        public final Location name_loc;
        public final Node receiver;
        public final ParametersNode parameters;
        public final Node body;
        public final byte[][] locals;
        public final Location def_keyword_loc;
        public final Location operator_loc;
        public final Location lparen_loc;
        public final Location rparen_loc;
        public final Location equal_loc;
        public final Location end_keyword_loc;

        public DefNode(int serializedLength, Location name_loc, Node receiver, ParametersNode parameters, Node body, byte[][] locals, Location def_keyword_loc, Location operator_loc, Location lparen_loc, Location rparen_loc, Location equal_loc, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.serializedLength = serializedLength;
            this.name_loc = name_loc;
            this.receiver = receiver;
            this.parameters = parameters;
            this.body = body;
            this.locals = locals;
            this.def_keyword_loc = def_keyword_loc;
            this.operator_loc = operator_loc;
            this.lparen_loc = lparen_loc;
            this.rparen_loc = rparen_loc;
            this.equal_loc = equal_loc;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.parameters, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitDefNode(this);
        }
    }

    public static final class ConstantWriteNode
    extends Node {
        public final Location name_loc;
        public final Node value;
        public final Location operator_loc;

        public ConstantWriteNode(Location name_loc, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.name_loc = name_loc;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantWriteNode(this);
        }
    }

    public static final class ConstantReadNode
    extends Node {
        public ConstantReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantReadNode(this);
        }
    }

    public static final class ConstantPathWriteNode
    extends Node {
        public final ConstantPathNode target;
        public final Location operator_loc;
        public final Node value;

        public ConstantPathWriteNode(ConstantPathNode target, Location operator_loc, Node value, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.operator_loc = operator_loc;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathWriteNode(this);
        }
    }

    public static final class ConstantPathNode
    extends Node {
        public final Node parent;
        public final Node child;
        public final Location delimiter_loc;

        public ConstantPathNode(Node parent, Node child, Location delimiter_loc, int startOffset, int length) {
            super(startOffset, length);
            this.parent = parent;
            this.child = child;
            this.delimiter_loc = delimiter_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parent != null) {
                this.parent.accept(visitor);
            }
            this.child.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parent, this.child};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitConstantPathNode(this);
        }
    }

    public static final class ClassVariableWriteNode
    extends Node {
        public final Location name_loc;
        public final Node value;
        public final Location operator_loc;

        public ClassVariableWriteNode(Location name_loc, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.name_loc = name_loc;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableWriteNode(this);
        }
    }

    public static final class ClassVariableReadNode
    extends Node {
        public ClassVariableReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassVariableReadNode(this);
        }
    }

    public static final class ClassNode
    extends Node {
        public final byte[][] locals;
        public final Location class_keyword_loc;
        public final Node constant_path;
        public final Location inheritance_operator_loc;
        public final Node superclass;
        public final Node body;
        public final Location end_keyword_loc;

        public ClassNode(byte[][] locals, Location class_keyword_loc, Node constant_path, Location inheritance_operator_loc, Node superclass, Node body, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.locals = locals;
            this.class_keyword_loc = class_keyword_loc;
            this.constant_path = constant_path;
            this.inheritance_operator_loc = inheritance_operator_loc;
            this.superclass = superclass;
            this.body = body;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.constant_path.accept(visitor);
            if (this.superclass != null) {
                this.superclass.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.constant_path, this.superclass, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitClassNode(this);
        }
    }

    public static final class CaseNode
    extends Node {
        public final Node predicate;
        public final Node[] conditions;
        public final ElseNode consequent;
        public final Location case_keyword_loc;
        public final Location end_keyword_loc;

        public CaseNode(Node predicate, Node[] conditions, ElseNode consequent, Location case_keyword_loc, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.predicate = predicate;
            this.conditions = conditions;
            this.consequent = consequent;
            this.case_keyword_loc = case_keyword_loc;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.predicate != null) {
                this.predicate.accept(visitor);
            }
            for (Node child : this.conditions) {
                child.accept(visitor);
            }
            if (this.consequent != null) {
                this.consequent.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.predicate);
            childNodes.addAll(Arrays.asList(this.conditions));
            childNodes.add(this.consequent);
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCaseNode(this);
        }
    }

    public static final class CapturePatternNode
    extends Node {
        public final Node value;
        public final Node target;
        public final Location operator_loc;

        public CapturePatternNode(Node value, Node target, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.value = value;
            this.target = target;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.value.accept(visitor);
            this.target.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value, this.target};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCapturePatternNode(this);
        }
    }

    public static final class CallOperatorWriteNode
    extends Node {
        public final CallNode target;
        public final Location operator_loc;
        public final Node value;
        public final byte[] operator_id;

        public CallOperatorWriteNode(CallNode target, Location operator_loc, Node value, byte[] operator_id, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.operator_loc = operator_loc;
            this.value = value;
            this.operator_id = operator_id;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallOperatorWriteNode(this);
        }
    }

    public static final class CallOperatorOrWriteNode
    extends Node {
        public final CallNode target;
        public final Node value;
        public final Location operator_loc;

        public CallOperatorOrWriteNode(CallNode target, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallOperatorOrWriteNode(this);
        }
    }

    public static final class CallOperatorAndWriteNode
    extends Node {
        public final CallNode target;
        public final Location operator_loc;
        public final Node value;

        public CallOperatorAndWriteNode(CallNode target, Location operator_loc, Node value, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.operator_loc = operator_loc;
            this.value = value;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallOperatorAndWriteNode(this);
        }
    }

    public static final class CallNode
    extends Node {
        public final Node receiver;
        public final Location operator_loc;
        public final Location message_loc;
        public final Location opening_loc;
        public final ArgumentsNode arguments;
        public final Location closing_loc;
        public final BlockNode block;
        public final short flags;
        public final byte[] name;

        public CallNode(Node receiver, Location operator_loc, Location message_loc, Location opening_loc, ArgumentsNode arguments, Location closing_loc, BlockNode block, short flags, byte[] name, int startOffset, int length) {
            super(startOffset, length);
            this.receiver = receiver;
            this.operator_loc = operator_loc;
            this.message_loc = message_loc;
            this.opening_loc = opening_loc;
            this.arguments = arguments;
            this.closing_loc = closing_loc;
            this.block = block;
            this.flags = flags;
            this.name = name;
        }

        public boolean isSafeNavigation() {
            return CallNodeFlags.isSafeNavigation(this.flags);
        }

        public boolean isVariableCall() {
            return CallNodeFlags.isVariableCall(this.flags);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.receiver != null) {
                this.receiver.accept(visitor);
            }
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
            if (this.block != null) {
                this.block.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.receiver, this.arguments, this.block};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitCallNode(this);
        }
    }

    public static final class BreakNode
    extends Node {
        public final ArgumentsNode arguments;
        public final Location keyword_loc;

        public BreakNode(ArgumentsNode arguments, Location keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.arguments = arguments;
            this.keyword_loc = keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.arguments != null) {
                this.arguments.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.arguments};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBreakNode(this);
        }
    }

    public static final class BlockParametersNode
    extends Node {
        public final ParametersNode parameters;
        public final Location[] locals;
        public final Location opening_loc;
        public final Location closing_loc;

        public BlockParametersNode(ParametersNode parameters, Location[] locals, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.parameters = parameters;
            this.locals = locals;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parameters};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockParametersNode(this);
        }
    }

    public static final class BlockParameterNode
    extends Node {
        public final Location name_loc;
        public final Location operator_loc;

        public BlockParameterNode(Location name_loc, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.name_loc = name_loc;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockParameterNode(this);
        }
    }

    public static final class BlockNode
    extends Node {
        public final byte[][] locals;
        public final BlockParametersNode parameters;
        public final Node body;
        public final Location opening_loc;
        public final Location closing_loc;

        public BlockNode(byte[][] locals, BlockParametersNode parameters, Node body, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.locals = locals;
            this.parameters = parameters;
            this.body = body;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.parameters != null) {
                this.parameters.accept(visitor);
            }
            if (this.body != null) {
                this.body.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.parameters, this.body};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockNode(this);
        }
    }

    public static final class BlockArgumentNode
    extends Node {
        public final Node expression;
        public final Location operator_loc;

        public BlockArgumentNode(Node expression, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.expression = expression;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.expression != null) {
                this.expression.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.expression};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBlockArgumentNode(this);
        }
    }

    public static final class BeginNode
    extends Node {
        public final Location begin_keyword_loc;
        public final StatementsNode statements;
        public final RescueNode rescue_clause;
        public final ElseNode else_clause;
        public final EnsureNode ensure_clause;
        public final Location end_keyword_loc;

        public BeginNode(Location begin_keyword_loc, StatementsNode statements, RescueNode rescue_clause, ElseNode else_clause, EnsureNode ensure_clause, Location end_keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.begin_keyword_loc = begin_keyword_loc;
            this.statements = statements;
            this.rescue_clause = rescue_clause;
            this.else_clause = else_clause;
            this.ensure_clause = ensure_clause;
            this.end_keyword_loc = end_keyword_loc;
        }

        @Override
        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.statements != null) {
                this.statements.accept(visitor);
            }
            if (this.rescue_clause != null) {
                this.rescue_clause.accept(visitor);
            }
            if (this.else_clause != null) {
                this.else_clause.accept(visitor);
            }
            if (this.ensure_clause != null) {
                this.ensure_clause.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.statements, this.rescue_clause, this.else_clause, this.ensure_clause};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBeginNode(this);
        }
    }

    public static final class BackReferenceReadNode
    extends Node {
        public BackReferenceReadNode(int startOffset, int length) {
            super(startOffset, length);
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
        }

        @Override
        public Node[] childNodes() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitBackReferenceReadNode(this);
        }
    }

    public static final class AssocSplatNode
    extends Node {
        public final Node value;
        public final Location operator_loc;

        public AssocSplatNode(Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAssocSplatNode(this);
        }
    }

    public static final class AssocNode
    extends Node {
        public final Node key;
        public final Node value;
        public final Location operator_loc;

        public AssocNode(Node key, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.key = key;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.key.accept(visitor);
            if (this.value != null) {
                this.value.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.key, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAssocNode(this);
        }
    }

    public static final class ArrayPatternNode
    extends Node {
        public final Node constant;
        public final Node[] requireds;
        public final Node rest;
        public final Node[] posts;
        public final Location opening_loc;
        public final Location closing_loc;

        public ArrayPatternNode(Node constant, Node[] requireds, Node rest, Node[] posts, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.constant = constant;
            this.requireds = requireds;
            this.rest = rest;
            this.posts = posts;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            if (this.constant != null) {
                this.constant.accept(visitor);
            }
            for (Node child : this.requireds) {
                child.accept(visitor);
            }
            if (this.rest != null) {
                this.rest.accept(visitor);
            }
            for (Node child : this.posts) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            childNodes.add(this.constant);
            childNodes.addAll(Arrays.asList(this.requireds));
            childNodes.add(this.rest);
            childNodes.addAll(Arrays.asList(this.posts));
            return childNodes.toArray(EMPTY_ARRAY);
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitArrayPatternNode(this);
        }
    }

    public static final class ArrayNode
    extends Node {
        public final Node[] elements;
        public final Location opening_loc;
        public final Location closing_loc;

        public ArrayNode(Node[] elements, Location opening_loc, Location closing_loc, int startOffset, int length) {
            super(startOffset, length);
            this.elements = elements;
            this.opening_loc = opening_loc;
            this.closing_loc = closing_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.elements) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.elements;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitArrayNode(this);
        }
    }

    public static final class ArgumentsNode
    extends Node {
        public final Node[] arguments;

        public ArgumentsNode(Node[] arguments, int startOffset, int length) {
            super(startOffset, length);
            this.arguments = arguments;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            for (Node child : this.arguments) {
                child.accept(visitor);
            }
        }

        @Override
        public Node[] childNodes() {
            return this.arguments;
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitArgumentsNode(this);
        }
    }

    public static final class AndWriteNode
    extends Node {
        public final Node target;
        public final Node value;
        public final Location operator_loc;

        public AndWriteNode(Node target, Node value, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.target = target;
            this.value = value;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.target.accept(visitor);
            this.value.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.target, this.value};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAndWriteNode(this);
        }
    }

    public static final class AndNode
    extends Node {
        public final Node left;
        public final Node right;
        public final Location operator_loc;

        public AndNode(Node left, Node right, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAndNode(this);
        }
    }

    public static final class AlternationPatternNode
    extends Node {
        public final Node left;
        public final Node right;
        public final Location operator_loc;

        public AlternationPatternNode(Node left, Node right, Location operator_loc, int startOffset, int length) {
            super(startOffset, length);
            this.left = left;
            this.right = right;
            this.operator_loc = operator_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.left.accept(visitor);
            this.right.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.left, this.right};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAlternationPatternNode(this);
        }
    }

    public static final class AliasNode
    extends Node {
        public final Node new_name;
        public final Node old_name;
        public final Location keyword_loc;

        public AliasNode(Node new_name, Node old_name, Location keyword_loc, int startOffset, int length) {
            super(startOffset, length);
            this.new_name = new_name;
            this.old_name = old_name;
            this.keyword_loc = keyword_loc;
        }

        @Override
        public <T> void visitChildNodes(AbstractNodeVisitor<T> visitor) {
            this.new_name.accept(visitor);
            this.old_name.accept(visitor);
        }

        @Override
        public Node[] childNodes() {
            return new Node[]{this.new_name, this.old_name};
        }

        @Override
        public <T> T accept(AbstractNodeVisitor<T> visitor) {
            return visitor.visitAliasNode(this);
        }
    }

    public static final class RegularExpressionFlags
    implements Comparable<RegularExpressionFlags> {
        public static final short IGNORE_CASE = 1;
        public static final short MULTI_LINE = 2;
        public static final short EXTENDED = 4;
        public static final short EUC_JP = 8;
        public static final short ASCII_8BIT = 16;
        public static final short WINDOWS_31J = 32;
        public static final short UTF_8 = 64;
        public static final short ONCE = 128;
        private final short flags;

        public static boolean isIgnoreCase(short flags) {
            return (flags & 1) != 0;
        }

        public static boolean isMultiLine(short flags) {
            return (flags & 2) != 0;
        }

        public static boolean isExtended(short flags) {
            return (flags & 4) != 0;
        }

        public static boolean isEucJp(short flags) {
            return (flags & 8) != 0;
        }

        public static boolean isAscii8bit(short flags) {
            return (flags & 0x10) != 0;
        }

        public static boolean isWindows31j(short flags) {
            return (flags & 0x20) != 0;
        }

        public static boolean isUtf8(short flags) {
            return (flags & 0x40) != 0;
        }

        public static boolean isOnce(short flags) {
            return (flags & 0x80) != 0;
        }

        public RegularExpressionFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RegularExpressionFlags)) {
                return false;
            }
            return this.flags == ((RegularExpressionFlags)other).flags;
        }

        @Override
        public int compareTo(RegularExpressionFlags other) {
            return this.flags - other.flags;
        }

        public boolean isIgnoreCase() {
            return (this.flags & 1) != 0;
        }

        public boolean isMultiLine() {
            return (this.flags & 2) != 0;
        }

        public boolean isExtended() {
            return (this.flags & 4) != 0;
        }

        public boolean isEucJp() {
            return (this.flags & 8) != 0;
        }

        public boolean isAscii8bit() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isWindows31j() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isUtf8() {
            return (this.flags & 0x40) != 0;
        }

        public boolean isOnce() {
            return (this.flags & 0x80) != 0;
        }
    }

    public static final class RangeFlags
    implements Comparable<RangeFlags> {
        public static final short EXCLUDE_END = 1;
        private final short flags;

        public static boolean isExcludeEnd(short flags) {
            return (flags & 1) != 0;
        }

        public RangeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RangeFlags)) {
                return false;
            }
            return this.flags == ((RangeFlags)other).flags;
        }

        @Override
        public int compareTo(RangeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isExcludeEnd() {
            return (this.flags & 1) != 0;
        }
    }

    public static final class LoopFlags
    implements Comparable<LoopFlags> {
        public static final short BEGIN_MODIFIER = 1;
        private final short flags;

        public static boolean isBeginModifier(short flags) {
            return (flags & 1) != 0;
        }

        public LoopFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof LoopFlags)) {
                return false;
            }
            return this.flags == ((LoopFlags)other).flags;
        }

        @Override
        public int compareTo(LoopFlags other) {
            return this.flags - other.flags;
        }

        public boolean isBeginModifier() {
            return (this.flags & 1) != 0;
        }
    }

    public static final class CallNodeFlags
    implements Comparable<CallNodeFlags> {
        public static final short SAFE_NAVIGATION = 1;
        public static final short VARIABLE_CALL = 2;
        private final short flags;

        public static boolean isSafeNavigation(short flags) {
            return (flags & 1) != 0;
        }

        public static boolean isVariableCall(short flags) {
            return (flags & 2) != 0;
        }

        public CallNodeFlags(short flags) {
            this.flags = flags;
        }

        public int hashCode() {
            return this.flags;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CallNodeFlags)) {
                return false;
            }
            return this.flags == ((CallNodeFlags)other).flags;
        }

        @Override
        public int compareTo(CallNodeFlags other) {
            return this.flags - other.flags;
        }

        public boolean isSafeNavigation() {
            return (this.flags & 1) != 0;
        }

        public boolean isVariableCall() {
            return (this.flags & 2) != 0;
        }
    }

    public static abstract class Node {
        public static final Node[] EMPTY_ARRAY = new Node[0];
        public final int startOffset;
        public final int length;
        private boolean newLineFlag = false;

        public Node(int startOffset, int length) {
            this.startOffset = startOffset;
            this.length = length;
        }

        public final int endOffset() {
            return this.startOffset + this.length;
        }

        public final boolean hasNewLineFlag() {
            return this.newLineFlag;
        }

        public void setNewLineFlag(Source source, boolean[] newlineMarked) {
            int line = source.line(this.startOffset);
            if (!newlineMarked[line]) {
                newlineMarked[line] = true;
                this.newLineFlag = true;
            }
        }

        public abstract <T> T accept(AbstractNodeVisitor<T> var1);

        public abstract <T> void visitChildNodes(AbstractNodeVisitor<T> var1);

        public abstract Node[] childNodes();

        public String toString() {
            return this.toString("");
        }

        private String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(indent).append(this.getClass().getSimpleName());
            if (this.hasNewLineFlag()) {
                builder.append("[Li]");
            }
            builder.append('\n');
            for (Node child : this.childNodes()) {
                if (child == null) continue;
                builder.append(child.toString(indent + "  "));
            }
            return builder.toString();
        }
    }

    public static final class Source {
        public final byte[] bytes;
        private final int[] lineOffsets;

        public Source(byte[] bytes) {
            this(bytes, Source.computeLineOffsets(bytes));
        }

        public Source(byte[] bytes, int[] lineOffsets) {
            assert (lineOffsets[0] == 0);
            this.bytes = bytes;
            this.lineOffsets = lineOffsets;
        }

        public static int[] computeLineOffsets(byte[] bytes) {
            int[] lineOffsets = new int[8];
            int lineOffsetsSize = 0;
            lineOffsets[lineOffsetsSize++] = 0;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 10) continue;
                if (lineOffsetsSize == lineOffsets.length) {
                    lineOffsets = Arrays.copyOf(lineOffsets, lineOffsets.length * 2);
                }
                lineOffsets[lineOffsetsSize++] = i + 1;
            }
            return Arrays.copyOf(lineOffsets, lineOffsetsSize);
        }

        public int line(int byteOffset) {
            assert (byteOffset >= 0 && byteOffset < this.bytes.length) : byteOffset;
            int index = Arrays.binarySearch(this.lineOffsets, byteOffset);
            int line = index < 0 ? -index - 1 : index + 1;
            assert (line >= 1 && line <= this.getLineCount()) : line;
            return line;
        }

        public int getLineCount() {
            return this.lineOffsets.length;
        }
    }

    public static final class Location {
        public static final Location[] EMPTY_ARRAY = new Location[0];
        public final int startOffset;
        public final int length;

        public Location(int startOffset, int length) {
            this.startOffset = startOffset;
            this.length = length;
        }

        public int endOffset() {
            return this.startOffset + this.length;
        }
    }
}

