/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import org.prism.AbstractNodeVisitor;
import org.prism.Nodes;

final class MarkNewlinesVisitor
extends AbstractNodeVisitor<Void> {
    private final Nodes.Source source;
    private boolean[] newlineMarked;

    MarkNewlinesVisitor(Nodes.Source source, boolean[] newlineMarked) {
        this.source = source;
        this.newlineMarked = newlineMarked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBlockNode(Nodes.BlockNode node) {
        boolean[] oldNewlineMarked = this.newlineMarked;
        this.newlineMarked = new boolean[oldNewlineMarked.length];
        try {
            Void void_ = (Void)super.visitBlockNode(node);
            return void_;
        }
        finally {
            this.newlineMarked = oldNewlineMarked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitLambdaNode(Nodes.LambdaNode node) {
        boolean[] oldNewlineMarked = this.newlineMarked;
        this.newlineMarked = new boolean[oldNewlineMarked.length];
        try {
            Void void_ = (Void)super.visitLambdaNode(node);
            return void_;
        }
        finally {
            this.newlineMarked = oldNewlineMarked;
        }
    }

    @Override
    public Void visitIfNode(Nodes.IfNode node) {
        node.setNewLineFlag(this.source, this.newlineMarked);
        return (Void)super.visitIfNode(node);
    }

    @Override
    public Void visitUnlessNode(Nodes.UnlessNode node) {
        node.setNewLineFlag(this.source, this.newlineMarked);
        return (Void)super.visitUnlessNode(node);
    }

    @Override
    public Void visitStatementsNode(Nodes.StatementsNode node) {
        for (Nodes.Node child : node.body) {
            child.setNewLineFlag(this.source, this.newlineMarked);
        }
        return (Void)super.visitStatementsNode(node);
    }

    @Override
    protected Void defaultVisit(Nodes.Node node) {
        node.visitChildNodes(this);
        return null;
    }
}

