/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.MutableTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.shadowed.org.jcodings.Encoding;
import org.graalvm.shadowed.org.jcodings.IntHolder;
import org.truffleruby.Layouts;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.cext.CapturedException;
import org.truffleruby.cext.SymbolToIDNode;
import org.truffleruby.cext.UnwrapNode;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.cext.WrapNode;
import org.truffleruby.cext.ZLibCRCTable;
import org.truffleruby.core.MarkingService;
import org.truffleruby.core.MarkingServiceNodes;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.cast.FloatToIntegerNode;
import org.truffleruby.core.cast.HashCastNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.ErrnoErrorNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.format.BytesResult;
import org.truffleruby.core.format.FormatExceptionTranslator;
import org.truffleruby.core.format.exceptions.FormatException;
import org.truffleruby.core.format.exceptions.InvalidFormatException;
import org.truffleruby.core.format.rbsprintf.RBSprintfCompiler;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.MethodLookupResult;
import org.truffleruby.core.module.ModuleNodes;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.BignumOperations;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringSupport;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.support.TypeNodes;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.thread.ThreadManager;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.extra.ffi.RubyPointer;
import org.truffleruby.interop.InteropNodes;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.LazyWarningNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.WarningNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.constants.LookupConstantNode;
import org.truffleruby.language.control.BreakException;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.DynamicReturnException;
import org.truffleruby.language.control.LocalReturnException;
import org.truffleruby.language.control.NextException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RedoException;
import org.truffleruby.language.control.RetryException;
import org.truffleruby.language.control.ThrowException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.globals.ReadGlobalVariableNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.supercall.CallSuperMethodNode;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.IdentifierType;
import org.truffleruby.parser.RubySource;

@CoreModule(value="Truffle::CExt")
public abstract class CExtNodes {
    public static final int RUBY_TAG_RETURN = 1;
    public static final int RUBY_TAG_BREAK = 2;
    public static final int RUBY_TAG_NEXT = 3;
    public static final int RUBY_TAG_RETRY = 4;
    public static final int RUBY_TAG_REDO = 5;
    public static final int RUBY_TAG_RAISE = 6;
    public static final int RUBY_TAG_THROW = 7;
    public static final int NATIVE_STRING_TERMINATOR_LENGTH = 4;

    public static Pointer newNativeStringPointer(RubyLanguage language, RubyContext context, int capacity) {
        Pointer pointer = Pointer.mallocAutoRelease(language, context, capacity + 4);
        pointer.writeInt(capacity, 0);
        return pointer;
    }

    public static Pointer newZeroedNativeStringPointer(RubyLanguage language, RubyContext context, int capacity) {
        return Pointer.callocAutoRelease(language, context, capacity + 4);
    }

    private static long getNativeStringCapacity(Pointer pointer) {
        long nativeBufferSize = pointer.getSize();
        assert (nativeBufferSize > 0L);
        return nativeBufferSize - 4L;
    }

    @CoreMethod(names={"zlib_get_crc_table"}, onSingleton=true)
    public static abstract class ZLibGetCRCTable
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray zlibGetCRCTable() {
            return this.createArray((long[])ZLibCRCTable.TABLE.clone());
        }
    }

    @CoreMethod(names={"ruby_native_thread_p"}, onSingleton=true)
    public static abstract class RubyThreadNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isRubyThread(VirtualFrame frame) {
            ThreadManager threadManager = this.getContext().getThreadManager();
            return Thread.currentThread() == threadManager.getRootJavaThread() || threadManager.isRubyManagedThread(Thread.currentThread());
        }
    }

    @CoreMethod(names={"rb_tr_sprintf"}, onSingleton=true, required=3, split=Split.ALWAYS)
    public static abstract class RBSprintfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        static RubyString format(Object format, Object stringReader, RubyArray argArray, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @Cached RubyStringLibrary libFormat, @Cached TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached InlinedBranchProfile exceptionProfile, @Cached InlinedConditionProfile resizeProfile, @Cached IndirectCallNode formatNode, @Bind(value="this") Node node) {
            RootCallTarget callTarget;
            AbstractTruffleString tstring = libFormat.getTString(node, format);
            RubyEncoding encoding = libFormat.getEncoding(node, format);
            Object[] arguments = arrayToObjectArrayNode.executeToObjectArray(argArray);
            try {
                callTarget = RBSprintfNode.compileFormat(tstring, encoding, stringReader, asTruffleStringNode, node);
            }
            catch (FormatException e) {
                exceptionProfile.enter(node);
                throw FormatExceptionTranslator.translate(RBSprintfNode.getContext(node), node, e);
            }
            BytesResult result = (BytesResult)formatNode.call((CallTarget)callTarget, new Object[]{arguments, arguments.length, null});
            int formatLength = tstring.byteLength(encoding.tencoding);
            byte[] bytes = result.getOutput();
            if (resizeProfile.profile(node, bytes.length != result.getOutputLength())) {
                bytes = Arrays.copyOf(bytes, result.getOutputLength());
            }
            return RBSprintfNode.createString(node, fromByteArrayNode, bytes, result.getEncoding().getEncodingForLength(formatLength));
        }

        @CompilerDirectives.TruffleBoundary
        protected static RootCallTarget compileFormat(AbstractTruffleString format, RubyEncoding encoding, Object stringReader, TruffleString.AsTruffleStringNode asTruffleStringNode, Node node) {
            RootCallTarget callTarget;
            TStringWithEncoding cacheKey = new TStringWithEncoding(asTruffleStringNode, format, encoding);
            RootCallTarget cachedCallTarget = RubyLanguage.sprintfCompilerCallTargets.get(cacheKey);
            if (cachedCallTarget != null) {
                return cachedCallTarget;
            }
            try {
                callTarget = new RBSprintfCompiler(RBSprintfNode.getLanguage(node), node).compile(format, encoding, stringReader);
            }
            catch (InvalidFormatException e) {
                throw new RaiseException(RBSprintfNode.getContext(node), RBSprintfNode.coreExceptions(node).argumentError(e.getMessage(), node));
            }
            RubyLanguage.sprintfCompilerCallTargets.putIfAbsent(cacheKey, callTarget);
            return callTarget;
        }
    }

    @CoreMethod(names={"rb_tr_sprintf_types"}, onSingleton=true, required=1)
    public static abstract class RBSprintfFormatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyArray types(Object format, @Cached RubyStringLibrary libFormat, @Cached TruffleString.AsTruffleStringNode asTruffleStringNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
            RubyEncoding encoding;
            AbstractTruffleString tstring = libFormat.getTString(this, format);
            TStringWithEncoding cacheKey = new TStringWithEncoding(asTruffleStringNode, tstring, encoding = libFormat.getEncoding(this, format));
            int[] cachedTypes = RubyLanguage.sprintfCompilerTypeLists.get(cacheKey);
            if (cachedTypes != null) {
                return this.createArray(cachedTypes);
            }
            RubyArray types = this.compileArgTypes(tstring, libFormat.getEncoding(this, format), byteArrayNode);
            int[] typesIntArray = (int[])ArrayStoreLibrary.getUncached().toJavaArrayCopy(types.getStore(), types.size);
            RubyLanguage.sprintfCompilerTypeLists.putIfAbsent(cacheKey, typesIntArray);
            return types;
        }

        @CompilerDirectives.TruffleBoundary
        protected RubyArray compileArgTypes(AbstractTruffleString format, RubyEncoding encoding, TruffleString.GetInternalByteArrayNode byteArrayNode) {
            try {
                return new RBSprintfCompiler(this.getLanguage(), this).typeList(format, encoding, byteArrayNode, this.getContext(), this.getLanguage());
            }
            catch (InvalidFormatException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }
    }

    @CoreMethod(names={"rb_ary_new_from_values"}, onSingleton=true, required=1)
    public static abstract class RbAryNewFromValues
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray rbAryNewFromValues(Object cArray, @Cached UnwrapNode.UnwrapCArrayNode unwrapCArrayNode) {
            Object[] values = unwrapCArrayNode.execute(cArray);
            return this.createArray(values);
        }
    }

    @CoreMethod(names={"rb_check_symbol_cstr"}, onSingleton=true, required=1)
    public static abstract class RbCheckSymbolCStrNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object checkSymbolCStr(Object string, @Cached RubyStringLibrary strings) {
            RubySymbol sym = this.getLanguage().symbolTable.getSymbolIfExists(strings.getTString(this, string), strings.getEncoding(this, string));
            return sym == null ? nil : sym;
        }
    }

    @CoreMethod(names={"rb_tr_force_native_function"}, onSingleton=true, required=0)
    public static abstract class ToNativeFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object wrapFunction() {
            return new ValueWrapperManager.ToNativeObjectFunction();
        }
    }

    @CoreMethod(names={"rb_tr_wrap_function"}, onSingleton=true, required=0)
    public static abstract class WrapperFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object wrapFunction() {
            return new ValueWrapperManager.WrapperFunction();
        }
    }

    @CoreMethod(names={"rb_tr_sym2id_function"}, onSingleton=true, required=0)
    public static abstract class Sym2IDFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object unwrapFunction() {
            return new ValueWrapperManager.Symbol2IDFunction();
        }
    }

    @CoreMethod(names={"rb_tr_id2sym_function"}, onSingleton=true, required=0)
    public static abstract class UnwrapperIDFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object unwrapFunction() {
            return new ValueWrapperManager.ID2SymbolFunction();
        }
    }

    @CoreMethod(names={"rb_tr_unwrap_function"}, onSingleton=true, required=0)
    public static abstract class UnwrapperFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object unwrapFunction() {
            return new ValueWrapperManager.UnwrapperFunction();
        }
    }

    @CoreMethod(names={"rb_tr_is_native_object_function"}, onSingleton=true, required=0)
    public static abstract class IsNativeObjectFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object isNativeObjectFunction() {
            return new ValueWrapperManager.IsNativeObjectFunction();
        }
    }

    @CoreMethod(names={"rb_thread_check_ints"}, onSingleton=true, required=0)
    public static abstract class CheckThreadInterrupt
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object checkInts() {
            TruffleSafepoint.pollHere((Node)this);
            return nil;
        }
    }

    @CoreMethod(names={"set_mark_list_on_object"}, onSingleton=true, required=1)
    public static abstract class SetMarkList
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object setMarkList(RubyDynamicObject structOwner, @Cached WriteObjectFieldNode writeMarkedNode) {
            writeMarkedNode.execute(this, structOwner, Layouts.MARKED_OBJECTS_IDENTIFIER, this.getContext().getMarkingService().finishMarking(this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack));
            return nil;
        }
    }

    @CoreMethod(names={"rb_tr_gc_guard"}, onSingleton=true, required=1)
    public static abstract class GCGuardNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object addToMarkList(Object guardedObject, @Cached MarkingServiceNodes.KeepAliveNode keepAliveNode, @Cached InlinedBranchProfile noExceptionProfile, @Cached UnwrapNode.ToWrapperNode toWrapperNode) {
            ValueWrapper wrappedValue = toWrapperNode.execute(this, guardedObject);
            if (wrappedValue != null) {
                noExceptionProfile.enter((Node)this);
                keepAliveNode.execute(this, wrappedValue);
            }
            return nil;
        }
    }

    @CoreMethod(names={"rb_gc_mark"}, onSingleton=true, required=1)
    public static abstract class AddToMarkList
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object rbGCMark(Object markedObject, @Cached InlinedBranchProfile noExceptionProfile, @Cached UnwrapNode.ToWrapperNode toWrapperNode) {
            ValueWrapper wrappedValue = toWrapperNode.execute(this, markedObject);
            if (wrappedValue != null) {
                noExceptionProfile.enter((Node)this);
                this.getContext().getMarkingService().addMark(this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack, wrappedValue);
            }
            return nil;
        }
    }

    @CoreMethod(names={"create_mark_list"}, onSingleton=true, required=1)
    public static abstract class NewMarkerList
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getDynamicObjectCacheLimit()")
        Object createNewMarkList(RubyDynamicObject object, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary) {
            this.getContext().getMarkingService().startMarking(this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack, (Object[])objectLibrary.getOrDefault((DynamicObject)object, (Object)Layouts.MARKED_OBJECTS_IDENTIFIER, null));
            return nil;
        }
    }

    @Primitive(name="cext_to_wrapper")
    public static abstract class CExtToWrapperNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        ValueWrapper toWrapper(Object value, @Cached UnwrapNode.ToWrapperNode toWrapperNode) {
            ValueWrapper wrapper = toWrapperNode.execute(this, value);
            if (wrapper == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("ValueWrapper not found for " + String.valueOf(value)));
            }
            return wrapper;
        }
    }

    @Primitive(name="cext_unwrap")
    public static abstract class UnwrapValueNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object unwrap(Object value, @Cached InlinedBranchProfile exceptionProfile, @Cached UnwrapNode unwrapNode) {
            Object object = unwrapNode.execute(this, value);
            if (object == null) {
                exceptionProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError(this.exceptionMessage(value), this));
            }
            return object;
        }

        @CompilerDirectives.TruffleBoundary
        private String exceptionMessage(Object value) {
            return String.format("native handle not found (%s)", value);
        }
    }

    @Primitive(name="cext_wrap")
    public static abstract class WrapValueNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        ValueWrapper wrap(Object value, @Cached WrapNode wrapNode) {
            return wrapNode.execute(value);
        }
    }

    @Primitive(name="cext_sym2id")
    public static abstract class Sym2IDNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object sym2id(RubySymbol symbol, @Cached SymbolToIDNode symbolToIDNode) {
            return symbolToIDNode.execute(symbol);
        }
    }

    @CoreMethod(names={"rb_enc_mbc_to_codepoint"}, onSingleton=true, required=1)
    public static abstract class RbEncMbcToCodepointNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        static int rbEncMbcToCodepoint(Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.CodePointAtByteIndexNode codePointAtByteIndexNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode, @Cached InlinedConditionProfile brokenProfile, @Bind(value="this") Node node) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            RubyEncoding encoding = strings.getEncoding(node, string);
            int codepoint = codePointAtByteIndexNode.execute(tstring, 0, encoding.tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (brokenProfile.profile(node, codepoint == -1)) {
                InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
                return StringSupport.mbcToCode(encoding.jcoding, byteArray.getArray(), byteArray.getOffset(), byteArray.getEnd());
            }
            return codepoint;
        }
    }

    @CoreMethod(names={"rb_enc_left_char_head"}, onSingleton=true, required=3, lowerFixnum={3})
    public static abstract class RbEncLeftCharHeadNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object rbEncLeftCharHead(RubyEncoding enc, Object string, int p, @Cached RubyStringLibrary strings) {
            byte[] bytes = TStringUtils.getBytesOrFail(strings.getTString(this, string), strings.getEncoding(this, string));
            return enc.jcoding.leftAdjustCharHead(bytes, 0, p, bytes.length);
        }
    }

    @CoreMethod(names={"rb_enc_strlen"}, onSingleton=true, required=1)
    public static abstract class RbEncStrlen
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        static int rbEncStrlen(Object string, @Bind(value="this") Node node, @Cached RubyStringLibrary strings, @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            TruffleString.Encoding tencoding = strings.getTEncoding(node, string);
            return codePointLengthNode.execute(tstring, tencoding);
        }
    }

    @CoreMethod(names={"rb_enc_precise_mbclen"}, onSingleton=true, required=1)
    public static abstract class RbEncPreciseMbclenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        static int rbEncPreciseMbclen(Object string, @Bind(value="this") Node node, @Cached RubyStringLibrary strings, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            TruffleString.Encoding tencoding = strings.getTEncoding(node, string);
            return byteLengthOfCodePointNode.execute(tstring, 0, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
        }
    }

    @CoreMethod(names={"rb_enc_mbclen"}, onSingleton=true, required=1)
    public static abstract class RbEncMbLenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        static Object rbEncMbLen(Object string, @Bind(value="this") Node node, @Cached RubyStringLibrary strings, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            TruffleString.Encoding tencoding = strings.getTEncoding(node, string);
            return byteLengthOfCodePointNode.execute(tstring, 0, tencoding, TruffleString.ErrorHandling.BEST_EFFORT);
        }
    }

    @CoreMethod(names={"rb_enc_mbminlen"}, onSingleton=true, required=1)
    public static abstract class RbEncMinLenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object rbEncMinLen(RubyEncoding value) {
            return value.jcoding.minLength();
        }
    }

    @CoreMethod(names={"rb_enc_mbmaxlen"}, onSingleton=true, required=1)
    public static abstract class RbEncMaxLenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object rbEncMaxLen(RubyEncoding value) {
            return value.jcoding.maxLength();
        }
    }

    @CoreMethod(names={"rb_tr_code_to_mbc"}, onSingleton=true, required=2, lowerFixnum={2})
    public static abstract class RbTrMbcPutNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object rbTrEncMbcPut(RubyEncoding enc, int code, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            Encoding encoding = enc.jcoding;
            byte[] buf = new byte[7];
            int resultLength = encoding.codeToMbc(code, buf, 0);
            byte[] result = new byte[resultLength];
            if (resultLength > 0) {
                System.arraycopy(buf, 0, result, 0, resultLength);
            }
            return this.createString(fromByteArrayNode, result, Encodings.US_ASCII);
        }
    }

    @CoreMethod(names={"rb_tr_enc_mbc_case_fold"}, onSingleton=true, required=4, lowerFixnum={1})
    public static abstract class RbTrMbcCaseFoldNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getCacheLimit()")
        static Object rbTrEncMbcCaseFold(int flags, Object string, Object advance_p, Object p, @Cached RubyStringLibrary strings, @CachedLibrary(value="advance_p") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode, @Bind(value="this") Node node) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            RubyEncoding encoding = strings.getEncoding(node, string);
            byte[] bytes = TStringUtils.getBytesOrFail(tstring, encoding, byteArrayNode);
            byte[] to = new byte[bytes.length];
            IntHolder intHolder = new IntHolder();
            intHolder.value = 0;
            int resultLength = encoding.jcoding.mbcCaseFold(flags, bytes, intHolder, bytes.length, to);
            InteropNodes.execute(node, advance_p, new Object[]{p, intHolder.value}, receivers, translateInteropExceptionNode);
            byte[] result = new byte[resultLength];
            if (resultLength > 0) {
                System.arraycopy(to, 0, result, 0, resultLength);
            }
            return RbTrMbcCaseFoldNode.createString(node, fromByteArrayNode, result, Encodings.US_ASCII);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.DISPATCH_CACHE;
        }
    }

    @CoreMethod(names={"raise_exception"}, onSingleton=true, required=1)
    public static abstract class RaiseExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object raiseException(CapturedException captured, @Cached InlinedConditionProfile runtimeExceptionProfile, @Cached InlinedConditionProfile errorProfile) {
            Throwable e = captured.getException();
            if (runtimeExceptionProfile.profile((Node)this, e instanceof RuntimeException)) {
                throw (RuntimeException)e;
            }
            if (errorProfile.profile((Node)this, e instanceof Error)) {
                throw (Error)e;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Checked Java Throwable rethrown", (Throwable)e);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ExtractRubyTagHelperNode
    extends RubyBaseNode {
        public abstract int execute(Node var1, Object var2);

        @Specialization
        static int dynamicReturnTag(DynamicReturnException e) {
            return 1;
        }

        @Specialization
        static int localReturnTag(LocalReturnException e) {
            return 1;
        }

        @Specialization
        static int breakTag(BreakException e) {
            return 2;
        }

        @Specialization
        static int nextTag(NextException e) {
            return 3;
        }

        @Specialization
        static int retryTag(RetryException e) {
            return 4;
        }

        @Specialization
        static int redoTag(RedoException e) {
            return 5;
        }

        @Specialization
        static int raiseTag(RaiseException e) {
            return 6;
        }

        @Specialization
        static int throwTag(ThrowException e) {
            return 7;
        }

        @Fallback
        static int noTag(Object e) {
            return 0;
        }
    }

    @CoreMethod(names={"extract_tag"}, onSingleton=true, required=1)
    public static abstract class ExtractRubyTag
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int extractRubyTag(CapturedException captured, @Cached ExtractRubyTagHelperNode helperNode) {
            return helperNode.execute(this, captured.getException());
        }
    }

    @CoreMethod(names={"extract_ruby_exception"}, onSingleton=true, required=1)
    public static abstract class ExtractRubyException
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object extractRubyException(CapturedException captured, @Cached InlinedConditionProfile rubyExceptionProfile) {
            Throwable e = captured.getException();
            if (rubyExceptionProfile.profile((Node)this, e instanceof RaiseException)) {
                return ((RaiseException)((Object)e)).getException();
            }
            return nil;
        }
    }

    @CoreMethod(names={"retrieve_exception"}, onSingleton=true)
    public static abstract class RetrieveException
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        CapturedException retrieveException() {
            MarkingService.ExtensionCallStack extensionStack = this.getLanguage().getCurrentFiber().extensionCallStack;
            return extensionStack.getException();
        }
    }

    @CoreMethod(names={"store_exception"}, onSingleton=true, required=1)
    public static abstract class StoreException
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object storeException(CapturedException captured) {
            MarkingService.ExtensionCallStack extensionStack = this.getLanguage().getCurrentFiber().extensionCallStack;
            extensionStack.setException(captured);
            return nil;
        }
    }

    @CoreMethod(names={"capture_exception"}, onSingleton=true, needsBlock=true)
    public static abstract class CaptureExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object captureException(RubyProc block, @Cached InlinedBranchProfile exceptionProfile, @Cached InlinedBranchProfile noExceptionProfile, @Cached CallBlockNode yieldNode) {
            try {
                yieldNode.yield(this, block, new Object[0]);
                noExceptionProfile.enter((Node)this);
                return nil;
            }
            catch (Throwable e) {
                exceptionProfile.enter((Node)this);
                return new CapturedException(e);
            }
        }
    }

    @CoreMethod(names={"rb_tr_debug"}, onSingleton=true, rest=true)
    public static abstract class DebugNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        DispatchNode toSCall;

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object debug(Object ... objects) {
            if (objects.length > 1) {
                System.err.printf("Printing %d values%n", objects.length);
            }
            RubyStringLibrary libString = RubyStringLibrary.getUncached();
            for (Object object : objects) {
                Object representation;
                if (libString.isRubyString(this, object)) {
                    AbstractTruffleString tstring = libString.getTString(this, object);
                    byte[] bytes = TStringUtils.getBytesOrCopy(tstring, libString.getEncoding(this, object));
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < bytes.length; ++i) {
                        if (i % 4 == 0 && i != 0 && i != bytes.length - 1) {
                            builder.append(" ");
                        }
                        builder.append(String.format("%02x", bytes[i]));
                    }
                    representation = String.valueOf(tstring) + " (" + String.valueOf(builder) + ")";
                } else {
                    representation = RubyGuards.isRubyValue(object) ? object.toString() + " (" + RubyGuards.getJavaString(this.callToS(object)) + ")" : object.toString();
                }
                System.err.printf("%s @ %s: %s%n", object.getClass(), System.identityHashCode(object), representation);
            }
            return nil;
        }

        private Object callToS(Object object) {
            if (this.toSCall == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSCall = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.toSCall.call(object, "to_s");
        }
    }

    @Primitive(name="string_is_native?")
    public static abstract class StringPointerIsNativeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isNative(RubyString string) {
            return string.tstring.isNative();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean isNative(ImmutableRubyString string) {
            return string.isNative();
        }
    }

    @CoreMethod(names={"string_to_ffi_pointer_copy"}, onSingleton=true, required=1)
    public static abstract class StringToFFIPointerCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyPointer toFFIPointerCopy(Object string, @Cached StringToNativeNode stringToNativeNode) {
            Pointer pointer = stringToNativeNode.executeToNative(this, string, false);
            RubyPointer instance = new RubyPointer(this.coreLibrary().truffleFFIPointerClass, this.getLanguage().truffleFFIPointerShape, pointer);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"string_to_ffi_pointer_inplace"}, onSingleton=true, required=1)
    public static abstract class StringToFFIPointerInplaceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyPointer toFFIPointerInplace(Object string, @Cached StringToNativeNode stringToNativeNode) {
            Pointer pointer = stringToNativeNode.executeToNative(this, string, true);
            RubyPointer instance = new RubyPointer(this.coreLibrary().truffleFFIPointerClass, this.getLanguage().truffleFFIPointerShape, pointer);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @Primitive(name="string_pointer_to_native")
    public static abstract class StringPointerToNativeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long toNative(Object string, @Cached StringToNativeNode stringToNativeNode) {
            return stringToNativeNode.executeToNative(this, string, true).getAddress();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class StringToNativeNode
    extends RubyBaseNode {
        public abstract Pointer executeToNative(Node var1, Object var2, boolean var3);

        @Specialization
        static Pointer toNative(Node node, RubyString string, boolean inplace, @Cached RubyStringLibrary libString, @Cached InlinedConditionProfile convertProfile, @Cached(inline=false) TruffleString.CopyToNativeMemoryNode copyToNativeMemoryNode, @Cached(inline=false) MutableTruffleString.FromNativePointerNode fromNativePointerNode, @Cached(inline=false) TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            Pointer pointer;
            CompilerAsserts.partialEvaluationConstant((boolean)inplace);
            AbstractTruffleString tstring = string.tstring;
            TruffleString.Encoding tencoding = libString.getTEncoding(node, (Object)string);
            if (convertProfile.profile(node, tstring.isNative())) {
                assert (tstring.isMutable());
                pointer = (Pointer)getInternalNativePointerNode.execute(tstring, tencoding);
            } else {
                int byteLength = tstring.byteLength(tencoding);
                pointer = StringToNativeNode.allocateAndCopyToNative(StringToNativeNode.getLanguage(node), StringToNativeNode.getContext(node), tstring, tencoding, byteLength, copyToNativeMemoryNode);
                if (inplace) {
                    MutableTruffleString nativeTString = fromNativePointerNode.execute((Object)pointer, 0, byteLength, tencoding, false);
                    string.setTString((AbstractTruffleString)nativeTString);
                }
            }
            return pointer;
        }

        @Specialization
        static Pointer toNativeImmutable(Node node, ImmutableRubyString string, boolean inplace) {
            return string.getNativeString(StringToNativeNode.getLanguage(node), StringToNativeNode.getContext(node));
        }

        public static Pointer allocateAndCopyToNative(RubyLanguage language, RubyContext context, AbstractTruffleString tstring, TruffleString.Encoding tencoding, int capacity, TruffleString.CopyToNativeMemoryNode copyToNativeMemoryNode) {
            Pointer pointer = CExtNodes.newNativeStringPointer(language, context, capacity);
            copyToNativeMemoryNode.execute(tstring, 0, (Object)pointer, 0, capacity, tencoding);
            return pointer;
        }
    }

    @CoreMethod(names={"rb_hash"}, onSingleton=true, required=1)
    public static abstract class RbHashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int rbHash(Object object, @Cached HashingNodes.ToHashByHashCode toHashByHashCode) {
            return toHashByHashCode.execute(this, object);
        }
    }

    @CoreMethod(names={"rb_syserr_fail"}, onSingleton=true, required=2, lowerFixnum={1})
    public static abstract class RbSysErrFail
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object rbSysErrFail(int errno, Object string, @Cached ErrnoErrorNode errnoErrorNode) {
            Backtrace backtrace = this.getContext().getCallStack().getBacktrace(this);
            throw new RaiseException(this.getContext(), (RubyException)errnoErrorNode.execute(null, errno, string, null, backtrace));
        }
    }

    @CoreMethod(names={"rb_frame_this_func"}, onSingleton=true, rest=true)
    public static abstract class FrameThisFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object frameThisFunc(VirtualFrame frame, Object[] args) {
            Frame callingMethodFrame = FrameThisFunctionNode.findCallingMethodFrame();
            InternalMethod callingMethod = RubyArguments.getMethod(callingMethodFrame);
            return this.getSymbol(callingMethod.getName());
        }

        @CompilerDirectives.TruffleBoundary
        private static Frame findCallingMethodFrame() {
            return (Frame)Truffle.getRuntime().iterateFrames(frameInstance -> {
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                InternalMethod method = RubyArguments.tryGetMethod(frame);
                if (method == null) {
                    return null;
                }
                if (method.getName().equals("rb_frame_this_func") || method.getName().equals("execute_without_conversion")) {
                    return null;
                }
                return frame;
            });
        }
    }

    @CoreMethod(names={"rb_call_super_splatted"}, onSingleton=true, rest=true)
    public static abstract class CallSuperNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallSuperMethodNode callSuperMethodNode = CallSuperMethodNode.create();

        @Specialization
        Object callSuper(VirtualFrame frame, Object[] args, @Cached MetaClassNode metaClassNode) {
            Frame callingMethodFrame = CallSuperNode.findCallingMethodFrame();
            InternalMethod callingMethod = RubyArguments.getMethod(callingMethodFrame);
            Object callingSelf = RubyArguments.getSelf(callingMethodFrame);
            RubyClass callingMetaclass = metaClassNode.execute(this, callingSelf);
            MethodLookupResult superMethodLookup = ModuleOperations.lookupSuperMethod(callingMethod, callingMetaclass);
            InternalMethod superMethod = superMethodLookup.getMethod();
            return this.callSuperMethodNode.execute(frame, callingSelf, superMethod, NoKeywordArgumentsDescriptor.INSTANCE, args, nil);
        }

        @CompilerDirectives.TruffleBoundary
        private static Frame findCallingMethodFrame() {
            return (Frame)Truffle.getRuntime().iterateFrames(frameInstance -> {
                Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                InternalMethod method = RubyArguments.tryGetMethod(frame);
                if (method == null) {
                    return null;
                }
                if (method.getName().equals("rb_call_super") || method.getName().equals("execute_without_conversion") || method.getName().equals("rb_call_super_splatted")) {
                    return null;
                }
                return frame;
            });
        }
    }

    @CoreMethod(names={"rb_is_class_id"}, onSingleton=true, required=1)
    public static abstract class IsClassVariableIdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isClassVariableId(RubySymbol symbol) {
            return symbol.getType() == IdentifierType.CLASS;
        }
    }

    @CoreMethod(names={"rb_is_const_id"}, onSingleton=true, required=1)
    public static abstract class IsConstIdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isConstId(RubySymbol symbol) {
            return symbol.getType() == IdentifierType.CONST;
        }
    }

    @CoreMethod(names={"rb_is_instance_id"}, onSingleton=true, required=1)
    public static abstract class IsInstanceIdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isInstanceId(RubySymbol symbol) {
            return symbol.getType() == IdentifierType.INSTANCE;
        }
    }

    @CoreMethod(names={"rb_is_local_id"}, onSingleton=true, required=1)
    public static abstract class IsLocalIdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isLocalId(RubySymbol symbol) {
            return symbol.getType() == IdentifierType.LOCAL;
        }
    }

    @CoreMethod(names={"rb_sourceline"}, onSingleton=true)
    public static abstract class SourceLineNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        int sourceLine() {
            SourceSection sourceSection = SourceFileNode.getTopUserSourceSection("rb_sourceline");
            return RubySource.getStartLineAdjusted(this.getContext(), sourceSection);
        }
    }

    @CoreMethod(names={"rb_sourcefile"}, onSingleton=true)
    public static abstract class SourceFileNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString sourceFile() {
            SourceSection sourceSection = SourceFileNode.getTopUserSourceSection("rb_sourcefile");
            String file = this.getLanguage().getSourcePath(sourceSection.getSource());
            return this.createString(this.fromJavaStringNode, file, Encodings.UTF_8);
        }

        @CompilerDirectives.TruffleBoundary
        public static SourceSection getTopUserSourceSection(String ... methodNames) {
            return (SourceSection)Truffle.getRuntime().iterateFrames(frameInstance -> {
                RootNode rootNode;
                Node callNode = frameInstance.getCallNode();
                if (callNode != null && (rootNode = callNode.getRootNode()) instanceof RubyRootNode && rootNode.getSourceSection().isAvailable() && !SourceFileNode.nameMatches(((RubyRootNode)rootNode).getSharedMethodInfo().getMethodName(), methodNames)) {
                    return frameInstance.getCallNode().getEncapsulatingSourceSection();
                }
                return null;
            });
        }

        private static boolean nameMatches(String name, String ... methodNames) {
            for (String methodName : methodNames) {
                if (!methodName.equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"rb_iter_break_value"}, onSingleton=true, required=1)
    public static abstract class IterBreakValueNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object iterBreakValue(Object value) {
            throw new BreakException(BreakID.ANY_BLOCK, value);
        }
    }

    @CoreMethod(names={"caller_frame_visibility"}, onSingleton=true, required=1)
    public static abstract class CallerFrameVisibilityNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean checkCallerVisibility(RubySymbol visibility) {
            Frame callerFrame = this.getContext().getCallStack().getCallerFrame(FrameInstance.FrameAccess.READ_ONLY);
            Visibility callerVisibility = DeclarationContext.findVisibility(callerFrame);
            switch (visibility.getString()) {
                case "private": {
                    return callerVisibility == Visibility.PRIVATE;
                }
                case "protected": {
                    return callerVisibility == Visibility.PROTECTED;
                }
                case "module_function": {
                    return callerVisibility == Visibility.MODULE_FUNCTION;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @CoreMethod(names={"cext_module_function"}, onSingleton=true, required=2)
    public static abstract class CextModuleFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule cextModuleFunction(RubyModule module, RubySymbol name, @Cached ModuleNodes.SetMethodVisibilityNode setMethodVisibilityNode) {
            setMethodVisibilityNode.execute(this, module, name, Visibility.MODULE_FUNCTION);
            return module;
        }
    }

    @ReportPolymorphism
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class RbGvGetInnerNode
    extends RubyBaseNode {
        public abstract Object execute(VirtualFrame var1, Node var2, String var3);

        @Specialization(guards={"name == cachedName"}, limit="getDefaultCacheLimit()")
        static Object rbGvGetCached(VirtualFrame frame, Node node, String name, @Cached(value="name") String cachedName, @Cached(value="create(cachedName)", inline=false) ReadGlobalVariableNode readGlobalVariableNode) {
            return readGlobalVariableNode.execute(frame);
        }

        @Specialization
        static Object rbGvGetUncached(Node node, String name, @Cached(inline=false) DispatchNode dispatchNode) {
            return dispatchNode.call((Object)RbGvGetInnerNode.coreLibrary((Node)node).topLevelBinding, "eval", (Object)name);
        }
    }

    @Primitive(name="rb_gv_get")
    public static abstract class RbGvGetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object rbGvGet(VirtualFrame frame, String name, @Cached InlinedBranchProfile notExistsProfile, @Cached LazyWarningNode lazyWarningNode, @Cached RbGvGetInnerNode rbGvGetInnerNode) {
            boolean exists = this.getContext().getCoreLibrary().globalVariables.contains(name);
            if (!exists) {
                notExistsProfile.enter((Node)this);
                WarningNode warningNode = lazyWarningNode.get(this);
                if (warningNode.shouldWarn()) {
                    warningNode.warningMessage(RbGvGetNode.getContext(this).getCallStack().getTopMostUserSourceSection(), StringUtils.format("global variable `%s' not initialized", name));
                }
                return nil;
            }
            return rbGvGetInnerNode.execute(frame, this, name);
        }
    }

    @CoreMethod(names={"rb_const_set"}, onSingleton=true, required=3)
    public static abstract class RbConstSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object rbConstSet(RubyModule module, Object name, Object value, @Cached ToJavaStringNode toJavaStringNode, @Cached ModuleNodes.ConstSetUncheckedNode constSetUncheckedNode) {
            String nameAsString = toJavaStringNode.execute(this, name);
            return constSetUncheckedNode.execute(module, nameAsString, value);
        }
    }

    @CoreMethod(names={"rb_const_get_from"}, onSingleton=true, required=2)
    public static abstract class RbConstGetFromNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LookupConstantNode lookupConstantNode = LookupConstantNode.create(true, false);

        @Specialization
        Object rbConstGetFrom(RubyModule module, Object name, @Cached ToJavaStringNode toJavaStringNode, @Cached GetConstantNode getConstantNode) {
            String nameAsString = toJavaStringNode.execute(this, name);
            return getConstantNode.lookupAndResolveConstant(LexicalScope.IGNORE, module, nameAsString, false, this.lookupConstantNode, true);
        }
    }

    @CoreMethod(names={"rb_const_get"}, onSingleton=true, required=2)
    public static abstract class RbConstGetNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LookupConstantNode lookupConstantNode = LookupConstantNode.create(true, true);

        @Specialization
        Object rbConstGet(RubyModule module, Object name, @Cached ToJavaStringNode toJavaStringNode, @Cached GetConstantNode getConstantNode) {
            String nameAsString = toJavaStringNode.execute(this, name);
            return getConstantNode.lookupAndResolveConstant(LexicalScope.IGNORE, module, nameAsString, false, this.lookupConstantNode, true);
        }
    }

    @CoreMethod(names={"rb_str_unlocktmp"}, onSingleton=true, required=1)
    public static abstract class RbStrUnlockTmpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString rbStrUnlockTmp(RubyString string, @Cached InlinedBranchProfile errorProfile) {
            if (!string.locked) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("temporal unlocking already unlocked string", this));
            }
            string.locked = false;
            return string;
        }

        @Specialization
        ImmutableRubyString rbStrUnlockTmpImmutable(ImmutableRubyString string) {
            throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("temporal unlocking immutable string", this));
        }
    }

    @CoreMethod(names={"rb_str_locktmp"}, onSingleton=true, required=1)
    public static abstract class RbStrLockTmpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString rbStrLockTmp(RubyString string, @Cached InlinedBranchProfile errorProfile) {
            if (string.locked) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("temporal locking already locked string", this));
            }
            string.locked = true;
            return string;
        }

        @Specialization
        RubyString rbStrLockTmpImmutable(ImmutableRubyString string) {
            throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("temporal locking immutable string", this));
        }
    }

    @CoreMethod(names={"rb_check_frozen"}, onSingleton=true, required=1)
    public static abstract class CheckFrozenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean rb_check_frozen(Object object, @Cached TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            raiseIfFrozenNode.execute(this, object);
            return true;
        }
    }

    @Primitive(name="cext_special_variables_from_stack")
    public static abstract class VarsFromStackNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object variables() {
            return this.getLanguage().getCurrentFiber().extensionCallStack.getSpecialVariables();
        }
    }

    @CoreMethod(names={"rb_block_proc"}, onSingleton=true)
    public static abstract class BlockProcNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object block() {
            return this.getLanguage().getCurrentFiber().extensionCallStack.getBlock();
        }
    }

    @CoreMethod(names={"rb_keyword_given_p"}, onSingleton=true)
    public static abstract class RbKeywordGivenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean keywordGiven() {
            return this.getLanguage().getCurrentFiber().extensionCallStack.areKeywordsGiven();
        }
    }

    @CoreMethod(names={"rb_tr_str_capa_resize"}, onSingleton=true, required=2, lowerFixnum={2})
    public static abstract class TrStrCapaResizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString trStrCapaResize(RubyString string, int newCapacity, @Cached RubyStringLibrary libString, @Cached StringToNativeNode stringToNativeNode, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode) {
            Pointer pointer = stringToNativeNode.executeToNative(this, (Object)string, true);
            TruffleString.Encoding tencoding = libString.getTEncoding(this, (Object)string);
            if (CExtNodes.getNativeStringCapacity(pointer) == (long)newCapacity) {
                return string;
            }
            int byteLength = string.tstring.byteLength(tencoding);
            MutableTruffleString newNativeTString = TrStrCapaResizeNode.resize(this.getLanguage(), this.getContext(), pointer, newCapacity, byteLength, tencoding, fromNativePointerNode);
            string.setTString((AbstractTruffleString)newNativeTString);
            return string;
        }

        static MutableTruffleString resize(RubyLanguage language, RubyContext context, Pointer pointer, int newCapacity, int newByteLength, TruffleString.Encoding tencoding, MutableTruffleString.FromNativePointerNode fromNativePointerNode) {
            Pointer newPointer = CExtNodes.newNativeStringPointer(language, context, newCapacity);
            newPointer.writeBytes(0L, pointer, 0, Math.min(pointer.getSize(), (long)newCapacity));
            return fromNativePointerNode.execute((Object)newPointer, 0, newByteLength, tencoding, false);
        }
    }

    @CoreMethod(names={"rb_str_resize"}, onSingleton=true, required=2, lowerFixnum={2})
    public static abstract class RbStrResizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString rbStrResize(RubyString string, int newByteLength, @Cached RubyStringLibrary libString, @Cached StringToNativeNode stringToNativeNode, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode) {
            Pointer pointer = stringToNativeNode.executeToNative(this, (Object)string, true);
            TruffleString.Encoding tencoding = libString.getTEncoding(this, (Object)string);
            int byteLength = string.tstring.byteLength(tencoding);
            if (byteLength == newByteLength) {
                string.clearCodeRange();
                return string;
            }
            MutableTruffleString newNativeTString = TrStrCapaResizeNode.resize(this.getLanguage(), this.getContext(), pointer, newByteLength, newByteLength, tencoding, fromNativePointerNode);
            string.setTString((AbstractTruffleString)newNativeTString);
            string.clearCodeRange();
            return string;
        }
    }

    @CoreMethod(names={"rb_str_set_len"}, onSingleton=true, required=2, lowerFixnum={2})
    public static abstract class RbStrSetLenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString strSetLen(RubyString string, int newByteLength, @Cached RubyStringLibrary libString, @Cached StringToNativeNode stringToNativeNode, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode, @Cached InlinedConditionProfile minLengthOneProfile) {
            Pointer pointer = stringToNativeNode.executeToNative(this, (Object)string, true);
            RubyEncoding encoding = libString.getEncoding(this, (Object)string);
            int minLength = encoding.jcoding.minLength();
            if (minLengthOneProfile.profile((Node)this, minLength == 1)) {
                pointer.writeByte(newByteLength, (byte)0);
            } else if (minLength == 2) {
                pointer.writeShort(newByteLength, (short)0);
            } else if (minLength == 4) {
                pointer.writeInt(newByteLength, 0);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            MutableTruffleString newNativeTString = fromNativePointerNode.execute((Object)pointer, 0, newByteLength, encoding.tencoding, false);
            string.setTString((AbstractTruffleString)newNativeTString);
            return string;
        }
    }

    @CoreMethod(names={"rb_str_capacity"}, onSingleton=true, required=1)
    public static abstract class RbStrCapacityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        long capacity(Object string, @Cached StringToNativeNode stringToNativeNode) {
            return CExtNodes.getNativeStringCapacity(stringToNativeNode.executeToNative(this, string, true));
        }
    }

    @CoreMethod(names={"rb_tr_temporary_native_string"}, onSingleton=true, required=3, lowerFixnum={2})
    public static abstract class TemporaryNativeStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString temporaryNativeString(Object pointer, int byteLength, RubyEncoding encoding, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode) {
            MutableTruffleString nativeTString = fromNativePointerNode.execute(pointer, 0, byteLength, encoding.tencoding, false);
            return this.createMutableString(nativeTString, encoding);
        }
    }

    @CoreMethod(names={"rb_str_new_nul"}, onSingleton=true, required=1, lowerFixnum={1})
    public static abstract class RbStrNewNulNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString rbStrNewNul(int byteLength, @Cached MutableTruffleString.FromNativePointerNode fromNativePointerNode) {
            Pointer pointer = CExtNodes.newZeroedNativeStringPointer(this.getLanguage(), this.getContext(), byteLength);
            MutableTruffleString nativeTString = fromNativePointerNode.execute((Object)pointer, 0, byteLength, Encodings.BINARY.tencoding, false);
            return this.createMutableString(nativeTString, Encodings.BINARY);
        }
    }

    @CoreMethod(names={"rb_enc_isspace"}, onSingleton=true, required=2, lowerFixnum={1})
    public static abstract class RbEncIsSpaceNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean rbEncIsSpace(int code, RubyEncoding value) {
            return value.jcoding.isSpace(code);
        }
    }

    @CoreMethod(names={"rb_enc_isalnum"}, onSingleton=true, required=2, lowerFixnum={1})
    public static abstract class RbEncIsAlNumNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean rbEncIsAlNum(int code, RubyEncoding value) {
            return value.jcoding.isAlnum(code);
        }
    }

    @CoreMethod(names={"rb_enc_codepoint_len"}, onSingleton=true, required=1)
    public static abstract class RbEncCodePointLenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        static RubyArray rbEncCodePointLen(Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.ByteLengthOfCodePointNode byteLengthOfCodePointNode, @Cached TruffleString.CodePointAtByteIndexNode codePointAtByteIndexNode, @Cached InlinedBranchProfile errorProfile, @Bind(value="this") Node node) {
            AbstractTruffleString tstring = strings.getTString(node, string);
            RubyEncoding encoding = strings.getEncoding(node, string);
            TruffleString.Encoding tencoding = encoding.tencoding;
            int r = byteLengthOfCodePointNode.execute(tstring, 0, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            if (!StringSupport.MBCLEN_CHARFOUND_P(r)) {
                errorProfile.enter(node);
                throw new RaiseException(RbEncCodePointLenNode.getContext(node), RbEncCodePointLenNode.coreExceptions(node).argumentErrorInvalidByteSequence(encoding, node));
            }
            int codePoint = codePointAtByteIndexNode.execute(tstring, 0, tencoding, TruffleString.ErrorHandling.RETURN_NEGATIVE);
            assert (codePoint != -1);
            return RbEncCodePointLenNode.createArray(node, new int[]{StringSupport.MBCLEN_CHARFOUND_LEN(r), codePoint});
        }
    }

    @CoreMethod(names={"code_to_mbclen"}, onSingleton=true, required=2, lowerFixnum={1})
    public static abstract class CodeToMbcLenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int codeToMbcLen(int code, RubyEncoding encoding) {
            return StringSupport.codeLength(encoding.jcoding, code);
        }
    }

    @CoreMethod(names={"rb_enc_coderange_clear"}, onSingleton=true, required=1)
    public static abstract class RbEncCodeRangeClear
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyString clearCodeRange(RubyString string, @Cached StringToNativeNode stringToNativeNode) {
            stringToNativeNode.executeToNative(this, (Object)string, true);
            string.clearCodeRange();
            return string;
        }
    }

    @CoreMethod(names={"rb_long2int"}, onSingleton=true, required=1)
    public static abstract class Long2Int
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int long2fix(int num) {
            return num;
        }

        @Specialization(guards={"fitsInInteger(num)"})
        int long2fixInRange(long num) {
            return (int)num;
        }

        @Specialization(guards={"!fitsInInteger(num)"})
        int long2fixOutOfRange(long num) {
            throw new RaiseException(this.getContext(), this.coreExceptions().rangeErrorConvertToInt(num, this));
        }
    }

    @CoreMethod(names={"DBL2BIG"}, onSingleton=true, required=1)
    public static abstract class DBL2BIGNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object dbl2big(double num, @Cached FloatToIntegerNode floatToIntegerNode) {
            return floatToIntegerNode.execute(this, num);
        }
    }

    @Primitive(name="rb_int_singlebit_p")
    public static abstract class IntSinglebitPPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int intSinglebitP(int num) {
            assert (num >= 0);
            return Integer.bitCount(num) == 1 ? 1 : 0;
        }

        @Specialization
        int intSinglebitP(long num) {
            assert (num >= 0L);
            return Long.bitCount(num) == 1 ? 1 : 0;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int intSinglebitP(RubyBignum num) {
            assert (num.value.signum() >= 0);
            return num.value.bitCount() == 1 ? 1 : 0;
        }
    }

    @CoreMethod(names={"rb_2scomp_bit_length"}, onSingleton=true, required=1)
    public static abstract class Bignum2sCompBitLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        int bitLength(int num) {
            return BigInteger.valueOf(num).bitLength();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int bitLength(long num) {
            return BigInteger.valueOf(num).bitLength();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int bitLength(RubyBignum num) {
            return num.value.bitLength();
        }
    }

    @CoreMethod(names={"rb_absint_bit_length"}, onSingleton=true, required=1)
    public static abstract class BignumAbsBitLengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        int bitLength(int num) {
            return BigInteger.valueOf(num).abs().bitLength();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int bitLength(long num) {
            return BigInteger.valueOf(num).abs().bitLength();
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int bitLength(RubyBignum num) {
            return num.value.abs().bitLength();
        }
    }

    @CoreMethod(names={"rb_integer_bytes"}, onSingleton=true, lowerFixnum={2, 3}, required=6)
    public static abstract class IntegerBytesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyArray bytes(int num, int num_words, int word_length, boolean msw_first, boolean twosComp, boolean bigEndian) {
            BigInteger bi = BigInteger.valueOf(num);
            return this.bytes(bi, num_words, word_length, msw_first, twosComp, bigEndian);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyArray bytes(long num, int num_words, int word_length, boolean msw_first, boolean twosComp, boolean bigEndian) {
            BigInteger bi = BigInteger.valueOf(num);
            return this.bytes(bi, num_words, word_length, msw_first, twosComp, bigEndian);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        RubyArray bytes(RubyBignum num, int num_words, int word_length, boolean msw_first, boolean twosComp, boolean bigEndian) {
            BigInteger bi = num.value;
            return this.bytes(bi, num_words, word_length, msw_first, twosComp, bigEndian);
        }

        private RubyArray bytes(BigInteger bi, int num_words, int word_length, boolean msw_first, boolean twosComp, boolean bigEndian) {
            int i;
            boolean negative;
            if (!twosComp) {
                bi = bi.abs();
            }
            int num_bytes = num_words * word_length;
            int[] bytes = new int[num_bytes];
            byte[] bi_bytes = bi.toByteArray();
            int bi_length = bi_bytes.length;
            boolean bl = negative = bi.signum() == -1;
            if (!twosComp && bi_bytes[0] == 0) {
                --bi_length;
            }
            int bytes_to_copy = Math.min(bi_length, num_bytes);
            if (msw_first) {
                int i2;
                int offset = bi_bytes.length - bytes_to_copy;
                for (i2 = 0; i2 < bytes_to_copy; ++i2) {
                    bytes[i2] = bi_bytes[offset + i2];
                }
                if (negative) {
                    for (i2 = 0; i2 < num_bytes - bytes_to_copy; ++i2) {
                        bytes[i2] = -1;
                    }
                }
            } else {
                for (i = 0; i < bytes_to_copy; ++i) {
                    bytes[i] = bi_bytes[bi_bytes.length - 1 - i];
                }
                if (negative) {
                    for (i = bytes_to_copy; i < num_bytes; ++i) {
                        bytes[i] = -1;
                    }
                }
            }
            if (bigEndian ^ msw_first && word_length > 1) {
                for (i = 0; i < num_words; ++i) {
                    for (int j = 0; j < word_length / 2; ++j) {
                        int pos_a = i * word_length + j;
                        int pos_b = (i + 1) * word_length - 1 - j;
                        int a = bytes[pos_a];
                        bytes[pos_a] = bytes[pos_b];
                        bytes[pos_b] = a;
                    }
                }
            }
            return this.createArray(bytes);
        }
    }

    @CoreMethod(names={"rb_ulong2num"}, onSingleton=true, required=1)
    public static abstract class ULong2NumNode
    extends CoreMethodArrayArgumentsNode {
        private static final BigInteger TWO_POW_64 = BigInteger.valueOf(1L).shiftLeft(64);

        @Specialization
        Object ulong2num(long num, @Cached InlinedConditionProfile positiveProfile) {
            if (positiveProfile.profile((Node)this, num >= 0L)) {
                return num;
            }
            return BignumOperations.createBignum(this.toUnsigned(num));
        }

        private BigInteger toUnsigned(long num) {
            return BigIntegerOps.add(TWO_POW_64, num);
        }
    }

    @CoreMethod(names={"cext_lock_owned?"}, onSingleton=true)
    public static abstract class IsCExtLockOwnedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isCExtLockOwned() {
            ReentrantLock lock = this.getContext().getCExtensionsLock();
            return lock.isHeldByCurrentThread();
        }
    }

    @CoreMethod(names={"cext_start_new_handle_block"}, onSingleton=true)
    public static abstract class StartNewHandleBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean startNewHandleBlock() {
            ValueWrapperManager.allocateNewBlock(this.getContext(), this.getLanguage());
            return true;
        }
    }

    @Primitive(name="cext_mark_object_on_call_exit")
    public static abstract class MarkObjectOnCallExit
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object markOnCallExit(Object object, @Cached WrapNode wrapNode) {
            ValueWrapper wrapper = wrapNode.execute(object);
            this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack.markOnExitObject(wrapper);
            return nil;
        }
    }

    @Primitive(name="public_send_argv_keywords_without_cext_lock")
    public static abstract class PublicSendARGVKeywordsWithoutCExtLockNode
    extends SendWithoutCExtLockBaseNode {
        @Specialization
        Object sendWithoutCExtLock(VirtualFrame frame, Object receiver, RubySymbol method, Object argv, Object block, @Cached UnwrapNode.UnwrapCArrayNode unwrapCArrayNode, @Cached HashCastNode hashCastNode, @Cached InlinedConditionProfile emptyProfile, @Cached DispatchNode dispatchNode, @Cached InlinedConditionProfile ownedProfile) {
            Object[] args = unwrapCArrayNode.execute(argv);
            RubyHash keywords = hashCastNode.execute(this, ArrayUtils.getLast(args));
            if (emptyProfile.profile((Node)this, keywords.empty())) {
                args = LiteralCallNode.removeEmptyKeywordArguments(args);
                return this.sendWithoutCExtLock(frame, receiver, method, block, NoKeywordArgumentsDescriptor.INSTANCE, args, dispatchNode, DispatchConfiguration.PUBLIC, ownedProfile);
            }
            return this.sendWithoutCExtLock(frame, receiver, method, block, KeywordArgumentsDescriptor.EMPTY, args, dispatchNode, DispatchConfiguration.PUBLIC, ownedProfile);
        }
    }

    @Primitive(name="public_send_argv_without_cext_lock", lowerFixnum={2})
    public static abstract class PublicSendARGVWithoutCExtLockNode
    extends SendWithoutCExtLockBaseNode {
        @Specialization
        Object publicSendWithoutLock(VirtualFrame frame, Object receiver, RubySymbol method, Object argv, Object block, @Cached UnwrapNode.UnwrapCArrayNode unwrapCArrayNode, @Cached DispatchNode dispatchNode, @Cached InlinedConditionProfile ownedProfile) {
            Object[] args = unwrapCArrayNode.execute(argv);
            return this.sendWithoutCExtLock(frame, receiver, method, block, NoKeywordArgumentsDescriptor.INSTANCE, args, dispatchNode, DispatchConfiguration.PUBLIC, ownedProfile);
        }
    }

    @Primitive(name="send_argv_keywords_without_cext_lock")
    public static abstract class SendARGVKeywordsWithoutCExtLockNode
    extends SendWithoutCExtLockBaseNode {
        @Specialization
        Object sendWithoutCExtLock(VirtualFrame frame, Object receiver, RubySymbol method, Object argv, Object block, @Cached UnwrapNode.UnwrapCArrayNode unwrapCArrayNode, @Cached HashCastNode hashCastNode, @Cached InlinedConditionProfile emptyProfile, @Cached DispatchNode dispatchNode, @Cached InlinedConditionProfile ownedProfile) {
            Object[] args = unwrapCArrayNode.execute(argv);
            RubyHash keywords = hashCastNode.execute(this, ArrayUtils.getLast(args));
            if (emptyProfile.profile((Node)this, keywords.empty())) {
                args = LiteralCallNode.removeEmptyKeywordArguments(args);
                return this.sendWithoutCExtLock(frame, receiver, method, block, NoKeywordArgumentsDescriptor.INSTANCE, args, dispatchNode, DispatchConfiguration.PRIVATE, ownedProfile);
            }
            return this.sendWithoutCExtLock(frame, receiver, method, block, KeywordArgumentsDescriptor.EMPTY, args, dispatchNode, DispatchConfiguration.PRIVATE, ownedProfile);
        }
    }

    @Primitive(name="send_argv_without_cext_lock")
    public static abstract class SendARGVWithoutCExtLockNode
    extends SendWithoutCExtLockBaseNode {
        @Specialization
        Object sendWithoutCExtLock(VirtualFrame frame, Object receiver, RubySymbol method, Object argv, Object block, @Cached UnwrapNode.UnwrapCArrayNode unwrapCArrayNode, @Cached DispatchNode dispatchNode, @Cached InlinedConditionProfile ownedProfile) {
            Object[] args = unwrapCArrayNode.execute(argv);
            return this.sendWithoutCExtLock(frame, receiver, method, block, NoKeywordArgumentsDescriptor.INSTANCE, args, dispatchNode, DispatchConfiguration.PRIVATE, ownedProfile);
        }
    }

    @Primitive(name="send_without_cext_lock")
    public static abstract class SendWithoutCExtLockNode
    extends SendWithoutCExtLockBaseNode {
        @Specialization
        Object sendWithoutCExtLock(VirtualFrame frame, Object receiver, RubySymbol method, RubyArray argsArray, Object block, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @Cached DispatchNode dispatchNode, @Cached InlinedConditionProfile ownedProfile) {
            Object[] args = arrayToObjectArrayNode.executeToObjectArray(argsArray);
            return this.sendWithoutCExtLock(frame, receiver, method, block, NoKeywordArgumentsDescriptor.INSTANCE, args, dispatchNode, DispatchConfiguration.PRIVATE, ownedProfile);
        }
    }

    public static abstract class SendWithoutCExtLockBaseNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object sendWithoutCExtLock(VirtualFrame frame, Object receiver, RubySymbol method, Object block, ArgumentsDescriptor descriptor, Object[] args, DispatchNode dispatchNode, DispatchConfiguration config, InlinedConditionProfile ownedProfile) {
            if (this.getContext().getOptions().CEXT_LOCK) {
                ReentrantLock lock = this.getContext().getCExtensionsLock();
                boolean owned = ownedProfile.profile((Node)this, lock.isHeldByCurrentThread());
                if (owned) {
                    MutexOperations.unlockInternal(lock);
                }
                try {
                    Object object = dispatchNode.callWithFrameAndBlock(config, (Frame)frame, receiver, method.getString(), block, descriptor, args);
                    return object;
                }
                finally {
                    if (owned) {
                        MutexOperations.internalLockEvenWithException(this.getContext(), lock, this);
                    }
                }
            }
            return dispatchNode.callWithFrameAndBlock(config, (Frame)frame, receiver, method.getString(), block, descriptor, args);
        }
    }

    @Primitive(name="call_with_c_mutex")
    public static abstract class CallWithCExtLockNode
    extends PrimitiveArrayArgumentsNode {
        public abstract Object execute(Object var1, RubyArray var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object callWithCExtLock(Object receiver, RubyArray argsArray, @CachedLibrary(limit="getCacheLimit()") InteropLibrary receivers, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Cached InlinedConditionProfile ownedProfile) {
            Object[] args = arrayToObjectArrayNode.executeToObjectArray(argsArray);
            if (this.getContext().getOptions().CEXT_LOCK) {
                ReentrantLock lock = this.getContext().getCExtensionsLock();
                boolean owned = ownedProfile.profile((Node)this, lock.isHeldByCurrentThread());
                if (!owned) {
                    MutexOperations.lockInternal(this.getContext(), lock, this);
                }
                try {
                    Object object = InteropNodes.execute(this, receiver, args, receivers, translateInteropExceptionNode);
                    return object;
                }
                finally {
                    if (!owned) {
                        MutexOperations.unlockInternal(lock);
                    }
                }
            }
            return InteropNodes.execute(this, receiver, args, receivers, translateInteropExceptionNode);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.DISPATCH_CACHE;
        }
    }

    @Primitive(name="call_with_c_mutex_and_frame_and_unwrap")
    public static abstract class CallWithCExtLockAndFrameAndUnwrapNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Specialization
        Object callWithCExtLockAndFrame(VirtualFrame frame, Object receiver, RubyArray argsArray, Object specialVariables, Object block, @CachedLibrary(limit="getCacheLimit()") InteropLibrary receivers, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Cached InlinedConditionProfile ownedProfile, @Cached MarkingServiceNodes.RunMarkOnExitNode runMarksNode, @Cached UnwrapNode unwrapNode) {
            MarkingService.ExtensionCallStack extensionStack = this.getLanguage().getCurrentFiber().extensionCallStack;
            boolean keywordsGiven = RubyArguments.getDescriptor((Frame)frame) instanceof KeywordArgumentsDescriptor;
            extensionStack.push(keywordsGiven, specialVariables, block);
            Object[] args = arrayToObjectArrayNode.executeToObjectArray(argsArray);
            if (this.getContext().getOptions().CEXT_LOCK) {
                ReentrantLock lock = this.getContext().getCExtensionsLock();
                boolean owned = ownedProfile.profile((Node)this, lock.isHeldByCurrentThread());
                if (!owned) {
                    MutexOperations.lockInternal(this.getContext(), lock, this);
                }
                try {
                    Object object = unwrapNode.execute(this, InteropNodes.execute(this, receiver, args, receivers, translateInteropExceptionNode));
                    return object;
                }
                finally {
                    runMarksNode.execute(this, extensionStack);
                    if (!owned) {
                        MutexOperations.unlockInternal(lock);
                    }
                }
            }
            Object object = unwrapNode.execute(this, InteropNodes.execute(this, receiver, args, receivers, translateInteropExceptionNode));
            runMarksNode.execute(this, extensionStack);
            return object;
            catch (Throwable throwable) {
                runMarksNode.execute(this, extensionStack);
                throw throwable;
            }
            finally {
                extensionStack.pop();
            }
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.DISPATCH_CACHE;
        }
    }

    @Primitive(name="call_with_c_mutex_and_frame")
    public static abstract class CallWithCExtLockAndFrameNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Specialization
        Object callWithCExtLockAndFrame(VirtualFrame frame, Object receiver, RubyArray argsArray, Object specialVariables, Object block, @CachedLibrary(limit="getCacheLimit()") InteropLibrary receivers, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Cached InlinedConditionProfile ownedProfile, @Cached MarkingServiceNodes.RunMarkOnExitNode runMarksNode) {
            extensionStack = this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack;
            keywordsGiven = RubyArguments.getDescriptor((Frame)frame) instanceof KeywordArgumentsDescriptor;
            extensionStack.push(keywordsGiven, specialVariables, block);
            args = arrayToObjectArrayNode.executeToObjectArray(argsArray);
            if (this.getContext().getOptions().CEXT_LOCK) {
                lock = this.getContext().getCExtensionsLock();
                owned = ownedProfile.profile((Node)this, lock.isHeldByCurrentThread());
                if (!owned) {
                    MutexOperations.lockInternal(this.getContext(), lock, this);
                }
                try {
                    var16_17 = InteropNodes.execute(this, receiver, args, receivers, translateInteropExceptionNode);
                    return var16_17;
                }
                finally {
                    runMarksNode.execute(this, extensionStack);
                    if (!owned) {
                        MutexOperations.unlockInternal(lock);
                    }
                }
            }
            ** try [egrp 3[TRYBLOCK] [2 : 155->168)] { 
lbl-1000:
            // 1 sources

            {
                var14_15 = InteropNodes.execute(this, receiver, args, receivers, translateInteropExceptionNode);
                runMarksNode.execute(this, extensionStack);
                return var14_15;
            }
lbl23:
            // 1 sources

            catch (Throwable var18_19) {
                runMarksNode.execute(this, extensionStack);
                throw var18_19;
            }
            finally {
                extensionStack.pop();
            }
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.DISPATCH_CACHE;
        }
    }
}

