/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.array.ArrayCopyOnWriteNode;
import org.truffleruby.core.array.ArrayCopyOnWriteNodeGen;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyNode;

@GeneratedBy(value=ArrayIndexNodes.class)
public final class ArrayIndexNodesFactory {
    private static final LibraryFactory<ArrayStoreLibrary> ARRAY_STORE_LIBRARY_ = LibraryFactory.resolve(ArrayStoreLibrary.class);

    public static List<NodeFactory<ArrayIndexNodes.ReadNormalizedNode>> getFactories() {
        return List.of(ReadNormalizedNodeFactory.getInstance());
    }

    @GeneratedBy(value=ArrayIndexNodes.ReadNormalizedNode.class)
    public static final class ReadNormalizedNodeFactory
    implements NodeFactory<ArrayIndexNodes.ReadNormalizedNode> {
        private static final ReadNormalizedNodeFactory READ_NORMALIZED_NODE_FACTORY_INSTANCE = new ReadNormalizedNodeFactory();

        private ReadNormalizedNodeFactory() {
        }

        public Class<ArrayIndexNodes.ReadNormalizedNode> getNodeClass() {
            return ArrayIndexNodes.ReadNormalizedNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(RubyNode[].class));
        }

        public ArrayIndexNodes.ReadNormalizedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ReadNormalizedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ArrayIndexNodes.ReadNormalizedNode> getInstance() {
            return READ_NORMALIZED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ArrayIndexNodes.ReadNormalizedNode create(RubyNode[] argumentNodes) {
            return new ReadNormalizedNodeGen(argumentNodes);
        }

        @GeneratedBy(value=ArrayIndexNodes.ReadNormalizedNode.class)
        public static final class ReadNormalizedNodeGen
        extends ArrayIndexNodes.ReadNormalizedNode {
            static final InlineSupport.ReferenceField<ReadInBounds0Data> READ_IN_BOUNDS0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"readInBounds0_cache", ReadInBounds0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private ReadInBounds0Data readInBounds0_cache;

            private ReadNormalizedNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            @ExplodeLoop
            public Object executeRead(RubyArray argumentNodes0Value, int argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0) {
                        ReadInBounds0Data s0_ = this.readInBounds0_cache;
                        while (s0_ != null) {
                            Object store__ = argumentNodes0Value.getStore();
                            if (s0_.stores_.accepts(store__) && ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value, argumentNodes1Value)) {
                                return this.readInBounds(argumentNodes0Value, argumentNodes1Value, store__, s0_.stores_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value, argumentNodes1Value)) {
                        return this.readInBounds1Boundary(state_0, argumentNodes0Value, argumentNodes1Value);
                    }
                    if ((state_0 & 4) != 0 && !ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value, argumentNodes1Value)) {
                        return this.readOutOfBounds(argumentNodes0Value, argumentNodes1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value, argumentNodes1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object readInBounds1Boundary(int state_0, RubyArray argumentNodes0Value, int argumentNodes1Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    Object store__ = argumentNodes0Value.getStore();
                    ArrayStoreLibrary stores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(store__);
                    Object object = this.readInBounds(argumentNodes0Value, argumentNodes1Value, store__, stores__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyArray) {
                    RubyArray argumentNodes0Value__ = (RubyArray)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Integer) {
                        int argumentNodes1Value__ = (Integer)argumentNodes1Value_;
                        if ((state_0 & 1) != 0) {
                            ReadInBounds0Data s0_ = this.readInBounds0_cache;
                            while (s0_ != null) {
                                Object store__ = argumentNodes0Value__.getStore();
                                if (s0_.stores_.accepts(store__) && ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value__, argumentNodes1Value__)) {
                                    return this.readInBounds(argumentNodes0Value__, argumentNodes1Value__, store__, s0_.stores_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0 && ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value__, argumentNodes1Value__)) {
                            return this.readInBounds1Boundary0(state_0, argumentNodes0Value__, argumentNodes1Value__);
                        }
                        if ((state_0 & 4) != 0 && !ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value__, argumentNodes1Value__)) {
                            return this.readOutOfBounds(argumentNodes0Value__, argumentNodes1Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object readInBounds1Boundary0(int state_0, RubyArray argumentNodes0Value__, int argumentNodes1Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    Object store__ = argumentNodes0Value__.getStore();
                    ArrayStoreLibrary stores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(store__);
                    Object object = this.readInBounds(argumentNodes0Value__, argumentNodes1Value__, store__, stores__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0;
                int oldState_0 = state_0 = this.state_0_;
                int oldCacheCount = this.countCaches();
                try {
                    if (argumentNodes0Value instanceof RubyArray) {
                        RubyArray argumentNodes0Value_ = (RubyArray)argumentNodes0Value;
                        if (argumentNodes1Value instanceof Integer) {
                            Object object;
                            int argumentNodes1Value_ = (Integer)argumentNodes1Value;
                            Object store__ = null;
                            if ((state_0 & 2) == 0) {
                                ReadInBounds0Data s0_;
                                block18: {
                                    ReadInBounds0Data s0_original;
                                    do {
                                        int count0_ = 0;
                                        s0_original = s0_ = (ReadInBounds0Data)((Object)READ_IN_BOUNDS0_CACHE_UPDATER.getVolatile((Node)this));
                                        while (!(s0_ == null || s0_.stores_.accepts(store__ = argumentNodes0Value_.getStore()) && ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value_, argumentNodes1Value_))) {
                                            ++count0_;
                                            s0_ = s0_.next_;
                                        }
                                        if (s0_ != null || !ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value_, argumentNodes1Value_) || count0_ >= ArrayGuards.storageStrategyLimit()) break block18;
                                        s0_ = (ReadInBounds0Data)this.insert(new ReadInBounds0Data(s0_original));
                                        store__ = argumentNodes0Value_.getStore();
                                        ArrayStoreLibrary stores__ = (ArrayStoreLibrary)s0_.insert((Node)((ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.create(store__)));
                                        Objects.requireNonNull(stores__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.stores_ = stores__;
                                    } while (!READ_IN_BOUNDS0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                                    this.state_0_ = state_0 |= 1;
                                }
                                if (s0_ != null) {
                                    object = this.readInBounds(argumentNodes0Value_, argumentNodes1Value_, store__, s0_.stores_);
                                    return object;
                                }
                            }
                            ArrayStoreLibrary stores__ = null;
                            Object store__2 = null;
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set((Node)this);
                            try {
                                if (ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value_, argumentNodes1Value_)) {
                                    store__2 = argumentNodes0Value_.getStore();
                                    stores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(store__2);
                                    this.readInBounds0_cache = null;
                                    state_0 &= 0xFFFFFFFE;
                                    this.state_0_ = state_0 |= 2;
                                    object = this.readInBounds(argumentNodes0Value_, argumentNodes1Value_, store__2, stores__);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                            if (!ArrayIndexNodes.ReadNormalizedNode.isInBounds(argumentNodes0Value_, argumentNodes1Value_)) {
                                this.state_0_ = state_0 |= 4;
                                Object object2 = this.readOutOfBounds(argumentNodes0Value_, argumentNodes1Value_);
                                return object2;
                            }
                        }
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
                }
                finally {
                    if (oldState_0 != 0) {
                        this.checkForPolymorphicSpecialize(oldState_0, oldCacheCount);
                    }
                }
            }

            private void checkForPolymorphicSpecialize(int oldState_0, int oldCacheCount) {
                int state_0 = this.state_0_;
                int newState_0 = state_0;
                if ((oldState_0 ^ newState_0) != 0 || oldCacheCount < this.countCaches()) {
                    this.reportPolymorphicSpecialize();
                }
            }

            private int countCaches() {
                int cacheCount = 0;
                ReadInBounds0Data s0_ = this.readInBounds0_cache;
                while (s0_ != null) {
                    ++cacheCount;
                    s0_ = s0_.next_;
                }
                return cacheCount;
            }

            @GeneratedBy(value=ArrayIndexNodes.ReadNormalizedNode.class)
            @DenyReplace
            private static final class ReadInBounds0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ReadInBounds0Data next_;
                @Node.Child
                ArrayStoreLibrary stores_;

                ReadInBounds0Data(ReadInBounds0Data next_) {
                    this.next_ = next_;
                }
            }
        }
    }

    @GeneratedBy(value=ArrayIndexNodes.ReadSliceNormalizedNode.class)
    public static final class ReadSliceNormalizedNodeGen
    extends ArrayIndexNodes.ReadSliceNormalizedNode {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private ArrayCopyOnWriteNode readInBounds_cowNode_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile readInBounds_endsInBoundsProfile_;

        private ReadSliceNormalizedNodeGen() {
        }

        @Override
        public Object executeReadSlice(RubyArray arg0Value, int arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                ConditionProfile endsInBoundsProfile__;
                ArrayCopyOnWriteNode cowNode__;
                if ((state_0 & 1) != 0 && !ArrayIndexNodes.ReadSliceNormalizedNode.indexInBounds(arg0Value, arg1Value)) {
                    return this.readIndexOutOfBounds(arg0Value, arg1Value, arg2Value);
                }
                if ((state_0 & 2) != 0 && arg2Value < 0) {
                    return this.readNegativeLength(arg0Value, arg1Value, arg2Value);
                }
                if ((state_0 & 4) != 0 && (cowNode__ = this.readInBounds_cowNode_) != null && (endsInBoundsProfile__ = this.readInBounds_endsInBoundsProfile_) != null && ArrayIndexNodes.ReadSliceNormalizedNode.indexInBounds(arg0Value, arg1Value) && arg2Value >= 0) {
                    return this.readInBounds(arg0Value, arg1Value, arg2Value, cowNode__, endsInBoundsProfile__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(RubyArray arg0Value, int arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (!ArrayIndexNodes.ReadSliceNormalizedNode.indexInBounds(arg0Value, arg1Value)) {
                this.state_0_ = state_0 |= 1;
                return this.readIndexOutOfBounds(arg0Value, arg1Value, arg2Value);
            }
            if (arg2Value < 0) {
                this.state_0_ = state_0 |= 2;
                return this.readNegativeLength(arg0Value, arg1Value, arg2Value);
            }
            if (ArrayIndexNodes.ReadSliceNormalizedNode.indexInBounds(arg0Value, arg1Value) && arg2Value >= 0) {
                ArrayCopyOnWriteNode cowNode__ = (ArrayCopyOnWriteNode)this.insert(ArrayCopyOnWriteNodeGen.create());
                Objects.requireNonNull(cowNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.readInBounds_cowNode_ = cowNode__;
                ConditionProfile endsInBoundsProfile__ = ConditionProfile.create();
                Objects.requireNonNull(endsInBoundsProfile__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.readInBounds_endsInBoundsProfile_ = endsInBoundsProfile__;
                this.state_0_ = state_0 |= 4;
                return this.readInBounds(arg0Value, arg1Value, arg2Value, cowNode__, endsInBoundsProfile__);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        @NeverDefault
        public static ArrayIndexNodes.ReadSliceNormalizedNode create() {
            return new ReadSliceNormalizedNodeGen();
        }
    }

    @GeneratedBy(value=ArrayIndexNodes.ReadConstantIndexNode.class)
    public static final class ReadConstantIndexNodeGen
    extends ArrayIndexNodes.ReadConstantIndexNode {
        static final InlineSupport.ReferenceField<ReadInBounds0Data> READ_IN_BOUNDS0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"readInBounds0_cache", ReadInBounds0Data.class);
        @Node.Child
        private RubyNode arrayNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        @InlineSupport.UnsafeAccessedField
        private ReadInBounds0Data readInBounds0_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile readInBounds1_isInBounds_;

        private ReadConstantIndexNodeGen(int index, RubyNode arrayNode) {
            super(index);
            this.arrayNode_ = arrayNode;
        }

        @Override
        public RubyNode getArrayNode() {
            return this.arrayNode_;
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arrayNodeValue_ = this.arrayNode_.execute(frameValue);
            if (state_0 != 0 && arrayNodeValue_ instanceof RubyArray) {
                ConditionProfile isInBounds__;
                RubyArray arrayNodeValue__ = (RubyArray)arrayNodeValue_;
                if ((state_0 & 1) != 0) {
                    ReadInBounds0Data s0_ = this.readInBounds0_cache;
                    while (s0_ != null) {
                        Object store__ = arrayNodeValue__.getStore();
                        if (s0_.stores_.accepts(store__)) {
                            return this.readInBounds(arrayNodeValue__, store__, s0_.stores_, s0_.isInBounds_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 2) != 0 && (isInBounds__ = this.readInBounds1_isInBounds_) != null) {
                    return this.readInBounds1Boundary(state_0, arrayNodeValue__, isInBounds__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arrayNodeValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object readInBounds1Boundary(int state_0, RubyArray arrayNodeValue__, ConditionProfile isInBounds__) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                Object store__ = arrayNodeValue__.getStore();
                ArrayStoreLibrary stores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(store__);
                Object object = this.readInBounds(arrayNodeValue__, store__, stores__, isInBounds__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arrayNodeValue) {
            int state_0;
            int oldState_0 = state_0 = this.state_0_;
            int oldCacheCount = this.countCaches();
            try {
                if (arrayNodeValue instanceof RubyArray) {
                    RubyArray arrayNodeValue_ = (RubyArray)arrayNodeValue;
                    Object store__ = null;
                    if ((state_0 & 2) == 0) {
                        Object stores__;
                        ReadInBounds0Data s0_;
                        block14: {
                            ReadInBounds0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (ReadInBounds0Data)((Object)READ_IN_BOUNDS0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.stores_.accepts(store__ = arrayNodeValue_.getStore())) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= ArrayGuards.storageStrategyLimit()) break block14;
                                s0_ = (ReadInBounds0Data)this.insert(new ReadInBounds0Data(s0_original));
                                store__ = arrayNodeValue_.getStore();
                                stores__ = (ArrayStoreLibrary)s0_.insert((Node)((ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.create(store__)));
                                Objects.requireNonNull(stores__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.stores_ = stores__;
                                ConditionProfile isInBounds__ = ConditionProfile.create();
                                Objects.requireNonNull(isInBounds__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s0_.isInBounds_ = isInBounds__;
                            } while (!READ_IN_BOUNDS0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            stores__ = this.readInBounds(arrayNodeValue_, store__, s0_.stores_, s0_.isInBounds_);
                            return stores__;
                        }
                    }
                    ArrayStoreLibrary stores__ = null;
                    Object store__2 = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        store__2 = arrayNodeValue_.getStore();
                        stores__ = (ArrayStoreLibrary)ARRAY_STORE_LIBRARY_.getUncached(store__2);
                        ConditionProfile isInBounds__ = ConditionProfile.create();
                        Objects.requireNonNull(isInBounds__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.readInBounds1_isInBounds_ = isInBounds__;
                        this.readInBounds0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Object object = this.readInBounds(arrayNodeValue_, store__2, stores__, isInBounds__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arrayNode_}, new Object[]{arrayNodeValue});
            }
            finally {
                if (oldState_0 != 0) {
                    this.checkForPolymorphicSpecialize(oldState_0, oldCacheCount);
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState_0, int oldCacheCount) {
            int state_0 = this.state_0_;
            int newState_0 = state_0;
            if ((oldState_0 ^ newState_0) != 0 || oldCacheCount < this.countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            ReadInBounds0Data s0_ = this.readInBounds0_cache;
            while (s0_ != null) {
                ++cacheCount;
                s0_ = s0_.next_;
            }
            return cacheCount;
        }

        @NeverDefault
        public static ArrayIndexNodes.ReadConstantIndexNode create(int index, RubyNode arrayNode) {
            return new ReadConstantIndexNodeGen(index, arrayNode);
        }

        @GeneratedBy(value=ArrayIndexNodes.ReadConstantIndexNode.class)
        @DenyReplace
        private static final class ReadInBounds0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            ReadInBounds0Data next_;
            @Node.Child
            ArrayStoreLibrary stores_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile isInBounds_;

            ReadInBounds0Data(ReadInBounds0Data next_) {
                this.next_ = next_;
            }
        }
    }
}

