/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.truffleruby.Layouts;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.SimpleStack;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.Hashing;
import org.truffleruby.core.array.ArrayAppendManyNode;
import org.truffleruby.core.array.ArrayAppendOneNode;
import org.truffleruby.core.array.ArrayBuilderNode;
import org.truffleruby.core.array.ArrayConvertNode;
import org.truffleruby.core.array.ArrayCopyCompatibleRangeNode;
import org.truffleruby.core.array.ArrayCopyOnWriteNode;
import org.truffleruby.core.array.ArrayCoreMethodNode;
import org.truffleruby.core.array.ArrayEachIteratorNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.ArrayNodesFactory;
import org.truffleruby.core.array.ArrayPopOneNode;
import org.truffleruby.core.array.ArrayPrepareForCopyNode;
import org.truffleruby.core.array.ArrayTruncateNode;
import org.truffleruby.core.array.ArrayWriteNormalizedNode;
import org.truffleruby.core.array.ArrayWriteNormalizedNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.NativeArrayStorage;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.CmpIntNode;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.cast.ToAryNode;
import org.truffleruby.core.cast.ToIntNode;
import org.truffleruby.core.cast.ToLongNode;
import org.truffleruby.core.cast.ToStrNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.format.BytesResult;
import org.truffleruby.core.format.FormatExceptionTranslator;
import org.truffleruby.core.format.FormatRootNode;
import org.truffleruby.core.format.exceptions.FormatException;
import org.truffleruby.core.format.pack.PackCompiler;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.FixnumLowerNode;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.range.RangeNodes;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.support.TypeNodes;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.WarningNode;
import org.truffleruby.language.arguments.NoKeywordArgumentsDescriptor;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.WriteObjectFieldNode;
import org.truffleruby.language.objects.shared.IsSharedNode;
import org.truffleruby.language.objects.shared.PropagateSharingNode;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.utils.Utils;

@CoreModule(value="Array", isClass=true)
public abstract class ArrayNodes {
    protected static void rotateArrayCopy(int rotation, int size, ArrayStoreLibrary arrays, Object original, Object rotated) {
        arrays.copyContents(original, rotation, rotated, 0, size - rotation);
        arrays.copyContents(original, 0, rotated, size - rotation, rotation);
    }

    @Primitive(name="array_can_contain_object?")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ArrayCanContainObjectNode
    extends PrimitiveArrayArgumentsNode {
        @NeverDefault
        public static ArrayCanContainObjectNode create() {
            return ArrayNodesFactory.ArrayCanContainObjectNodeFactory.create(null);
        }

        public abstract boolean execute(RubyArray var1);

        @Specialization(limit="storageStrategyLimit()")
        boolean array(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return !stores.isPrimitive(store);
        }

        @Specialization(guards={"!isRubyArray(array)"})
        boolean other(Object array) {
            return true;
        }
    }

    @Primitive(name="array_flatten_helper", lowerFixnum={2})
    public static abstract class FlattenHelperNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"!canContainObject.execute(array)"}, limit="1")
        boolean flattenHelperPrimitive(RubyArray array, RubyArray out, int maxLevels, @Cached @Cached.Exclusive ArrayAppendManyNode concat, @Cached @Cached.Exclusive ArrayCanContainObjectNode canContainObject) {
            concat.executeAppendMany(out, array);
            return false;
        }

        @Specialization(replaces={"flattenHelperPrimitive"})
        boolean flattenHelper(RubyArray array, RubyArray out, int maxLevels, @Cached @Cached.Exclusive ArrayCanContainObjectNode canContainObject, @Cached @Cached.Exclusive ArrayAppendManyNode concat, @Cached AtNode at, @Cached DispatchNode convert, @Cached ArrayAppendOneNode append) {
            boolean modified = false;
            EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            SimpleStack<Entry> workStack = new SimpleStack<Entry>();
            workStack.push(new Entry(array, 0));
            while (!workStack.isEmpty()) {
                int i;
                Entry e = (Entry)workStack.pop();
                if (e.index == 0) {
                    if (!canContainObject.execute(e.array)) {
                        concat.executeAppendMany(out, e.array);
                        continue;
                    }
                    if (FlattenHelperNode.contains((EconomicSet<RubyArray>)visited, e.array)) {
                        throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("tried to flatten recursive array", this));
                    }
                    if (maxLevels == workStack.size()) {
                        concat.executeAppendMany(out, e.array);
                        continue;
                    }
                    FlattenHelperNode.add((EconomicSet<RubyArray>)visited, e.array);
                }
                for (i = e.index; i < e.array.size; ++i) {
                    Object obj = at.executeAt(e.array, i);
                    Object converted = convert.call(this.coreLibrary().truffleTypeModule, "rb_check_convert_type", obj, (Object)this.coreLibrary().arrayClass, (Object)this.coreSymbols().TO_ARY);
                    if (converted != nil) {
                        modified = true;
                        workStack.push(new Entry(e.array, i + 1));
                        workStack.push(new Entry((RubyArray)converted, 0));
                        break;
                    }
                    append.executeAppendOne(out, obj);
                }
                if (i != e.array.size) continue;
                FlattenHelperNode.remove((EconomicSet<RubyArray>)visited, e.array);
            }
            return modified;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean contains(EconomicSet<RubyArray> set, RubyArray array) {
            return set.contains((Object)array);
        }

        @CompilerDirectives.TruffleBoundary
        private static void remove(EconomicSet<RubyArray> set, RubyArray array) {
            set.remove((Object)array);
        }

        @CompilerDirectives.TruffleBoundary
        private static void add(EconomicSet<RubyArray> set, RubyArray array) {
            set.add((Object)array);
        }

        static final class Entry {
            final RubyArray array;
            final int index;

            private Entry(RubyArray array, int index) {
                this.array = array;
                this.index = index;
            }
        }
    }

    @Primitive(name="array_mark_store")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MarkNativeStoreNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object markNativeStore(RubyArray array) {
            Object store = array.getStore();
            if (store instanceof NativeArrayStorage) {
                ((NativeArrayStorage)store).preserveMembers();
            }
            return nil;
        }
    }

    @Primitive(name="array_store_native?")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class IsStoreNativeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="storageStrategyLimit()")
        boolean isStoreNative(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return stores.isNative(store);
        }

        @Specialization(guards={"!isRubyArray(array)"})
        boolean isStoreNativeNonArray(Object array) {
            return false;
        }
    }

    @Primitive(name="array_store_address")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class StoreAddressNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"stores.isNative(store)"}, limit="storageStrategyLimit()")
        long storeIsNative(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            NativeArrayStorage storage = (NativeArrayStorage)store;
            return storage.getAddress();
        }

        @Specialization(guards={"!stores.isNative(store)"}, limit="storageStrategyLimit()")
        Object storeNotNative(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return DispatchNode.MISSING;
        }
    }

    @Primitive(name="array_store_to_native")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class StoreToNativeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"!stores.isNative(store)"}, limit="storageStrategyLimit()")
        RubyArray storeToNative(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached IntValueProfile arraySizeProfile) {
            int size = arraySizeProfile.profile(array.size);
            Pointer pointer = Pointer.mallocAutoRelease(this.getLanguage(), this.getContext(), (long)size * 8L);
            NativeArrayStorage newStore = new NativeArrayStorage(pointer, size);
            stores.copyContents(store, 0, newStore, 0, size);
            array.setStore(newStore);
            return array;
        }

        @Specialization(guards={"stores.isNative(store)"}, limit="storageStrategyLimit()")
        RubyArray storeIsNative(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return array;
        }
    }

    @Primitive(name="array_zip")
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class ZipNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="storageStrategyLimit()")
        RubyArray zipToPairs(RubyArray array, RubyArray other, @Bind(value="array.getStore()") Object a, @Bind(value="other.getStore()") Object b, @CachedLibrary(value="a") ArrayStoreLibrary aStores, @CachedLibrary(value="b") ArrayStoreLibrary bStores, @CachedLibrary(limit="1") ArrayStoreLibrary pairs, @Cached ConditionProfile bNotSmallerProfile, @Cached IntValueProfile arraySizeProfile, @Cached LoopConditionProfile loopProfile) {
            int zippedLength = arraySizeProfile.profile(array.size);
            int bSize = other.size;
            Object[] zipped = new Object[zippedLength];
            int n = 0;
            try {
                while (loopProfile.inject(n < zippedLength)) {
                    if (bNotSmallerProfile.profile(n < bSize)) {
                        Object pair = aStores.unsharedAllocateForNewStore(a, b, 2);
                        pairs.write(pair, 0, aStores.read(a, n));
                        pairs.write(pair, 1, bStores.read(b, n));
                        zipped[n] = this.createArray(pair, 2);
                    } else {
                        zipped[n] = this.createArray(new Object[]{aStores.read(a, n), nil});
                    }
                    TruffleSafepoint.poll((Node)this);
                    ++n;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, n);
            }
            return this.createArray(zipped, zippedLength);
        }
    }

    @Primitive(name="steal_array_storage")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class StealArrayStorageNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"array == other"})
        RubyArray stealStorageNoOp(RubyArray array, RubyArray other) {
            return array;
        }

        @Specialization(guards={"array != other"})
        static RubyArray stealStorage(RubyArray array, RubyArray other, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary stores, @Cached PropagateSharingNode propagateSharingNode, @Bind(value="this") Node node) {
            propagateSharingNode.execute(node, array, other);
            int size = other.size;
            Object store = other.getStore();
            ArrayHelpers.setStoreAndSize(array, store, size);
            ArrayHelpers.setStoreAndSize(other, stores.initialStore(store), 0);
            return array;
        }
    }

    @CoreMethod(names={"unshift"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class UnshiftNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"rest.length == 0"})
        Object unshiftNothing(RubyArray array, Object[] rest) {
            return array;
        }

        @Specialization(guards={"rest.length != 0"})
        Object unshift(RubyArray array, Object[] rest, @Cached ArrayPrepareForCopyNode resize, @Cached ArrayCopyCompatibleRangeNode moveElements, @Cached ArrayCopyCompatibleRangeNode copyUnshifted, @Cached ArrayTruncateNode truncate) {
            int originalSize = array.size;
            RubyArray prepended = this.createArray(rest);
            int prependedSize = prepended.size;
            int newSize = originalSize + prependedSize;
            Object newStore = resize.execute(array, prepended, 0, newSize);
            moveElements.execute(newStore, newStore, prependedSize, 0, originalSize);
            copyUnshifted.execute(newStore, prepended.getStore(), 0, 0, prependedSize);
            truncate.execute(array, newSize);
            return array;
        }
    }

    @CoreMethod(names={"sort"}, needsBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class SortNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"isEmptyArray(array)"})
        RubyArray sortEmpty(RubyArray array, Object unusedBlock) {
            return this.createEmptyArray();
        }

        @ExplodeLoop
        @Specialization(guards={"!isEmptyArray(array)", "isSmall(array)"}, limit="storageStrategyLimit()")
        static RubyArray sortVeryShort(VirtualFrame frame, RubyArray array, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") @Cached.Exclusive ArrayStoreLibrary newStores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Exclusive DispatchNode compareDispatchNode, @Cached CmpIntNode cmpIntNode, @Bind(value="this") Node node) {
            int i;
            Object newStore = stores.unsharedAllocator(store).allocate(SortNode.getContext((Node)node).getOptions().ARRAY_SMALL);
            int size = arraySizeProfile.profile(array.size);
            for (i = 0; i < SortNode.getContext((Node)node).getOptions().ARRAY_SMALL; ++i) {
                if (i >= size) continue;
                newStores.write(newStore, i, stores.read(store, i));
            }
            for (i = 0; i < SortNode.getContext((Node)node).getOptions().ARRAY_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < SortNode.getContext((Node)node).getOptions().ARRAY_SMALL; ++j) {
                    if (j >= size) continue;
                    Object a = newStores.read(newStore, i);
                    Object b = newStores.read(newStore, j);
                    Object comparisonResult = compareDispatchNode.call(b, "<=>", a);
                    if (cmpIntNode.executeCmpInt(node, comparisonResult, b, a) >= 0) continue;
                    newStores.write(newStore, j, a);
                    newStores.write(newStore, i, b);
                }
            }
            return SortNode.createArray(node, newStore, size);
        }

        @Specialization(guards={"!isEmptyArray(array)", "!isSmall(array)", "stores.isPrimitive(store)"}, assumptions={"getLanguage().coreMethodAssumptions.integerCmpAssumption", "getLanguage().coreMethodAssumptions.floatCmpAssumption"}, limit="storageStrategyLimit()")
        Object sortPrimitiveArrayNoBlock(RubyArray array, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") @Cached.Exclusive ArrayStoreLibrary mutableStores, @Cached @Cached.Shared IntValueProfile arraySizeProfile) {
            int size = arraySizeProfile.profile(array.size);
            Object newStore = stores.unsharedAllocator(store).allocate(size);
            stores.copyContents(store, 0, newStore, 0, size);
            mutableStores.sort(newStore, size);
            return this.createArray(newStore, size);
        }

        @Specialization(guards={"!isEmptyArray(array)", "!isSmall(array)"}, limit="storageStrategyLimit()")
        Object sortArrayWithoutBlock(RubyArray array, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared DispatchNode fallbackNode) {
            return fallbackNode.call(array, "sort_fallback");
        }

        @Specialization(guards={"!isEmptyArray(array)"})
        Object sortGenericWithBlock(RubyArray array, RubyProc block, @Cached @Cached.Shared DispatchNode fallbackNode) {
            return fallbackNode.callWithBlock(array, "sort_fallback", block);
        }

        protected boolean isSmall(RubyArray array) {
            return array.size <= this.getContext().getOptions().ARRAY_SMALL;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends ArrayCoreMethodNode {
        @Specialization
        int size(RubyArray array, @Cached IntValueProfile arraySizeProfile) {
            return arraySizeProfile.profile(array.size);
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true, optional=1, lowerFixnum={1})
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class ShiftNode
    extends CoreMethodArrayArgumentsNode {
        public abstract Object executeShift(RubyArray var1, Object var2);

        @Specialization(guards={"isEmptyArray(array)"})
        @ReportPolymorphism.Exclude
        Object shiftEmpty(RubyArray array, NotProvided n) {
            return nil;
        }

        @Specialization(guards={"!isEmptyArray(array)"}, limit="storageStrategyLimit()")
        Object shiftOther(RubyArray array, NotProvided n, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            int size = array.size;
            Object value = stores.read(store, 0);
            stores.clear(store, 0, 1);
            ArrayHelpers.setStoreAndSize(array, stores.extractRange(store, 1, size), size - 1);
            return value;
        }

        @Specialization(guards={"n < 0"})
        Object shiftNegative(RubyArray array, int n) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorNegativeArraySize(this));
        }

        @Specialization(guards={"n == 0"})
        Object shiftZero(RubyArray array, int n) {
            return this.createEmptyArray();
        }

        @Specialization(guards={"n > 0", "isEmptyArray(array)"})
        Object shiftManyEmpty(RubyArray array, int n) {
            return this.createEmptyArray();
        }

        @Specialization(guards={"n > 0", "!isEmptyArray(array)"}, limit="storageStrategyLimit()")
        Object shiftMany(RubyArray array, int n, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached ConditionProfile minProfile) {
            int size = array.size;
            int numShift = minProfile.profile(size < n) ? size : n;
            Object result = stores.extractRangeAndUnshare(store, 0, numShift);
            Object newStore = stores.extractRange(store, numShift, size);
            ArrayHelpers.setStoreAndSize(array, newStore, size - numShift);
            return this.createArray(result, numShift);
        }

        @Specialization(guards={"wasProvided(n)", "!isInteger(n)"})
        Object shiftNToInt(RubyArray array, Object n, @Cached ToIntNode toIntNode) {
            return this.executeShift(array, toIntNode.execute(n));
        }
    }

    @CoreMethod(names={"select", "filter"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class SelectNode
    extends CoreMethodArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder = ArrayBuilderNode.create();

        @Specialization
        Object select(RubyArray array, RubyProc block, @Cached ArrayEachIteratorNode iteratorNode, @Cached InlinedIntValueProfile arraySizeProfile) {
            ArrayBuilderNode.BuilderState builderState = this.arrayBuilder.start(arraySizeProfile.profile((Node)this, array.size));
            State iterationState = new State(builderState, 0, block);
            iteratorNode.execute(this, array, iterationState, 0, this);
            int selectedSize = iterationState.selectedSize;
            return this.createArray(this.arrayBuilder.finish(builderState, selectedSize), selectedSize);
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object stateObject, Object element, int index, BooleanCastNode booleanCastNode) {
            State state = (State)stateObject;
            if (booleanCastNode.execute(node, yieldNode.yield(node, state.block, element))) {
                this.arrayBuilder.appendValue(state.builderState, state.selectedSize, element);
                ++state.selectedSize;
            }
        }

        private static final class State {
            final ArrayBuilderNode.BuilderState builderState;
            int selectedSize;
            final RubyProc block;

            State(ArrayBuilderNode.BuilderState builderState, int selectedSize, RubyProc block) {
                this.builderState = builderState;
                this.selectedSize = selectedSize;
                this.block = block;
            }
        }
    }

    @Primitive(name="array_rotate_inplace", lowerFixnum={1})
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class RotateInplaceNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"stores.isMutable(store)"}, limit="storageStrategyLimit()")
        RubyArray rotate(RubyArray array, int rotation, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Shared IntValueProfile rotationProfile, @Cached LoopConditionProfile loop1Profile, @Cached LoopConditionProfile loop2Profile, @Cached LoopConditionProfile loop3Profile) {
            int size = arraySizeProfile.profile(array.size);
            rotation = rotationProfile.profile(rotation);
            assert (0 < rotation && rotation < size);
            if (CompilerDirectives.isPartialEvaluationConstant((Object)size) && CompilerDirectives.isPartialEvaluationConstant((Object)rotation) && size <= 16) {
                this.rotateSmallExplode(stores, rotation, size, store);
            } else {
                this.rotateReverse(stores, rotation, size, store, loop1Profile, loop2Profile, loop3Profile);
            }
            return array;
        }

        @Specialization(guards={"!stores.isMutable(store)"}, limit="storageStrategyLimit()")
        RubyArray rotateStorageNotMutable(RubyArray array, int rotation, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Shared IntValueProfile rotationProfile) {
            int size = arraySizeProfile.profile(array.size);
            rotation = rotationProfile.profile(rotation);
            assert (0 < rotation && rotation < size);
            Object rotated = stores.allocator(store).allocate(size);
            ArrayNodes.rotateArrayCopy(rotation, size, stores, store, rotated);
            ArrayHelpers.setStoreAndSize(array, rotated, size);
            return array;
        }

        @ExplodeLoop
        protected void rotateSmallExplode(ArrayStoreLibrary stores, int rotation, int size, Object store) {
            int i;
            Object[] copy = new Object[size];
            for (i = 0; i < size; ++i) {
                copy[i] = stores.read(store, i);
            }
            for (i = 0; i < size; ++i) {
                int j = i + rotation;
                if (j >= size) {
                    j -= size;
                }
                stores.write(store, i, copy[j]);
            }
        }

        protected void rotateReverse(ArrayStoreLibrary stores, int rotation, int size, Object store, LoopConditionProfile loop1Profile, LoopConditionProfile loop2Profile, LoopConditionProfile loop3Profile) {
            this.reverse(stores, store, rotation, size, loop1Profile);
            this.reverse(stores, store, 0, rotation, loop2Profile);
            this.reverse(stores, store, 0, size, loop3Profile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reverse(ArrayStoreLibrary stores, Object store, int from, int until, LoopConditionProfile loopProfile) {
            int to = until - 1;
            int loopCount = until - from >> 1;
            try {
                while (loopProfile.inject(from < to)) {
                    Object tmp = stores.read(store, from);
                    stores.write(store, from, stores.read(store, to));
                    stores.write(store, to, tmp);
                    ++from;
                    --to;
                    TruffleSafepoint.poll((Node)this);
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, loopCount);
            }
        }
    }

    @Primitive(name="array_rotate", lowerFixnum={1})
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class RotateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="storageStrategyLimit()")
        RubyArray rotate(RubyArray array, int rotation, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached IntValueProfile arraySizeProfile, @Cached IntValueProfile rotationProfile) {
            int size = arraySizeProfile.profile(array.size);
            rotation = rotationProfile.profile(rotation);
            assert (0 < rotation && rotation < size);
            Object rotated = stores.unsharedAllocator(store).allocate(size);
            ArrayNodes.rotateArrayCopy(rotation, size, stores, store, rotated);
            return this.createArray(rotated, size);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="other", type=RubyBaseNodeWithExecute.class)})
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        @NeverDefault
        public static ReplaceNode create() {
            return ArrayNodesFactory.ReplaceNodeFactory.create(null, null);
        }

        public abstract RubyArray executeReplace(RubyArray var1, RubyArray var2);

        @Specialization
        RubyArray replace(RubyArray array, Object otherObject, @Cached ToAryNode toAryNode, @Cached ArrayCopyOnWriteNode cowNode, @Cached IsSharedNode isSharedNode, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary stores) {
            RubyArray other = toAryNode.execute(this, otherObject);
            int size = other.size;
            Object store = cowNode.execute(other, 0, size);
            if (isSharedNode.execute(this, array)) {
                store = stores.makeShared(store, size);
            }
            ArrayHelpers.setStoreAndSize(array, store, size);
            return array;
        }
    }

    @CoreMethod(names={"reject"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectNode
    extends CoreMethodArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder = ArrayBuilderNode.create();

        @Specialization
        Object reject(RubyArray array, RubyProc block, @Cached ArrayEachIteratorNode iteratorNode, @Cached InlinedIntValueProfile arraySizeProfile) {
            ArrayBuilderNode.BuilderState builderState = this.arrayBuilder.start(arraySizeProfile.profile((Node)this, array.size));
            State iterationState = new State(builderState, 0, block);
            iteratorNode.execute(this, array, iterationState, 0, this);
            int actualSize = iterationState.newArraySize;
            return this.createArray(this.arrayBuilder.finish(builderState, actualSize), actualSize);
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object stateObject, Object element, int index, BooleanCastNode booleanCastNode) {
            State state = (State)stateObject;
            if (!booleanCastNode.execute(node, yieldNode.yield(node, state.block, element))) {
                this.arrayBuilder.appendValue(state.builderState, state.newArraySize, element);
                ++state.newArraySize;
            }
        }

        private static final class State {
            final ArrayBuilderNode.BuilderState builderState;
            int newArraySize;
            final RubyProc block;

            State(ArrayBuilderNode.BuilderState builderState, int newArraySize, RubyProc block) {
                this.builderState = builderState;
                this.newArraySize = newArraySize;
                this.block = block;
            }
        }
    }

    @CoreMethod(names={"push", "append"}, rest=true, optional=1, raiseIfFrozenSelf=true)
    public static abstract class PushNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayAppendOneNode appendOneNode = ArrayAppendOneNode.create();

        @Specialization(guards={"rest.length == 0"})
        RubyArray pushZero(RubyArray array, NotProvided value, Object[] rest) {
            return array;
        }

        @Specialization(guards={"rest.length == 0", "wasProvided(value)"})
        RubyArray pushOne(RubyArray array, Object value, Object[] rest) {
            return this.appendOneNode.executeAppendOne(array, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"rest.length > 0", "wasProvided(value)"})
        RubyArray pushMany(VirtualFrame frame, RubyArray array, Object value, Object[] rest, @Cached LoopConditionProfile loopProfile) {
            this.appendOneNode.executeAppendOne(array, value);
            int i = 0;
            try {
                while (loopProfile.inject(i < rest.length)) {
                    this.appendOneNode.executeAppendOne(array, rest[i]);
                    TruffleSafepoint.poll((Node)this);
                    ++i;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, i);
            }
            return array;
        }
    }

    @CoreMethod(names={"<<"}, raiseIfFrozenSelf=true, required=1, split=Split.ALWAYS)
    public static abstract class AppendNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayAppendOneNode appendOneNode = ArrayAppendOneNode.create();

        @Specialization
        RubyArray append(RubyArray array, Object value) {
            return this.appendOneNode.executeAppendOne(array, value);
        }
    }

    @CoreMethod(names={"pop"}, raiseIfFrozenSelf=true, optional=1, lowerFixnum={1})
    @ReportPolymorphism
    public static abstract class PopNode
    extends ArrayCoreMethodNode {
        public abstract Object executePop(RubyArray var1, Object var2);

        @Specialization
        @ReportPolymorphism.Exclude
        Object pop(RubyArray array, NotProvided n, @Cached ArrayPopOneNode popOneNode) {
            return popOneNode.executePopOne(array);
        }

        @Specialization(guards={"n < 0"})
        @ReportPolymorphism.Exclude
        Object popNNegative(RubyArray array, int n) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorNegativeArraySize(this));
        }

        @Specialization(guards={"n >= 0", "isEmptyArray(array)"})
        @ReportPolymorphism.Exclude
        RubyArray popEmpty(RubyArray array, int n) {
            return this.createEmptyArray();
        }

        @Specialization(guards={"n == 0", "!isEmptyArray(array)"})
        @ReportPolymorphism.Exclude
        RubyArray popZeroNotEmpty(RubyArray array, int n) {
            return this.createEmptyArray();
        }

        @Specialization(guards={"n > 0", "!isEmptyArray(array)", "!stores.isMutable(array.getStore())"}, limit="storageStrategyLimit()")
        RubyArray popNotEmptySharedStorage(RubyArray array, int n, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Shared ConditionProfile minProfile) {
            int size = arraySizeProfile.profile(array.size);
            int numPop = minProfile.profile(size < n) ? size : n;
            Object popped = stores.extractRangeAndUnshare(store, size - numPop, size);
            Object prefix = stores.extractRange(store, 0, size - numPop);
            ArrayHelpers.setStoreAndSize(array, prefix, size - numPop);
            return this.createArray(popped, numPop);
        }

        @Specialization(guards={"n > 0", "!isEmptyArray(array)", "stores.isMutable(array.getStore())"}, limit="storageStrategyLimit()")
        RubyArray popNotEmptyUnsharedStorage(RubyArray array, int n, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Shared ConditionProfile minProfile) {
            int size = arraySizeProfile.profile(array.size);
            int numPop = minProfile.profile(size < n) ? size : n;
            Object popped = stores.unsharedAllocator(store).allocate(numPop);
            stores.copyContents(store, size - numPop, popped, 0, numPop);
            stores.clear(store, size - numPop, numPop);
            ArrayHelpers.setSize(array, size - numPop);
            return this.createArray(popped, numPop);
        }

        @Specialization(guards={"wasProvided(n)", "!isInteger(n)"})
        Object popNToInt(RubyArray array, Object n, @Cached ToIntNode toIntNode) {
            return this.executePop(array, toIntNode.execute(n));
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @ReportPolymorphism
    public static abstract class PackNode
    extends RubyBaseNode {
        public abstract RubyString execute(Node var1, RubyArray var2, Object var3, Object var4);

        @Specialization(guards={"libFormat.isRubyString(this, format)", "libBuffer.isRubyString(this, buffer)", "equalNode.execute(libFormat, format, cachedFormat, cachedEncoding)"}, limit="getCacheLimit()")
        static RubyString packCached(Node node, RubyArray array, Object format, Object buffer, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile, @Cached @Cached.Shared InlinedConditionProfile resizeProfile, @Cached @Cached.Shared RubyStringLibrary libFormat, @Cached @Cached.Shared RubyStringLibrary libBuffer, @Cached @Cached.Shared WriteObjectFieldNode writeAssociatedNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached(value="asTruffleStringUncached(format)") TruffleString cachedFormat, @Cached(value="libFormat.getEncoding(this, format)") RubyEncoding cachedEncoding, @Cached(value="cachedFormat.byteLength(cachedEncoding.tencoding)") int cachedFormatLength, @Cached(value="compileFormat(node, getJavaString(format))") RootCallTarget formatCallTarget, @Cached(value="create(formatCallTarget)") DirectCallNode callPackNode, @Cached StringHelperNodes.EqualNode equalNode) {
            BytesResult result;
            byte[] bytes = PackNode.initOutputBytes(buffer, libBuffer, formatCallTarget, copyToByteArrayNode, node);
            try {
                result = (BytesResult)callPackNode.call(new Object[]{array.getStore(), array.size, bytes, libBuffer.byteLength(node, buffer)});
            }
            catch (FormatException e) {
                exceptionProfile.enter(node);
                throw FormatExceptionTranslator.translate(PackNode.getContext(node), node, e);
            }
            return PackNode.finishPack(node, cachedFormatLength, result, resizeProfile, writeAssociatedNode, fromByteArrayNode);
        }

        @Specialization(guards={"libFormat.isRubyString(this, format)", "libBuffer.isRubyString(this, buffer)"}, replaces={"packCached"})
        static RubyString packUncached(Node node, RubyArray array, Object format, Object buffer, @Cached @Cached.Shared InlinedBranchProfile exceptionProfile, @Cached @Cached.Shared InlinedConditionProfile resizeProfile, @Cached @Cached.Shared RubyStringLibrary libFormat, @Cached @Cached.Shared RubyStringLibrary libBuffer, @Cached @Cached.Shared WriteObjectFieldNode writeAssociatedNode, @Cached @Cached.Shared TruffleString.FromByteArrayNode fromByteArrayNode, @Cached @Cached.Shared TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached ToJavaStringNode toJavaStringNode, @Cached IndirectCallNode callPackNode) {
            BytesResult result;
            String formatString = toJavaStringNode.execute(node, format);
            RootCallTarget formatCallTarget = PackNode.compileFormat(node, formatString);
            byte[] bytes = PackNode.initOutputBytes(buffer, libBuffer, formatCallTarget, copyToByteArrayNode, node);
            try {
                result = (BytesResult)callPackNode.call((CallTarget)formatCallTarget, new Object[]{array.getStore(), array.size, bytes, libBuffer.byteLength(node, buffer)});
            }
            catch (FormatException e) {
                exceptionProfile.enter(node);
                throw FormatExceptionTranslator.translate(PackNode.getContext(node), node, e);
            }
            int formatLength = libFormat.getTString(node, format).byteLength(libFormat.getTEncoding(node, format));
            return PackNode.finishPack(node, formatLength, result, resizeProfile, writeAssociatedNode, fromByteArrayNode);
        }

        private static RubyString finishPack(Node node, int formatLength, BytesResult result, InlinedConditionProfile resizeProfile, WriteObjectFieldNode writeAssociatedNode, TruffleString.FromByteArrayNode fromByteArrayNode) {
            byte[] bytes = result.getOutput();
            if (resizeProfile.profile(node, bytes.length != result.getOutputLength())) {
                bytes = Arrays.copyOf(bytes, result.getOutputLength());
            }
            RubyEncoding rubyEncoding = result.getEncoding().getEncodingForLength(formatLength);
            RubyString string = PackNode.createString(node, fromByteArrayNode, bytes, rubyEncoding);
            if (result.getAssociated() != null) {
                writeAssociatedNode.execute(node, string, Layouts.ASSOCIATED_IDENTIFIER, result.getAssociated());
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        protected static RootCallTarget compileFormat(Node node, String format) {
            try {
                return new PackCompiler(PackNode.getLanguage(node), node).compile(format);
            }
            catch (DeferredRaiseException dre) {
                throw dre.getException(PackNode.getContext(node));
            }
        }

        private static byte[] initOutputBytes(Object buffer, RubyStringLibrary libBuffer, RootCallTarget formatCallTarget, TruffleString.CopyToByteArrayNode copyToByteArrayNode, Node node) {
            int bufferLength = libBuffer.byteLength(node, buffer);
            FormatRootNode formatRootNode = (FormatRootNode)formatCallTarget.getRootNode();
            int expectedLength = formatRootNode.getExpectedLength();
            int length = Math.max(bufferLength, expectedLength);
            byte[] bytes = new byte[length];
            copyToByteArrayNode.execute(libBuffer.getTString(node, buffer), 0, bytes, 0, bufferLength, libBuffer.getTEncoding(node, buffer));
            return bytes;
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.PACK_CACHE;
        }
    }

    @Primitive(name="array_pack", lowerFixnum={1})
    public static abstract class ArrayPackPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString pack(RubyArray array, Object format, Object buffer, @Cached ToStrNode toStrNode, @Cached PackNode packNode) {
            Object formatAsString = toStrNode.execute(this, format);
            return packNode.execute(this, array, formatAsString, buffer);
        }
    }

    @CoreMethod(names={"map!", "collect!"}, needsBlock=true, enumeratorSize="size", raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapInPlaceNode
    extends CoreMethodArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Node.Child
        private ArrayWriteNormalizedNode writeNode = ArrayWriteNormalizedNodeGen.create();

        @Specialization
        Object map(RubyArray array, RubyProc block, @Cached ArrayEachIteratorNode iteratorNode) {
            return iteratorNode.execute(this, array, block, 0, this);
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object state, Object element, int index, BooleanCastNode booleanCastNode) {
            RubyProc block = (RubyProc)state;
            this.writeNode.executeWrite(array, index, yieldNode.yield(node, block, element));
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapNode
    extends CoreMethodArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder = ArrayBuilderNode.create();

        @Specialization
        Object map(RubyArray array, RubyProc block, @Cached ArrayEachIteratorNode iteratorNode, @Cached InlinedIntValueProfile arraySizeProfile) {
            ArrayBuilderNode.BuilderState builderState = this.arrayBuilder.start(arraySizeProfile.profile((Node)this, array.size));
            State iterationState = new State(builderState, block);
            iteratorNode.execute(this, array, iterationState, 0, this);
            int size = array.size;
            return this.createArray(this.arrayBuilder.finish(iterationState.builderState, size), size);
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object stateObject, Object element, int index, BooleanCastNode booleanCastNode) {
            State state = (State)stateObject;
            Object value = yieldNode.yield(node, state.block, element);
            this.arrayBuilder.appendValue(state.builderState, index, value);
        }

        private static final class State {
            final ArrayBuilderNode.BuilderState builderState;
            final RubyProc block;

            State(ArrayBuilderNode.BuilderState builderState, RubyProc block) {
                this.builderState = builderState;
                this.block = block;
            }
        }
    }

    @Primitive(name="array_inject")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InjectNode
    extends PrimitiveArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Node.Child
        private DispatchNode dispatch = DispatchNode.create();

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(initialOrSymbol)"})
        Object injectEmptyArray(RubyArray array, Object initialOrSymbol, NotProvided symbol, RubyProc block) {
            return initialOrSymbol;
        }

        @Specialization(guards={"isEmptyArray(array)"})
        Object injectEmptyArrayNoInitial(RubyArray array, NotProvided initialOrSymbol, NotProvided symbol, RubyProc block) {
            return nil;
        }

        @Specialization(guards={"!isEmptyArray(array)", "wasProvided(initialOrSymbol)"})
        Object injectWithInitial(RubyArray array, Object initialOrSymbol, NotProvided symbol, RubyProc block, @Cached @Cached.Shared ArrayEachIteratorNode iteratorNode) {
            return this.injectBlockHelper(array, block, initialOrSymbol, 0, iteratorNode);
        }

        @Specialization(guards={"!isEmptyArray(array)"}, limit="storageStrategyLimit()")
        Object injectNoInitial(RubyArray array, NotProvided initialOrSymbol, NotProvided symbol, RubyProc block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared ArrayEachIteratorNode iteratorNode) {
            return this.injectBlockHelper(array, block, stores.read(store, 0), 1, iteratorNode);
        }

        private Object injectBlockHelper(RubyArray array, RubyProc block, Object initial, int start, ArrayEachIteratorNode iteratorNode) {
            Object accumulator = initial;
            State iterationState = new State(accumulator, block);
            iteratorNode.execute(this, array, iterationState, start, this);
            return iterationState.accumulator;
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object stateObject, Object element, int index, BooleanCastNode booleanCastNode) {
            State state = (State)stateObject;
            state.accumulator = yieldNode.yield(node, state.block, state.accumulator, element);
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(initialOrSymbol)"})
        Object injectSymbolEmptyArrayNoInitial(RubyArray array, Object initialOrSymbol, NotProvided symbol, Nil block, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            nameToJavaStringNode.execute(this, initialOrSymbol);
            return nil;
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(initialOrSymbol)", "wasProvided(symbol)"})
        Object injectSymbolEmptyArray(RubyArray array, Object initialOrSymbol, Object symbol, Nil block, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            nameToJavaStringNode.execute(this, symbol);
            return initialOrSymbol;
        }

        @Specialization(guards={"!isEmptyArray(array)", "wasProvided(initialOrSymbol)"}, limit="storageStrategyLimit()")
        Object injectSymbolNoInitial(VirtualFrame frame, RubyArray array, Object initialOrSymbol, NotProvided symbol, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String methodName = nameToJavaStringNode.execute(this, initialOrSymbol);
            return this.injectSymbolHelper(frame, array, methodName, stores, store, stores.read(store, 0), 1, arraySizeProfile, loopProfile);
        }

        @Specialization(guards={"!isEmptyArray(array)", "wasProvided(initialOrSymbol)", "wasProvided(symbol)"}, limit="storageStrategyLimit()")
        Object injectSymbolWithInitial(VirtualFrame frame, RubyArray array, Object initialOrSymbol, Object symbol, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared IntValueProfile arraySizeProfile, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @Cached @Cached.Shared NameToJavaStringNode nameToJavaStringNode) {
            String methodName = nameToJavaStringNode.execute(this, symbol);
            return this.injectSymbolHelper(frame, array, methodName, stores, store, initialOrSymbol, 0, arraySizeProfile, loopProfile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object injectSymbolHelper(VirtualFrame frame, RubyArray array, String symbol, ArrayStoreLibrary stores, Object store, Object initial, int start, IntValueProfile arraySizeProfile, LoopConditionProfile loopProfile) {
            Object accumulator = initial;
            int n = start;
            try {
                while (loopProfile.inject(n < arraySizeProfile.profile(array.size))) {
                    accumulator = this.dispatch.callWithFrame(DispatchConfiguration.PUBLIC, (Frame)frame, accumulator, symbol, stores.read(store, n));
                    TruffleSafepoint.poll((Node)this);
                    ++n;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, n);
            }
            return accumulator;
        }

        private static final class State {
            Object accumulator;
            final RubyProc block;

            State(Object accumulator, RubyProc block) {
                this.accumulator = accumulator;
                this.block = block;
            }
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray initializeCopy(RubyArray self, Object fromObject, @Cached ToAryNode toAryNode, @Cached ReplaceNode replaceNode) {
            RubyArray from = toAryNode.execute(this, fromObject);
            if (self == from) {
                return self;
            }
            replaceNode.executeReplace(self, from);
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=2, raiseIfFrozenSelf=true, lowerFixnum={1}, argumentNames={"size_or_copy", "filling_value", "block"})
    @ImportStatic(value={ArrayGuards.class, ArrayStoreLibrary.class})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode toAryNode;
        protected static final long MAX_INT = Integer.MAX_VALUE;

        protected abstract RubyArray executeInitialize(RubyArray var1, Object var2, Object var3, Object var4);

        @Specialization
        RubyArray initializeNoArgs(RubyArray array, NotProvided size, NotProvided fillingValue, Nil block, @Cached @Cached.Shared IsSharedNode isSharedNode) {
            ArrayHelpers.setStoreAndSize(array, ArrayStoreLibrary.initialStorage(isSharedNode.execute(this, array)), 0);
            return array;
        }

        @Specialization
        RubyArray initializeOnlyBlock(RubyArray array, NotProvided size, NotProvided fillingValue, RubyProc block, @Cached @Cached.Shared IsSharedNode isSharedNode, @Cached(value="new()") WarningNode warningNode) {
            if (warningNode.shouldWarn()) {
                SourceSection sourceSection = this.getContext().getCallStack().getTopMostUserSourceSection();
                warningNode.warningMessage(sourceSection, "given block not used");
            }
            ArrayHelpers.setStoreAndSize(array, ArrayStoreLibrary.initialStorage(isSharedNode.execute(this, array)), 0);
            return array;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"size < 0"})
        RubyArray initializeNegativeIntSize(RubyArray array, int size, Object unusedFillingValue, Object unusedBlock) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("negative array size", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"size < 0"})
        RubyArray initializeNegativeLongSize(RubyArray array, long size, Object unusedFillingValue, Object unusedBlock) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("negative array size", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"size >= MAX_INT"})
        RubyArray initializeSizeTooBig(RubyArray array, long size, NotProvided fillingValue, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("array size too big", this));
        }

        @Specialization(guards={"size >= 0"})
        RubyArray initializeWithSizeNoValue(RubyArray array, int size, NotProvided fillingValue, Nil block, @Cached @Cached.Shared IsSharedNode isSharedNode, @CachedLibrary(limit="storageStrategyLimit()") @Cached.Exclusive ArrayStoreLibrary stores) {
            Object store = isSharedNode.execute(this, array) ? new SharedArrayStorage(new Object[size]) : new Object[size];
            stores.fill(store, 0, size, nil);
            ArrayHelpers.setStoreAndSize(array, store, size);
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"size >= 0", "wasProvided(fillingValue)"}, limit="storageStrategyLimit()")
        RubyArray initializeWithSizeAndValue(RubyArray array, int size, Object fillingValue, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") ArrayStoreLibrary allocatedStores, @Cached @Cached.Exclusive ConditionProfile needsFill, @Cached @Cached.Exclusive LoopConditionProfile loopProfile) {
            Object allocatedStore = stores.allocateForNewValue(store, fillingValue, size);
            if (needsFill.profile(!allocatedStores.isDefaultValue(allocatedStore, fillingValue))) {
                int i = 0;
                try {
                    while (loopProfile.inject(i < size)) {
                        allocatedStores.write(allocatedStore, i, fillingValue);
                        TruffleSafepoint.poll((Node)this);
                        ++i;
                    }
                }
                finally {
                    this.profileAndReportLoopCount(loopProfile, i);
                }
            }
            ArrayHelpers.setStoreAndSize(array, allocatedStore, size);
            return array;
        }

        @Specialization(guards={"wasProvided(size)", "!isImplicitLong(size)", "wasProvided(fillingValue)"})
        RubyArray initializeSizeOther(RubyArray array, Object size, Object fillingValue, Nil block, @Cached @Cached.Shared ToIntNode toIntNode) {
            int intSize = toIntNode.execute(size);
            return this.executeInitialize(array, intSize, fillingValue, block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"size >= 0"})
        static Object initializeBlock(RubyArray array, int size, Object unusedFillingValue, RubyProc block, @Cached ArrayBuilderNode arrayBuilder, @CachedLibrary(limit="storageStrategyLimit()") @Cached.Exclusive ArrayStoreLibrary stores, @Cached @Cached.Exclusive IsSharedNode isSharedNode, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @Cached CallBlockNode yieldNode, @Bind(value="this") Node node) {
            ArrayBuilderNode.BuilderState state = arrayBuilder.start(size);
            int n = 0;
            try {
                while (loopProfile.inject(n < size)) {
                    Object value = yieldNode.yield(node, block, n);
                    arrayBuilder.appendValue(state, n, value);
                    ++n;
                }
            }
            finally {
                InitializeNode.profileAndReportLoopCount(node, loopProfile, n);
                Object store = arrayBuilder.finish(state, n);
                if (isSharedNode.execute(node, array)) {
                    store = stores.makeShared(store, n);
                }
                ArrayHelpers.setStoreAndSize(array, store, n);
            }
            return array;
        }

        @Specialization
        RubyArray initializeFromArray(RubyArray array, RubyArray copy, NotProvided unusedValue, Object maybeBlock, @Cached ReplaceNode replaceNode) {
            replaceNode.executeReplace(array, copy);
            return array;
        }

        @Specialization(guards={"!isImplicitLong(object)", "wasProvided(object)", "!isRubyArray(object)"})
        RubyArray initialize(RubyArray array, Object object, NotProvided unusedValue, Nil block, @Cached KernelNodes.RespondToNode respondToNode, @Cached @Cached.Shared ToIntNode toIntNode) {
            Object toAryResult;
            RubyArray copy = null;
            if (respondToNode.executeDoesRespondTo(object, this.coreSymbols().TO_ARY, true) && (toAryResult = this.callToAry(object)) instanceof RubyArray) {
                copy = (RubyArray)toAryResult;
            }
            if (copy != null) {
                return this.executeInitialize(array, copy, NotProvided.INSTANCE, nil);
            }
            int size = toIntNode.execute(object);
            return this.executeInitialize(array, size, NotProvided.INSTANCE, nil);
        }

        protected Object callToAry(Object object) {
            if (this.toAryNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toAryNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.toAryNode.call(object, "to_ary");
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    @ReportPolymorphism
    public static abstract class IncludeNode
    extends ArrayCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="storageStrategyLimit()")
        static boolean include(RubyArray array, Object value, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached KernelNodes.SameOrEqualNode sameOrEqualNode, @Cached InlinedIntValueProfile arraySizeProfile, @Cached InlinedLoopConditionProfile loopProfile, @Bind(value="this") Node node) {
            int n = 0;
            try {
                while (loopProfile.inject(node, n < arraySizeProfile.profile(node, array.size))) {
                    Object stored = stores.read(store, n);
                    if (sameOrEqualNode.execute(node, stored, value)) {
                        boolean bl = true;
                        return bl;
                    }
                    TruffleSafepoint.poll((Node)node);
                    ++n;
                }
            }
            finally {
                IncludeNode.profileAndReportLoopCount(node, loopProfile, n);
            }
            return false;
        }
    }

    @Primitive(name="hash_internal")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class HashNode
    extends PrimitiveArrayArgumentsNode {
        private static final int CLASS_SALT = 42753062;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="storageStrategyLimit()")
        static long hash(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached HashingNodes.ToHashByHashCode toHashByHashCode, @Cached @Cached.Exclusive InlinedIntValueProfile arraySizeProfile, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopProfile, @Bind(value="this") Node node) {
            int size = arraySizeProfile.profile(node, array.size);
            long h = HashNode.getContext(node).getHashing(node).start(size);
            h = Hashing.update(h, 42753062L);
            int n = 0;
            try {
                while (loopProfile.inject(node, n < size)) {
                    Object value = stores.read(store, n);
                    h = Hashing.update(h, toHashByHashCode.execute(node, value));
                    TruffleSafepoint.poll((Node)node);
                    ++n;
                }
            }
            finally {
                HashNode.profileAndReportLoopCount(node, loopProfile, n);
            }
            return Hashing.end(h);
        }
    }

    @CoreMethod(names={"fill"}, rest=true, needsBlock=true, raiseIfFrozenSelf=true)
    public static abstract class FillNode
    extends ArrayCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"args.length == 1", "stores.acceptsValue(store, value(args))"}, limit="storageStrategyLimit()")
        RubyArray fill(RubyArray array, Object[] args, Nil block, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached IntValueProfile arraySizeProfile, @Cached LoopConditionProfile loopProfile) {
            Object value = args[0];
            int size = arraySizeProfile.profile(array.size);
            int i = 0;
            try {
                while (loopProfile.inject(i < size)) {
                    stores.write(store, i, value);
                    TruffleSafepoint.poll((Node)this);
                    ++i;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, i);
            }
            return array;
        }

        protected Object value(Object[] args) {
            return args[0];
        }

        @Specialization
        Object fillFallback(VirtualFrame frame, RubyArray array, Object[] args, Nil block, @Cached @Cached.Shared DispatchNode callFillInternal) {
            return callFillInternal.call((Object)array, "fill_internal", args);
        }

        @Specialization
        Object fillFallback(VirtualFrame frame, RubyArray array, Object[] args, RubyProc block, @Cached @Cached.Shared DispatchNode callFillInternal) {
            return callFillInternal.callWithDescriptor(array, "fill_internal", block, NoKeywordArgumentsDescriptor.INSTANCE, args);
        }
    }

    @Primitive(name="array_eql?")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EqlNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"stores.accepts(bStore)", "stores.isPrimitive(aStore)"}, limit="storageStrategyLimit()")
        static boolean eqlSamePrimitiveType(RubyArray a, RubyArray b, @Bind(value="a.getStore()") Object aStore, @Bind(value="b.getStore()") Object bStore, @CachedLibrary(value="aStore") ArrayStoreLibrary stores, @Cached KernelNodes.SameOrEqlNode eqlNode, @Cached InlinedConditionProfile sameProfile, @Cached InlinedIntValueProfile arraySizeProfile, @Cached InlinedConditionProfile sameSizeProfile, @Cached InlinedBranchProfile trueProfile, @Cached InlinedBranchProfile falseProfile, @Cached InlinedLoopConditionProfile loopProfile, @Bind(value="$node") Node node) {
            if (sameProfile.profile(node, a == b)) {
                return true;
            }
            int size = arraySizeProfile.profile(node, a.size);
            if (!sameSizeProfile.profile(node, size == b.size)) {
                return false;
            }
            int i = 0;
            try {
                while (loopProfile.inject(node, i < size)) {
                    if (!eqlNode.execute(node, stores.read(aStore, i), stores.read(bStore, i))) {
                        falseProfile.enter(node);
                        boolean bl = false;
                        return bl;
                    }
                    TruffleSafepoint.poll((Node)node);
                    ++i;
                }
            }
            finally {
                EqlNode.profileAndReportLoopCount(node, loopProfile, i);
            }
            trueProfile.enter(node);
            return true;
        }

        @Specialization(guards={"!stores.accepts(bStore)", "stores.isPrimitive(aStore)"}, limit="storageStrategyLimit()")
        Object eqlDifferentPrimitiveType(RubyArray a, RubyArray b, @Bind(value="a.getStore()") Object aStore, @Bind(value="b.getStore()") Object bStore, @CachedLibrary(value="aStore") ArrayStoreLibrary stores) {
            return FAILURE;
        }

        @Specialization(guards={"!stores.isPrimitive(aStore)"}, limit="storageStrategyLimit()")
        Object eqlNotPrimitiveType(RubyArray a, RubyArray b, @Bind(value="a.getStore()") Object aStore, @CachedLibrary(value="aStore") ArrayStoreLibrary stores) {
            return FAILURE;
        }

        @Specialization(guards={"!isRubyArray(b)"})
        Object eqlNotArray(RubyArray a, Object b) {
            return FAILURE;
        }
    }

    @Primitive(name="array_equal?")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EqualNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"stores.accepts(bStore)", "stores.isPrimitive(aStore)"}, limit="storageStrategyLimit()")
        static boolean equalSamePrimitiveType(RubyArray a, RubyArray b, @Bind(value="a.getStore()") Object aStore, @Bind(value="b.getStore()") Object bStore, @CachedLibrary(value="aStore") ArrayStoreLibrary stores, @Cached InlinedConditionProfile sameProfile, @Cached InlinedIntValueProfile arraySizeProfile, @Cached InlinedConditionProfile sameSizeProfile, @Cached InlinedBranchProfile trueProfile, @Cached InlinedBranchProfile falseProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached KernelNodes.SameOrEqualNode sameOrEqualNode, @Bind(value="this") Node node) {
            if (sameProfile.profile(node, a == b)) {
                return true;
            }
            int size = arraySizeProfile.profile(node, a.size);
            if (!sameSizeProfile.profile(node, size == b.size)) {
                return false;
            }
            int i = 0;
            try {
                while (loopProfile.inject(node, i < size)) {
                    if (!sameOrEqualNode.execute(node, stores.read(aStore, i), stores.read(bStore, i))) {
                        falseProfile.enter(node);
                        boolean bl = false;
                        return bl;
                    }
                    TruffleSafepoint.poll((Node)node);
                    ++i;
                }
            }
            finally {
                EqualNode.profileAndReportLoopCount(node, loopProfile, i);
            }
            trueProfile.enter(node);
            return true;
        }

        @Specialization(guards={"!stores.accepts(bStore)", "stores.isPrimitive(aStore)"}, limit="storageStrategyLimit()")
        Object equalDifferentPrimitiveType(RubyArray a, RubyArray b, @Bind(value="a.getStore()") Object aStore, @Bind(value="b.getStore()") Object bStore, @CachedLibrary(value="aStore") ArrayStoreLibrary stores) {
            return FAILURE;
        }

        @Specialization(guards={"stores.accepts(aStore)", "!stores.isPrimitive(aStore)"}, limit="storageStrategyLimit()")
        Object equalNotPrimitiveType(RubyArray a, RubyArray b, @Bind(value="a.getStore()") Object aStore, @Bind(value="b.getStore()") Object bStore, @CachedLibrary(value="aStore") ArrayStoreLibrary stores) {
            return FAILURE;
        }

        @Specialization(guards={"!isRubyArray(b)"})
        Object equalNotArray(RubyArray a, Object b) {
            return FAILURE;
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isEmpty(RubyArray array) {
            return array.size == 0;
        }
    }

    @Primitive(name="array_each_with_index")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachWithIndexNode
    extends PrimitiveArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Specialization
        Object eachOther(RubyArray array, RubyProc block, @Cached ArrayEachIteratorNode iteratorNode) {
            return iteratorNode.execute(this, array, block, 0, this);
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object state, Object element, int index, BooleanCastNode booleanCastNode) {
            RubyProc block = (RubyProc)state;
            yieldNode.yield(node, block, element, index);
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachNode
    extends CoreMethodArrayArgumentsNode
    implements ArrayEachIteratorNode.ArrayElementConsumerNode {
        @Specialization
        Object each(RubyArray array, RubyProc block, @Cached ArrayEachIteratorNode iteratorNode) {
            return iteratorNode.execute(this, array, block, 0, this);
        }

        @Override
        public void accept(Node node, CallBlockNode yieldNode, RubyArray array, Object state, Object element, int index, BooleanCastNode booleanCastNode) {
            RubyProc block = (RubyProc)state;
            yieldNode.yield(node, block, element);
        }
    }

    @CoreMethod(names={"delete_at"}, required=1, raiseIfFrozenSelf=true, lowerFixnum={1})
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class DeleteAtNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="storageStrategyLimit()")
        static Object doDelete(RubyArray array, Object indexObject, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached ToIntNode toIntNode, @Cached InlinedIntValueProfile arraySizeProfile, @Cached InlinedConditionProfile negativeIndexProfile, @Cached InlinedConditionProfile notInBoundsProfile, @Cached InlinedConditionProfile isMutableProfile, @Bind(value="this") Node node) {
            int index;
            int size = arraySizeProfile.profile(node, array.size);
            int i = index = toIntNode.execute(indexObject);
            if (negativeIndexProfile.profile(node, index < 0)) {
                i += size;
            }
            if (notInBoundsProfile.profile(node, i < 0 || i >= size)) {
                return nil;
            }
            if (isMutableProfile.profile(node, stores.isMutable(store))) {
                Object value = stores.read(store, i);
                stores.copyContents(store, i + 1, store, i, size - i - 1);
                stores.clear(store, size - 1, 1);
                ArrayHelpers.setStoreAndSize(array, store, size - 1);
                return value;
            }
            Object mutableStore = stores.allocator(store).allocate(size - 1);
            stores.copyContents(store, 0, mutableStore, 0, i);
            Object value = stores.read(store, i);
            stores.copyContents(store, i + 1, mutableStore, i, size - i - 1);
            ArrayHelpers.setStoreAndSize(array, mutableStore, size - 1);
            return value;
        }
    }

    @CoreMethod(names={"delete"}, required=1, needsBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class DeleteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"stores.isMutable(store)"}, limit="storageStrategyLimit()")
        Object deleteMutable(RubyArray array, Object value, Object maybeBlock, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached @Cached.Shared KernelNodes.SameOrEqualNode sameOrEqualNode, @Cached @Cached.Shared InlinedIntValueProfile arraySizeProfile, @Cached @Cached.Shared InlinedLoopConditionProfile loopProfile, @Cached @Cached.Shared CallBlockNode yieldNode, @Cached @Cached.Shared TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            return this.delete(array, value, maybeBlock, true, store, store, stores, stores, arraySizeProfile, loopProfile, yieldNode, sameOrEqualNode, raiseIfFrozenNode);
        }

        @Specialization(guards={"!stores.isMutable(store)"}, limit="storageStrategyLimit()")
        Object deleteNotMutable(RubyArray array, Object value, Object maybeBlock, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") ArrayStoreLibrary newStores, @Cached @Cached.Shared KernelNodes.SameOrEqualNode sameOrEqualNode, @Cached @Cached.Shared InlinedIntValueProfile arraySizeProfile, @Cached @Cached.Shared InlinedLoopConditionProfile loopProfile, @Cached @Cached.Shared CallBlockNode yieldNode, @Cached @Cached.Shared TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            Object newStore = stores.allocator(store).allocate(arraySizeProfile.profile((Node)this, array.size));
            return this.delete(array, value, maybeBlock, false, store, newStore, stores, newStores, arraySizeProfile, loopProfile, yieldNode, sameOrEqualNode, raiseIfFrozenNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object delete(RubyArray array, Object value, Object maybeBlock, boolean sameStores, Object oldStore, Object newStore, ArrayStoreLibrary oldStores, ArrayStoreLibrary newStores, InlinedIntValueProfile arraySizeProfile, InlinedLoopConditionProfile loopProfile, CallBlockNode yieldNode, KernelNodes.SameOrEqualNode sameOrEqualNode, TypeNodes.CheckFrozenNode raiseIfFrozenNode) {
            assert (!sameStores || oldStore == newStore && oldStores == newStores);
            int size = arraySizeProfile.profile((Node)this, array.size);
            Object found = nil;
            int i = 0;
            int n = 0;
            try {
                while (loopProfile.inject((Node)this, n < size)) {
                    Object stored = oldStores.read(oldStore, n);
                    if (sameOrEqualNode.execute(this, stored, value)) {
                        raiseIfFrozenNode.execute(this, array);
                        found = stored;
                        ++n;
                    } else {
                        newStores.write(newStore, i, oldStores.read(oldStore, n));
                        ++i;
                        ++n;
                    }
                    TruffleSafepoint.poll((Node)this);
                }
            }
            finally {
                DeleteNode.profileAndReportLoopCount((Node)this, loopProfile, n);
            }
            if (i != n) {
                if (sameStores) {
                    oldStores.clear(oldStore, i, size - i);
                }
                ArrayHelpers.setStoreAndSize(array, newStore, i);
                return found;
            }
            if (maybeBlock == nil) {
                return nil;
            }
            return yieldNode.yield(this, (RubyProc)maybeBlock, value);
        }
    }

    @CoreMethod(names={"concat"}, optional=1, rest=true, raiseIfFrozenSelf=true)
    @ReportPolymorphism
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ConcatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"rest.length == 0"})
        RubyArray concatZero(RubyArray array, NotProvided first, Object[] rest) {
            return array;
        }

        @Specialization(guards={"wasProvided(first)", "rest.length == 0"})
        RubyArray concatOne(RubyArray array, Object first, Object[] rest, @Cached @Cached.Shared ToAryNode toAryNode, @Cached @Cached.Shared ArrayAppendManyNode appendManyNode) {
            appendManyNode.executeAppendMany(array, toAryNode.execute(this, first));
            return array;
        }

        @ExplodeLoop
        @Specialization(guards={"wasProvided(first)", "rest.length > 0", "rest.length == cachedLength", "cachedLength <= MAX_EXPLODE_SIZE"}, limit="getDefaultCacheLimit()")
        RubyArray concatMany(RubyArray array, Object first, Object[] rest, @Cached(value="rest.length") int cachedLength, @Cached @Cached.Shared ToAryNode toAryNode, @Cached @Cached.Shared ArrayAppendManyNode appendManyNode, @Cached @Cached.Shared ArrayCopyOnWriteNode cowNode, @Cached @Cached.Shared ConditionProfile selfArgProfile) {
            int size = array.size;
            RubyArray copy = this.createArray(cowNode.execute(array, 0, size), size);
            RubyArray result = appendManyNode.executeAppendMany(array, toAryNode.execute(this, first));
            for (int i = 0; i < cachedLength; ++i) {
                RubyArray argOrCopy = selfArgProfile.profile(rest[i] == array) ? copy : toAryNode.execute(this, rest[i]);
                result = appendManyNode.executeAppendMany(array, argOrCopy);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"wasProvided(first)", "rest.length > 0"}, replaces={"concatMany"})
        RubyArray concatManyGeneral(RubyArray array, Object first, Object[] rest, @Cached @Cached.Shared ToAryNode toAryNode, @Cached @Cached.Shared ArrayAppendManyNode appendManyNode, @Cached @Cached.Shared ArrayCopyOnWriteNode cowNode, @Cached @Cached.Shared ConditionProfile selfArgProfile, @Cached LoopConditionProfile loopProfile) {
            int size = array.size;
            Object store = cowNode.execute(array, 0, size);
            RubyArray result = appendManyNode.executeAppendMany(array, toAryNode.execute(this, first));
            int i = 0;
            try {
                while (loopProfile.inject(i < rest.length)) {
                    Object arg = rest[i];
                    result = selfArgProfile.profile(arg == array) ? appendManyNode.executeAppendMany(array, this.createArray(store, size)) : appendManyNode.executeAppendMany(array, toAryNode.execute(this, arg));
                    TruffleSafepoint.poll((Node)this);
                    ++i;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, i);
            }
            return result;
        }
    }

    @CoreMethod(names={"compact!"}, raiseIfFrozenSelf=true)
    @ReportPolymorphism
    public static abstract class CompactBangNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"stores.isPrimitive(store)"}, limit="storageStrategyLimit()")
        @ReportPolymorphism.Exclude
        Object compactNotObjects(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return nil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!stores.isPrimitive(store)"}, limit="storageStrategyLimit()")
        Object compactObjects(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") ArrayStoreLibrary mutableStores, @Cached IntValueProfile arraySizeProfile, @Cached LoopConditionProfile loopProfile) {
            int size = arraySizeProfile.profile(array.size);
            Object oldStore = store;
            Object newStore = !stores.isMutable(oldStore) ? stores.allocator(oldStore).allocate(size) : oldStore;
            int m = 0;
            int n = 0;
            try {
                while (loopProfile.inject(n < size)) {
                    Object v = stores.read(oldStore, n);
                    if (v != nil) {
                        mutableStores.write(newStore, m, v);
                        ++m;
                    }
                    TruffleSafepoint.poll((Node)this);
                    ++n;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, n);
            }
            stores.clear(oldStore, m, size - m);
            ArrayHelpers.setStoreAndSize(array, newStore, m);
            if (m == size) {
                return nil;
            }
            return array;
        }
    }

    @CoreMethod(names={"compact"})
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class CompactNode
    extends ArrayCoreMethodNode {
        @Specialization(guards={"stores.isPrimitive(store)"}, limit="storageStrategyLimit()")
        @ReportPolymorphism.Exclude
        RubyArray compactPrimitive(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached ArrayCopyOnWriteNode cowNode) {
            int size = array.size;
            return this.createArray(cowNode.execute(array, 0, size), size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!stores.isPrimitive(store)"}, limit="storageStrategyLimit()")
        Object compactObjects(RubyArray array, @Bind(value="array.getStore()") Object store, @Cached IntValueProfile arraySizeProfile, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached ArrayBuilderNode arrayBuilder, @Cached LoopConditionProfile loopProfile) {
            int size = arraySizeProfile.profile(array.size);
            ArrayBuilderNode.BuilderState state = arrayBuilder.start(size);
            int m = 0;
            int n = 0;
            try {
                while (loopProfile.inject(n < size)) {
                    Object v = stores.read(store, n);
                    if (v != nil) {
                        arrayBuilder.appendValue(state, m, v);
                        ++m;
                    }
                    TruffleSafepoint.poll((Node)this);
                    ++n;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, n);
            }
            return this.createArray(arrayBuilder.finish(state, m), m);
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends ArrayCoreMethodNode {
        @Specialization
        RubyArray clear(RubyArray array, @Cached IsSharedNode isSharedNode) {
            ArrayHelpers.setStoreAndSize(array, ArrayStoreLibrary.initialStorage(isSharedNode.execute(this, array)), 0);
            return array;
        }
    }

    @CoreMethod(names={"[]="}, split=Split.ALWAYS, required=2, optional=1, lowerFixnum={1, 2}, raiseIfFrozenSelf=true, argumentNames={"index_start_or_range", "length_or_value", "value"})
    @ImportStatic(value={ArrayHelpers.class})
    public static abstract class SetIndexNode
    extends ArrayCoreMethodNode {
        public static SetIndexNode create() {
            return ArrayNodesFactory.SetIndexNodeFactory.create(null);
        }

        abstract Object executeIntIndex(RubyArray var1, int var2, Object var3, NotProvided var4);

        abstract Object executeIntIndices(RubyArray var1, int var2, int var3, Object var4);

        @Specialization
        Object set(RubyArray array, int index, Object value, NotProvided unused, @Cached ArrayWriteNormalizedNode writeNode, @Cached @Cached.Shared ConditionProfile negativeDenormalizedIndex, @Cached @Cached.Shared BranchProfile negativeNormalizedIndex) {
            int size = array.size;
            int nIndex = this.normalize(size, index, negativeDenormalizedIndex, negativeNormalizedIndex);
            return writeNode.executeWrite(array, nIndex, value);
        }

        @Specialization(guards={"isRubyRange(range)"})
        Object setRange(RubyArray array, Object range, Object value, NotProvided unused, @Cached RangeNodes.NormalizedStartLengthNode normalizedStartLength, @Cached @Cached.Exclusive BranchProfile negativeStart) {
            int[] startLength = normalizedStartLength.execute(range, array.size);
            int start = startLength[0];
            if (start < 0) {
                negativeStart.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().rangeError(Utils.concat("index ", start, " out of bounds"), (Node)this));
            }
            int length = Math.max(startLength[1], 0);
            return this.executeIntIndices(array, start, length, value);
        }

        @Specialization(guards={"!isInteger(start)", "!isRubyRange(start)"})
        Object fallbackBinary(RubyArray array, Object start, Object value, NotProvided unused, @Cached @Cached.Shared ToIntNode startToInt) {
            return this.executeIntIndex(array, startToInt.execute(start), value, unused);
        }

        @Specialization(guards={"wasProvided(replacement)", "length < 0"})
        Object negativeLength(RubyArray array, int start, int length, Object replacement) {
            throw new RaiseException(this.getContext(), this.coreExceptions().negativeLengthError(length, this));
        }

        @Specialization(guards={"length >= 0"})
        Object setTernary(RubyArray array, int start, int length, RubyArray replacement, @Cached @Cached.Shared ConditionProfile negativeDenormalizedIndex, @Cached @Cached.Shared BranchProfile negativeNormalizedIndex, @Cached @Cached.Exclusive ConditionProfile moveNeeded, @Cached ArrayPrepareForCopyNode prepareToCopy, @Cached ArrayCopyCompatibleRangeNode shift, @Cached ArrayCopyCompatibleRangeNode copyRange, @Cached ArrayTruncateNode truncate) {
            int originalSize = array.size;
            start = this.normalize(originalSize, start, negativeDenormalizedIndex, negativeNormalizedIndex);
            Object replacementStore = replacement.getStore();
            int replacementSize = replacement.size;
            int overwrittenAreaEnd = start + length;
            int tailSize = originalSize - overwrittenAreaEnd;
            if (moveNeeded.profile(tailSize > 0)) {
                int writtenAreaEnd = start + replacementSize;
                int newSize = originalSize - length + replacementSize;
                int requiredLength = newSize - start;
                Object newStore = prepareToCopy.execute(array, replacement, start, requiredLength);
                shift.execute(newStore, newStore, writtenAreaEnd, overwrittenAreaEnd, tailSize);
                copyRange.execute(newStore, replacementStore, start, 0, replacementSize);
                truncate.execute(array, newSize);
            } else {
                Object newStore = prepareToCopy.execute(array, replacement, start, replacementSize);
                copyRange.execute(newStore, replacementStore, start, 0, replacementSize);
                truncate.execute(array, start + replacementSize);
            }
            return replacement;
        }

        @Specialization(guards={"!isRubyArray(replacement)", "wasProvided(replacement)", "length >= 0"})
        Object setTernary(RubyArray array, int start, int length, Object replacement, @Cached ArrayConvertNode convert, @Cached SetIndexNode recurse) {
            recurse.executeIntIndices(array, start, length, convert.execute(replacement));
            return replacement;
        }

        @Specialization(guards={"!isInteger(start) || !isInteger(length)", "wasProvided(replacement)"})
        Object fallbackTernary(RubyArray array, Object start, Object length, Object replacement, @Cached @Cached.Shared ToIntNode startToInt, @Cached @Cached.Exclusive ToIntNode lengthToInt) {
            return this.executeIntIndices(array, startToInt.execute(start), lengthToInt.execute(length), replacement);
        }

        protected int normalize(int arraySize, int index, ConditionProfile negativeDenormalizedIndex, BranchProfile negativeNormalizedIndex) {
            if (negativeDenormalizedIndex.profile(index < 0) && (index += arraySize) < 0) {
                negativeNormalizedIndex.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().indexTooSmallError("array", index, arraySize, this));
            }
            return index;
        }
    }

    @CoreMethod(names={"[]", "slice"}, split=Split.ALWAYS, required=1, optional=1, lowerFixnum={1, 2}, argumentNames={"index_start_or_range", "length"})
    public static abstract class IndexNode
    extends ArrayCoreMethodNode {
        abstract Object executeIntIndices(RubyArray var1, int var2, int var3);

        @Specialization
        Object index(RubyArray array, int index, NotProvided length, @Cached @Cached.Shared ConditionProfile negativeIndexProfile, @Cached ArrayIndexNodes.ReadNormalizedNode readNode) {
            if (negativeIndexProfile.profile(index < 0)) {
                index += array.size;
            }
            return readNode.executeRead(array, index);
        }

        @Specialization(guards={"isRubyRange(range)"})
        Object indexRange(RubyArray array, Object range, NotProvided length, @Cached RangeNodes.NormalizedStartLengthNode startLengthNode, @Cached @Cached.Shared ArrayIndexNodes.ReadSliceNormalizedNode readSliceNode) {
            int[] startLength = startLengthNode.execute(range, array.size);
            int len = Math.max(startLength[1], 0);
            return readSliceNode.executeReadSlice(array, startLength[0], len);
        }

        @Specialization(guards={"isArithmeticSequence(enumerator, isANode)"})
        Object indexArithmeticSequence(RubyArray array, Object enumerator, NotProvided length, @Cached @Cached.Shared IsANode isANode, @Cached DispatchNode callSliceArithmeticSequence) {
            return callSliceArithmeticSequence.call((Object)array, "slice_arithmetic_sequence", enumerator);
        }

        @Specialization(guards={"!isInteger(index)", "!isRubyRange(index)", "!isArithmeticSequence(index, isANode)"})
        Object indexFallback(RubyArray array, Object index, NotProvided length, @Cached @Cached.Shared IsANode isANode, @Cached AtNode accessWithIndexConversion) {
            return accessWithIndexConversion.executeAt(array, index);
        }

        @Specialization
        Object slice(RubyArray array, int start, int length, @Cached @Cached.Shared ArrayIndexNodes.ReadSliceNormalizedNode readSliceNode, @Cached @Cached.Shared ConditionProfile negativeIndexProfile) {
            if (negativeIndexProfile.profile(start < 0)) {
                start += array.size;
            }
            return readSliceNode.executeReadSlice(array, start, length);
        }

        @Specialization(guards={"wasProvided(length)", "!isInteger(start) || !isInteger(length)"})
        Object sliceFallback(RubyArray array, Object start, Object length, @Cached ToIntNode indexToInt, @Cached ToIntNode lengthToInt) {
            return this.executeIntIndices(array, indexToInt.execute(start), lengthToInt.execute(length));
        }

        protected boolean isArithmeticSequence(Object object, IsANode isANode) {
            return isANode.executeIsA(object, this.coreLibrary().arithmeticSequenceClass);
        }
    }

    @CoreMethod(names={"at"}, required=1, lowerFixnum={1})
    public static abstract class AtNode
    extends CoreMethodArrayArgumentsNode {
        abstract Object executeAt(RubyArray var1, Object var2);

        @NeverDefault
        public static AtNode create() {
            return ArrayNodesFactory.AtNodeFactory.create(new RubyNode[]{null, null});
        }

        @Specialization
        Object at(RubyArray array, int index, @Cached ArrayIndexNodes.ReadNormalizedNode readNormalizedNode, @Cached ConditionProfile denormalized) {
            if (denormalized.profile(index < 0)) {
                index += array.size;
            }
            return readNormalizedNode.executeRead(array, index);
        }

        @Specialization
        Object at(RubyArray array, long index) {
            assert (!CoreLibrary.fitsIntoInteger(index));
            return nil;
        }

        @Specialization(guards={"!isImplicitLong(index)"})
        static Object at(RubyArray array, Object index, @Cached ToLongNode toLongNode, @Cached FixnumLowerNode lowerNode, @Cached AtNode atNode, @Bind(value="this") Node node) {
            return atNode.executeAt(array, lowerNode.execute(node, toLongNode.execute(node, index)));
        }
    }

    @Primitive(name="array_mul", lowerFixnum={1})
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class MulNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"count < 0"})
        RubyArray mulNeg(RubyArray array, long count) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("negative argument", this));
        }

        @Specialization(guards={"count == 0"})
        RubyArray mulZero(RubyArray array, int count) {
            return this.createEmptyArray();
        }

        @Specialization(guards={"count > 0", "isEmptyArray(array)"})
        RubyArray mulEmpty(RubyArray array, long count) {
            return this.createEmptyArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"count > 0", "!isEmptyArray(array)"}, limit="storageStrategyLimit()")
        RubyArray mulOther(RubyArray array, int count, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary arrays, @Cached IntValueProfile arraySizeProfile, @Cached LoopConditionProfile loopProfile) {
            int newSize;
            int size = arraySizeProfile.profile(array.size);
            try {
                newSize = Math.multiplyExact(size, count);
            }
            catch (ArithmeticException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("new array size too large", (Node)this));
            }
            Object newStore = arrays.unsharedAllocator(store).allocate(newSize);
            int n = 0;
            try {
                while (loopProfile.inject(n < count)) {
                    arrays.copyContents(store, 0, newStore, n * size, size);
                    TruffleSafepoint.poll((Node)this);
                    ++n;
                }
            }
            finally {
                this.profileAndReportLoopCount(loopProfile, n);
            }
            return this.createArray(newStore, newSize);
        }

        @Specialization(guards={"count > 0", "!isEmptyArray(array)", "!fitsInInteger(count)"})
        RubyArray mulLong(RubyArray array, long count) {
            throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("array size too big", (Node)this));
        }

        @Specialization(guards={"!isImplicitLong(count)"})
        Object fallback(RubyArray array, Object count) {
            return FAILURE;
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class AddNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="storageStrategyLimit()")
        static RubyArray addGeneralize(RubyArray a, Object bObject, @Cached ToAryNode toAryNode, @Bind(value="this") Node node, @Bind(value="toAryNode.execute(node, bObject)") RubyArray b, @Bind(value="a.getStore()") Object aStore, @Bind(value="b.getStore()") Object bStore, @CachedLibrary(value="aStore") ArrayStoreLibrary as, @CachedLibrary(value="bStore") ArrayStoreLibrary bs, @Cached IntValueProfile aSizeProfile, @Cached IntValueProfile bSizeProfile) {
            int aSize = aSizeProfile.profile(a.size);
            int bSize = bSizeProfile.profile(b.size);
            int combinedSize = aSize + bSize;
            Object newStore = as.unsharedAllocateForNewStore(aStore, bStore, combinedSize);
            as.copyContents(aStore, 0, newStore, 0, aSize);
            bs.copyContents(bStore, 0, newStore, aSize, bSize);
            return AddNode.createArray(node, newStore, combinedSize);
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().arrayShape;
            RubyArray array = new RubyArray(rubyClass, shape, ArrayStoreLibrary.initialStorage(false), 0);
            AllocationTracing.trace(array, this);
            return array;
        }
    }
}

