/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.IntValueProfile;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayToObjectArrayNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayToObjectArrayNode
extends RubyBaseNode {
    @NeverDefault
    public static ArrayToObjectArrayNode create() {
        return ArrayToObjectArrayNodeGen.create();
    }

    public Object[] unsplat(Object[] arguments) {
        assert (arguments.length == 1);
        return this.executeToObjectArray((RubyArray)arguments[0]);
    }

    public abstract Object[] executeToObjectArray(RubyArray var1);

    @Specialization(limit="storageStrategyLimit()")
    Object[] toObjectArrayOther(RubyArray array, @Bind(value="array.getStore()") Object store, @Cached IntValueProfile sizeProfile, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        int size = sizeProfile.profile(array.size);
        return stores.boxedCopyOfRange(store, 0, size);
    }
}

