/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

@ExportLibrary(value=ArrayStoreLibrary.class, receiverType=Object[].class)
@GenerateUncached
public final class ObjectArrayStore {
    public static final ArrayStoreLibrary.ArrayAllocator OBJECT_ARRAY_ALLOCATOR = new ObjectArrayAllocator();

    @ExportMessage
    static Object read(Object[] store, int index) {
        return store[index];
    }

    @ExportMessage
    static boolean acceptsValue(Object[] store, Object value) {
        return true;
    }

    @ExportMessage
    static boolean acceptsAllValues(Object[] store, Object otherStore) {
        return true;
    }

    @ExportMessage
    static boolean isMutable(Object[] store) {
        return true;
    }

    @ExportMessage
    static String toString(Object[] store) {
        return "Object[]";
    }

    @ExportMessage
    static void write(Object[] store, int index, Object value) {
        store[index] = value;
    }

    @ExportMessage
    static int capacity(Object[] store) {
        return store.length;
    }

    @ExportMessage
    static Object[] expand(Object[] store, int newCapacity) {
        return ArrayUtils.grow(store, newCapacity);
    }

    @ExportMessage
    static Object[] boxedCopyOfRange(Object[] store, int start, int length) {
        Object[] result = new Object[length];
        System.arraycopy(store, start, result, 0, length);
        return result;
    }

    @ExportMessage
    static Object makeShared(Object[] store, int size, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        stores.shareElements(store, 0, size);
        return new SharedArrayStorage(store);
    }

    @ExportMessage
    static void clear(Object[] store, int start, int length, @CachedLibrary(value="store") ArrayStoreLibrary node, @Cached @Cached.Exclusive LoopConditionProfile profile) {
        ArrayUtils.fill(store, start, start + length, null, (Node)node, profile);
    }

    @ExportMessage
    static void fill(Object[] store, int start, int length, Object value, @CachedLibrary(value="store") ArrayStoreLibrary node, @Cached @Cached.Exclusive LoopConditionProfile profile) {
        ArrayUtils.fill(store, start, start + length, value, (Node)node, profile);
    }

    @ExportMessage
    static Object[] toJavaArrayCopy(Object[] store, int length) {
        return ArrayUtils.extractRange(store, 0, length);
    }

    @ExportMessage
    static Iterable<Object> getIterable(final Object[] store, final int from, final int length) {
        return () -> new Iterator<Object>(){
            private int n;
            {
                this.n = from;
            }

            @Override
            public boolean hasNext() {
                return this.n < from + length;
            }

            @Override
            public Object next() throws NoSuchElementException {
                if (this.n >= from + length) {
                    throw new NoSuchElementException();
                }
                Object object = store[this.n];
                ++this.n;
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object[] store, Object newValue) {
        return OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object[] store, Object newValue) {
        return OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object[] store) {
        return SharedArrayStorage.SHARED_OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    static Object allocateForNewValue(Object[] store, Object newValue, int length) {
        return OBJECT_ARRAY_ALLOCATOR.allocate(length);
    }

    @ExportMessage
    static Object allocateForNewStore(Object[] store, Object newValue, int length) {
        return OBJECT_ARRAY_ALLOCATOR.allocate(length);
    }

    @ExportMessage
    static boolean isDefaultValue(Object[] store, Object value) {
        return value == null;
    }

    @ExportMessage
    static ArrayStoreLibrary.ArrayAllocator allocator(Object[] store) {
        return OBJECT_ARRAY_ALLOCATOR;
    }

    private static final class ObjectArrayAllocator
    extends ArrayStoreLibrary.ArrayAllocator {
        private ObjectArrayAllocator() {
        }

        public Object[] allocate(int capacity) {
            return new Object[capacity];
        }

        @Override
        public boolean accepts(Object value) {
            return true;
        }

        @Override
        public boolean specializesFor(Object value) {
            return !(value instanceof Integer) && !(value instanceof Long) && !(value instanceof Double);
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return value == null;
        }
    }

    @ExportMessage
    @ImportStatic(value={ArrayGuards.class})
    static final class CopyContents {
        CopyContents() {
        }

        @Specialization
        static void copyContents(Object[] srcStore, int srcStart, Object[] destStore, int destStart, int length) {
            System.arraycopy(srcStore, srcStart, destStore, destStart, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isObjectStore(destStore)"}, limit="storageStrategyLimit()")
        static void copyContents(Object[] srcStore, int srcStart, Object destStore, int destStart, int length, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @CachedLibrary(value="destStore") ArrayStoreLibrary destStores) {
            int i = 0;
            try {
                while (loopProfile.inject(i < length)) {
                    destStores.write(destStore, destStart + i, srcStore[srcStart + i]);
                    TruffleSafepoint.poll((Node)destStores);
                    ++i;
                }
            }
            finally {
                RubyBaseNode.profileAndReportLoopCount(destStores.getNode(), loopProfile, i);
            }
        }

        protected static boolean isObjectStore(Object store) {
            return store instanceof Object[];
        }
    }

    @ExportMessage
    static final class ShareElements {
        ShareElements() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void shareElements(Object[] store, int start, int end, @CachedLibrary(value="store") ArrayStoreLibrary arrayStoreLibrary, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @Cached WriteBarrierNode writeBarrierNode, @Bind(value="$node") Node node) {
            int i = start;
            try {
                while (loopProfile.inject(i < end)) {
                    writeBarrierNode.execute(node, store[i]);
                    ++i;
                }
            }
            finally {
                RubyBaseNode.profileAndReportLoopCount((Node)arrayStoreLibrary, loopProfile, i);
            }
        }
    }
}

