/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.utils.Utils;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class IntegerCastNode
extends RubyBaseNode {
    public abstract int execute(Node var1, Object var2);

    @Specialization
    static int doInt(int value) {
        return value;
    }

    @Specialization(guards={"fitsInInteger(value)"})
    static int doLong(long value) {
        return (int)value;
    }

    @Specialization(guards={"!fitsInInteger(value)"})
    static int doLongToBig(Node node, long value) {
        throw new RaiseException(IntegerCastNode.getContext(node), IntegerCastNode.coreExceptions(node).rangeError("long too big to convert into `int'", node));
    }

    @Specialization(guards={"!isImplicitLong(value)"})
    static int doBasicObject(Node node, Object value) {
        throw new RaiseException(IntegerCastNode.getContext(node), IntegerCastNode.coreExceptions(node).typeErrorIsNotA(Utils.toString(value), "Integer (fitting in int)", node));
    }
}

