/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.graalvm.shadowed.org.jcodings.EncodingDB;
import org.graalvm.shadowed.org.jcodings.util.CaseInsensitiveBytesHash;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToRubyEncodingNode;
import org.truffleruby.core.encoding.EncodingNodesFactory;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Encoding", isClass=true)
public abstract class EncodingNodes {

    @Primitive(name="encoding_unicode_emoji_version")
    public static abstract class UnicodeEmojiVersionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString getUnicodeEmojiVersion(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, "13.1", Encodings.UTF_8);
        }
    }

    @Primitive(name="encoding_unicode_version")
    public static abstract class UnicodeVersionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString getUnicodeVersion(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, "13.0.0", Encodings.UTF_8);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CheckStringEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(Node var1, AbstractTruffleString var2, RubyEncoding var3, AbstractTruffleString var4, RubyEncoding var5);

        @Specialization
        static RubyEncoding checkEncoding(Node node, AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached InlinedBranchProfile errorProfile, @Cached NegotiateCompatibleStringEncodingNode negotiateCompatibleEncodingNode) {
            RubyEncoding negotiatedEncoding = negotiateCompatibleEncodingNode.execute(node, first, firstEncoding, second, secondEncoding);
            if (negotiatedEncoding == null) {
                errorProfile.enter(node);
                throw new RaiseException(CheckStringEncodingNode.getContext(node), CheckStringEncodingNode.coreExceptions(node).encodingCompatibilityErrorIncompatible(firstEncoding, secondEncoding, node));
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_ensure_compatible_str")
    public static abstract class CheckStringEncodingPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libFirst.isRubyString(this, first)", "libSecond.isRubyString(this, second)"}, limit="1")
        static RubyEncoding checkEncodingStringString(Object first, Object second, @Cached RubyStringLibrary libFirst, @Cached RubyStringLibrary libSecond, @Cached InlinedBranchProfile errorProfile, @Cached NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Bind(value="this") Node node) {
            RubyEncoding firstEncoding = libFirst.getEncoding(node, first);
            RubyEncoding secondEncoding = libSecond.getEncoding(node, second);
            RubyEncoding negotiatedEncoding = negotiateCompatibleStringEncodingNode.execute(node, libFirst.getTString(node, first), firstEncoding, libSecond.getTString(node, second), secondEncoding);
            if (negotiatedEncoding == null) {
                errorProfile.enter(node);
                throw new RaiseException(CheckStringEncodingPrimitiveNode.getContext(node), CheckStringEncodingPrimitiveNode.coreExceptions(node).encodingCompatibilityErrorIncompatible(firstEncoding, secondEncoding, node));
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_get_encoding_index")
    public static abstract class GetEncodingIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int getIndex(RubyEncoding encoding) {
            return encoding.index;
        }
    }

    @Primitive(name="encoding_get_encoding_by_index", lowerFixnum={0})
    public static abstract class GetEncodingObjectByIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSingleContext()", "index == cachedIndex"}, limit="getCacheLimit()")
        RubyEncoding getEncoding(int index, @Cached(value="index") int cachedIndex, @Cached(value="getContext().getEncodingManager().getRubyEncoding(index)") RubyEncoding cachedEncoding) {
            return cachedEncoding;
        }

        @Specialization(replaces={"getEncoding"})
        RubyEncoding getEncodingUncached(int index) {
            return this.getContext().getEncodingManager().getRubyEncoding(index);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.ENCODING_LOADED_CLASSES_CACHE;
        }
    }

    @Primitive(name="encoding_create_dummy")
    public static abstract class DummyEncodingNode
    extends EncodingCreationNode {
        @Specialization(guards={"strings.isRubyString(this, nameObject)"}, limit="1")
        static RubyArray createDummyEncoding(Object nameObject, @Cached RubyStringLibrary strings, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            String name = toJavaStringNode.execute(node, nameObject);
            RubyEncoding newEncoding = DummyEncodingNode.createDummy(node, name);
            return DummyEncodingNode.setIndexOrRaiseError(node, name, newEncoding);
        }

        @CompilerDirectives.TruffleBoundary
        private static RubyEncoding createDummy(Node node, String name) {
            if (DummyEncodingNode.getContext(node).getEncodingManager().getNumberOfEncodings() >= 256) {
                throw new RaiseException(DummyEncodingNode.getContext(node), DummyEncodingNode.coreExceptions(node).encodingErrorTooManyEncodings(256, node));
            }
            return DummyEncodingNode.getContext(node).getEncodingManager().createDummyEncoding(name);
        }
    }

    public static abstract class EncodingCreationNode
    extends PrimitiveArrayArgumentsNode {
        public static RubyArray setIndexOrRaiseError(Node node, String name, RubyEncoding newEncoding) {
            if (newEncoding == null) {
                throw new RaiseException(EncodingCreationNode.getContext(node), EncodingCreationNode.coreExceptions(node).argumentErrorEncodingAlreadyRegistered(name, node));
            }
            int index = newEncoding.index;
            return EncodingCreationNode.createArray(node, new Object[]{newEncoding, index});
        }
    }

    @Primitive(name="encoding_get_object_encoding")
    public static abstract class EncodingGetObjectEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getObjectEncoding(Object object, @Cached ToRubyEncodingNode toRubyEncodingNode, @Cached InlinedConditionProfile nullProfile) {
            RubyEncoding rubyEncoding = toRubyEncodingNode.execute(this, object);
            if (nullProfile.profile((Node)this, rubyEncoding == null)) {
                return nil;
            }
            return rubyEncoding;
        }
    }

    @Primitive(name="encoding_set_default_internal")
    public static abstract class SetDefaultInternalNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyEncoding setDefaultInternal(RubyEncoding encoding) {
            this.getContext().getEncodingManager().setDefaultInternalEncoding(encoding);
            return encoding;
        }

        @Specialization
        Object noDefaultInternal(Nil encoding) {
            this.getContext().getEncodingManager().setDefaultInternalEncoding(null);
            return nil;
        }
    }

    @Primitive(name="encoding_set_default_external")
    public static abstract class SetDefaultExternalNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyEncoding setDefaultExternal(RubyEncoding encoding) {
            this.getContext().getEncodingManager().setDefaultExternalEncoding(encoding);
            return encoding;
        }

        @Specialization
        RubyEncoding noDefaultExternal(Nil encoding) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("default external can not be nil", this));
        }
    }

    @Primitive(name="encoding_get_default_encoding")
    public static abstract class GetDefaultEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object getDefaultEncoding(Object name) {
            RubyEncoding encoding = this.getEncoding(RubyGuards.getJavaString(name));
            if (encoding == null) {
                return nil;
            }
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        private RubyEncoding getEncoding(String name) {
            switch (name) {
                case "internal": {
                    return this.getContext().getEncodingManager().getDefaultInternalEncoding();
                }
                case "external": 
                case "filesystem": {
                    return this.getContext().getEncodingManager().getDefaultExternalEncoding();
                }
                case "locale": {
                    return this.getContext().getEncodingManager().getLocaleEncoding();
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetActualEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(Node var1, AbstractTruffleString var2, RubyEncoding var3);

        @Specialization(guards={"!encoding.isDummy"})
        static RubyEncoding getActualEncoding(AbstractTruffleString tstring, RubyEncoding encoding) {
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"encoding.isDummy"})
        static RubyEncoding getActualEncodingDummy(AbstractTruffleString tstring, RubyEncoding encoding, @Cached(inline=false) TruffleString.ReadByteNode readByteNode) {
            if (encoding.isUnicode) {
                TruffleString.Encoding enc = encoding.tencoding;
                int byteLength = tstring.byteLength(enc);
                if (encoding == Encodings.UTF16_DUMMY && byteLength >= 2) {
                    int c0 = readByteNode.execute(tstring, 0, enc);
                    int c1 = readByteNode.execute(tstring, 1, enc);
                    if (c0 == 254 && c1 == 255) {
                        return Encodings.UTF16BE;
                    }
                    if (c0 == 255 && c1 == 254) {
                        return Encodings.UTF16LE;
                    }
                    return Encodings.BINARY;
                }
                if (encoding == Encodings.UTF32_DUMMY && byteLength >= 4) {
                    int c0 = readByteNode.execute(tstring, 0, enc);
                    int c1 = readByteNode.execute(tstring, 1, enc);
                    int c2 = readByteNode.execute(tstring, 2, enc);
                    int c3 = readByteNode.execute(tstring, 3, enc);
                    if (c0 == 0 && c1 == 0 && c2 == 254 && c3 == 255) {
                        return Encodings.UTF32BE;
                    }
                    if (c3 == 0 && c2 == 0 && c1 == 254 && c0 == 255) {
                        return Encodings.UTF32LE;
                    }
                    return Encodings.BINARY;
                }
            }
            return encoding;
        }
    }

    @Primitive(name="get_actual_encoding")
    public static abstract class GetActualEncodingPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        static RubyEncoding getActualEncoding(Object string, @Cached GetActualEncodingNode getActualEncodingNode, @Cached RubyStringLibrary libString, @Bind(value="this") Node node) {
            return getActualEncodingNode.execute(node, libString.getTString(node, string), libString.getEncoding(node, string));
        }
    }

    @Primitive(name="encoding_is_unicode?")
    public static abstract class IsUnicodeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isUnicode(RubyEncoding encoding) {
            return encoding.isUnicode;
        }
    }

    @Primitive(name="encoding_define_alias")
    public static abstract class DefineAliasNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyEncoding defineAlias(RubyEncoding encoding, RubySymbol aliasName) {
            this.getContext().getEncodingManager().defineAlias(encoding.jcoding, aliasName.getString());
            return encoding;
        }
    }

    @Primitive(name="encoding_each_alias")
    public static abstract class EachAliasNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object eachAlias(RubyProc block, @Cached CallBlockNode yieldNode) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator iterator = EncodingDB.getAliases().entryIterator();
            while (iterator.hasNext()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry entry = iterator.next();
                RubyString aliasName = this.createString(this.fromByteArrayNode, ArrayUtils.extractRange(entry.bytes, entry.p, entry.end), Encodings.US_ASCII);
                yieldNode.yield(this, block, new Object[]{aliasName, Encodings.getBuiltInEncoding(((EncodingDB.Entry)entry.value).getEncoding())});
            }
            return nil;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString toS(RubyEncoding encoding) {
            return encoding.name;
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isDummy(RubyEncoding encoding) {
            return encoding.isDummy;
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString localeCharacterMap() {
            RubyEncoding rubyEncoding = this.getContext().getEncodingManager().getLocaleEncoding();
            return rubyEncoding.name;
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray list() {
            return this.createArray(this.getContext().getEncodingManager().getEncodingList());
        }
    }

    @Primitive(name="strings_compatible?")
    public static abstract class AreStringsCompatibleNode
    extends PrimitiveArrayArgumentsNode {
        public static AreStringsCompatibleNode create() {
            return EncodingNodesFactory.AreStringsCompatibleNodeFactory.create(null);
        }

        @Specialization
        Object areCompatible(Object first, Object second, @Cached RubyStringLibrary libFirst, @Cached RubyStringLibrary libSecond, @Cached NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Cached InlinedConditionProfile noNegotiatedEncodingProfile) {
            RubyEncoding negotiatedEncoding = negotiateCompatibleStringEncodingNode.execute(this, libFirst.getTString(this, first), libFirst.getEncoding(this, first), libSecond.getTString(this, second), libSecond.getEncoding(this, second));
            if (noNegotiatedEncodingProfile.profile((Node)this, negotiatedEncoding == null)) {
                return nil;
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_compatible?")
    public static abstract class CompatibleQueryNode
    extends PrimitiveArrayArgumentsNode {
        public static CompatibleQueryNode create() {
            return EncodingNodesFactory.CompatibleQueryNodeFactory.create(null);
        }

        @Specialization
        Object isCompatible(Object first, Object second, @Cached NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode, @Cached ToRubyEncodingNode toRubyEncodingNode, @Cached InlinedConditionProfile nullEncodingProfile, @Cached InlinedConditionProfile noNegotiatedEncodingProfile) {
            RubyEncoding firstEncoding = toRubyEncodingNode.execute(this, first);
            RubyEncoding secondEncoding = toRubyEncodingNode.execute(this, second);
            if (nullEncodingProfile.profile((Node)this, firstEncoding == null || secondEncoding == null)) {
                return nil;
            }
            RubyEncoding negotiatedEncoding = negotiateCompatibleEncodingNode.execute(this, first, firstEncoding, second, secondEncoding);
            if (noNegotiatedEncodingProfile.profile((Node)this, negotiatedEncoding == null)) {
                return nil;
            }
            return negotiatedEncoding;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class NegotiateCompatibleEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(Node var1, Object var2, RubyEncoding var3, Object var4, RubyEncoding var5);

        @Specialization
        static RubyEncoding negotiateEncoding(Node node, Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached RubyStringLibrary libFirst, @Cached RubyStringLibrary libSecond, @Cached InlinedConditionProfile equalEncodingsProfile, @Cached InlinedConditionProfile stringStringProfile, @Cached InlinedConditionProfile incompatibleProfile, @Cached InlinedConditionProfile objectStringProfile, @Cached(inline=false) TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached NegotiateCompatibleStringEncodingNode negotiateForStringsNode) {
            assert (firstEncoding != null);
            assert (secondEncoding != null);
            if (equalEncodingsProfile.profile(node, firstEncoding == secondEncoding)) {
                return firstEncoding;
            }
            boolean firstIsString = libFirst.isRubyString(node, first);
            boolean secondIsString = libSecond.isRubyString(node, second);
            if (stringStringProfile.profile(node, firstIsString && secondIsString)) {
                return negotiateForStringsNode.execute(node, libFirst.getTString(node, first), firstEncoding, libSecond.getTString(node, second), secondEncoding);
            }
            if (incompatibleProfile.profile(node, !firstEncoding.isAsciiCompatible || !secondEncoding.isAsciiCompatible)) {
                return null;
            }
            if (objectStringProfile.profile(node, secondIsString && !firstIsString)) {
                return NegotiateCompatibleEncodingNode.compatibleEncoding(node, second, secondEncoding, secondIsString, firstEncoding, codeRangeNode, libSecond);
            }
            return NegotiateCompatibleEncodingNode.compatibleEncoding(node, first, firstEncoding, firstIsString, secondEncoding, codeRangeNode, libFirst);
        }

        protected static RubyEncoding compatibleEncoding(Node node, Object first, RubyEncoding firstEncoding, boolean firstIsString, RubyEncoding secondEncoding, TruffleString.GetByteCodeRangeNode codeRangeNode, RubyStringLibrary libFirst) {
            assert (firstEncoding != secondEncoding);
            if (secondEncoding == Encodings.US_ASCII) {
                return firstEncoding;
            }
            if (firstIsString ? codeRangeNode.execute(libFirst.getTString(node, first), libFirst.getTEncoding(node, first)) == TruffleString.CodeRange.ASCII : firstEncoding == Encodings.US_ASCII) {
                return secondEncoding;
            }
            return null;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    public static abstract class NegotiateCompatibleStringEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(Node var1, AbstractTruffleString var2, RubyEncoding var3, AbstractTruffleString var4, RubyEncoding var5);

        @Specialization
        static RubyEncoding negotiateEncoding(Node node, AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached InlinedConditionProfile equalEncodingsProfile, @Cached InlinedConditionProfile first7BitProfile, @Cached InlinedConditionProfile firstAsciiCompatProfile, @Cached InlinedConditionProfile second7BitProfile, @Cached InlinedConditionProfile secondAsciiCompatProfile, @Cached(inline=false) TruffleString.GetByteCodeRangeNode codeRangeNode) {
            assert (first.isCompatibleToUncached(firstEncoding.tencoding) && second.isCompatibleToUncached(secondEncoding.tencoding));
            if (equalEncodingsProfile.profile(node, firstEncoding == secondEncoding)) {
                return firstEncoding;
            }
            boolean second7Bit = StringGuards.is7Bit(second, secondEncoding, codeRangeNode);
            if (firstAsciiCompatProfile.profile(node, firstEncoding.isAsciiCompatible)) {
                if (second7BitProfile.profile(node, second7Bit)) {
                    return firstEncoding;
                }
                if (secondAsciiCompatProfile.profile(node, secondEncoding.isAsciiCompatible)) {
                    if (first7BitProfile.profile(node, StringGuards.is7Bit(first, firstEncoding, codeRangeNode))) {
                        return secondEncoding;
                    }
                    return null;
                }
            }
            return NegotiateCompatibleStringEncodingNode.compatibleEncodingForStrings(first, firstEncoding, second, secondEncoding, second7Bit, codeRangeNode);
        }

        @CompilerDirectives.TruffleBoundary
        protected static RubyEncoding compatibleEncodingForStrings(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, boolean second7Bit, TruffleString.GetByteCodeRangeNode codeRangeNode) {
            assert (firstEncoding != secondEncoding) : "this method assumes the encodings are different";
            if (second.isEmpty()) {
                return firstEncoding;
            }
            if (first.isEmpty()) {
                return firstEncoding.isAsciiCompatible && second7Bit ? firstEncoding : secondEncoding;
            }
            if (!firstEncoding.isAsciiCompatible || !secondEncoding.isAsciiCompatible) {
                return null;
            }
            if (second7Bit) {
                return firstEncoding;
            }
            if (StringGuards.is7Bit(first, firstEncoding, codeRangeNode)) {
                return secondEncoding;
            }
            return null;
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isAsciiCompatible(RubyEncoding encoding) {
            return encoding.isAsciiCompatible;
        }
    }
}

